/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.Assert;
import oracle.ideimpl.runner.BaseRunnerFolder;
import oracle.ideimpl.runner.RunnerBundle;
import oracle.ideimpl.runner.RunnerImpl;
import oracle.javatools.icons.OracleIcons;

final class Processes
extends BaseRunnerFolder {
    private RunnerImpl runner;
    private boolean calledViewRunManager;

    Processes(RunnerImpl runner) {
        this.runner = runner;
        this.calledViewRunManager = false;
    }

    @Override
    public String getShortLabel() {
        return RunnerBundle.get("PROCESSES_LABEL");
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"runmanager.png");
    }

    @Override
    public boolean add(Element element) {
        Assert.checkAWTThread();
        boolean addOk = super.add(element);
        if (addOk) {
            if (element instanceof RunProcess) {
                this.runner.selectProcess((RunProcess)element);
            }
            if (!this.calledViewRunManager && this.countChildren() > 2) {
                this.runner.viewRunManager();
                this.calledViewRunManager = true;
            }
        }
        return addOk;
    }

    @Override
    public boolean remove(Element element) {
        RunProcess runProcess;
        Assert.checkAWTThread();
        boolean selectNextProcess = false;
        RunProcess next = null;
        if (element instanceof RunProcess && this.runner.isActiveRunProcess(runProcess = (RunProcess)element)) {
            selectNextProcess = true;
            List<RunProcess> list = this.getRunProcessesList();
            if (list.size() > 1) {
                int i = list.indexOf(runProcess);
                if (i != -1) {
                    i = i == 0 ? 1 : --i;
                    next = list.get(i);
                } else {
                    next = list.get(0);
                }
            }
        }
        boolean result = super.remove(element);
        if (selectNextProcess) {
            this.runner.selectProcess(next);
        }
        return result;
    }

    private List<RunProcess> getRunProcessesList() {
        ArrayList<RunProcess> list = new ArrayList<RunProcess>();
        Iterator i = this.getChildren();
        if (i != null) {
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof RunProcess)) continue;
                list.add((RunProcess)o);
            }
        }
        return list;
    }

    public RunProcess[] getRunProcesses() {
        List<RunProcess> list = this.getRunProcessesList();
        return list.toArray(new RunProcess[list.size()]);
    }
}

