/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.aurora.compiler.Db;

public class Sorter {
    Comparer comparer;

    public Sorter(Comparer comparer) {
        this.comparer = comparer;
    }

    public Enumeration sort(Enumeration unsorted) {
        List list = new List();
        while (unsorted.hasMoreElements()) {
            list.addElement(unsorted.nextElement());
        }
        list.sort();
        return list;
    }

    class List
    implements Enumeration {
        ListNode first;
        ListNode last;

        List() {
        }

        List(Object element) {
            this.last = this.first = new ListNode(element, null);
        }

        void append(List rhs) {
            if (rhs != null && rhs.first != null) {
                if (this.first == null) {
                    this.first = rhs.first;
                    this.last = rhs.last;
                } else {
                    this.last.next = rhs.first;
                    this.last = rhs.last;
                }
            }
            if (rhs != null) {
                rhs.first = null;
                rhs.last = null;
            }
        }

        void addNode(ListNode n) {
            n.next = null;
            if (this.last == null) {
                this.first = n;
                this.last = n;
            } else {
                this.last.next = n;
                this.last = n;
            }
        }

        void addElement(Object element) {
            this.addNode(new ListNode(element, null));
        }

        ListNode head() {
            ListNode n = this.first;
            if (n != null) {
                this.first = n.next;
            }
            if (this.first == null) {
                this.last = null;
            }
            return n;
        }

        List merge(List other) {
            if (other.first == null) {
                return this;
            }
            if (this.first == null) {
                return other;
            }
            ListNode a = this.head();
            ListNode b = other.head();
            List merged = new List();
            while (a != null && b != null) {
                if (Sorter.this.comparer.lessThan(b.element, a.element)) {
                    merged.addNode(b);
                    b = other.head();
                    continue;
                }
                merged.addNode(a);
                a = this.head();
            }
            if (a == null) {
                merged.addNode(b);
                merged.append(other);
            } else {
                merged.addNode(a);
                merged.append(this);
            }
            return merged;
        }

        List split() {
            if (this.first == null || this.first.next == null) {
                return new List();
            }
            ListNode trailing = this.first;
            ListNode leading = trailing.next;
            while (leading != null) {
                leading = leading.next;
                if (leading == null) continue;
                leading = leading.next;
                trailing = trailing.next;
            }
            List secondHalf = new List();
            secondHalf.first = trailing.next;
            secondHalf.last = this.last;
            this.last = trailing;
            trailing.next = null;
            return secondHalf;
        }

        void sort() {
            if (this.first == null || this.first.next == null) {
                return;
            }
            List b = this.split();
            this.sort();
            b.sort();
            List sorted = this.merge(b);
            this.first = sorted.first;
            this.last = sorted.last;
        }

        public Object nextElement() {
            Object element;
            if (this.first != null) {
                element = this.first.element;
                this.first = this.first.next;
                if (this.first == null) {
                    this.last = null;
                }
            } else {
                throw new NoSuchElementException();
            }
            return element;
        }

        public boolean hasMoreElements() {
            return this.first != null;
        }

        void dbPrint(String what) {
            Db.output(what);
            Db.push();
            ListNode n = this.first;
            while (n != null) {
                Db.output(n.element.toString());
                n = n.next;
            }
            Db.pop();
        }

        class ListNode {
            ListNode next;
            Object element;

            ListNode(Object element, ListNode next) {
                this.next = next;
                this.element = element;
            }
        }
    }

    public static interface Comparer {
        public boolean lessThan(Object var1, Object var2);
    }
}

