/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.vm.Id;
import oracle.aurora.vm.IdManager;
import oracle.aurora.vm.IdNotFoundException;

class TypeDescriptor {
    private Id schema;
    private String className;
    private PolicyTable table;
    private IdManager manager;

    TypeDescriptor(PolicyTable table, Class clazz) throws IdNotFoundException {
        this.table = table;
        this.manager = table.getManager();
        this.className = clazz.getName();
        this.schema = this.manager.owner(clazz);
    }

    TypeDescriptor(PolicyTable table, String className) throws IdNotFoundException, ClassNotFoundException {
        this.table = table;
        this.manager = table.getManager();
        this.parse(className);
    }

    TypeDescriptor(PolicyTable table, String schemaName, String className) throws IdNotFoundException {
        this.table = table;
        this.manager = table.getManager();
        this.init(schemaName, className);
    }

    void init(String schemaName, String className) throws IdNotFoundException {
        this.schema = this.manager.getId(schemaName);
        this.className = className;
    }

    TypeDescriptor(PolicyTable table, Id schema, String className) {
        this.table = table;
        this.manager = table.getManager();
        this.init(schema, className);
    }

    TypeDescriptor(PolicyTable table, long number, String className) throws IdNotFoundException {
        this.table = table;
        this.manager = table.getManager();
        this.init(this.manager.getId(number), className);
    }

    void init(Id schema, String className) {
        this.schema = schema;
        this.className = className;
    }

    String getName() {
        return this.className;
    }

    long getSchemaNumber() {
        return this.schema.getNumber();
    }

    Id getSchema() {
        return this.schema;
    }

    Class classForName() throws ClassNotFoundException {
        return this.getSchema().lookupClass(this.className);
    }

    void parse(String t) throws IdNotFoundException, ClassNotFoundException {
        long sNumber;
        String cName;
        int xColon = t.indexOf(":");
        if (xColon > 0 && Character.isDigit(t.charAt(0))) {
            cName = t.substring(xColon + 1);
            sNumber = Integer.parseInt(t.substring(0, xColon));
        } else if (xColon >= 0) {
            cName = t.substring(xColon + 1);
            String ownerName = t.substring(0, xColon);
            Id owner = this.manager.getId(ownerName);
            sNumber = owner.getNumber();
        } else {
            Class<?> typeClass = Class.forName(t);
            Id owner = this.manager.owner(typeClass);
            cName = t;
            sNumber = owner.getNumber();
        }
        this.className = cName;
        this.schema = this.manager.getId(sNumber);
    }

    public String toString() {
        return this.schema + ":" + this.className;
    }

    String unparse() {
        return this.schema.getNumber() + ":" + this.className;
    }

    public int hashCode() {
        return this.schema.hashCode() + this.className.hashCode();
    }

    public boolean equals(Object rhs) {
        boolean result = false;
        if (rhs instanceof TypeDescriptor) {
            TypeDescriptor rhsT = (TypeDescriptor)rhs;
            result = this.schema.equals(rhsT.schema) && this.className.equals(rhsT.className);
        }
        return result;
    }
}

