/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Properties;
import oracle.aurora.util.OrderedCollection;

public class ParamBlock {
    public boolean processArguments(String utlName, String[] args) {
        Field[] fields = this.getInstanceFields();
        return this.processArguments(utlName, args, fields);
    }

    protected boolean setField(Field field, String value) {
        try {
            Class<?> cls = field.getType();
            if (cls == Byte.TYPE) {
                field.setByte(this, Byte.parseByte(value));
            } else if (cls == Short.TYPE) {
                field.setShort(this, Short.parseShort(value));
            } else if (cls == Integer.TYPE) {
                field.setInt(this, Integer.parseInt(value));
            } else if (cls == Long.TYPE) {
                field.setLong(this, Long.parseLong(value));
            } else if (cls == Float.TYPE) {
                field.setFloat(this, Float.valueOf(value).floatValue());
            } else if (cls == Double.TYPE) {
                field.setDouble(this, Double.valueOf(value));
            } else if (cls == String.class) {
                field.set(this, value);
            } else if (cls == Boolean.TYPE) {
                field.set(this, Boolean.valueOf(value));
            }
        }
        catch (Exception e) {
            System.err.print("Problem processing args:\n");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean processArguments(String utlName, String[] args, Field[] fields) {
        System.out.println();
        for (int idx = 0; idx < args.length; ++idx) {
            int fidx = this.findField(args[idx].substring(1), fields);
            if (fidx < 0) {
                if (!args[idx].equals("-help")) {
                    System.err.println(args[idx] + " unexpected");
                }
                this.usage(utlName, fields);
                return false;
            }
            Field field = fields[fidx];
            Class<?> cls = field.getType();
            if (args.length <= ++idx) {
                System.err.println("-" + field.getName() + " expected " + this.role(fields, fidx));
                this.usage(utlName, fields);
                return false;
            }
            if (this.setField(field, args[idx])) continue;
            return false;
        }
        this.postProcess();
        return true;
    }

    public boolean processProperties(String utlName, Properties props) {
        Field[] fields = this.getInstanceFields();
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            int fidx = this.findField(key, fields);
            if (fidx >= 0) {
                this.setField(fields[fidx], props.getProperty(key));
                continue;
            }
            this.usage(utlName, fields);
            return false;
        }
        this.postProcess();
        return true;
    }

    public void printParameters(PrintStream ps) {
        ps.print("Arguments:\n");
        Field[] fields = this.getInstanceFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                ps.print("  -" + fields[i].getName() + " " + fields[i].get(this) + "\n");
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("assertion violated");
            }
        }
    }

    protected int findField(String arg, Field[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!arg.equals(field.getName())) continue;
            return i;
        }
        return -1;
    }

    protected String getDocField(Field field) {
        String docName = field.getName() + "Doc";
        Field docField = null;
        try {
            docField = field.getDeclaringClass().getDeclaredField(docName);
        }
        catch (Exception e) {
            return null;
        }
        if (!String.class.isAssignableFrom(docField.getType())) {
            return null;
        }
        try {
            return (String)docField.get(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("assertion violation");
        }
    }

    protected void usage(String utlName, Field[] fields) {
        System.err.print("usage: java " + utlName + "\n");
        System.err.println("  [-help]\n  Display this message");
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            System.err.print("  [-" + field.getName());
            Class<?> cls = field.getType();
            System.err.print(" <" + cls.getName() + ">");
            System.err.print("]");
            String doc = this.getDocField(field);
            if (doc != null) {
                System.err.println("\n  " + doc);
            }
            System.err.println();
        }
    }

    protected Field[] getInstanceFields() {
        OrderedCollection oc = new OrderedCollection();
        for (Class<?> cls = this.getClass(); cls != null; cls = cls.getSuperclass()) {
            Field[] fields = cls.getDeclaredFields();
            for (int i = fields.length - 1; i >= 0; --i) {
                Class<?> fcls;
                if (Modifier.isStatic(fields[i].getModifiers()) || fields[i].getName().charAt(0) == '_' || (!(fcls = fields[i].getType()).isPrimitive() || fcls == Character.TYPE) && fcls != String.class) continue;
                oc.push(fields[i]);
            }
        }
        return (Field[])oc.getObjects(Field.class);
    }

    protected String role(Field[] fields, int idx) {
        String doc = this.getDocField(fields[idx]);
        return "<" + fields[idx].getType().getName() + ">" + (doc != null ? "  --  " + doc : "");
    }

    protected void postProcess() {
    }
}

