/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployCloudUtil;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.JTextFieldLimit;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.raptor.cloud.controls.CloudConnectionComboBox;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.util.ResourceUtils;

public class DbCartDeployAuthPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int PREFERENCES = 0;
    public static int WIZARD = 1;
    public static String USER = DbCartAddinArb.getString("USER_AUTH");
    public static String KEY_FILE = DbCartAddinArb.getString("KEY_FILE_AUTH");
    public static final String KEY_FILE_PATH = "KEY_FILE_PATH";
    public static String[] AUTHS = new String[]{USER, KEY_FILE};
    private JPanel _authPanel;
    private JPanel _userPanel;
    CloudConnectionComboBox _cloudConns;
    private JLabel _labelUser = new JLabel();
    private JTextField _textUser = new JTextField();
    private JLabel _labelPass = new JLabel();
    private JPasswordField _pass = new JPasswordField();
    private JLabel _labelTitle = new JLabel();
    private JTextField _textTitle = new JTextField();
    private JLabel _labelServer = new JLabel();
    private JTextField _textServer = new JTextField();
    private JLabel _labelPort = new JLabel();
    private WholeNumberField _textPort = new WholeNumberField(4);
    private int m_usage;
    char[] _sftpPass;

    public DbCartDeployAuthPanel() {
        this(WIZARD);
    }

    public DbCartDeployAuthPanel(int n) {
        this.m_usage = n;
        this._textServer.setEnabled(false);
        this._textPort.setEnabled(false);
        this._textUser.setEnabled(false);
    }

    public JPanel getPanel() {
        this._authPanel = new JPanel(new GridBagLayout());
        this._userPanel = new JPanel(new GridBagLayout());
        this._cloudConns = new CloudConnectionComboBox();
        JComboBox jComboBox = this._cloudConns.getComboBox();
        jComboBox.setToolTipText(DbCartAddinArb.getString("CLOUD_CONNECTION_TIP"));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jComboBox, (String)DbCartAddinArb.getString("CLOUD_CONNECTION"));
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DbCartDeployAuthPanel.this.updateConnectionDetails((String)itemEvent.getItem());
                }
            }
        });
        this.updateConnectionDetails(this._cloudConns.getCurrentConnectionName());
        this._authPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add((Component)jComboBox, new GridBagConstraints(1, 0, 2, 1, 0.5, 0.5, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        this._labelTitle.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("DEPLOY_TITLE")));
        this._labelTitle.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("DEPLOY_TITLE")));
        this._labelTitle.setLabelFor(this._textTitle);
        this._textTitle.setDocument(new JTextFieldLimit(14));
        this._textTitle.setText(DbCartUtil.getTabPageName());
        this._authPanel.add((Component)this._labelTitle, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add((Component)this._textTitle, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._labelServer.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("SERVER")));
        this._labelServer.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("SERVER")));
        this._labelServer.setLabelFor(this._textServer);
        this._authPanel.add((Component)this._labelServer, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add((Component)this._textServer, new GridBagConstraints(1, 3, 2, 1, 0.5, 0.5, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._labelPort.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("PORT")));
        this._labelPort.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("PORT")));
        this._labelPort.setLabelFor((Component)this._textPort);
        this._textPort.setPreferredSize(new Dimension(40, 20));
        this._textPort.setMinimumSize(new Dimension(40, 20));
        this._authPanel.add((Component)this._labelPort, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        this._authPanel.add((Component)this._textPort, new GridBagConstraints(1, 4, 1, 1, 0.5, 0.5, 17, 0, new Insets(8, 8, 0, 8), 0, 0));
        this._labelUser.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("USER")));
        this._labelUser.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("USER")));
        this._labelUser.setLabelFor(this._textUser);
        this._labelPass.setText(StringUtils.stripMnemonic((String)DbCartAddinArb.getString("PASS")));
        this._labelPass.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)DbCartAddinArb.getString("PASS")));
        this._labelPass.setLabelFor(this._pass);
        this._userPanel.add((Component)this._labelUser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 0, 8), 0, 0));
        this._userPanel.add((Component)this._textUser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.5, 17, 2, new Insets(6, 8, 0, 8), 0, 0));
        this._userPanel.add((Component)this._labelPass, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(6, 8, 8, 8), 0, 0));
        this._userPanel.add((Component)this._pass, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 17, 2, new Insets(6, 8, 8, 8), 0, 0));
        TargetFormat targetFormat = new TargetFormat(1, 5);
        targetFormat.setSaveAsType(1);
        targetFormat.setSaveAs(targetFormat.getDefaultSaveAs());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._authPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._userPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        JLabel jLabel2 = new JLabel(DbCartAddinArb.getString("CLOUD"));
        TitledPane titledPane = new TitledPane((Component)jLabel2, (Component)jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)titledPane, "Center");
        return jPanel3;
    }

    public int getUsage() {
        return this.m_usage;
    }

    public String getUser() {
        return this._textUser.getText();
    }

    public void setUser(String string) {
        this._textUser.setText(string);
    }

    public String getTitle() {
        return this._textTitle.getText();
    }

    public void setTitle(String string) {
        this._textTitle.setText(string);
    }

    public char[] getPass() {
        return this._pass.isEnabled() ? this._pass.getPassword() : this._sftpPass;
    }

    public String getConnName() {
        return this._cloudConns.getCurrentConnectionName();
    }

    public JComboBox getConnJCombo() {
        return this._cloudConns.getComboBox();
    }

    public String getServer() {
        return this._textServer.getText();
    }

    public int getPort() {
        return this._textPort.getNumber().intValue();
    }

    private void updateConnectionDetails(String string) {
        boolean bl;
        SessionInfo.SftpInfo sftpInfo = DbCartDeployCloudUtil.getSftpInfo(string);
        SessionInfo.OssInfo ossInfo = DbCartDeployCloudUtil.getOssInfo(string);
        boolean bl2 = bl = ossInfo != null && ossInfo.isOssEnabled();
        if (bl) {
            String string2 = ossInfo.getOssServiceName();
            String string3 = ossInfo.getOssIdentityDomain();
            String string4 = ossInfo.getOssUserName();
            String string5 = ossInfo.getOssServiceUrl();
            this._textUser.setText(string4);
            this._textUser.setEnabled(false);
            this._textServer.setText(string5);
            this._textServer.setEnabled(false);
            this._textPort.setNumber((Number)0);
            this._textPort.setEnabled(false);
            this._pass.setEnabled(false);
        } else if (sftpInfo != null) {
            String string6 = sftpInfo.getSftpUser();
            this._textUser.setText(string6);
            this._textUser.setEnabled(string6 == null || string6.length() <= 0);
            String string7 = sftpInfo.getSftpHost();
            this._textServer.setText(string7);
            this._textServer.setEnabled(string7 == null || string7.length() <= 0);
            int n = sftpInfo.getSftpPort();
            this._textPort.setNumber((Number)n);
            this._sftpPass = sftpInfo.getSftpPass();
            if (this._sftpPass != null && this._sftpPass.length > 0) {
                this._pass.setEnabled(false);
            } else {
                this._pass.setEnabled(true);
            }
        } else {
            this._textUser.setText("");
            this._textUser.setEnabled(true);
            this._textServer.setText("");
            this._textServer.setEnabled(true);
            this._textPort.setNumber((Number)22);
            this._textPort.setEnabled(true);
        }
    }
}

