/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.dbcart.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.bali.ewt.border.TitledPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.dbcart.DbCartAddinArb;
import oracle.dbtools.dbcart.DbCartDeployAuthPanel;
import oracle.dbtools.dbcart.DbCartDeployCloudDdlPanel;
import oracle.dbtools.dbcart.DbCartDeployCloudUtil;
import oracle.dbtools.dbcart.DbCartDeployDataOptionPanel;
import oracle.dbtools.dbcart.DbCartUtil;
import oracle.dbtools.dbcart.config.DbCartUserCloudConfig;
import oracle.dbtools.dbcart.tools.DbCartUtilityTool;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.TargetFormat;
import oracle.dbtools.raptor.export.DbCartDeployOptions;
import oracle.dbtools.raptor.export.ExportAPI;
import oracle.dbtools.raptor.export.wizard.TargetOptionsPanel;
import oracle.dbtools.raptor.extract.models.ExtractDataFormat;
import oracle.dbtools.raptor.extract.models.ExtractObject;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.sftp.SftpParms;
import oracle.dbtools.raptor.sftp.SftpUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class DbCartDeployCloudTool
extends DbCartUtilityTool {
    public static final String TYPE = "DEPLOY_CLOUD";
    public static int ACTION = Ide.findOrCreateCmdID((String)"cart_deploy_cloud");
    private JEWTDialog _actionDialog;
    private JPanel _mainPanel = new JPanel();
    private JPanel _authPanel;
    private JPanel _ddlPanel;
    private JPanel _dataPanel;
    private JPanel _targetPanel;
    private JPanel _configPanel;
    private DbCartDeployOptions _deployOptions;
    private DbCartDeployCloudDdlPanel _deployCloudDDLPanel = new DbCartDeployCloudDdlPanel();
    private DbCartDeployAuthPanel _deployAuthPanel = new DbCartDeployAuthPanel();
    private DbCartDeployDataOptionPanel _deployDataOptionPanel = new DbCartDeployDataOptionPanel();
    private DbCartUserCloudConfig _config = new DbCartUserCloudConfig();
    private TargetFormat _targetFormat;
    private TargetOptionsPanel _targetOptions;
    private ExportAPI _expApi;

    public DbCartDeployCloudTool() {
        super(TYPE, 3);
    }

    @Override
    public IdeAction getAction() {
        if (this._action == null) {
            this._action = IdeAction.get((int)ACTION, null, (String)DbCartAddinArb.getString("DEPLOY_CLOUD_LABEL"), null, null, (Icon)RaptorImagesArb.getIcon((String)"CLOUD"), null, (boolean)true);
            this._action.addController((Controller)this);
        }
        return this._action;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == ACTION) {
            if (this.validateObjects()) {
                this.showDialog();
            }
            return true;
        }
        return false;
    }

    public void showDialog() {
        ArrayList<ExtractObject> arrayList = DbCartUtil.getTableModel().getIncludedDBORows();
        List<ExtractObject> list = DbCartUtil.validateUniqueObjects(arrayList, false);
        List<ExtractObject> list2 = DbCartDeployCloudUtil.validateConns(arrayList);
        List<ExtractObject> list3 = DbCartDeployCloudUtil.validateTypes(arrayList);
        List<ExtractObject> list4 = DbCartDeployCloudUtil.validateObjects(arrayList);
        if (!(list.isEmpty() && list2.isEmpty() && list3.isEmpty() && list4.isEmpty())) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            if (!list.isEmpty()) {
                DbCartAddinArb.format("NOT_SUPPORTED", new Object[]{DbCartAddinArb.getString("EXPORT_LABEL")} + "\n");
                stringBuilder.append(DbCartAddinArb.getString("NON_UNIQUE_CART") + "\n\n");
                for (ExtractObject extractObject : list) {
                    stringBuilder.append(string + Connections.getDisplayName((String)extractObject.getDBObject().getConnectionName()) + ": " + extractObject.getDBObject().getObjectType() + " " + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                    string = ", ";
                }
                stringBuilder.append("\n");
            }
            if (!(list2.isEmpty() && list3.isEmpty() && list4.isEmpty())) {
                stringBuilder.append(DbCartAddinArb.getString("UNABLE_TO_DEPLOY_OBJECTS_TO_CLOUD") + "\n");
                if (!list2.isEmpty()) {
                    stringBuilder.append(DbCartAddinArb.getString("BAD_CONN_TEXT") + "\n");
                    for (ExtractObject extractObject : list2) {
                        stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                        string = ", ";
                    }
                    stringBuilder.append("\n");
                }
                if (!list3.isEmpty()) {
                    string = "";
                    stringBuilder.append(DbCartAddinArb.getString("BAD_TYPE_TEXT") + "\n");
                    for (ExtractObject extractObject : list3) {
                        stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                        string = ", ";
                    }
                    stringBuilder.append("\n");
                }
                if (!list4.isEmpty()) {
                    string = "";
                    stringBuilder.append(DbCartAddinArb.getString("BAD_COLUMN_TEXT") + "\n");
                    for (ExtractObject extractObject : list4) {
                        stringBuilder.append(string + extractObject.getDBObject().getSchemaName() + "." + extractObject.getDBObject().getObjectName());
                        string = ", ";
                    }
                    stringBuilder.append("\n");
                }
            }
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)stringBuilder.toString(), (String)DbCartAddinArb.getString("BAD_COLUMN_TITLE"), (String)"DBCART_UNSUPPORTED_OBJECT_ERROR");
        } else {
            String string = DbCartAddinArb.getString("DEPLOY_CLOUD_DIALOG_TITLE");
            this._mainPanel = new JPanel();
            this._mainPanel.setLayout(new GridBagLayout());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this._mainPanel, "f1_deployobjectscloud_html");
            this._targetFormat = DbCartDeployCloudUtil.getTargetFormat();
            String string2 = this._targetFormat.getDefaultDirectory();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            this._targetFormat.setSaveAs(string2 + DbCartUtil.getTabPageName() + "." + "zip");
            this._targetOptions = new TargetOptionsPanel((Component)this._mainPanel, this._targetFormat);
            this._deployCloudDDLPanel.allowDisable(false);
            this._deployCloudDDLPanel.showDDLCheckBox(false);
            this._deployDataOptionPanel.showDisableConstraints(true);
            this._deployDataOptionPanel.showFormatOptions(true);
            this._configPanel = this.getConfigPanel();
            this._authPanel = this._deployAuthPanel.getPanel();
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this._targetOptions.getPanel(), "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            JLabel jLabel = new JLabel(DbCartAddinArb.getString("WORK_FILE"));
            TitledPane titledPane = new TitledPane((Component)jLabel, (Component)jPanel);
            this._targetPanel = new JPanel(new BorderLayout());
            this._targetPanel.add((Component)titledPane, "Center");
            this._ddlPanel = this._deployCloudDDLPanel.getPanel();
            this._dataPanel = this._deployDataOptionPanel.getPanel();
            boolean bl = false;
            for (ExtractObject object2 : arrayList) {
                if (!object2.isExtractMetaData()) continue;
                bl = true;
                break;
            }
            this._deployCloudDDLPanel.enableOptions(bl);
            bl = false;
            for (ExtractObject extractObject : arrayList) {
                if (!extractObject.isExtractData()) continue;
                bl = true;
                break;
            }
            this._deployDataOptionPanel.enableOptions(bl);
            this.addPanels();
            this._mainPanel.setBackground(UIManager.getColor("EWTDialog.background"));
            this._actionDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._mainPanel, null, (String)string, (int)14);
            this._actionDialog.pack();
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    if (actionEvent.getActionCommand().equalsIgnoreCase("apply")) {
                        if (DbCartDeployCloudTool.this._deployAuthPanel.getTitle() == null || DbCartDeployCloudTool.this._deployAuthPanel.getTitle().equals("")) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("NULL_TITLE_MESSAGE"), (String)DbCartAddinArb.getString("BAD_TITLE_TITLE"), (String)"DBCART_DEPLOY_BAD_TITLE");
                            return;
                        }
                        if (!DbCartDeployCloudUtil.isValidString(DbCartDeployCloudTool.this._deployAuthPanel.getTitle()).booleanValue()) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("BAD_TITLE_MESSAGE"), (String)DbCartAddinArb.getString("BAD_TITLE_TITLE"), (String)"DBCART_DEPLOY_BAD_TITLE");
                            return;
                        }
                        DbCartDeployCloudTool.this._targetFormat = DbCartDeployCloudTool.this._targetOptions.getFormat();
                        n = DbCartDeployCloudTool.this._targetFormat.validateSaveAsFile((Component)Ide.getMainWindow());
                        if (n == 0) {
                            SftpParms sftpParms = new SftpParms();
                            sftpParms.setCloudConnection(DbCartDeployCloudTool.this._deployAuthPanel.getConnName());
                            sftpParms.setImportName(DbCartDeployCloudTool.this._deployAuthPanel.getTitle());
                            sftpParms.setUser(DbCartDeployCloudTool.this._deployAuthPanel.getUser());
                            sftpParms.setPass(DbCartDeployCloudTool.this._deployAuthPanel.getPass());
                            sftpParms.setKeyFile(null);
                            sftpParms.setLocalFile(DbCartDeployCloudTool.this._targetFormat.getSaveAs());
                            sftpParms.setHost(DbCartDeployCloudTool.this._deployAuthPanel.getServer());
                            sftpParms.setPort(DbCartDeployCloudTool.this._deployAuthPanel.getPort());
                            DbCartDeployCloudTool.this._targetFormat.setSftpParms(sftpParms);
                            SftpUtil sftpUtil = new SftpUtil();
                            boolean bl = sftpUtil.SftpTestConnection(sftpParms);
                            if (!bl) {
                                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.getString("BAD_CONN_MESSAGE"), (String)DbCartAddinArb.getString("BAD_CONN_TITLE"), (String)"DBCART_DEPLOY_BAD_SFTP");
                                return;
                            }
                            DbCartDeployCloudTool.this._deployOptions = new DbCartDeployOptions();
                            DbCartDeployCloudTool.this._deployOptions.setSourceExtractObjectList(DbCartDeployCloudTool.this.getClonedExtractObjects());
                            DbCartDeployCloudTool.this._deployOptions.setTargetFormat(DbCartDeployCloudTool.this._targetFormat);
                            DbCartDeployCloudTool.this._deployOptions.setDDLFormat(DbCartDeployCloudTool.this.getDDLFormat());
                            DbCartDeployCloudTool.this._deployOptions.setDataFormat(DbCartDeployCloudTool.this.getDataFormat());
                            DbCartDeployCloudTool.this._expApi = new ExportAPI();
                            DbCartDeployCloudTool.this._expApi.setDeploy(DbCartDeployCloudTool.this._deployOptions);
                            DbCartDeployCloudTool.this._expApi.writeExportWithDialog();
                        }
                    }
                    if (n == 0) {
                        DbCartDeployCloudTool.this._actionDialog.setVisible(false);
                        DbCartDeployCloudTool.this._actionDialog.dispose();
                    } else if (n == 1) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartDeployCloudTool.this._targetFormat.getValidationMessage(), (String)DbCartAddinArb.getString("DEPLOY_LABEL"), (String)"DBCART_FILE_ERROR");
                    }
                }
            };
            this._actionDialog.addActionListener(actionListener);
            Dimension dimension = this._mainPanel.getPreferredSize();
            int n = (int)dimension.getHeight() + 100;
            int n2 = (int)dimension.getWidth() + 28;
            this._actionDialog.setMinimumSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._actionDialog);
            WizardLauncher.runDialog((JDialog)this._actionDialog);
        }
    }

    private void addPanels() {
        this._mainPanel.add((Component)this._configPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 23, 0, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._authPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._targetPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._ddlPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 0, 0), 0, 0));
        this._mainPanel.add((Component)this._dataPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 23, 2, new Insets(16, 0, 16, 0), 0, 0));
    }

    private void removeAll() {
        this._mainPanel.removeAll();
    }

    private DDLFormat getDDLFormat() {
        DDLFormat dDLFormat = DbCartDeployCloudUtil.getDDLFormat();
        dDLFormat.setDrop(this._deployCloudDDLPanel.getDoReplaceDest());
        dDLFormat.setCascade(this._deployCloudDDLPanel.getDoReplaceDest());
        return dDLFormat;
    }

    private ExtractDataFormat getDataFormat() {
        ExtractDataFormat extractDataFormat = this._deployDataOptionPanel.getFormatProperties();
        extractDataFormat.isSeparateDataFile(true);
        extractDataFormat.isTruncate(this._deployDataOptionPanel.getChkbxTruncData());
        extractDataFormat.isDisableConstraints(this._deployDataOptionPanel.getChkbxDisableConstraints());
        return extractDataFormat;
    }

    @Override
    public void openConfigOptions() {
        URL uRL = this._chooser.getSelectedURL();
        try {
            this._config = new DbCartUserCloudConfig(DbCartUserCloudConfig.importFrom(uRL));
            String string = this._config.getString("DbCartConfig");
            if (string == null) {
                string = DbCartAddinArb.getString("XML_FILE_NO_KEY");
            }
            if (!string.equals("deploy_cloud_tool")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)DbCartAddinArb.format("XML_FILE_ERROR_MESSAGE", uRL.getFile(), "\"deploy_cloud_tool\"", string), (String)DbCartAddinArb.getString("XML_FILE_ERROR_TITLE"), (String)"XML_FILE_ERROR_TITLE");
            } else {
                String string2;
                this.removeAll();
                String string3 = this._config.getString("CLOUD_CONN");
                if (!this.setCombo(string3, this._deployAuthPanel.getConnJCombo())) {
                    string2 = string3 == null || string3.length() == 0 ? DbCartAddinArb.getString("XML_CONN_ERROR_MESSAGE2") : DbCartAddinArb.format("XML_CONN_ERROR_MESSAGE1", string3);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)DbCartAddinArb.getString("XML_CONN_ERROR_TITLE"), (String)"XML_CONN_ERROR_TITLE");
                }
                this._deployAuthPanel.setTitle(this._config.getString("CLOUD_TITLE"));
                string2 = this.getDDLFormat();
                this._config.copyToDDLFormat((DDLFormat)string2);
                boolean bl = DbCartUtil.getTableModel().isAnyDDLRows();
                string2.isExtractEnabled(bl);
                this._deployCloudDDLPanel.enableOptions(bl);
                this._ddlPanel = this._deployCloudDDLPanel.getPanel();
                this._deployCloudDDLPanel.setDoReplaceDest(string2.getDrop());
                ExtractDataFormat extractDataFormat = this.getDataFormat();
                this._config.copyToDataFormat(extractDataFormat);
                this._dataPanel = this._deployDataOptionPanel.getPanel(extractDataFormat);
                this._targetFormat = this._targetOptions.getFormat();
                this._config.copyToTargetFormat(this._targetFormat);
                this._targetFormat.setSaveAs(this._config.getString("CLOUD_TRANSFER_FILE"));
                this._targetOptions.setFormat(this._targetFormat);
                this._targetPanel = this._targetOptions.getPanel();
                this.addPanels();
                this._actionDialog.pack();
                Dimension dimension = this._mainPanel.getPreferredSize();
                int n = (int)dimension.getHeight() + 100;
                int n2 = (int)dimension.getWidth() + 28;
                this._actionDialog.setSize(n2, n);
                this._actionDialog.setPreferredSize(n2, n);
                this._actionDialog.repaint();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    @Override
    public void saveConfigOptions() {
        URL uRL = this.getConfigURL();
        try {
            this._config.putString("DbCartConfig", "deploy_cloud_tool");
            this._config.putString("CLOUD_TITLE", this._deployAuthPanel.getTitle());
            this._config.putString("CLOUD_CONN", this._deployAuthPanel.getConnName());
            this._config.copyFromDDLFormat(this.getDDLFormat());
            this._config.copyFromDataFormat(this.getDataFormat());
            this._config.copyFromTargetFormat(this._targetOptions.getFormat());
            this._config.putString("CLOUD_TRANSFER_FILE", this._targetOptions.getFormat().getSaveAs());
            this._config.exportTo(uRL);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

