/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.lifecycle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.lifecycle.LifecycleContext;
import oracle.adf.share.lifecycle.LifecycleListener;
import oracle.adf.share.lifecycle.MetaClass;
import oracle.adf.share.mt.util.MultiTenantStorage;
import oracle.adf.share.platform.AdfServerPlatformUtil;

public class LifecycleManager {
    protected static final Logger logger = Logger.getLogger(LifecycleManager.class.getName());
    private static final MultiTenantStorage<ConcurrentHashMap<String, LifecycleManager>> managers = new MultiTenantStorage<ConcurrentHashMap<String, LifecycleManager>>(){

        @Override
        protected ConcurrentHashMap<String, LifecycleManager> initialValue() {
            return new ConcurrentHashMap<String, LifecycleManager>();
        }
    };
    protected final String appId;
    protected final ArrayList<MetaClass<LifecycleListener>> listeners;

    public static LifecycleManager getInstance(String appId) {
        LifecycleManager mgr2;
        ConcurrentHashMap<String, LifecycleManager> mgrMap = managers.get();
        LifecycleManager mgr = mgrMap.get(appId);
        if (mgr == null && (mgr2 = mgrMap.putIfAbsent(appId, mgr = new LifecycleManager(appId))) != null) {
            return mgr2;
        }
        return mgr;
    }

    public static LifecycleManager releaseInstance(String appId) {
        ConcurrentHashMap<String, LifecycleManager> mgrMap = managers.get();
        LifecycleManager mgr = mgrMap.remove(appId);
        if (mgr != null) {
            mgr.listeners.clear();
        }
        return mgr;
    }

    protected LifecycleManager(String appId) {
        this.appId = appId;
        this.listeners = new ArrayList();
        Iterator<LifecycleListener> iter = ServiceLoader.load(LifecycleListener.class).iterator();
        while (iter.hasNext()) {
            this.addListener(iter.next());
        }
    }

    public void addListener(LifecycleListener listener) {
        MetaClass<LifecycleListener> mc = new MetaClass<LifecycleListener>(listener);
        if (!this.listeners.contains(mc)) {
            this.listeners.add(mc);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "addListener=" + mc + ", appId=" + this.appId, logger.isLoggable(Level.FINEST) ? new Throwable("DIAGNOSTIC AID") : null);
            }
        }
    }

    public void notifyListeners(LifecycleContext context) {
        ArrayList<MetaClass<LifecycleListener>> tmp = new ArrayList<MetaClass<LifecycleListener>>(this.listeners);
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder buf = new StringBuilder();
            Iterator<MetaClass<LifecycleListener>> iter = tmp.iterator();
            while (iter.hasNext()) {
                buf.append(((Object)iter.next()).toString() + "\n");
            }
            logger.log(Level.FINE, "ListenerCount=" + tmp.size() + ", " + context.toString() + "\n" + buf.toString(), logger.isLoggable(Level.FINEST) ? new Throwable("DIAGNOSTIC AID") : null);
        }
        for (MetaClass<LifecycleListener> mc : tmp) {
            try {
                mc.getInstance().lifecycleEvent(context);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(AdfServerPlatformUtil.INCIDENT_ERROR)) continue;
                logger.log(AdfServerPlatformUtil.INCIDENT_ERROR, "Listener=" + mc + ", " + context, t);
            }
        }
    }
}

