/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.logging.ADFLoggerODLHelper;
import oracle.adf.share.logging.ADFLoggerUtil;
import oracle.adf.share.platform.AdfAbstractSupport;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adf.share.platform.UnknownPlatformException;
import oracle.jrf.Application;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupport;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public abstract class AdfServerPlatformSupport
extends AdfAbstractSupport {
    public static final String CLUSTER_UNKNOWN = "cluster_unknown";
    protected static final Logger logger = Logger.getLogger(AdfServerPlatformSupport.class.getName());
    protected static final String CREDENTIAL_STORE_PROVIDER_DEFAULT = "oracle.adf.share.security.providers.jps.CSFCredentialStore";
    protected static final String CREDENTIAL_STORE_PROVIDER_NO_STORE = "oracle.adf.share.security.ADFNoCredentialSupportStore";

    public String getClusterName() throws PortabilityLayerException {
        Object svrcomp = this.getConcretePlatformSupport();
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getClusterName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
    }

    public byte[] getCheckSum(String algorithm, byte[] data) throws Exception {
        return new byte[0];
    }

    protected abstract Object getConcretePlatformSupport() throws PortabilityLayerException;

    public String getPlatformName() {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getPlatformName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    @Deprecated
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getApplicationIdentifier();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public Application getApplication() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getApplication();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public Connection getNativeDBConnection(Connection datasourceJdbcConnection, Class targetUnwrapClass) {
        try {
            ClassLoader cl = ClassUtils.getClassLoader(AdfServerPlatformSupport.class);
            Class localUnwrapClass = cl.loadClass("oracle.jdbc.OracleConnection");
            if (targetUnwrapClass != null) {
                localUnwrapClass = targetUnwrapClass;
            }
            Method meth1 = datasourceJdbcConnection.getClass().getMethod("isWrapperFor", Class.class);
            Boolean isWrappable = (Boolean)meth1.invoke((Object)datasourceJdbcConnection, localUnwrapClass);
            if (isWrappable.booleanValue()) {
                Method meth2 = datasourceJdbcConnection.getClass().getMethod("unwrap", Class.class);
                return (Connection)meth2.invoke((Object)datasourceJdbcConnection, localUnwrapClass);
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return datasourceJdbcConnection;
    }

    @Deprecated
    public String[] getSupportedPlatformNames() {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            String[] pms = ((ServerPlatformSupport)svrcomp).getSupportedPlatformNames();
            int len = pms.length;
            String[] platforms = new String[len + 1];
            System.arraycopy(pms, 0, platforms, 0, len);
            platforms[len] = AdfAbstractSupport.PLATFORM_TYPE.GLASSFISH_PLATFORM.toString();
            return platforms;
        }
        return new String[]{AdfAbstractSupport.PLATFORM_TYPE.WEBLOGIC_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.WEBSPHERE_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.JBOSS_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.GLASSFISH_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.WEBLOGIC_CORE_PLATFORM.toString(), AdfAbstractSupport.PLATFORM_TYPE.TOMCAT_PLATFORM.toString()};
    }

    public String getAdminServerName() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getAdminServerName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getServerName() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getServerLogPath() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerLogPath();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public boolean isAdminServer() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).isAdminServer();
        }
        return false;
    }

    public static boolean isWebLogic() {
        return AdfServerPlatformUtil.isWebLogicJRF();
    }

    public static boolean isWebLogicJRF() {
        return AdfServerPlatformUtil.isWebLogicJRF();
    }

    public static boolean isWebLogicCore() {
        return AdfServerPlatformUtil.isWebLogicCore();
    }

    public static boolean isWebSphere() {
        return AdfServerPlatformUtil.isWebSphere();
    }

    public boolean isWebSphereND() {
        return AdfServerPlatformUtil.isWebSphereND();
    }

    public boolean isWebSphereAS() {
        return AdfServerPlatformUtil.isWebSphereAS();
    }

    public static boolean isJBoss() {
        return AdfServerPlatformUtil.isJBoss();
    }

    public static boolean isJEE() {
        return AdfServerPlatformUtil.isJEE();
    }

    public static boolean isGlassFish() {
        return AdfServerPlatformUtil.isGlassFish();
    }

    public static boolean isTomcat() {
        return AdfServerPlatformUtil.isTomcat();
    }

    public String getServerConfigDirectory(String domainName, String serverName) throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerConfigDirectory(domainName, serverName);
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getDomainConfigDirectory() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getDomainConfigDirectory();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getServerConfigDirectory() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getServerConfigDirectory();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public String getDomainName() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getDomainName();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public PortConfig getPortConfig() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getPortConfig();
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public PortConfig getPortConfig(String serverId) throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getPortConfig(serverId);
        }
        throw new UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public boolean isExalogicOptimizationsEnabled() {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).isExalogicOptimizationsEnabled();
        }
        return false;
    }

    public String getCredentialStoreProviderClassName() {
        return CREDENTIAL_STORE_PROVIDER_DEFAULT;
    }

    public String getJtaTransactionXidClassName() {
        return null;
    }

    public String getCommonComponentsHome() throws PortabilityLayerException {
        Object svrcomp = null;
        try {
            svrcomp = this.getConcretePlatformSupport();
        }
        catch (PortabilityLayerException e) {
            logger.severe(e.getMessage());
        }
        if (svrcomp != null) {
            return ((ServerPlatformSupport)svrcomp).getCommonComponentsHome();
        }
        throw new oracle.jrf.UnknownPlatformException(JRFMessageBundleHelper.msg.getString("JRF-10015"));
    }

    public void setSupplementalAttributes() {
        if (AdfServerPlatformUtil.isDMSAvailable()) {
            ADFLoggerUtil.setSupplementalAttributes();
        }
    }

    public void begin(String loggerName, String actionName, HashMap<String, String> contextData) {
        ADFLoggerODLHelper helper = new ADFLoggerODLHelper();
        helper.beginPS(loggerName, actionName, contextData);
    }

    public void beginNode(String loggerName, Level level, String actionName, Map<String, String> contextData, String methodName) {
        ADFLoggerODLHelper helper = new ADFLoggerODLHelper();
        helper.beginNodePS(loggerName, level, actionName, contextData, methodName);
    }

    public void addContextData(String loggerName, String actionName, HashMap<String, String> contextData) {
        ADFLoggerODLHelper helper = new ADFLoggerODLHelper();
        helper.addContextDataPS(loggerName, actionName, contextData);
    }

    public void addMessageToRequest(String loggerName, Level level, String actionName, Map<String, String> contextData, String MessageTag, String methodName, Throwable thrown) {
        ADFLoggerODLHelper helper = new ADFLoggerODLHelper();
        helper.addMessageToRequestPS(loggerName, level, actionName, contextData, MessageTag, methodName, thrown);
    }

    public void endNode(String loggerName, Level level, String actionName) {
        ADFLoggerODLHelper helper = new ADFLoggerODLHelper();
        helper.endNodePS(loggerName, level, actionName);
    }

    public void LogRelativeADFRequest(String loggerName, String ecid) {
        ADFLoggerODLHelper helper = new ADFLoggerODLHelper();
        helper.LogRelativeADFRequest(loggerName, ecid);
    }
}

