/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.objectmerge.logging;

import java.util.ArrayList;
import oracle.adfinternal.share.objectmerge.logging.SandboxLogRecord;

public class SandboxLogger<R extends SandboxLogRecord> {
    private final String _sandboxId;
    private final ArrayList<R> _buffer;

    private SandboxLogger(String sandboxId, boolean buffering) {
        if (sandboxId == null) {
            throw new IllegalArgumentException("Invalid sandbox ID: null.");
        }
        this._sandboxId = sandboxId;
        this._buffer = buffering ? new ArrayList() : null;
    }

    public static <T extends SandboxLogRecord> SandboxLogger<T> getLogger(String sandboxId, Class<T> recordClass) {
        return SandboxLogger.getLogger(sandboxId, recordClass, false);
    }

    public static <T extends SandboxLogRecord> SandboxLogger<T> getLogger(String sandboxId, Class<T> recordClass, boolean buffering) {
        if (sandboxId == null) {
            return null;
        }
        if (recordClass == null) {
            return null;
        }
        return new SandboxLogger(sandboxId, buffering);
    }

    private void _log(R record) {
        System.out.println(record);
    }

    public void log(R record) {
        if (record == null) {
            throw new IllegalArgumentException("Invalid record: null.");
        }
        if (this._buffer != null) {
            this._buffer.add(record);
        } else {
            this._log(record);
        }
    }

    public void flush() {
        if (this._buffer == null) {
            return;
        }
        for (SandboxLogRecord r : this._buffer) {
            this._log(r);
        }
        this._buffer.clear();
    }
}

