/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.perf;

import java.util.logging.Level;
import oracle.adf.share.logging.internal.LoggingUtils;
import oracle.adf.share.logging.internal.perf.ADFPerfSensor;
import oracle.adf.share.logging.internal.perf.SensorTable;
import oracle.adf.share.perf.Timer;
import oracle.adf.share.perf.TimerProvider;
import oracle.adf.share.perf.TimerToken;
import oracle.adfinternal.share.perf.NounUtil;
import oracle.adfinternal.share.perf.TimerTokenImpl;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.SegregationType;

public class TimerImpl
extends Timer {
    private ThreadLocal<TimerTokenImpl> mTokenHolder = null;
    private PhaseEvent mPEvent = null;
    private long mElapsedTime = 0L;
    private TimerProvider mProvider = null;

    private TimerImpl(Level level, String sensorFullName, PhaseEvent pe) {
        super(level, sensorFullName);
        this.mPEvent = pe;
        if (pe != null) {
            this.mTokenHolder = new ThreadLocal<TimerTokenImpl>(){

                @Override
                protected TimerTokenImpl initialValue() {
                    return new TimerTokenImpl(false, 0L, true);
                }
            };
        }
    }

    public static Timer createDMSTimer(Level level, String groupName, String name, String type, String desc, TimerProvider provider, SegregationType sgType) {
        if ("__LAZY_NOUN_TYPE__".equals(type)) {
            type = LoggingUtils.getNounType(groupName);
        }
        if (provider != null) {
            provider.createTimers(level, groupName, name, type, desc);
            if (!provider.isParentLoggable()) {
                type = null;
            }
        }
        name = LoggingUtils.standardizeSensorName(name);
        StringBuilder groupNameBuf = LoggingUtils.standardizeGroupName2(groupName);
        groupNameBuf.append('/').append(name).append(" ").append("t");
        String fullName = groupNameBuf.toString();
        ADFPerfSensor timer = SensorTable.getSensor(fullName);
        if (timer != null && timer instanceof Timer) {
            if (timer instanceof TimerImpl) {
                ((TimerImpl)timer).mProvider = provider;
            }
            return (Timer)timer;
        }
        PhaseEvent pet = null;
        if (sLogger.isLoggable(level) || LoggingUtils.isDMSLoggingEnabled(level)) {
            Noun parentNoun = NounUtil.registerGroupNameIfNeeded(groupName, sgType, type);
            pet = PhaseEvent.create((Noun)parentNoun, (String)name, (String)desc);
            pet.deriveMetric(511);
        }
        Timer tr = new TimerImpl(level, fullName, pet);
        tr = (Timer)SensorTable.putSensor(fullName, tr);
        if (timer instanceof TimerImpl) {
            ((TimerImpl)timer).mProvider = provider;
        }
        return tr;
    }

    @Override
    public void start() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        TimerTokenImpl token = this.getTimerToken();
        if (!token.mStarted) {
            token.mDMSToken = this.mPEvent.start();
            token.mStarted = true;
        }
    }

    @Override
    public TimerToken startWithToken() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return null;
        }
        return new TimerTokenImpl(true, this.mPEvent.start(), false);
    }

    @Override
    public void stop() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        try {
            TimerTokenImpl token = this.getTimerToken();
            if (token != null && token.mStarted) {
                this.mElapsedTime = this.mPEvent.stop2(token.mDMSToken) - token.mDMSToken;
                if (this.mEnablePerfLog) {
                    this.log(token.mDMSToken, Long.toString(this.mElapsedTime), token.mEcid);
                }
                token.mStarted = false;
            }
        }
        finally {
            this.cleanupTimerToken();
        }
    }

    @Override
    public void stopWithToken(TimerToken tok) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (tok instanceof TimerTokenImpl) {
            TimerTokenImpl token = (TimerTokenImpl)tok;
            if (token.mStarted) {
                this.mElapsedTime = this.mPEvent.stop2(token.mDMSToken) - token.mDMSToken;
                if (this.mEnablePerfLog) {
                    this.log(token.mDMSToken, Long.toString(this.mElapsedTime), token.mEcid);
                }
                token.mStarted = false;
            }
        }
    }

    @Override
    public void stop(int returnValue) {
        this.stopComposite(null, returnValue, null);
    }

    @Override
    public void stopWithToken(TimerToken token, int returnValue) {
        this.stopComposite(token, returnValue, null);
    }

    @Override
    public void stop(Object returnValue) {
        this.stopComposite(null, 0, returnValue);
    }

    @Override
    public void stopWithToken(TimerToken token, Object returnValue) {
        this.stopComposite(token, 0, returnValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopComposite(TimerToken tok, int returnInt, Object returnObj) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        TimerTokenImpl token = null;
        if (tok == null) {
            token = this.getTimerToken();
        } else if (tok instanceof TimerTokenImpl) {
            token = (TimerTokenImpl)tok;
        }
        try {
            if (token != null && token.mStarted) {
                TimerImpl[] timers;
                long endTime = this.mPEvent.stop2(token.mDMSToken);
                this.mElapsedTime = endTime - token.mDMSToken;
                if (this.mProvider != null && (timers = returnObj != null ? (TimerImpl[])this.mProvider.getTimers(returnObj) : (TimerImpl[])this.mProvider.getTimers(returnInt)) != null) {
                    for (int i = 0; i < timers.length; ++i) {
                        PhaseEvent pe = timers[i].mPEvent;
                        if (pe == null) continue;
                        pe.start(token.mDMSToken);
                        pe.stop(token.mDMSToken, endTime);
                        if (!this.mEnablePerfLog) continue;
                        timers[i].log(token.mDMSToken, Long.toString(this.mElapsedTime), token.mEcid);
                    }
                }
                if (this.mEnablePerfLog && (this.mProvider != null && this.mProvider.isParentLoggable() || this.mProvider == null)) {
                    this.log(token.mDMSToken, Long.toString(this.mElapsedTime), token.mEcid);
                }
                token.mStarted = false;
            }
        }
        finally {
            this.cleanupTimerToken();
        }
    }

    @Override
    public void cleanup() {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        try {
            TimerTokenImpl token = this.getTimerToken();
            if (token != null && token.mStarted) {
                this.mPEvent.abort(token.mDMSToken);
                token.mStarted = false;
            }
        }
        finally {
            this.cleanupTimerToken();
        }
    }

    @Override
    public void cleanupWithToken(TimerToken tok) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        if (tok instanceof TimerTokenImpl) {
            TimerTokenImpl token = (TimerTokenImpl)tok;
            if (token.mStarted) {
                this.mPEvent.abort(token.mDMSToken);
                token.mStarted = false;
            }
        }
    }

    private TimerTokenImpl getTimerToken() {
        return this.mTokenHolder.get();
    }

    private void cleanupTimerToken() {
        this.mTokenHolder.remove();
    }

    @Override
    public void reset() {
        if (this.mPEvent != null) {
            this.mPEvent.reset();
        }
        this.mElapsedTime = 0L;
    }

    @Override
    public void destroy() {
        if (this.mPEvent != null) {
            this.mPEvent.destroy();
        }
    }

    @Override
    protected long getElapsedTime() {
        return this.mElapsedTime;
    }
}

