/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.extension.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.Extension;
import javax.ide.util.MetaClassAwareClassLoader;
import oracle.ide.ExtensionRegistry;
import oracle.ide.osgi.Platform;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ClassLoaderProxy
extends oracle.javatools.util.ClassLoaderProxy
implements MetaClassAwareClassLoader {
    private static Logger s_LOG = Logger.getLogger(ClassLoaderProxy.class.getName());
    private final BundleClassLoaderAdapter m_bundleAdapter;
    private ThreadLocal<Boolean> m_processingInitExemptions;
    private ThreadLocal<Boolean> m_isFullyLoadingAlready;
    private static Map<String, ClassLoaderProxy> m_extId2ClassLoaderProxy = new HashMap<String, ClassLoaderProxy>();

    public static ClassLoader findOrCreateLoader(String extensionId) {
        ExtensionManagerImpl extensionManager;
        List<Bundle> bundles = Platform.getBundleRegistry().getBundles();
        Bundle bundleFound = null;
        for (Bundle b : bundles) {
            if (!b.getSymbolicName().equalsIgnoreCase(extensionId)) continue;
            bundleFound = b;
            break;
        }
        if (bundleFound == null) {
            return null;
        }
        ClassLoaderProxy proxy = m_extId2ClassLoaderProxy.get(extensionId);
        if (proxy == null) {
            proxy = new ClassLoaderProxy(bundleFound);
            m_extId2ClassLoaderProxy.put(extensionId, proxy);
        }
        if ((extensionManager = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry()).isCurrentThreadFullyLoadingExtension(extensionId)) {
            return proxy.getDelegate();
        }
        return proxy;
    }

    public ClassLoaderProxy(Bundle bundle) {
        this.m_bundleAdapter = new BundleClassLoaderAdapter(bundle);
        this.m_processingInitExemptions = new ThreadLocal();
        this.m_isFullyLoadingAlready = new ThreadLocal();
    }

    public ClassLoader getDelegate() {
        return this.m_bundleAdapter;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.getDelegate().loadClass(name);
        this.fullyLoadExtensionIfNeeded(name, false);
        return clazz;
    }

    public Class loadMetaClass(String className, boolean triggerTopmostClassloader) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, this.getDelegate());
        }
        catch (IllegalStateException ise) {
            ClassNotFoundException cnfe = new ClassNotFoundException("Failed to load " + className + " from the bundle " + "because of IllegalStateException thrown when " + "the OSGi container tried to access the bundle cache. " + "This may not be a real issue, but if it is, " + "see if running with -clean gets around it", ise);
            throw cnfe;
        }
        this.fullyLoadExtensionIfNeeded(className, triggerTopmostClassloader);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullyLoadExtensionIfNeeded(String triggeringClass, boolean triggerTopmostClassloader) {
        if (!this.isProcessingNonExtInitClasses().booleanValue() && this.isExtensionNotFullyLoaded() && (triggerTopmostClassloader || this.bundleDelgateClassLoaderWasInited()) && !this.isIDEExtension()) {
            this.m_bundleAdapter.startBundle();
            this.setFullyLoadingAlready(Boolean.TRUE);
            try {
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                Extension extension = registry.findExtension(this.m_bundleAdapter.getBundle().getSymbolicName());
                registry.fullyLoadExtension(extension, "Triggered by loading class: " + triggeringClass);
            }
            catch (Throwable t) {
                s_LOG.log(Level.SEVERE, "Failed while fully loading " + this.m_bundleAdapter.getBundle().getSymbolicName() + " , trigerring class -> " + triggeringClass, t);
            }
            finally {
                this.setFullyLoadingAlready(Boolean.FALSE);
            }
        }
    }

    void setProcessingNonExtInitClasses(Boolean isProcessingNonInit) {
        this.m_processingInitExemptions.set(isProcessingNonInit);
    }

    Boolean isProcessingNonExtInitClasses() {
        if (this.m_processingInitExemptions.get() == null) {
            this.m_processingInitExemptions.set(Boolean.FALSE);
        }
        return this.m_processingInitExemptions.get();
    }

    private void setFullyLoadingAlready(Boolean isFLA) {
        this.m_isFullyLoadingAlready.set(isFLA);
    }

    private Boolean isFullyLoadingAlready() {
        if (this.m_isFullyLoadingAlready.get() == null) {
            this.m_isFullyLoadingAlready.set(Boolean.FALSE);
        }
        return this.m_isFullyLoadingAlready.get();
    }

    private boolean isExtensionNotFullyLoaded() {
        Extension ext = ExtensionRegistry.getExtensionRegistry().findExtension(this.m_bundleAdapter.getBundle().getSymbolicName());
        if (ext != null) {
            return !ExtensionRegistry.getExtensionRegistry().isFullyLoaded(ext) && this.isFullyLoadingAlready() == false;
        }
        s_LOG.log(Level.WARNING, this.m_bundleAdapter.getBundle().getSymbolicName() + " was not an extension in the ext registry. " + "This can happen if the extension registry is not fully available. Did this happen during startup?");
        return false;
    }

    private boolean bundleDelgateClassLoaderWasInited() {
        return this.m_bundleAdapter.m_classloader != null;
    }

    private boolean isIDEExtension() {
        return "oracle.ide".equals(this.m_bundleAdapter.getBundle().getSymbolicName());
    }

    public static Extension findExtensionByClassLoader(ClassLoader loader) {
        if (loader instanceof ClassLoaderProxy) {
            return ClassLoaderProxy.findExtensionByClassLoaderProxy((ClassLoaderProxy)((Object)loader));
        }
        return ClassLoaderProxy.findExtensionByClassLoaderReference(loader);
    }

    private static Extension findExtensionByClassLoaderProxy(ClassLoaderProxy proxy) {
        BundleClassLoaderAdapter delegate = (BundleClassLoaderAdapter)proxy.getDelegate();
        return ExtensionRegistry.getExtensionRegistry().findExtension(delegate.getBundle().getSymbolicName());
    }

    public static Extension findExtensionByClassLoaderReference(ClassLoader classLoaderRef) {
        Extension ext;
        DefaultClassLoader defCL;
        Bundle bundle;
        String bundleSymbolicName;
        if (classLoaderRef instanceof DefaultClassLoader && (bundleSymbolicName = (String)(bundle = (defCL = (DefaultClassLoader)classLoaderRef).getBundle()).getHeaders().get("Bundle-SymbolicName")) != null && (ext = ExtensionRegistry.getExtensionRegistry().findExtension(bundleSymbolicName)) != null) {
            return ext;
        }
        for (Extension extension : ExtensionRegistry.getExtensionRegistry().getExtensions()) {
            String extensionId = extension.getID();
            ClassLoaderProxy proxy = m_extId2ClassLoaderProxy.get(extensionId);
            BundleClassLoaderAdapter delegate = (BundleClassLoaderAdapter)proxy.getDelegate();
            if (!classLoaderRef.equals(delegate.m_classloader)) continue;
            return extension;
        }
        return null;
    }

    private class BundleClassLoaderAdapter
    extends ClassLoader {
        private final Bundle m_bundle;
        private volatile ClassLoader m_classloader = null;
        private Enumeration<URL> EMPTY_ENUMERATION = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                return null;
            }
        };

        public BundleClassLoaderAdapter(Bundle bundle) {
            this.m_bundle = bundle;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            DefaultClassLoader defCL;
            Class clazz = this.m_bundle.loadClass(className);
            if (this.m_classloader == null && clazz.getClassLoader() instanceof DefaultClassLoader && (defCL = (DefaultClassLoader)clazz.getClassLoader()).getDelegate() instanceof BundleLoader) {
                BundleLoader del = (BundleLoader)defCL.getDelegate();
                AbstractBundle bundle = del.getBundle();
                if (this.m_bundle.getSymbolicName().equals(bundle.getSymbolicName())) {
                    this.m_classloader = clazz.getClassLoader();
                }
            }
            return clazz;
        }

        @Override
        public synchronized void clearAssertionStatus() {
            this.m_classloader.clearAssertionStatus();
        }

        @Override
        public URL getResource(String resourcePath) {
            ClassLoader loader;
            URL url = this.m_bundle.getResource(resourcePath);
            if (url == null && this.m_classloader != null) {
                url = this.m_classloader.getResource(resourcePath);
            }
            if (url == null && resourcePath.toLowerCase().endsWith(".png") && !"oracle.icons".equals(this.m_bundle.getSymbolicName()) && (loader = ClassLoaderProxy.findOrCreateLoader("oracle.icons")) != null) {
                url = loader.getResource(resourcePath);
            }
            return url;
        }

        @Override
        public InputStream getResourceAsStream(String resourcePath) {
            URL resURL = this.m_bundle.getResource(resourcePath);
            if (resURL != null) {
                try {
                    return resURL.openStream();
                }
                catch (IOException e) {
                    s_LOG.log(Level.SEVERE, "Unable to open stream " + resourcePath + " in " + this.m_bundle.getSymbolicName(), e);
                }
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String resourcePath) throws IOException {
            Enumeration<URL> urls = this.m_bundle.getResources(resourcePath);
            if (urls == null && this.m_classloader != null) {
                urls = this.m_classloader.getResources(resourcePath);
            }
            return urls != null ? urls : this.EMPTY_ENUMERATION;
        }

        @Override
        public synchronized void setClassAssertionStatus(String arg0, boolean arg1) {
            this.m_classloader.setClassAssertionStatus(arg0, arg1);
        }

        @Override
        public synchronized void setDefaultAssertionStatus(boolean arg0) {
            this.m_classloader.setDefaultAssertionStatus(arg0);
        }

        @Override
        public synchronized void setPackageAssertionStatus(String arg0, boolean arg1) {
            this.m_classloader.setPackageAssertionStatus(arg0, arg1);
        }

        public Bundle getBundle() {
            return this.m_bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startBundle() {
            try {
                Bundle bundle = this.m_bundle;
                synchronized (bundle) {
                    if (this.m_bundle.getState() != 32 && this.m_bundle.getState() != 8) {
                        this.m_bundle.start();
                    }
                }
            }
            catch (BundleException e) {
                throw new IllegalStateException("Wrapped as runtime the following bundle exception -- " + e.getMessage(), e);
            }
        }
    }
}

