/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.osgi.manip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.ide.net.URLFactory;
import oracle.ide.osgi.boot.api.BundlesInfoUtil;
import oracle.ide.osgi.manip.SimpleBundleEntry;

public class SimpleBundleEntriesList
implements Iterable<SimpleBundleEntry> {
    private BundlesInfoUtil.InstallationSource m_installationSource;

    SimpleBundleEntriesList(URL installationDirectory) {
        this.m_installationSource = BundlesInfoUtil.InstallationSource.create((String)installationDirectory.getPath());
    }

    boolean isEmpty() {
        return this.m_installationSource.isEmpty();
    }

    public synchronized void load() throws FileNotFoundException, IOException {
        this.m_installationSource.load();
    }

    public List<SimpleBundleEntry> getBundleEntries() {
        if (!this.isLoaded()) {
            try {
                this.load();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LinkedList<SimpleBundleEntry> simpleBundleEntries = new LinkedList<SimpleBundleEntry>();
        Collection allBundleInfoData = this.m_installationSource.getAllSources();
        for (String bundleInfoDatum : allBundleInfoData) {
            SimpleBundleEntry sbe = SimpleBundleEntry.create(bundleInfoDatum, this.m_installationSource.getConfigurationDirectoryPath());
            simpleBundleEntries.add(sbe);
        }
        return Collections.unmodifiableList(simpleBundleEntries);
    }

    public BundlesInfoUtil.InstallationSource getInstallationSource() {
        return this.m_installationSource;
    }

    public boolean isLoaded() {
        return this.m_installationSource.isLoaded();
    }

    public boolean contains(String bundleSymbolicName) {
        return this.m_installationSource.find(bundleSymbolicName) != null;
    }

    public SimpleBundleEntry find(String bundleSymbolicName) {
        String bundleInfoDatum = this.m_installationSource.find(bundleSymbolicName);
        return bundleInfoDatum != null ? SimpleBundleEntry.create(bundleInfoDatum, this.m_installationSource.getConfigurationDirectoryPath()) : null;
    }

    public int size() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("trying to get the size of the list of bundles while the list of bundles isn't loaded");
        }
        return this.m_installationSource.size();
    }

    @Override
    public synchronized Iterator<SimpleBundleEntry> iterator() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("trying to get an itertor to the list of bundles while the list of bundles isn't loaded");
        }
        Collection bundleInfoData = this.m_installationSource.getAllSources();
        ArrayList<SimpleBundleEntry> simpleBundleEntries = new ArrayList<SimpleBundleEntry>(this.m_installationSource.size());
        for (String bundleInfoDatum : bundleInfoData) {
            simpleBundleEntries.add(SimpleBundleEntry.create(bundleInfoDatum, this.m_installationSource.getConfigurationDirectoryPath()));
        }
        return simpleBundleEntries.iterator();
    }

    public boolean add(SimpleBundleEntry bundle) {
        if (!this.isLoaded()) {
            throw new IllegalStateException("trying to add bundle " + bundle.getBundleSymbolicName() + " to a while the list of bundles isn't loaded");
        }
        if (SimpleBundleEntry.isValid(bundle)) {
            this.m_installationSource.removeByName(bundle.getBundleSymbolicName());
            this.m_installationSource.add(bundle.toBundleInfoFormat(URLFactory.newURL((String)this.m_installationSource.getConfigurationDirectoryPath())), BundlesInfoUtil.InstallationSource.INSTALL_TYPE.EDT);
            return true;
        }
        return false;
    }

    public void save() throws IOException {
        if (this.isLoaded()) {
            this.m_installationSource.saveChanges();
        }
    }

    public void save(BundlesInfoUtil.InstallationSource.INSTALL_TYPE type) {
        if (this.isLoaded()) {
            this.m_installationSource.save(type);
        }
    }

    public boolean delete(BundlesInfoUtil.InstallationSource.INSTALL_TYPE type) {
        return this.m_installationSource.delete(type);
    }
}

