/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.cloud;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.cloud.CloudConnectionPanel;
import oracle.dbtools.thirdparty.cloud.Messages;
import oracle.ide.util.ResourceUtils;

class BasicPanel
extends JPanel
implements CDComponentView {
    private static final long serialVersionUID = 1L;
    private final CloudConnectionPanel m_basicPanel;
    private JLabel m_hostLbl = new JLabel();
    protected JTextField m_tfdHost = new JTextField(15);
    private JLabel m_schemaLbl = new JLabel();
    protected JTextField m_tfdSchema = new JTextField(15);
    public static final String SCHEMA = "schema";

    public BasicPanel(CloudConnectionPanel cloudConnectionPanel) {
        this.m_basicPanel = cloudConnectionPanel;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void clear() {
        this.m_tfdHost.setText("");
        this.m_tfdSchema.setText("");
    }

    public void generateProperties(Properties properties) {
        String string = "";
        string = this.m_tfdHost.getText().trim();
        properties.setProperty("customUrl", string);
        String string2 = this.m_tfdSchema.getText().trim();
        properties.setProperty(SCHEMA, string2);
    }

    private void jbInit() throws Exception {
        this.m_tfdHost.setText("localhost");
        this.m_tfdSchema.setText("");
        this.setLayout(new GridBagLayout());
        ResourceUtils.resLabel((JLabel)this.m_hostLbl, (Component)this.m_tfdHost, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_HOST"));
        this.add((Component)this.m_hostLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdHost, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_schemaLbl, (Component)this.m_tfdSchema, (String)ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_DETAILS_SCHEMA"));
        this.add((Component)this.m_schemaLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.m_tfdSchema, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 0), 0, 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.m_basicPanel.getUserName().length() < 1 || this.m_basicPanel.getUserName().length() < 1 || this.m_basicPanel.getConnectionName().length() < 1) {
                this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + Messages.getString("BasicPanel.0"));
                return;
            }
            this.m_basicPanel.setStatus("");
            ClassLoader classLoader = RaptorClassLoader.findClassLoader((String)"com.cloud.jdbc.Driver");
            Class<Driver> clazz = null;
            clazz = classLoader != null ? classLoader.loadClass("oracle.dbtools.jdbc.Driver").asSubclass(Driver.class) : Class.forName("oracle.dbtools.jdbc.Driver").asSubclass(Driver.class);
            Driver driver = clazz.newInstance();
            Properties properties = new Properties();
            String string = this.m_basicPanel.getUserName();
            String string2 = this.m_basicPanel.getPassword();
            String string3 = "jdbc:cloud://" + this.m_tfdHost.getText().trim();
            if (null != string) {
                properties.setProperty("user", string);
            }
            if (null != string2) {
                properties.setProperty("password", string2);
            }
            Connection connection = driver.connect(string3, properties);
            PreparedStatement preparedStatement = connection.prepareStatement("show databases");
            ResultSet resultSet = preparedStatement.executeQuery();
            connection.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getClass().getName().equals("com.cloud.jdbc.CommunicationsException")) {
                this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + ConnectionDialogArb.format((String)Messages.getString("CLOUD_CONNECTION_ERROR"), (Object[])new Object[]{this.m_tfdHost.getText().trim()}));
            } else {
                this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + sQLException.getLocalizedMessage());
            }
        }
        catch (InstantiationException instantiationException) {
            this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + illegalAccessException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.m_basicPanel.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + classNotFoundException.getMessage());
        }
    }

    public void setDefaultPrompts() {
        this.m_tfdHost.setText("localhost");
        this.m_tfdSchema.setText("");
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("customUrl");
        this.m_tfdHost.setText(string);
        String string2 = properties.getProperty(SCHEMA);
        this.m_tfdSchema.setText(string2);
    }
}

