/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.copy;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.ddl.DbmsMetadataDDLGenerator;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.thirdparty.copy.CopyToOracle;
import oracle.dbtools.thirdparty.copy.ElementDbObject;
import oracle.ide.model.Element;
import oracle.jdeveloper.db.ConnectionException;

public class DDLGeneratorTask
extends RaptorTask<String> {
    private StringBuilder sb = new StringBuilder();
    private ElementDbObject eDB;
    private DbmsMetadataDDLGenerator generator;
    private ScriptRunnerContext context;
    private static String NL = "\n";

    public DDLGeneratorTask(Element element, CopyToOracle copyToOracle) {
        super(MessageFormat.format("Generating DDL for: {0}", element.getShortLabel()), false, IRaptorTaskRunMode.TASKVIEWER);
        this.eDB = new ElementDbObject(element, copyToOracle);
    }

    protected String doWork() throws TaskException {
        this.sb.append(this.generateDDL());
        return this.sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateDDL() {
        Connection connection = null;
        StringWriter stringWriter = new StringWriter();
        try {
            connection = Connections.getInstance().getUniqueConnection(this.eDB.getDBObject().getConnectionName());
            Connections.getInstance().lock(connection);
            this.setupGenerator(connection);
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            this.generator.processDDL(bufferedWriter, this.eDB.getObjectName(), this.eDB.getObjectType());
            Connections.getInstance().unlock(connection);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (ConnectionException connectionException) {
            connectionException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        return stringWriter.toString();
    }

    private void setupGenerator(Connection connection) {
        try {
            String string = "begin" + NL + " dbms_metadata.set_transform_param(dbms_metadata.session_transform,'DEFAULT',true);" + NL + "DBMS_METADATA.SET_TRANSFORM_PARAM(dbms_metadata.SESSION_TRANSFORM, 'EMIT_SCHEMA', false); " + NL + " dbms_metadata.set_transform_param(dbms_metadata.session_transform,'STORAGE',false); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'SQLTERMINATOR',true);" + NL + " dbms_metadata.set_transform_param(dbms_metadata.session_transform,'SPECIFICATION',false); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'SIZE_BYTE_KEYWORD',true); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'PRETTY',true); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'REF_CONSTRAINTS',true);" + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'FORCE',true); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'PARTITIONING',true); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'CONSTRAINTS',true); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'INSERT',false); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'BODY',true); " + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'CONSTRAINTS_AS_ALTER',true);" + NL + "  dbms_metadata.set_transform_param(dbms_metadata.session_transform,'SEGMENT_ATTRIBUTES',false);" + NL + "end;";
            Statement statement = connection.createStatement();
            statement.execute(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.generator == null) {
            if (this.context == null) {
                this.context = new ScriptRunnerContext();
            }
            this.generator = new DbmsMetadataDDLGenerator(connection, this.context);
        }
    }

    public String getDDL() {
        return this.sb.toString();
    }
}

