/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;

public abstract class AbstractPPNode
implements PPNode {
    protected PPNode parent = null;
    protected List<PPNode> children = new ArrayList<PPNode>();
    protected int direction = 0;
    protected ASTTripleAtom sNode = null;
    protected ASTTripleAtom tNode = null;

    @Override
    public void addChild(PPNode pPNode) {
        this.children.add(pPNode);
    }

    @Override
    public int getNumChildren() {
        return this.children.size();
    }

    @Override
    public PPNode getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public void setParent(PPNode pPNode) {
        this.parent = pPNode;
    }

    @Override
    public PPNode getParent() {
        return this.parent;
    }

    @Override
    public void setDirection(int n) {
        this.direction = n;
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setStartNode(ASTTripleAtom aSTTripleAtom) {
        this.sNode = aSTTripleAtom;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            if (this.getDirection() == 0) {
                this.getChild(i).setStartNode(aSTTripleAtom);
                continue;
            }
            this.getChild(i).setEndNode(aSTTripleAtom);
        }
    }

    @Override
    public boolean hasConstrainedStart() {
        return this.sNode != null;
    }

    @Override
    public ASTTripleAtom getStartNode() {
        return this.sNode;
    }

    @Override
    public void setEndNode(ASTTripleAtom aSTTripleAtom) {
        this.tNode = aSTTripleAtom;
        for (int i = 0; i < this.getNumChildren(); ++i) {
            if (this.getDirection() == 0) {
                this.getChild(i).setEndNode(aSTTripleAtom);
                continue;
            }
            this.getChild(i).setStartNode(aSTTripleAtom);
        }
    }

    @Override
    public boolean hasConstrainedEnd() {
        return this.tNode != null;
    }

    @Override
    public ASTTripleAtom getEndNode() {
        return this.tNode;
    }

    @Override
    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + this.getClass().getName() + ": Direction [" + this.direction + "]\n";
        if (this.hasConstrainedStart()) {
            string2 = string2 + string + "START [" + this.getStartNode().toString("") + "]\n";
        }
        if (this.hasConstrainedEnd()) {
            string2 = string2 + string + "End [" + this.getEndNode().toString("") + "]\n";
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            string2 = string2 + this.getChild(i).toString(string + "  ") + "\n";
        }
        return string2;
    }
}

