/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.spatial.rdf.server.BGPNodeInfo;
import oracle.spatial.rdf.server.SPARQLTriplesBlock;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.TriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class BasicGraphPattern {
    List<TriplesBlock> TBList = new ArrayList<TriplesBlock>();
    Map<String, BGPNodeInfo> BGPelements = new HashMap<String, BGPNodeInfo>();

    public void populateTriplesList(List<TriplesBlock> list) {
        this.TBList.addAll(list);
        this.populateElements();
    }

    public void addTriplesBlock(TriplesBlock triplesBlock) {
        this.TBList.add(triplesBlock);
        this.BGPelements.clear();
        this.populateElements();
    }

    private static TriplesBlock toTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock, SQLGenContext sQLGenContext) {
        SimpleNode[] simpleNodeArray = new SimpleNode[]{sPARQLTriplesBlock.getSubject(), sPARQLTriplesBlock.getPredicate(), sPARQLTriplesBlock.getObject()};
        return new TriplesBlock(simpleNodeArray, sQLGenContext, sPARQLTriplesBlock.getPath());
    }

    public void addTriplesBlock(SPARQLTriplesBlock sPARQLTriplesBlock, SQLGenContext sQLGenContext) {
        this.addTriplesBlock(BasicGraphPattern.toTriplesBlock(sPARQLTriplesBlock, sQLGenContext));
    }

    public void addAll(List<? extends SPARQLTriplesBlock> list, SQLGenContext sQLGenContext) {
        for (SPARQLTriplesBlock sPARQLTriplesBlock : list) {
            this.TBList.add(BasicGraphPattern.toTriplesBlock(sPARQLTriplesBlock, sQLGenContext));
        }
        this.BGPelements.clear();
        this.populateElements();
    }

    public List<TriplesBlock> getTriplesList() {
        return Collections.unmodifiableList(this.TBList);
    }

    private void populateElements() {
        int n = 0;
        for (int i = this.TBList.size() - 1; i >= 0; --i) {
            TriplesBlock triplesBlock = this.TBList.get(i);
            for (int j = 2; j >= 0; --j) {
                BGPNodeInfo bGPNodeInfo;
                String string;
                switch (j) {
                    case 0: {
                        string = triplesBlock.getSubject().toString();
                        break;
                    }
                    case 1: {
                        string = triplesBlock.getPredicate().toString();
                        break;
                    }
                    case 2: {
                        string = triplesBlock.getObject().toString();
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
                string = string + "," + new Integer(j).toString();
                if (!this.BGPelements.containsKey(string)) {
                    bGPNodeInfo = null;
                    if (j == 0) {
                        bGPNodeInfo = new BGPNodeInfo(string, new Integer(n).toString(), "subject", Integer.toString(triplesBlock.getSubject().getType()), triplesBlock.getSubject().getLitLang(), triplesBlock.getSubject().getLitType(), 0, 1, 1);
                        bGPNodeInfo.addToAliasList(i);
                    }
                    if (j == 1) {
                        bGPNodeInfo = new BGPNodeInfo(string, new Integer(n).toString(), "predicate", Integer.toString(triplesBlock.getPredicate().getType()), triplesBlock.getPredicate().getLitLang(), triplesBlock.getPredicate().getLitType(), -1, -1, 1);
                        bGPNodeInfo.addToAliasList(i);
                    }
                    if (j == 2) {
                        bGPNodeInfo = new BGPNodeInfo(string, new Integer(n).toString(), "object", Integer.toString(triplesBlock.getObject().getType()), triplesBlock.getObject().getLitLang(), triplesBlock.getObject().getLitType(), 1, 0, 1);
                        bGPNodeInfo.addToAliasList(i);
                    }
                    this.BGPelements.put(string, bGPNodeInfo);
                    ++n;
                    continue;
                }
                bGPNodeInfo = this.BGPelements.get(string);
                bGPNodeInfo.addToAliasList(i);
                if (j == 0) {
                    bGPNodeInfo.IncrementOutDegree();
                    bGPNodeInfo.IncrementOccurences();
                }
                if (j == 1) {
                    bGPNodeInfo.IncrementOccurences();
                }
                if (j != 2) continue;
                bGPNodeInfo.IncrementInDegree();
                bGPNodeInfo.IncrementOccurences();
            }
        }
    }

    public int numTriples() {
        return this.TBList.size();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 17;
        n2 = n2 * n + (this.getTriplesList() == null ? 0 : this.getTriplesList().hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BasicGraphPattern) {
            BasicGraphPattern basicGraphPattern = (BasicGraphPattern)object;
            if (this.getTriplesList() == null && basicGraphPattern.getTriplesList() == null) {
                return true;
            }
            if (this.getTriplesList() != null && basicGraphPattern.getTriplesList() != null && this.getTriplesList().equals(basicGraphPattern.getTriplesList())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        String string = new String();
        for (TriplesBlock object : this.TBList) {
            string = string + object.toString() + "\n";
        }
        for (String string2 : this.BGPelements.keySet()) {
            string = string + this.BGPelements.get(string2).toString() + "\n";
        }
        return string;
    }

    public String toString(String string) {
        String string2 = new String();
        for (TriplesBlock object : this.TBList) {
            string2 = string2 + string + object.toString() + "\n";
        }
        for (String string3 : this.BGPelements.keySet()) {
            string2 = string2 + string + this.BGPelements.get(string3).toString() + "\n";
        }
        return string2;
    }
}

