/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Stack;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTGraphPatternNotTriples;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class BindRewriteOptimizer
implements SparqlQueryOptimizer {
    private static final int MAX_ITERS = 10000;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int n;
        boolean bl = true;
        for (n = 0; bl && n < 10000; ++n) {
            bl = this.removeBind(node);
        }
        if (n >= 10000) {
            throw new ParseException("BindRewriteOptimizer: entered infinite loop when optimizing query tree");
        }
        return node;
    }

    private boolean removeBind(Node node) throws ParseException {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        boolean bl = false;
        while (!stack.isEmpty() && !bl) {
            Node node2 = (Node)stack.pop();
            if (((SimpleNode)node2).id == 48) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                int n = 0;
                int n2 = 0;
                while (n < node2.jjtGetNumChildren() && !bl) {
                    if (OptimizerUtils.isGPNTBind(node2.jjtGetChild(n))) {
                        Node node3;
                        arrayList.add(node2.jjtGetChild(n).jjtGetChild(0));
                        n2 = n++;
                        boolean bl2 = true;
                        while (bl2 && n < node2.jjtGetNumChildren()) {
                            if (OptimizerUtils.isGPNTBind(node2.jjtGetChild(n))) {
                                arrayList.add(node2.jjtGetChild(n).jjtGetChild(0));
                                ++n;
                                continue;
                            }
                            bl2 = false;
                        }
                        ArrayList<Node> arrayList2 = new ArrayList<Node>();
                        ArrayList<Node> arrayList3 = new ArrayList<Node>();
                        for (int i = 0; i < n2; ++i) {
                            node3 = node2.jjtGetChild(i);
                            if (OptimizerUtils.isGPNTFilter(node3)) {
                                arrayList3.add(node3);
                                continue;
                            }
                            arrayList2.add(node3);
                        }
                        ArrayList<Node> arrayList4 = new ArrayList<Node>();
                        for (int i = n; i < node2.jjtGetNumChildren(); ++i) {
                            arrayList4.add(node2.jjtGetChild(i));
                        }
                        node3 = OptimizerUtils.genSelectQuery(arrayList2, arrayList);
                        ASTGraphPatternNotTriples aSTGraphPatternNotTriples = new ASTGraphPatternNotTriples(49);
                        aSTGraphPatternNotTriples.jjtAddChild(node3, 0);
                        ((SimpleNode)node3).jjtSetParent(aSTGraphPatternNotTriples);
                        node2.jjtSetInitCapacity(1 + arrayList3.size() + arrayList4.size());
                        node2.jjtAddChild(aSTGraphPatternNotTriples, 0);
                        aSTGraphPatternNotTriples.jjtSetParent(node2);
                        int n3 = 1;
                        for (Node node4 : arrayList3) {
                            node2.jjtAddChild(node4, n3);
                            node4.jjtSetParent(node2);
                            ++n3;
                        }
                        for (Node node4 : arrayList4) {
                            node2.jjtAddChild(node4, n3);
                            node4.jjtSetParent(node2);
                            ++n3;
                        }
                        bl = true;
                        continue;
                    }
                    stack.push(node2.jjtGetChild(n));
                    ++n;
                }
                continue;
            }
            for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
                stack.push(node2.jjtGetChild(i));
            }
        }
        return bl;
    }
}

