/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.parser.sparql.ASTBind;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public class BindVarRewriteOptimizer
implements SparqlQueryOptimizer {
    private static final int MAX_ITERS = 10000;
    private ASTTopLevelQueryNode tqn = null;

    @Override
    public Node optimizeQuery(Node node) throws RDFException, ParseException {
        int n;
        if (((SimpleNode)node.jjtGetChild((int)0)).id != 5) {
            return node;
        }
        boolean bl = true;
        this.tqn = (ASTTopLevelQueryNode)node.jjtGetChild(0).jjtGetChild(0);
        for (n = 0; bl && n < 10000; ++n) {
            bl = this.removeBind(node);
        }
        if (n >= 10000) {
            throw new ParseException("BindVarRewriteOptimizer: entered infinite loop when optimizing query tree");
        }
        return node;
    }

    private boolean removeBind(Node node) throws RDFException, ParseException {
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        boolean bl = false;
        while (!stack.isEmpty() && !bl) {
            int n;
            Node node2 = (Node)stack.pop();
            if (((SimpleNode)node2).id == 48) {
                for (n = 0; n < node2.jjtGetNumChildren() && !bl; ++n) {
                    if (this.isReplaceableGPNTBind(node2.jjtGetChild(n))) {
                        int n2;
                        int n3 = ((ASTBind)node2.jjtGetChild((int)n).jjtGetChild((int)0)).bindId;
                        ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)node2.jjtGetChild(n).jjtGetChild(0).jjtGetChild(1);
                        String string = aSTTripleAtom.name;
                        for (n2 = 0; n2 < n; ++n2) {
                            if (OptimizerUtils.isGPNTFilter(node2.jjtGetChild(n2))) {
                                this.replaceWithBindVar(node2.jjtGetChild(n2), string, n3, true, true);
                                continue;
                            }
                            this.replaceWithBindVar(node2.jjtGetChild(n2), string, n3, false, false);
                        }
                        for (n2 = n + 1; n2 < node2.jjtGetNumChildren(); ++n2) {
                            this.replaceWithBindVar(node2.jjtGetChild(n2), string, n3, true, true);
                        }
                        boolean[] blArray = new boolean[]{false};
                        for (int i = n + 1; i < node2.jjtGetNumChildren() && !blArray[0]; ++i) {
                            this.isProjected(node2.jjtGetChild(i), string, blArray);
                        }
                        if (blArray[0]) {
                            ((SimpleNode)node2).jjtRemoveChild(n);
                            bl = true;
                        } else {
                            this.updateBindVar(aSTTripleAtom, n3);
                            ArrayList<Node> arrayList = new ArrayList<Node>();
                            arrayList.add(node2.jjtGetChild(n).jjtGetChild(0));
                            ASTSelectQuery aSTSelectQuery = OptimizerUtils.genSelectQuery(new ArrayList<Node>(), arrayList);
                            node2.jjtGetChild(n).jjtAddChild(aSTSelectQuery, 0);
                            aSTSelectQuery.jjtSetParent(node2.jjtGetChild(n));
                        }
                        this.tqn.addBindVar(n3);
                        continue;
                    }
                    stack.push(node2.jjtGetChild(n));
                }
                continue;
            }
            for (n = 0; n < node2.jjtGetNumChildren(); ++n) {
                stack.push(node2.jjtGetChild(n));
            }
        }
        return bl;
    }

    private boolean isReplaceableGPNTBind(Node node) {
        boolean bl = false;
        if (((SimpleNode)node).id == 49 && node.jjtGetNumChildren() == 1 && ((SimpleNode)node.jjtGetChild((int)0)).id == 53) {
            SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(0).jjtGetChild(0);
            if (simpleNode.id == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode;
                if (aSTTripleAtom.type == 1 || aSTTripleAtom.type == 2 || aSTTripleAtom.type == 3 || aSTTripleAtom.type == 4 || aSTTripleAtom.type == 5 || aSTTripleAtom.type == 6) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void updateBindVar(ASTTripleAtom aSTTripleAtom, int n) {
        aSTTripleAtom.type = 9;
        aSTTripleAtom.bindId = n;
    }

    private void replaceWithBindVar(Node node, String string, int n, boolean bl, boolean bl2) throws RDFException {
        block6: {
            block5: {
                if (((SimpleNode)node).id != 73) break block5;
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)node;
                if (aSTTripleAtom.type != 0 || !aSTTripleAtom.name.equals(string)) break block6;
                if (!bl) {
                    throw new RDFException("Bind variable ?" + string + " is already defined");
                }
                if (!bl2) break block6;
                this.updateBindVar(aSTTripleAtom, n);
                break block6;
            }
            switch (((SimpleNode)node).id) {
                case 7: {
                    List<String> list;
                    if (bl || !(list = ((ASTSelectQuery)node).getselDesc().getSelectList()).contains(string)) break;
                    throw new RDFException("Bind variable ?" + string + " is already defined");
                }
                default: {
                    for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                        this.replaceWithBindVar(node.jjtGetChild(i), string, n, bl, bl2);
                    }
                }
            }
        }
    }

    private void isProjected(Node node, String string, boolean[] blArray) {
        int n;
        switch (((SimpleNode)node).id) {
            case 47: {
                Node node2;
                for (n = 0; n < node.jjtGetNumChildren(); ++n) {
                    node2 = node.jjtGetChild(n);
                    if (((SimpleNode)node2).id != 73) continue;
                    ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)node2;
                    if (aSTTripleAtom.type != 9 || !aSTTripleAtom.name.equals(string)) continue;
                    blArray[0] = true;
                    return;
                }
                break;
            }
            case 51: {
                Node node3 = node.jjtGetChild(0);
                if (((SimpleNode)node3).id != 73) break;
                Node node2 = (ASTTripleAtom)node3;
                if (((ASTTripleAtom)node2).type != 9 || !((ASTTripleAtom)node2).name.equals(string)) break;
                blArray[0] = true;
                return;
            }
        }
        if (((SimpleNode)node).id != 50 && ((SimpleNode)node).id != 55 && ((SimpleNode)node).id != 7) {
            for (n = 0; n < node.jjtGetNumChildren(); ++n) {
                this.isProjected(node.jjtGetChild(n), string, blArray);
            }
        }
    }
}

