/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.SPARQLBGP;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public abstract class HintProvider {
    protected HintProvider() {
    }

    public Hint generateHint(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, List<HintToken> list) throws ParseException {
        HintBuilder hintBuilder = new HintBuilder();
        if (list == null) {
            throw new IllegalArgumentException("Argument 'tokenTree' is null");
        }
        if (sPARQLBGP == null) {
            throw new IllegalArgumentException("Argument 'bgp' is null");
        }
        TreeMap<HintToken, Enum> treeMap = new TreeMap<HintToken, Enum>(HintTokenComparator.getInstance());
        treeMap.putAll(this.getParsableTokens());
        List<HintToken> list2 = this.getParsableTokens(list);
        List<HintToken> list3 = this.getIgnoredTokens(list);
        HintContext hintContext = new HintContext(sPARQLBGP, sQLGenContext, hintBuilder, list3, list);
        for (HintToken hintToken : list2) {
            Enum enum_ = (Enum)treeMap.get(hintToken);
            this.parseToken(hintContext, hintToken, enum_);
        }
        return hintBuilder.toHint();
    }

    public List<HintToken> getParsableTokens(List<HintToken> list) {
        Map<HintToken, Enum> map = this.getParsableTokens();
        TreeSet<HintToken> treeSet = new TreeSet<HintToken>(HintTokenComparator.getInstance());
        treeSet.addAll(map.keySet());
        boolean bl = false;
        return HintProvider.setToOrderedList(treeSet, list, bl);
    }

    public List<HintToken> getIgnoredTokens(List<HintToken> list) {
        Map<HintToken, Enum> map = this.getParsableTokens();
        TreeSet<HintToken> treeSet = new TreeSet<HintToken>(HintTokenComparator.getInstance());
        TreeSet<HintToken> treeSet2 = new TreeSet<HintToken>(HintTokenComparator.getInstance());
        for (HintToken hintToken : map.keySet()) {
            treeSet2.add(hintToken);
            while (hintToken.hasParent()) {
                hintToken = hintToken.getParent();
                treeSet2.add(hintToken);
            }
        }
        boolean bl = true;
        List<HintToken> list2 = HintProvider.setToOrderedList(treeSet2, list, bl);
        treeSet.addAll(map.keySet());
        Iterator<HintToken> iterator = list2.iterator();
        block2: while (iterator.hasNext()) {
            HintToken hintToken = iterator.next();
            while (hintToken.hasParent()) {
                if (!treeSet.contains(hintToken = hintToken.getParent())) continue;
                iterator.remove();
                continue block2;
            }
        }
        return list2;
    }

    static List<HintToken> setToOrderedList(Set<HintToken> set, List<HintToken> list, boolean bl) {
        LinkedList<HintToken> linkedList = new LinkedList<HintToken>();
        LinkedList<HintToken> linkedList2 = new LinkedList<HintToken>(list);
        while (!linkedList2.isEmpty()) {
            HintToken hintToken = (HintToken)linkedList2.remove();
            if (set.contains(hintToken) ^ bl) {
                linkedList.add(hintToken);
            }
            linkedList2.addAll(hintToken.getChildren());
        }
        return linkedList;
    }

    static boolean searchTree(HintToken hintToken, List<HintToken> list) {
        return HintProvider.searchTree(hintToken, list, HintTokenComparator.getInstance());
    }

    static boolean searchTree(HintToken hintToken, List<HintToken> list, Comparator<HintToken> comparator) {
        LinkedList<HintToken> linkedList = new LinkedList<HintToken>(list);
        while (!linkedList.isEmpty()) {
            HintToken hintToken2 = (HintToken)linkedList.remove();
            if (comparator.compare(hintToken, hintToken2) == 0) {
                return true;
            }
            linkedList.addAll(hintToken2.getChildren());
        }
        return false;
    }

    protected abstract Map<HintToken, Enum> getParsableTokens();

    protected abstract void parseToken(HintContext var1, HintToken var2, Enum var3) throws ParseException;

    public static class HintToken {
        private final HintToken parent;
        private final List<HintToken> children;
        private final String value;
        private final Type type;

        private HintToken(HintToken hintToken, String string, Type type) {
            this.parent = hintToken;
            this.value = string;
            this.type = type;
            this.children = new LinkedList<HintToken>();
            if (hintToken != null) assert (hintToken.getType() != Type.NO_ARG) : "Illegal token '" + string + "' has parent with NO_ARG type";
            assert (string != null) : "Token value is null";
            assert (type != null) : "Token type is null";
            if (hintToken != null) {
                hintToken.addChild(this);
            }
        }

        private void addChild(HintToken hintToken) {
            assert (hintToken != null) : "Trying to add null token to parent '" + this + "'";
            assert (this.getType() != Type.NO_ARG) : "Attempting to add child token to parent token that accepts no arguments (type = NO_ARG)";
            assert (hintToken.getParent() == this) : "Attempting to add child token to wrong parent token.  Trying to add to '" + this + "' but should be adding to '" + hintToken.getParent() + "'";
            this.children.add(hintToken);
        }

        public static HintToken createNoArgToken(String string) {
            return HintToken.createNoArgToken(null, string);
        }

        public static HintToken createNoArgToken(HintToken hintToken, String string) {
            return new HintToken(hintToken, string, Type.NO_ARG);
        }

        public static HintToken createToken(String string) {
            return HintToken.createToken(null, string);
        }

        public static HintToken createToken(HintToken hintToken, String string) {
            return new HintToken(hintToken, string, Type.PARENS);
        }

        public static HintToken createEqualsToken(String string) {
            return HintToken.createEqualsToken(null, string);
        }

        public static HintToken createEqualsToken(HintToken hintToken, String string) {
            return new HintToken(hintToken, string, Type.EQUALS);
        }

        public static HintToken createBracketsToken(String string) {
            return HintToken.createBracketsToken(null, string);
        }

        public static HintToken createBracketsToken(HintToken hintToken, String string) {
            return new HintToken(hintToken, string, Type.EQUALS_BRACKETS);
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public HintToken getParent() {
            return this.parent;
        }

        public String getValue() {
            return this.value;
        }

        public Type getType() {
            return this.type;
        }

        public List<HintToken> getChildren() {
            return this.children;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Stack<HintToken> stack = new Stack<HintToken>();
            HintToken hintToken = this;
            while (hintToken.hasParent()) {
                hintToken = hintToken.getParent();
                stack.push(hintToken);
            }
            while (!stack.isEmpty()) {
                stringBuilder.append(((HintToken)stack.pop()).getValue());
                stringBuilder.append(".");
            }
            stringBuilder.append(this.getValue());
            if (this.getType() != Type.NO_ARG) {
                stringBuilder.append("( ");
                for (HintToken hintToken2 : this.children) {
                    stringBuilder.append(hintToken2.getValue());
                    stringBuilder.append(" ");
                }
                stringBuilder.append(") ");
            }
            return stringBuilder.toString();
        }

        public static enum Type {
            NO_ARG,
            PARENS,
            EQUALS,
            EQUALS_BRACKETS;

        }
    }

    protected static class HintBuilder {
        private Collection<Hint.SQLHint> sqlHints = new LinkedList<Hint.SQLHint>();
        private Collection<Hint.JoinHint> bgpJoinHints = new LinkedList<Hint.JoinHint>();
        private Collection<Hint.AntiJoinHint> antiJoinHints = new LinkedList<Hint.AntiJoinHint>();
        private Map<Hint.QueryOption, String> queryOptions = new HashMap<Hint.QueryOption, String>();

        public void addSQLHint(Hint.SQLHint sQLHint) {
            this.sqlHints.add(sQLHint);
        }

        public void removeSQLHint(Hint.SQLHint sQLHint) {
            this.sqlHints.remove(sQLHint);
        }

        public boolean containsSQLHint(Hint.SQLHint sQLHint) {
            return this.sqlHints.contains(sQLHint);
        }

        public Collection<Hint.SQLHint> getSQLHints() {
            return Collections.unmodifiableCollection(this.sqlHints);
        }

        public void addBGPJoinHint(Hint.JoinHint joinHint) {
            this.bgpJoinHints.add(joinHint);
        }

        public void removeBGPJoinHint(Hint.JoinHint joinHint) {
            this.bgpJoinHints.remove((Object)joinHint);
        }

        public boolean containsBGPJoinHint(Hint.JoinHint joinHint) {
            return this.bgpJoinHints.contains((Object)joinHint);
        }

        public Collection<Hint.JoinHint> getBGPJoinHints() {
            return Collections.unmodifiableCollection(this.bgpJoinHints);
        }

        public void addAntiJoinHint(Hint.AntiJoinHint antiJoinHint) {
            this.antiJoinHints.add(antiJoinHint);
        }

        public void removeAntiJoinHint(Hint.AntiJoinHint antiJoinHint) {
            this.antiJoinHints.remove((Object)antiJoinHint);
        }

        public boolean containsAntiJoinHint(Hint.JoinHint joinHint) {
            return this.antiJoinHints.contains((Object)joinHint);
        }

        public Collection<Hint.AntiJoinHint> getAntiJoinHints() {
            return Collections.unmodifiableCollection(this.antiJoinHints);
        }

        public void addQueryOption(Hint.QueryOption queryOption) {
            this.queryOptions.put(queryOption, null);
        }

        public void addQueryOption(Hint.QueryOption queryOption, String string) {
            this.queryOptions.put(queryOption, string);
        }

        public void removeQueryOption(Hint.QueryOption queryOption) {
            this.queryOptions.remove((Object)queryOption);
        }

        public boolean containsQueryOption(Hint.QueryOption queryOption) {
            return this.queryOptions.containsKey((Object)queryOption);
        }

        public Collection<Hint.QueryOption> getQueryOptions() {
            return Collections.unmodifiableCollection(this.queryOptions.keySet());
        }

        public Map<Hint.QueryOption, String> getQueryOptionsMap() {
            return Collections.unmodifiableMap(this.queryOptions);
        }

        public Hint toHint() {
            return new Hint(this.sqlHints, this.bgpJoinHints, this.antiJoinHints, this.queryOptions);
        }
    }

    static final class HintTokenComparator
    implements Comparator<HintToken> {
        private static final HintTokenComparator INSTANCE = new HintTokenComparator();

        private HintTokenComparator() {
        }

        public static HintTokenComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(HintToken hintToken, HintToken hintToken2) {
            if (hintToken == hintToken2) {
                return 0;
            }
            if (!hintToken.getValue().equalsIgnoreCase(hintToken2.getValue())) {
                return hintToken.getValue().toLowerCase().compareTo(hintToken2.getValue().toLowerCase());
            }
            if (hintToken.getType() != hintToken2.getType()) {
                return hintToken.getType().compareTo(hintToken2.getType());
            }
            if (hintToken.getParent() != null && hintToken2.getParent() == null) {
                return -1;
            }
            if (hintToken.getParent() == null && hintToken2.getParent() != null) {
                return 1;
            }
            if (hintToken.getParent() != null && !hintToken.getParent().equals(hintToken2.getParent())) {
                return this.compare(hintToken.getParent(), hintToken2.getParent());
            }
            return 0;
        }
    }

    static final class HintContext {
        private final SPARQLBGP bgp;
        private final SQLGenContext ctx;
        private final HintBuilder hintBuilder;
        private final List<HintToken> ignored;
        private final List<HintToken> tokenTree;

        public HintContext(SPARQLBGP sPARQLBGP, SQLGenContext sQLGenContext, HintBuilder hintBuilder, List<HintToken> list, List<HintToken> list2) {
            this.bgp = sPARQLBGP;
            this.ctx = sQLGenContext;
            this.hintBuilder = hintBuilder;
            this.ignored = list;
            this.tokenTree = list2;
        }

        public SPARQLBGP getSPARQLBGP() {
            return this.bgp;
        }

        public SQLGenContext getSQLGenContext() {
            return this.ctx;
        }

        public HintBuilder getHintBuilder() {
            return this.hintBuilder;
        }

        public List<HintToken> getIgnoredTokens() {
            return this.ignored;
        }

        public List<HintToken> getTokenTree() {
            return this.tokenTree;
        }
    }
}

