/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.HintProvider;
import oracle.spatial.rdf.server.parser.sparql.ParseException;

public class LeadingHintProvider
extends HintProvider {
    private static final HintProvider.HintToken LEADING_TOKEN = HintProvider.HintToken.createToken("LEADING");
    private static final Map<HintProvider.HintToken, Enum> TOKENS;
    private static final LeadingHintProvider instance;

    private LeadingHintProvider() {
    }

    public static LeadingHintProvider getInstance() {
        return instance;
    }

    @Override
    protected Map<HintProvider.HintToken, Enum> getParsableTokens() {
        return TOKENS;
    }

    @Override
    protected void parseToken(HintProvider.HintContext hintContext, HintProvider.HintToken hintToken, Enum enum_) throws ParseException {
        String string = hintToken.getValue();
        List<HintProvider.HintToken> list = hintToken.getChildren();
        HintProvider.HintBuilder hintBuilder = hintContext.getHintBuilder();
        if (list.isEmpty()) {
            return;
        }
        LinkedList<Hint.SQLHint.Arg> linkedList = new LinkedList<Hint.SQLHint.Arg>();
        for (HintProvider.HintToken hintToken2 : list) {
            linkedList.add(Hint.SQLHint.Arg.createStaticArgument(hintToken2.getValue()));
        }
        hintBuilder.addSQLHint(Hint.SQLHint.createMultiArgHint(string, linkedList));
    }

    static {
        HashMap<HintProvider.HintToken, Type> hashMap = new HashMap<HintProvider.HintToken, Type>();
        hashMap.put(LEADING_TOKEN, Type.DEFAULT);
        TOKENS = Collections.unmodifiableMap(hashMap);
        instance = new LeadingHintProvider();
    }

    private static enum Type {
        DEFAULT;

    }
}

