/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.spatial.rdf.server.AbstractSPARQLTreeNode;
import oracle.spatial.rdf.server.AskSPARQLTreeNode;
import oracle.spatial.rdf.server.BNPropListExpandOptimizer;
import oracle.spatial.rdf.server.BindRewriteOptimizer;
import oracle.spatial.rdf.server.BindVarRewriteOptimizer;
import oracle.spatial.rdf.server.BindingsRewriteOptimizer;
import oracle.spatial.rdf.server.BlankNodesRewriteOptimizer;
import oracle.spatial.rdf.server.CalendarFilterHandler;
import oracle.spatial.rdf.server.CollectionExpandOptimizer;
import oracle.spatial.rdf.server.ConstructExpandOptimizer;
import oracle.spatial.rdf.server.ConstructSPARQLTreeNode;
import oracle.spatial.rdf.server.CurlyBraceSPARQLTreeNode;
import oracle.spatial.rdf.server.DescribeRewriteOptimizer;
import oracle.spatial.rdf.server.DistinctOrderByRewriteOptimizer;
import oracle.spatial.rdf.server.EFilterRewriteOptimizer;
import oracle.spatial.rdf.server.EmptySPARQLTreeOptimizer;
import oracle.spatial.rdf.server.EncryptFilterHandler;
import oracle.spatial.rdf.server.Filter;
import oracle.spatial.rdf.server.FilterException;
import oracle.spatial.rdf.server.FilterFuncHandler;
import oracle.spatial.rdf.server.FilterScopeOptimizer;
import oracle.spatial.rdf.server.GGPReduceOptimizer;
import oracle.spatial.rdf.server.GeoSparqlDistanceFilterOptimizer;
import oracle.spatial.rdf.server.GroupByAliasRewriteOptimizer;
import oracle.spatial.rdf.server.Hint;
import oracle.spatial.rdf.server.NumericFilterHandler;
import oracle.spatial.rdf.server.OptimizerUtils;
import oracle.spatial.rdf.server.OrderByExprRewriteOptimizer;
import oracle.spatial.rdf.server.PGFilterHandler;
import oracle.spatial.rdf.server.PPAltNode;
import oracle.spatial.rdf.server.PPIRINode;
import oracle.spatial.rdf.server.PPModNode;
import oracle.spatial.rdf.server.PPNegatedNode;
import oracle.spatial.rdf.server.PPNode;
import oracle.spatial.rdf.server.PPSeqNode;
import oracle.spatial.rdf.server.QueryUtils;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.SPARQLTreeNode;
import oracle.spatial.rdf.server.SPARQLTreeOptimizer;
import oracle.spatial.rdf.server.SQLGenContext;
import oracle.spatial.rdf.server.SelectSPARQLTreeNode;
import oracle.spatial.rdf.server.ServiceSPARQLTreeNode;
import oracle.spatial.rdf.server.SimpleSPARQLTreeNode;
import oracle.spatial.rdf.server.SimpleSPARQLTriplesBlock;
import oracle.spatial.rdf.server.SparqlQueryOptimizer;
import oracle.spatial.rdf.server.SpatialFilterHandler;
import oracle.spatial.rdf.server.StringFilterHandler;
import oracle.spatial.rdf.server.TemplateSPARQLTreeNode;
import oracle.spatial.rdf.server.TermConstructFilterHandler;
import oracle.spatial.rdf.server.TextFilterHandler;
import oracle.spatial.rdf.server.TurtleExpandOptimizer;
import oracle.spatial.rdf.server.TypeException;
import oracle.spatial.rdf.server.UnionSPARQLTreeNode;
import oracle.spatial.rdf.server.ValuesRewriteOptimizer;
import oracle.spatial.rdf.server.XSDConstructFilterHandler;
import oracle.spatial.rdf.server.parser.sparql.ASTAskQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTComplexPathMod;
import oracle.spatial.rdf.server.parser.sparql.ASTConstructQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTGroupGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTSelectQuery;
import oracle.spatial.rdf.server.parser.sparql.ASTServiceGraphPattern;
import oracle.spatial.rdf.server.parser.sparql.ASTSimplePathMod;
import oracle.spatial.rdf.server.parser.sparql.ASTTopLevelQueryNode;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.Node;
import oracle.spatial.rdf.server.parser.sparql.ParseException;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;

public final class SPARQLEngine {
    private static Connection sConn;
    private static String isMigrated;
    static final String NO_SRID_MSG = "Unable to retrieve SRID value for semantic network";
    static final String NO_DIM_MSG = "Unable to retrieve Dimension value for semantic network";

    protected static void prepareSTreeForTrans(SPARQLTreeNode sPARQLTreeNode, SQLGenContext sQLGenContext, Set<String> set) throws TypeException, RDFException {
        if (sQLGenContext.dmpSTree) {
            QueryUtils.log("%%%%%%%%%% Original Bottom-up SPARQL Tree %%%%%%%%%%%%%%%%%%%");
            QueryUtils.log(sPARQLTreeNode.toString(""));
            QueryUtils.log("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        ArrayList<EmptySPARQLTreeOptimizer> arrayList = new ArrayList<EmptySPARQLTreeOptimizer>();
        arrayList.add(new EmptySPARQLTreeOptimizer());
        for (SPARQLTreeOptimizer sPARQLTreeOptimizer : arrayList) {
            sPARQLTreeNode = sPARQLTreeOptimizer.optimizeTree(sPARQLTreeNode);
        }
        SPARQLEngine.validateFilterExpressions(sPARQLTreeNode, sQLGenContext.funcTypeMap);
        sPARQLTreeNode.pushJoinVarsForHint();
        sPARQLTreeNode.setPushedBGPs();
        sPARQLTreeNode.addLexVars(set);
        sPARQLTreeNode.setLexVars();
        sPARQLTreeNode.setInScopeVars(new HashSet<String>());
        sPARQLTreeNode.setInScopeLexVars(new HashSet<String>());
        sPARQLTreeNode.propagateLexVars();
        sPARQLTreeNode.initFilters();
        sPARQLTreeNode.allocateFilters();
        sPARQLTreeNode.setProjections();
        sPARQLTreeNode.verifyPushedBGPs();
        if (sQLGenContext.dmpSTree) {
            QueryUtils.log("%%%%%%%%% Final Bottom-up SPARQL Tree %%%%%%%%%%%%%%%%%%%%%%%");
            QueryUtils.log(sPARQLTreeNode.toString(""));
            QueryUtils.log("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
    }

    protected static void validateFilterExpressions(SPARQLTreeNode sPARQLTreeNode, Map<String, String> map) throws RDFException, TypeException {
        Stack<SPARQLTreeNode> stack = new Stack<SPARQLTreeNode>();
        stack.push(sPARQLTreeNode);
        while (!stack.empty()) {
            SPARQLTreeNode sPARQLTreeNode2 = (SPARQLTreeNode)stack.pop();
            List<Filter> list = sPARQLTreeNode2.getAllFilters();
            for (Filter filter : list) {
                filter.validateFilter(map);
            }
            for (int i = sPARQLTreeNode2.getNumChildren() - 1; i >= 0; --i) {
                stack.push(sPARQLTreeNode2.getChild(i));
            }
        }
    }

    protected static SPARQLTreeNode buildSPARQLTree(Node node, SQLGenContext sQLGenContext, ASTTripleAtom aSTTripleAtom, Set<String> set, Set<String> set2, String string) throws RDFException {
        if (sQLGenContext.dmpAST) {
            QueryUtils.log("%%%%%%%%%%%%% Original AST %%%%%%%%%%%%%%%%%%%%%%%%%\n");
            ((SimpleNode)node).dump("");
            QueryUtils.log("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        OrderByExprRewriteOptimizer orderByExprRewriteOptimizer = new OrderByExprRewriteOptimizer();
        DistinctOrderByRewriteOptimizer distinctOrderByRewriteOptimizer = new DistinctOrderByRewriteOptimizer();
        CollectionExpandOptimizer collectionExpandOptimizer = new CollectionExpandOptimizer();
        BNPropListExpandOptimizer bNPropListExpandOptimizer = new BNPropListExpandOptimizer();
        BlankNodesRewriteOptimizer blankNodesRewriteOptimizer = new BlankNodesRewriteOptimizer();
        GroupByAliasRewriteOptimizer groupByAliasRewriteOptimizer = new GroupByAliasRewriteOptimizer();
        BindVarRewriteOptimizer bindVarRewriteOptimizer = new BindVarRewriteOptimizer();
        BindRewriteOptimizer bindRewriteOptimizer = new BindRewriteOptimizer();
        TurtleExpandOptimizer turtleExpandOptimizer = new TurtleExpandOptimizer();
        EFilterRewriteOptimizer eFilterRewriteOptimizer = new EFilterRewriteOptimizer();
        DescribeRewriteOptimizer describeRewriteOptimizer = new DescribeRewriteOptimizer(sQLGenContext.describeIncludeNG);
        ConstructExpandOptimizer constructExpandOptimizer = new ConstructExpandOptimizer();
        BindingsRewriteOptimizer bindingsRewriteOptimizer = new BindingsRewriteOptimizer();
        ValuesRewriteOptimizer valuesRewriteOptimizer = new ValuesRewriteOptimizer();
        FilterScopeOptimizer filterScopeOptimizer = new FilterScopeOptimizer(sQLGenContext.funcTypeMap, set, set2);
        GeoSparqlDistanceFilterOptimizer geoSparqlDistanceFilterOptimizer = new GeoSparqlDistanceFilterOptimizer();
        GGPReduceOptimizer gGPReduceOptimizer = new GGPReduceOptimizer();
        ArrayList<SparqlQueryOptimizer> arrayList = new ArrayList<SparqlQueryOptimizer>();
        arrayList.add(orderByExprRewriteOptimizer);
        if (sQLGenContext.distinctPdwn) {
            arrayList.add(distinctOrderByRewriteOptimizer);
        }
        arrayList.add(collectionExpandOptimizer);
        arrayList.add(bNPropListExpandOptimizer);
        arrayList.add(blankNodesRewriteOptimizer);
        arrayList.add(groupByAliasRewriteOptimizer);
        if (sQLGenContext.useBindVars) {
            arrayList.add(bindVarRewriteOptimizer);
        }
        arrayList.add(bindRewriteOptimizer);
        arrayList.add(turtleExpandOptimizer);
        arrayList.add(eFilterRewriteOptimizer);
        arrayList.add(describeRewriteOptimizer);
        arrayList.add(constructExpandOptimizer);
        arrayList.add(bindingsRewriteOptimizer);
        arrayList.add(valuesRewriteOptimizer);
        arrayList.add(filterScopeOptimizer);
        if (!sQLGenContext.disableDistanceOpt) {
            arrayList.add(geoSparqlDistanceFilterOptimizer);
        }
        arrayList.add(gGPReduceOptimizer);
        Node node2 = null;
        try {
            node2 = SPARQLEngine.optimizeAST(node, arrayList, sQLGenContext);
        }
        catch (ParseException parseException) {
            throw new RDFException(parseException.getMessage());
        }
        if (sQLGenContext.dmpAST) {
            QueryUtils.log("%%%%%%%%%%%%% Optimized AST %%%%%%%%%%%%%%%%%%%%%%%%%\n");
            ((SimpleNode)node2).dump("");
            QueryUtils.log("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        int[] nArray = new int[]{0};
        return SPARQLEngine.buildSPARQLTree(null, nArray, node2, sQLGenContext, false, false, aSTTripleAtom, false, string);
    }

    protected static SPARQLTreeNode buildSPARQLTree(SPARQLTreeNode sPARQLTreeNode, int[] nArray, Node node, SQLGenContext sQLGenContext, boolean bl, boolean bl2, ASTTripleAtom aSTTripleAtom, boolean bl3, String string) throws RDFException {
        switch (((SimpleNode)node).id) {
            case 2: {
                CurlyBraceSPARQLTreeNode curlyBraceSPARQLTreeNode = new CurlyBraceSPARQLTreeNode(0, sQLGenContext, nArray[0]);
                if (aSTTripleAtom != null) {
                    curlyBraceSPARQLTreeNode.setIsGraphQuery(true);
                    curlyBraceSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                }
                nArray[0] = nArray[0] + 1;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.buildSPARQLTree(curlyBraceSPARQLTreeNode, nArray, node.jjtGetChild(i), sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                }
                return curlyBraceSPARQLTreeNode;
            }
            case 5: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(i);
                    if (simpleNode.id != 7 && simpleNode.id != 12 && simpleNode.id != 10) continue;
                    return SPARQLEngine.buildSPARQLTree(null, nArray, simpleNode, sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                }
                throw new RDFException("Syntax Tree Error: SELECT QUERY not found under FULL SPARQL QUERY");
            }
            case 7: {
                ASTSelectQuery aSTSelectQuery = (ASTSelectQuery)node;
                SelectSPARQLTreeNode selectSPARQLTreeNode = new SelectSPARQLTreeNode(0, sQLGenContext, nArray[0], aSTSelectQuery.selDesc, aSTSelectQuery.sourceDesc, aSTSelectQuery.solnMod, sQLGenContext.rdfTermsOnly, sQLGenContext.plusRDFTerms);
                selectSPARQLTreeNode.setBindIds(aSTSelectQuery.getBindVars());
                if (sPARQLTreeNode != null) {
                    selectSPARQLTreeNode.setParent(sPARQLTreeNode);
                    sPARQLTreeNode.addChild(selectSPARQLTreeNode);
                }
                boolean bl4 = bl3;
                if (aSTTripleAtom != null) {
                    selectSPARQLTreeNode.setIsGraphQuery(true);
                    if (!(aSTSelectQuery.selDesc.getIsTopSelect() || aSTTripleAtom.type != 0 || bl4 || aSTSelectQuery.noGraphMask)) {
                        aSTTripleAtom = QueryUtils.maskVar(aSTTripleAtom.name);
                        selectSPARQLTreeNode.markForUnmask();
                        bl4 = true;
                    }
                    selectSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                }
                nArray[0] = nArray[0] + 1;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(i);
                    if (simpleNode.id != 48) continue;
                    SPARQLEngine.buildSPARQLTree(selectSPARQLTreeNode, nArray, simpleNode, sQLGenContext, bl, bl2, aSTTripleAtom, bl4, string);
                }
                return selectSPARQLTreeNode;
            }
            case 12: {
                ASTAskQuery aSTAskQuery = (ASTAskQuery)node;
                AskSPARQLTreeNode askSPARQLTreeNode = new AskSPARQLTreeNode(0, sQLGenContext, nArray[0], sQLGenContext.rdfTermsOnly, sQLGenContext.plusRDFTerms, aSTAskQuery.getselDesc());
                askSPARQLTreeNode.setBindIds(aSTAskQuery.getBindVars());
                if (aSTTripleAtom != null) {
                    askSPARQLTreeNode.setIsGraphQuery(true);
                    askSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                }
                nArray[0] = nArray[0] + 1;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(i);
                    if (simpleNode.id != 48) continue;
                    SPARQLEngine.buildSPARQLTree(askSPARQLTreeNode, nArray, simpleNode, sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                }
                return askSPARQLTreeNode;
            }
            case 10: {
                ASTConstructQuery aSTConstructQuery = (ASTConstructQuery)node;
                ConstructSPARQLTreeNode constructSPARQLTreeNode = new ConstructSPARQLTreeNode(0, sQLGenContext, nArray[0], sQLGenContext.rdfTermsOnly, sQLGenContext.plusRDFTerms, string);
                nArray[0] = nArray[0] + 1;
                if (aSTTripleAtom != null) {
                    constructSPARQLTreeNode.setIsGraphQuery(true);
                    constructSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                }
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SimpleNode simpleNode = (SimpleNode)node.jjtGetChild(i);
                    SPARQLEngine.buildSPARQLTree(constructSPARQLTreeNode, nArray, simpleNode, sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                }
                return constructSPARQLTreeNode;
            }
            case 59: {
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.buildSPARQLTree(sPARQLTreeNode, nArray, node.jjtGetChild(i), sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                }
                return sPARQLTreeNode;
            }
            case 48: {
                String string2;
                Object object;
                Object object2 = sPARQLTreeNode;
                if (sPARQLTreeNode == null || !bl2) {
                    object = new SimpleSPARQLTreeNode(0, sQLGenContext, nArray[0]);
                    if (sPARQLTreeNode != null) {
                        object.setParent(sPARQLTreeNode);
                        sPARQLTreeNode.addChild((SPARQLTreeNode)object);
                    }
                    if (aSTTripleAtom != null) {
                        object.setIsGraphQuery(true);
                        object.setActiveGraph(aSTTripleAtom);
                    }
                    nArray[0] = nArray[0] + 1;
                    object2 = object;
                }
                bl2 = false;
                object = (ASTGroupGraphPattern)node;
                object2.addUserHint(QueryUtils.extractHint0Contents(sQLGenContext.defaultBGPHint));
                boolean bl5 = true;
                for (Node node2 = node.jjtGetParent(); node2 != null; node2 = node2.jjtGetParent()) {
                    if (((SimpleNode)node2).id != 48) continue;
                    bl5 = false;
                    break;
                }
                String string3 = null;
                if (sQLGenContext.queryOptions != null) {
                    string3 = sQLGenContext.queryOptions;
                }
                if (bl5 && string3 != null && (string2 = QueryUtils.extractHint0Contents(string3)) != null) {
                    object2.addUserHint(string2);
                }
                if (((ASTGroupGraphPattern)object).comment.length() > 0 && (string2 = QueryUtils.extractHint0Contents(((ASTGroupGraphPattern)object).comment)) != null) {
                    object2.addUserHint(string2);
                }
                boolean bl6 = false;
                boolean bl7 = false;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.buildSPARQLTree((SPARQLTreeNode)object2, nArray, node.jjtGetChild(i), sQLGenContext, bl6 && bl7, bl2, aSTTripleAtom, bl3, string);
                    if (((SimpleNode)node.jjtGetChild((int)i)).id == 47) {
                        bl6 = true;
                        continue;
                    }
                    if (((SimpleNode)node.jjtGetChild((int)i)).id != 49 || node.jjtGetChild(i).jjtGetNumChildren() == 1 && ((SimpleNode)node.jjtGetChild((int)i).jjtGetChild((int)0)).id == 56) continue;
                    bl7 = true;
                }
                return object2;
            }
            case 47: {
                if (bl) {
                    SimpleSPARQLTreeNode simpleSPARQLTreeNode = new SimpleSPARQLTreeNode(0, sQLGenContext, nArray[0]);
                    if (sPARQLTreeNode != null) {
                        simpleSPARQLTreeNode.setParent(sPARQLTreeNode);
                        sPARQLTreeNode.addChild(simpleSPARQLTreeNode);
                    }
                    if (aSTTripleAtom != null) {
                        simpleSPARQLTreeNode.setIsGraphQuery(true);
                        simpleSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                    }
                    nArray[0] = nArray[0] + 1;
                    sPARQLTreeNode = simpleSPARQLTreeNode;
                    bl = false;
                    sPARQLTreeNode.addUserHint(QueryUtils.extractHint0Contents(sQLGenContext.defaultBGPHint));
                }
                if (node.jjtGetNumChildren() != 3 && node.jjtGetNumChildren() != 4) {
                    throw new RDFException("Syntax Tree Error: unexpected number of children under TriplesBlock");
                }
                int n = ((SimpleNode)node.jjtGetChild((int)1)).id;
                if (n == 65 || n == 66 || n == 67 || n == 68 || n == 71 || n == 72) {
                    if (OptimizerUtils.containsNodeType(node.jjtGetChild(1), 57)) {
                        throw new RDFException("EFILTER clauses are not supported inside property path expressions");
                    }
                    PPNode pPNode = SPARQLEngine.extractPPTree(null, node.jjtGetChild(1), 0);
                    if (((SimpleNode)node.jjtGetChild((int)0)).id != 73 || ((SimpleNode)node.jjtGetChild((int)2)).id != 73) {
                        throw new RDFException("Syntax Tree Error: unexpected child type under TriplesBlock");
                    }
                    pPNode.setStartNode((ASTTripleAtom)node.jjtGetChild(0));
                    pPNode.setEndNode((ASTTripleAtom)node.jjtGetChild(2));
                    SimpleSPARQLTriplesBlock simpleSPARQLTriplesBlock = new SimpleSPARQLTriplesBlock((ASTTripleAtom)node.jjtGetChild(0), pPNode, (ASTTripleAtom)node.jjtGetChild(2));
                    sPARQLTreeNode.addTriplesBlock(simpleSPARQLTriplesBlock);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        if (((SimpleNode)node.jjtGetChild((int)i)).id == 73) continue;
                        throw new RDFException("Syntax Tree Error: unexpected child type under TriplesBlock");
                    }
                    SimpleSPARQLTriplesBlock simpleSPARQLTriplesBlock = new SimpleSPARQLTriplesBlock((ASTTripleAtom)node.jjtGetChild(0), (ASTTripleAtom)node.jjtGetChild(1), (ASTTripleAtom)node.jjtGetChild(2));
                    sPARQLTreeNode.addTriplesBlock(simpleSPARQLTriplesBlock);
                }
                if (node.jjtGetNumChildren() == 4) {
                    SPARQLEngine.buildSPARQLTree(sPARQLTreeNode, nArray, node.jjtGetChild(3), sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                }
                return sPARQLTreeNode;
            }
            case 50: 
            case 54: {
                int n = 1;
                if (((SimpleNode)node).id == 54) {
                    n = 2;
                }
                SimpleSPARQLTreeNode simpleSPARQLTreeNode = new SimpleSPARQLTreeNode(n, sQLGenContext, nArray[0]);
                if (sPARQLTreeNode != null) {
                    simpleSPARQLTreeNode.setParent(sPARQLTreeNode);
                    sPARQLTreeNode.addChild(simpleSPARQLTreeNode);
                }
                if (aSTTripleAtom != null) {
                    simpleSPARQLTreeNode.setIsGraphQuery(true);
                    simpleSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                }
                simpleSPARQLTreeNode.addUserHint(QueryUtils.extractHint0Contents(sQLGenContext.defaultBGPHint));
                nArray[0] = nArray[0] + 1;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.buildSPARQLTree(simpleSPARQLTreeNode, nArray, node.jjtGetChild(i), sQLGenContext, bl, true, aSTTripleAtom, bl3, string);
                }
                return simpleSPARQLTreeNode;
            }
            case 51: {
                SPARQLTreeNode sPARQLTreeNode2 = sPARQLTreeNode;
                if (node.jjtGetNumChildren() != 2) {
                    throw new RDFException("Syntax Tree Error: unexpected number of children under " + node.toString());
                }
                if (((SimpleNode)node.jjtGetChild((int)0)).id != 73) {
                    throw new RDFException("Syntax Tree Error: Expecting TripleAtom under " + node.toString());
                }
                ASTTripleAtom aSTTripleAtom2 = (ASTTripleAtom)node.jjtGetChild(0);
                SimpleSPARQLTreeNode simpleSPARQLTreeNode = new SimpleSPARQLTreeNode(0, sQLGenContext, nArray[0]);
                simpleSPARQLTreeNode.setIsGraphQuery(true);
                simpleSPARQLTreeNode.setActiveGraph(aSTTripleAtom2);
                if (sPARQLTreeNode != null) {
                    simpleSPARQLTreeNode.setParent(sPARQLTreeNode);
                    sPARQLTreeNode.addChild(simpleSPARQLTreeNode);
                }
                nArray[0] = nArray[0] + 1;
                sPARQLTreeNode2 = simpleSPARQLTreeNode;
                for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.buildSPARQLTree(sPARQLTreeNode2, nArray, node.jjtGetChild(i), sQLGenContext, bl, true, aSTTripleAtom2, false, string);
                }
                return sPARQLTreeNode;
            }
            case 46: {
                if (node.jjtGetNumChildren() == 1) {
                    throw new RDFException("An empty CONSTRUCT template is not allowed");
                }
                if (node.jjtGetNumChildren() != 2) {
                    throw new RDFException("Syntax Tree Error: unexpected number of children under " + node.toString());
                }
                if (((SimpleNode)node.jjtGetChild((int)0)).id != 73) {
                    throw new RDFException("Syntax Tree Error: Expecting TripleAtom under " + node.toString());
                }
                ASTTripleAtom aSTTripleAtom3 = (ASTTripleAtom)node.jjtGetChild(0);
                TemplateSPARQLTreeNode templateSPARQLTreeNode = (TemplateSPARQLTreeNode)sPARQLTreeNode;
                templateSPARQLTreeNode.openBGP();
                templateSPARQLTreeNode.setActiveGraph(aSTTripleAtom3);
                for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.buildSPARQLTree(templateSPARQLTreeNode, nArray, node.jjtGetChild(i), sQLGenContext, false, true, aSTTripleAtom3, false, string);
                }
                templateSPARQLTreeNode.closeBGP();
                return sPARQLTreeNode;
            }
            case 55: {
                UnionSPARQLTreeNode unionSPARQLTreeNode = new UnionSPARQLTreeNode(0, sQLGenContext, nArray[0]);
                if (sPARQLTreeNode != null) {
                    unionSPARQLTreeNode.setParent(sPARQLTreeNode);
                    sPARQLTreeNode.addChild(unionSPARQLTreeNode);
                }
                if (aSTTripleAtom != null) {
                    unionSPARQLTreeNode.setIsGraphQuery(true);
                    unionSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                }
                nArray[0] = nArray[0] + 1;
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.buildSPARQLTree(unionSPARQLTreeNode, nArray, node.jjtGetChild(i), sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                }
                return unionSPARQLTreeNode;
            }
            case 56: {
                List<Filter> list = SPARQLEngine.extractFilters((SimpleNode)node, sQLGenContext, aSTTripleAtom);
                for (Filter filter : list) {
                    sPARQLTreeNode.addFilter(filter);
                }
                return sPARQLTreeNode;
            }
            case 52: {
                if (node.jjtGetNumChildren() != 2) {
                    throw new RDFException("Syntax Tree Error: unexpected number of children under " + node.toString());
                }
                AbstractSPARQLTreeNode abstractSPARQLTreeNode = null;
                String string4 = "";
                try {
                    string4 = ((ASTServiceGraphPattern)node).getEndpoint();
                }
                catch (ParseException parseException) {
                    throw new RDFException(parseException.getMessage());
                }
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = false;
                String string5 = "";
                if (string4.startsWith("http://xmlns.oracle.com/models/")) {
                    bl8 = true;
                    string5 = string4.substring("http://xmlns.oracle.com/models/".length()).toUpperCase();
                } else if (string4.startsWith("http://xmlns.oracle.com/virtual_models/")) {
                    bl8 = true;
                    bl9 = true;
                    string5 = string4.substring("http://xmlns.oracle.com/virtual_models/".length()).toUpperCase();
                } else if (string4.startsWith("http://xmlns.oracle.com/rdb_models/")) {
                    bl8 = true;
                    bl10 = true;
                    string5 = string4.substring("http://xmlns.oracle.com/rdb_models/".length()).toUpperCase();
                }
                if (bl8) {
                    if (sQLGenContext.vmViewName == null && sQLGenContext.defaultGraph.contains("UNION")) {
                        throw new RDFException("Overloaded service is not allowed with multiple models nor with entailments");
                    }
                    try {
                        SQLGenContext sQLGenContext2 = (SQLGenContext)sQLGenContext.clone();
                        sQLGenContext2.models = new String[]{string5};
                        sQLGenContext2.isRdfVWModel = bl10;
                        String string6 = "(\"MDSYS\"\\.\")(RDFM)_(\\w)+?(\")";
                        String string7 = "$1RDFM_" + string5 + "$4";
                        if (sQLGenContext2.vmViewName != null) {
                            sQLGenContext2.defaultGraph = sQLGenContext2.vmDefault;
                            sQLGenContext2.namedGraphs = sQLGenContext2.vmNamed;
                            string6 = "(\"MDSYS\"\\.\")(SEMV|SEMU)_(\\w)+?(\")";
                        }
                        sQLGenContext2.defaultGraph = sQLGenContext2.defaultGraph.replaceAll(string6, string7);
                        sQLGenContext2.namedGraphs = sQLGenContext2.namedGraphs.replaceAll(string6, string7);
                        if (bl9) {
                            sQLGenContext2.vmDefault = sQLGenContext2.defaultGraph;
                            sQLGenContext2.vmNamed = sQLGenContext2.namedGraphs;
                            string6 = "(\"MDSYS\"\\.\")(RDFM)_(\\w)+?(\")";
                            if (sQLGenContext2.serviceSEMU) {
                                sQLGenContext2.vmViewName = "\"MDSYS\".\"SEMU_" + string5 + "\"";
                                string7 = "$1SEMU_" + string5 + "$4";
                            } else {
                                sQLGenContext2.vmViewName = "\"MDSYS\".\"SEMV_" + string5 + "\"";
                                string7 = "$1SEMV_" + string5 + "$4";
                            }
                            sQLGenContext2.vmDefault = sQLGenContext2.vmDefault.replaceAll(string6, string7);
                            sQLGenContext2.vmNamed = sQLGenContext2.vmNamed.replaceAll(string6, string7);
                        } else {
                            sQLGenContext2.vmViewName = null;
                            sQLGenContext2.vmDefault = null;
                            sQLGenContext2.vmNamed = null;
                        }
                        int n = 1;
                        String string8 = ((ASTServiceGraphPattern)node).getComment().toUpperCase();
                        if (sQLGenContext2.overloadedNL || string8.contains("OVERLOADED_NL=T")) {
                            n |= 2;
                        }
                        if (sQLGenContext2.joinOverloaded || string8.contains("JOIN_OVERLOADED=T")) {
                            n |= 4;
                        }
                        if ((n & 2) == 0) {
                            abstractSPARQLTreeNode = new SimpleSPARQLTreeNode(0, sQLGenContext2, nArray[0]);
                        } else {
                            try {
                                String string9 = node.jjtGetChild(1).printSPARQLText();
                                if (aSTTripleAtom != null) {
                                    string9 = "{ GRAPH " + aSTTripleAtom.printSPARQLText() + string9 + " }";
                                }
                                abstractSPARQLTreeNode = new SimpleSPARQLTreeNode(0, sQLGenContext2, nArray[0], string9);
                            }
                            catch (ParseException parseException) {
                                throw new RDFException(parseException.getMessage());
                            }
                        }
                        abstractSPARQLTreeNode.setOverloadedServiceInfo(n);
                        if (sPARQLTreeNode != null) {
                            abstractSPARQLTreeNode.setParent(sPARQLTreeNode);
                            sPARQLTreeNode.addChild(abstractSPARQLTreeNode);
                        }
                        if (aSTTripleAtom != null) {
                            abstractSPARQLTreeNode.setIsGraphQuery(true);
                            abstractSPARQLTreeNode.setActiveGraph(aSTTripleAtom);
                        }
                        nArray[0] = nArray[0] + 1;
                        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                            SPARQLEngine.buildSPARQLTree(abstractSPARQLTreeNode, nArray, node.jjtGetChild(i), sQLGenContext2, bl, bl2, aSTTripleAtom, bl3, string);
                        }
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        cloneNotSupportedException.printStackTrace();
                    }
                } else {
                    if (aSTTripleAtom != null) {
                        throw new RDFException("Syntax Tree Error: SERVICE should not be called inside of GRAPH clause");
                    }
                    try {
                        abstractSPARQLTreeNode = new ServiceSPARQLTreeNode(0, sQLGenContext, nArray[0], string4, ((ASTServiceGraphPattern)node).getGraphPattern(), ((ASTServiceGraphPattern)node).getSilent(), ((ASTServiceGraphPattern)node).getComment());
                    }
                    catch (ParseException parseException) {
                        throw new RDFException(parseException.getMessage());
                    }
                    if (sPARQLTreeNode != null) {
                        abstractSPARQLTreeNode.setParent(sPARQLTreeNode);
                        sPARQLTreeNode.addChild(abstractSPARQLTreeNode);
                    }
                    nArray[0] = nArray[0] + 1;
                    for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                        SPARQLEngine.buildSPARQLTree(abstractSPARQLTreeNode, nArray, node.jjtGetChild(i), sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
                    }
                }
                return abstractSPARQLTreeNode;
            }
        }
        if (node.jjtGetNumChildren() != 1) {
            throw new RDFException("Syntax Tree Error: unexpected number of children under " + node.toString());
        }
        return SPARQLEngine.buildSPARQLTree(sPARQLTreeNode, nArray, node.jjtGetChild(0), sQLGenContext, bl, bl2, aSTTripleAtom, bl3, string);
    }

    protected static PPNode extractPPTree(PPNode pPNode, Node node, int n) throws RDFException {
        switch (((SimpleNode)node).id) {
            case 65: {
                PPAltNode pPAltNode = new PPAltNode();
                pPAltNode.setDirection(n);
                if (pPNode != null) {
                    pPNode.addChild(pPAltNode);
                    pPAltNode.setParent(pPNode);
                }
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.extractPPTree(pPAltNode, node.jjtGetChild(i), 0);
                }
                return pPAltNode;
            }
            case 66: {
                PPSeqNode pPSeqNode = new PPSeqNode();
                pPSeqNode.setDirection(n);
                if (pPNode != null) {
                    pPNode.addChild(pPSeqNode);
                    pPSeqNode.setParent(pPNode);
                }
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.extractPPTree(pPSeqNode, node.jjtGetChild(i), 0);
                }
                return pPSeqNode;
            }
            case 67: {
                if (node.jjtGetNumChildren() != 2) {
                    throw new RDFException("Syntax Tree Error: unexpected number of children under Path Elt");
                }
                PPModNode pPModNode = new PPModNode();
                pPModNode.setDirection(n);
                if (pPNode != null) {
                    pPNode.addChild(pPModNode);
                    pPModNode.setParent(pPNode);
                }
                SPARQLEngine.extractPPTree(pPModNode, node.jjtGetChild(0), 0);
                SPARQLEngine.extractPPTree(pPModNode, node.jjtGetChild(1), 0);
                return pPModNode;
            }
            case 68: 
            case 72: {
                if (node.jjtGetNumChildren() != 1) {
                    throw new RDFException("Syntax Tree Error: unexpected number children under Inverse Path Elt");
                }
                return SPARQLEngine.extractPPTree(pPNode, node.jjtGetChild(0), (n + 1) % 2);
            }
            case 71: {
                PPNegatedNode pPNegatedNode = new PPNegatedNode();
                pPNegatedNode.setDirection(n);
                if (pPNode != null) {
                    pPNode.addChild(pPNegatedNode);
                    pPNegatedNode.setParent(pPNode);
                }
                for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                    SPARQLEngine.extractPPTree(pPNegatedNode, node.jjtGetChild(i), 0);
                }
                return pPNegatedNode;
            }
            case 69: {
                int n2;
                PPModNode pPModNode = (PPModNode)pPNode;
                ASTSimplePathMod aSTSimplePathMod = (ASTSimplePathMod)node;
                if (aSTSimplePathMod.name.equals("?")) {
                    n2 = 0;
                } else if (aSTSimplePathMod.name.equals("*")) {
                    n2 = 1;
                } else if (aSTSimplePathMod.name.equals("+")) {
                    n2 = 2;
                } else {
                    throw new RDFException("Syntax Tree Error: unexpected property path modifier: " + aSTSimplePathMod.name);
                }
                pPModNode.setModDetails(n2, false, -1, -1);
                return pPModNode;
            }
            case 70: {
                PPModNode pPModNode = (PPModNode)pPNode;
                ASTComplexPathMod aSTComplexPathMod = (ASTComplexPathMod)node;
                pPModNode.setModDetails(3, aSTComplexPathMod.exact, aSTComplexPathMod.minOcc, aSTComplexPathMod.maxOcc);
                return pPModNode;
            }
            case 73: {
                PPIRINode pPIRINode = new PPIRINode((ASTTripleAtom)node);
                pPIRINode.setDirection(n);
                if (pPNode != null) {
                    pPNode.addChild(pPIRINode);
                    pPIRINode.setParent(pPNode);
                }
                return pPIRINode;
            }
        }
        throw new RDFException("Syntax Tree Error: unexpected node type encountered while processing property path");
    }

    protected static List<Filter> extractFilters(SimpleNode simpleNode, SQLGenContext sQLGenContext, ASTTripleAtom aSTTripleAtom) {
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        Stack<SimpleNode> stack = new Stack<SimpleNode>();
        stack.push(simpleNode);
        while (!stack.empty()) {
            SimpleNode simpleNode2 = (SimpleNode)stack.pop();
            int n = simpleNode2.id;
            if (n == 79 || n == 56) {
                int n2 = simpleNode2.jjtGetNumChildren();
                for (int i = n2 - 1; i >= 0; --i) {
                    stack.push((SimpleNode)simpleNode2.jjtGetChild(i));
                }
                continue;
            }
            Filter filter = new Filter(simpleNode2, sQLGenContext, aSTTripleAtom);
            arrayList.add(filter);
        }
        return arrayList;
    }

    protected static Node optimizeAST(Node node, List<SparqlQueryOptimizer> list, SQLGenContext sQLGenContext) throws RDFException, ParseException {
        Node node2 = node.cloneSubTree();
        for (SparqlQueryOptimizer sparqlQueryOptimizer : list) {
            node2 = sparqlQueryOptimizer.optimizeQuery(node2);
        }
        return node2;
    }

    protected static void populateFuncTypeMap(SQLGenContext sQLGenContext) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (sQLGenContext.useOldOptimizationForSTR && !sQLGenContext.clobExpSupport) {
            hashMap.put("STR", "LITERAL");
        } else {
            hashMap.put("STR", "SDO_RDF_TERM");
        }
        hashMap.put("LANG", "LITERAL");
        hashMap.put("LANGMATCHES", "BOOLEAN");
        hashMap.put("DATATYPE", "URI");
        hashMap.put("BOUND", "BOOLEAN");
        hashMap.put("SAMETERM", "BOOLEAN");
        hashMap.put("ISURI", "BOOLEAN");
        hashMap.put("ISIRI", "BOOLEAN");
        hashMap.put("ISBLANK", "BOOLEAN");
        hashMap.put("ISLITERAL", "BOOLEAN");
        hashMap.put("ISNUMERIC", "BOOLEAN");
        hashMap.put("REGEX", "BOOLEAN");
        hashMap.put("IN", "BOOLEAN");
        hashMap.put("NOT IN", "BOOLEAN");
        hashMap.put("EXISTS", "BOOLEAN");
        hashMap.put("NOT EXISTS", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/hasVID", "BOOLEAN");
        if (sQLGenContext.clobExpSupport) {
            hashMap.put("IF", "SDO_RDF_TERM");
            hashMap.put("COALESCE", "SDO_RDF_TERM");
            hashMap.put("REPLACE", "SDO_RDF_TERM");
        } else {
            hashMap.put("IF", "VC_RDF_TERM");
            hashMap.put("COALESCE", "VC_RDF_TERM");
            hashMap.put("REPLACE", "VC_RDF_TERM");
        }
        hashMap.put("COUNT", "INTEGER");
        hashMap.put("SUM", "NUMERIC");
        hashMap.put("AVG", "NUMERIC");
        if (sQLGenContext.clobAggSupport) {
            hashMap.put("GROUP_CONCAT", "SDO_RDF_TERM");
            hashMap.put("MIN", "SDO_RDF_TERM");
            hashMap.put("MAX", "SDO_RDF_TERM");
            hashMap.put("SAMPLE", "SDO_RDF_TERM");
        } else {
            hashMap.put("GROUP_CONCAT", "VC_RDF_TERM");
            hashMap.put("MIN", "VC_RDF_TERM");
            hashMap.put("MAX", "VC_RDF_TERM");
            hashMap.put("SAMPLE", "VC_RDF_TERM");
        }
        hashMap.put("http://www.w3.org/2001/XMLSchema#boolean", "BOOLEAN");
        hashMap.put("http://www.w3.org/2001/XMLSchema#decimal", "NUMERIC");
        hashMap.put("http://www.w3.org/2001/XMLSchema#double", "DOUBLE");
        hashMap.put("http://www.w3.org/2001/XMLSchema#float", "FLOAT");
        hashMap.put("http://www.w3.org/2001/XMLSchema#integer", "INTEGER");
        hashMap.put("http://www.w3.org/2001/XMLSchema#int", "INTEGER");
        hashMap.put("http://www.w3.org/2001/XMLSchema#string", "SDO_RDF_TERM");
        hashMap.put("http://www.w3.org/2001/XMLSchema#dateTime", "DATETIME");
        hashMap.put("CONTAINS", "BOOLEAN");
        hashMap.put("STRLEN", "INTEGER");
        hashMap.put("STRSTARTS", "BOOLEAN");
        hashMap.put("STRENDS", "BOOLEAN");
        hashMap.put("ENCODE_FOR_URI", "LITERAL");
        hashMap.put("ABS", "NUMERIC");
        hashMap.put("ROUND", "NUMERIC");
        hashMap.put("CEIL", "NUMERIC");
        hashMap.put("FLOOR", "NUMERIC");
        hashMap.put("RAND", "NUMERIC");
        hashMap.put("NOW", "DATETIME");
        hashMap.put("YEAR", "INTEGER");
        hashMap.put("MONTH", "INTEGER");
        hashMap.put("DAY", "INTEGER");
        hashMap.put("HOURS", "INTEGER");
        hashMap.put("MINUTES", "INTEGER");
        hashMap.put("SECONDS", "NUMERIC");
        hashMap.put("MD5", "LITERAL");
        hashMap.put("SHA1", "LITERAL");
        hashMap.put("SHA256", "LITERAL");
        hashMap.put("SHA384", "LITERAL");
        hashMap.put("SHA512", "LITERAL");
        hashMap.put("UUID", "URI");
        hashMap.put("STRUUID", "LITERAL");
        if (sQLGenContext.clobExpSupport) {
            hashMap.put("UCASE", "SDO_RDF_TERM");
            hashMap.put("LCASE", "SDO_RDF_TERM");
            hashMap.put("SUBSTR", "SDO_RDF_TERM");
            hashMap.put("CONCAT", "SDO_RDF_TERM");
            hashMap.put("STRBEFORE", "SDO_RDF_TERM");
            hashMap.put("STRAFTER", "SDO_RDF_TERM");
            hashMap.put("URI", "SDO_RDF_TERM");
            hashMap.put("IRI", "SDO_RDF_TERM");
            hashMap.put("BNODE", "SDO_RDF_TERM");
            hashMap.put("STRLANG", "SDO_RDF_TERM");
            hashMap.put("STRDT", "SDO_RDF_TERM");
            hashMap.put("TIMEZONE", "SDO_RDF_TERM");
            hashMap.put("TZ", "SDO_RDF_TERM");
        } else {
            hashMap.put("UCASE", "VC_RDF_TERM");
            hashMap.put("LCASE", "VC_RDF_TERM");
            hashMap.put("SUBSTR", "VC_RDF_TERM");
            hashMap.put("CONCAT", "VC_RDF_TERM");
            hashMap.put("STRBEFORE", "VC_RDF_TERM");
            hashMap.put("STRAFTER", "VC_RDF_TERM");
            hashMap.put("URI", "VC_RDF_TERM");
            hashMap.put("IRI", "VC_RDF_TERM");
            hashMap.put("BNODE", "VC_RDF_TERM");
            hashMap.put("STRLANG", "VC_RDF_TERM");
            hashMap.put("STRDT", "VC_RDF_TERM");
            hashMap.put("TIMEZONE", "VC_RDF_TERM");
            hashMap.put("TZ", "VC_RDF_TERM");
        }
        hashMap.put("http://xmlns.oracle.com/pg/isVertex", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isEdge", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isVertexProperty", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isEdgeProperty", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isProperty", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isValue", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isVertexLabelProperty", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isVertexIdProperty", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isEdgeLabelProperty", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/pg/isEdgeIdProperty", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/sameCanonTerm", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/textContains", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/textScore", "NUMERIC");
        hashMap.put("http://xmlns.oracle.com/rdf/like", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfEquals", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfDisjoint", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfIntersects", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfTouches", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfCrosses", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfWithin", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfContains", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfOverlaps", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/relate", "BOOLEAN");
        hashMap.put("http://www.opengis.net/def/function/geosparql/distance", "NUMERIC");
        hashMap.put("http://www.opengis.net/def/function/geosparql/buffer", "SDO_GEOM");
        hashMap.put("http://www.opengis.net/def/function/geosparql/envelope", "SDO_GEOM");
        hashMap.put("http://www.opengis.net/def/function/geosparql/convexHull", "SDO_GEOM");
        hashMap.put("http://www.opengis.net/def/function/geosparql/difference", "SDO_GEOM");
        hashMap.put("http://www.opengis.net/def/function/geosparql/symDifference", "SDO_GEOM");
        hashMap.put("http://www.opengis.net/def/function/geosparql/union", "SDO_GEOM");
        hashMap.put("http://www.opengis.net/def/function/geosparql/intersection", "SDO_GEOM");
        hashMap.put("http://www.opengis.net/def/function/geosparql/getSRID", "URI");
        hashMap.put("http://www.opengis.net/def/function/geosparql/boundary", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/withinDistance", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/idxWithinDistance", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/funcWithinDistance", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/relate", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/idxRelate", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/funcRelate", "LITERAL");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/nearestNeighbor", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/area", "NUMERIC");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/centroid", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/length", "NUMERIC");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/maxMbrOrdinate", "NUMERIC");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/minMbrOrdinate", "NUMERIC");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/distance", "NUMERIC");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/buffer", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/convexHull", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/intersection", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/union", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/difference", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/xor", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/mbr", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/sdoJoin", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/sdoDistJoin", "BOOLEAN");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/getSRID", "URI");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrCentroid", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrConcatLines", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrConvexhull", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrMBR", "SDO_GEOM");
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrUnion", "SDO_GEOM");
        sQLGenContext.funcTypeMap = hashMap;
    }

    protected static void populateFuncHandMap(SQLGenContext sQLGenContext) {
        HashMap<String, FilterFuncHandler> hashMap = new HashMap<String, FilterFuncHandler>();
        StringFilterHandler stringFilterHandler = new StringFilterHandler(sQLGenContext);
        NumericFilterHandler numericFilterHandler = new NumericFilterHandler();
        CalendarFilterHandler calendarFilterHandler = new CalendarFilterHandler();
        EncryptFilterHandler encryptFilterHandler = new EncryptFilterHandler(sQLGenContext);
        TermConstructFilterHandler termConstructFilterHandler = new TermConstructFilterHandler(sQLGenContext);
        hashMap.put("CONTAINS", stringFilterHandler);
        hashMap.put("STRLEN", stringFilterHandler);
        hashMap.put("UCASE", stringFilterHandler);
        hashMap.put("LCASE", stringFilterHandler);
        hashMap.put("STRSTARTS", stringFilterHandler);
        hashMap.put("STRENDS", stringFilterHandler);
        hashMap.put("SUBSTR", stringFilterHandler);
        hashMap.put("CONCAT", stringFilterHandler);
        hashMap.put("ENCODE_FOR_URI", stringFilterHandler);
        hashMap.put("STRBEFORE", stringFilterHandler);
        hashMap.put("STRAFTER", stringFilterHandler);
        hashMap.put("ABS", numericFilterHandler);
        hashMap.put("ROUND", numericFilterHandler);
        hashMap.put("CEIL", numericFilterHandler);
        hashMap.put("FLOOR", numericFilterHandler);
        hashMap.put("RAND", numericFilterHandler);
        hashMap.put("NOW", calendarFilterHandler);
        hashMap.put("YEAR", calendarFilterHandler);
        hashMap.put("MONTH", calendarFilterHandler);
        hashMap.put("DAY", calendarFilterHandler);
        hashMap.put("HOURS", calendarFilterHandler);
        hashMap.put("MINUTES", calendarFilterHandler);
        hashMap.put("SECONDS", calendarFilterHandler);
        hashMap.put("MD5", encryptFilterHandler);
        hashMap.put("SHA1", encryptFilterHandler);
        hashMap.put("SHA256", encryptFilterHandler);
        hashMap.put("SHA384", encryptFilterHandler);
        hashMap.put("SHA512", encryptFilterHandler);
        hashMap.put("IRI", termConstructFilterHandler);
        hashMap.put("URI", termConstructFilterHandler);
        hashMap.put("BNODE", termConstructFilterHandler);
        hashMap.put("STRLANG", termConstructFilterHandler);
        hashMap.put("STRDT", termConstructFilterHandler);
        hashMap.put("TIMEZONE", termConstructFilterHandler);
        hashMap.put("TZ", termConstructFilterHandler);
        hashMap.put("UUID", termConstructFilterHandler);
        hashMap.put("STRUUID", termConstructFilterHandler);
        PGFilterHandler pGFilterHandler = new PGFilterHandler();
        hashMap.put("http://xmlns.oracle.com/pg/isVertex", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isEdge", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isVertexProperty", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isEdgeProperty", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isProperty", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isValue", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isVertexLabelProperty", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isVertexIdProperty", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isEdgeLabelProperty", pGFilterHandler);
        hashMap.put("http://xmlns.oracle.com/pg/isEdgeIdProperty", pGFilterHandler);
        XSDConstructFilterHandler xSDConstructFilterHandler = new XSDConstructFilterHandler();
        hashMap.put("http://www.w3.org/2001/XMLSchema#boolean", xSDConstructFilterHandler);
        hashMap.put("http://www.w3.org/2001/XMLSchema#decimal", xSDConstructFilterHandler);
        hashMap.put("http://www.w3.org/2001/XMLSchema#double", xSDConstructFilterHandler);
        hashMap.put("http://www.w3.org/2001/XMLSchema#float", xSDConstructFilterHandler);
        hashMap.put("http://www.w3.org/2001/XMLSchema#integer", xSDConstructFilterHandler);
        hashMap.put("http://www.w3.org/2001/XMLSchema#string", xSDConstructFilterHandler);
        hashMap.put("http://www.w3.org/2001/XMLSchema#dateTime", xSDConstructFilterHandler);
        hashMap.put("http://www.w3.org/2001/XMLSchema#int", xSDConstructFilterHandler);
        TextFilterHandler textFilterHandler = new TextFilterHandler();
        hashMap.put("http://xmlns.oracle.com/rdf/textContains", textFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/textScore", textFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/like", textFilterHandler);
        SpatialFilterHandler spatialFilterHandler = new SpatialFilterHandler(sQLGenContext, sQLGenContext.strictOGC);
        hashMap.put("http://www.opengis.net/def/function/geosparql/relate", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/distance", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/buffer", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/envelope", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/convexHull", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/difference", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/symDifference", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/union", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/intersection", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/getSRID", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/boundary", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/withinDistance", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/idxWithinDistance", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/funcWithinDistance", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/relate", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/idxRelate", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/funcRelate", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/nearestNeighbor", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/area", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/centroid", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/length", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/maxMbrOrdinate", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/minMbrOrdinate", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/distance", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/buffer", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/convexHull", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/intersection", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/union", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/difference", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/xor", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/mbr", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/sdoJoin", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/sdoDistJoin", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/getSRID", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfEquals", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfDisjoint", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfIntersects", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfTouches", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfCrosses", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfWithin", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfContains", spatialFilterHandler);
        hashMap.put("http://www.opengis.net/def/function/geosparql/sfOverlaps", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrCentroid", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrConcatLines", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrConvexhull", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrMBR", spatialFilterHandler);
        hashMap.put("http://xmlns.oracle.com/rdf/geo/aggrUnion", spatialFilterHandler);
        sQLGenContext.funcHandMap = hashMap;
    }

    protected static String translateSPARQL(SQLGenContext sQLGenContext, Node node, ASTTopLevelQueryNode aSTTopLevelQueryNode, int[] nArray, String string) throws TypeException, FilterException, ParseException, RDFException, SQLException {
        SPARQLEngine.setNetworkSpatialInfo(sQLGenContext, node);
        SPARQLEngine.populateFuncTypeMap(sQLGenContext);
        SPARQLEngine.populateFuncHandMap(sQLGenContext);
        sQLGenContext.pIDs = nArray;
        if (aSTTopLevelQueryNode != null) {
            sQLGenContext.defaultGraphList = aSTTopLevelQueryNode.getsourceDesc().getDefaultGraphs();
            sQLGenContext.namedGraphsList = aSTTopLevelQueryNode.getsourceDesc().getNamedGraphs();
        }
        SPARQLEngine.buildDefaultBGPHint(sQLGenContext);
        SPARQLTreeNode sPARQLTreeNode = SPARQLEngine.buildSPARQLTree(node, sQLGenContext, null, new HashSet<String>(), new HashSet<String>(), string);
        SPARQLEngine.prepareSTreeForTrans(sPARQLTreeNode, sQLGenContext, new HashSet<String>());
        String string2 = sPARQLTreeNode.toSQL();
        if (sQLGenContext.dmpSQL) {
            QueryUtils.log("%%%%%%%%%%% Bottom-up SQL: Size [" + string2.length() + "] %%%%%%%%%%%%%%%%%%%");
            QueryUtils.log(string2);
            QueryUtils.log("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void setQueryOptions(SQLGenContext sQLGenContext, int n) throws RDFException {
        String string;
        String string2;
        int n2;
        int n3;
        String string3;
        String string4;
        String string5;
        String string6;
        int n4;
        boolean bl;
        try {
            if (!SPARQLEngine.getIsMigrated()) {
                throw new RDFException("RDF_VALUE$ Table needs data migration with SEM_APIS.MIGRATE_DATA_TO_CURRENT");
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RDFException("Error checking data migration. Verify MDSYS.RDF_PARAMETER table");
        }
        sQLGenContext.allUnnamedTrips = (n & 0x20) > 0;
        sQLGenContext.entUnnamedTrips = (n & 0x40) > 0;
        sQLGenContext.nonEmptyNamed = (n & 0x100) > 0;
        boolean bl2 = (n & 0x200) > 0;
        boolean bl3 = (n & 0x400) > 0;
        boolean bl4 = (n & 0x800) > 0;
        boolean bl5 = (n & 0x1000) > 0;
        boolean bl6 = bl = (n & 0x2000) > 0;
        if (sQLGenContext.queryOptions == null) return;
        String string7 = sQLGenContext.queryOptions;
        String string8 = "";
        if (string7 != null) {
            string8 = string7.toUpperCase();
        }
        if ((n4 = string8.indexOf("MIN_LABEL=")) != -1) {
            n4 += 10;
            StringBuffer stringBuffer = new StringBuffer();
            while (n4 < string8.length() && string8.charAt(n4) != ' ' && string8.charAt(n4) != ',') {
                stringBuffer.append(string8.charAt(n4++));
            }
            sQLGenContext.minLabel = stringBuffer.toString().trim();
            n4 = string8.indexOf("POLICY_NAME=");
            if (n4 != -1) {
                n4 += 12;
                StringBuffer stringBuffer2 = new StringBuffer();
                while (n4 < string8.length() && string8.charAt(n4) != ' ' && string8.charAt(n4) != ',') {
                    stringBuffer2.append(string8.charAt(n4++));
                }
                sQLGenContext.policyName = stringBuffer2.toString().trim();
            }
        }
        if (string8.indexOf("ALLOW_DUP=T") >= 0) {
            sQLGenContext.forceDup = true;
            sQLGenContext.serviceSEMU = false;
        }
        if (string8.indexOf("RELAX_FILTER=T") >= 0) {
            sQLGenContext.relaxFilter = true;
        }
        if (string8.indexOf("FAST_DATE_FILTER=T") >= 0) {
            sQLGenContext.filterFlags |= 1;
        }
        if (string8.indexOf("STRICT_TERM_COMP=F") >= 0) {
            sQLGenContext.filterFlags |= 2;
        }
        if (string8.indexOf("DISABLE_VID_F_OPT") >= 0) {
            sQLGenContext.filterFlags |= 4;
        }
        if (string8.indexOf("DISABLE_NO_MERGE") >= 0) {
            sQLGenContext.disableNoMerge = true;
        }
        if (string8.indexOf("ENABLE_SUB_NO_MERGE") >= 0) {
            sQLGenContext.enableSubNoMerge = true;
        }
        if (string8.indexOf("DISABLE_GRAPH_MAT_VIEW") >= 0) {
            sQLGenContext.disableGMVOpt = true;
        }
        if (string8.indexOf("DISABLE_NO_SWAP_JOIN_INPUTS") >= 0) {
            sQLGenContext.disableNoSwap = true;
        }
        if (string8.indexOf("ENABLE_SUB_NO_SWAP_JOIN_INPUTS") >= 0) {
            sQLGenContext.enableSubNoSwap = true;
        }
        if (string8.indexOf(Hint.QueryOption.ALL_LINK_HASH.getName()) >= 0) {
            sQLGenContext.allLinkHash = true;
        }
        if (string8.indexOf(Hint.QueryOption.ALL_LINK_NL.getName()) >= 0) {
            sQLGenContext.allLinkNL = true;
        }
        if (string8.indexOf(Hint.QueryOption.NO_LINK_INDEX.getName()) >= 0) {
            sQLGenContext.allLinkNoIndex = true;
        }
        if (string8.indexOf(Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH.getName()) >= 0) {
            sQLGenContext.allNLValueHash = true;
        }
        if (string8.indexOf(Hint.QueryOption.ALL_NONLOCAL_VALUE_NL.getName()) >= 0) {
            sQLGenContext.allNLValueNL = true;
        }
        if (string8.indexOf(Hint.QueryOption.ALL_NONLOCAL_VALUE_NO_MERGE.getName()) >= 0) {
            sQLGenContext.allValueNoMerge = true;
        }
        if (string8.indexOf(Hint.QueryOption.ALL_LOCAL_VALUE_HASH.getName()) >= 0) {
            sQLGenContext.allLValueHash = true;
        }
        if (string8.indexOf(Hint.QueryOption.ALL_LOCAL_VALUE_NL.getName()) >= 0) {
            sQLGenContext.allLValueNL = true;
        }
        if (string8.indexOf(Hint.QueryOption.NO_VALUE_INDEX.getName()) >= 0) {
            sQLGenContext.allLValueNoIndex = true;
        }
        if (string8.indexOf(Hint.QueryOption.NO_NL_VALUE_INDEX.getName()) >= 0) {
            sQLGenContext.allNLValueNoIndex = true;
        }
        if (string8.indexOf("FINAL_VALUE_HASH") >= 0) {
            sQLGenContext.finalValJoinFlag |= 1;
        }
        if (string8.indexOf("FINAL_VALUE_NL") >= 0) {
            sQLGenContext.finalValJoinFlag |= 2;
        }
        if (string8.indexOf("FINAL_VALUE_NO_INDEX") >= 0) {
            sQLGenContext.finalValJoinFlag |= 4;
        }
        if (string8.indexOf("ALL_NO_INDEXES") >= 0) {
            sQLGenContext.allLinkNoIndex = true;
            sQLGenContext.allLValueNoIndex = true;
            sQLGenContext.allNLValueNoIndex = true;
            sQLGenContext.finalValJoinFlag |= 4;
        }
        if (string8.indexOf("ALL_BGP_HASH") >= 0) {
            sQLGenContext.allBgpHash = true;
        }
        if (string8.indexOf("ALL_BGP_NL") >= 0) {
            sQLGenContext.allBgpNL = true;
        }
        if (string8.indexOf("ALL_NO_MERGE") >= 0) {
            sQLGenContext.allNoMerge = true;
        }
        if (string8.indexOf("ALL_BGP_SWAP_JOIN_INPUTS") >= 0) {
            sQLGenContext.allSwap = true;
        }
        if (string8.indexOf("ALL_ORDERED") >= 0) {
            sQLGenContext.allOrdered = true;
        }
        if (string8.indexOf("NO_PUSH_VALUE") >= 0) {
            sQLGenContext.noPushVal = true;
        }
        if (string8.indexOf("TOP_DOWN_TRANS=T") >= 0) {
            sQLGenContext.useBottomUpTrans = false;
        }
        if (string8.indexOf("ALL_PULL_PARENT_BGP") >= 0) {
            sQLGenContext.allPullBgp = true;
        }
        if (string8.indexOf("ALL_MATERIALIZE") >= 0) {
            sQLGenContext.allMaterialize = true;
        }
        if ((string6 = QueryUtils.extractPlainOption(string8, "SERVICE_PROXY")) != null) {
            sQLGenContext.serviceProxy = string6;
        }
        if ((string5 = QueryUtils.extractPlainOption(string8, "SERVICE_URL_CHARSET")) != null) {
            sQLGenContext.serviceURLCharset = string5;
        }
        if (string8.indexOf("HTTP_METHOD=POST_PAR") >= 0) {
            sQLGenContext.httpMethod = 2;
        } else if (string8.indexOf("HTTP_METHOD=POST_DIR") >= 0) {
            sQLGenContext.httpMethod = 3;
        }
        if (string8.indexOf("SERVICE_ESCAPE=F") >= 0) {
            sQLGenContext.escapeService = false;
        }
        if (string8.indexOf("USE_XMLPARSER=T") >= 0) {
            sQLGenContext.useXMLParser = true;
        }
        if (string8.indexOf("SERVICE_CLOB=F") >= 0) {
            sQLGenContext.nullServiceCLOB = true;
        }
        if ((string4 = QueryUtils.extractPlainOption(string8, "SERVICE_NROWS")) != null) {
            sQLGenContext.serviceNRows = string4;
        }
        if (string8.indexOf("SERVICE_JPDWN=T") >= 0) {
            sQLGenContext.disableVidLexOpt = true;
            sQLGenContext.serviceJoinPushDown = true;
        }
        if (string8.indexOf("OVERLOADED_NL=T") >= 0) {
            sQLGenContext.overloadedNL = true;
        }
        if (string8.indexOf("JOIN_OVERLOADED=T") >= 0) {
            sQLGenContext.joinOverloaded = true;
        }
        if (string8.indexOf("START_PP_OPT=F") >= 0) {
            sQLGenContext.startPPOpt = false;
        }
        if (string8.indexOf("STRICT_PP_NODE_SET=T") >= 0) {
            sQLGenContext.strictPPNodeSet = true;
        }
        if (string8.indexOf("RDFT_ONLY=T") >= 0) {
            sQLGenContext.rdfTermsOnly = true;
        }
        if (string8.indexOf("PLUS_RDFT=T") >= 0) {
            sQLGenContext.plusRDFTerms = true;
        }
        if (string8.indexOf("RDFT_ONLY=VC") >= 0) {
            sQLGenContext.rdfTermsOnly = true;
            sQLGenContext.vcTerms = true;
        }
        if (string8.indexOf("PLUS_RDFT=VC") >= 0) {
            sQLGenContext.plusRDFTerms = true;
            sQLGenContext.vcTerms = true;
        }
        if (string8.indexOf("STRICT_OGC=T") >= 0) {
            sQLGenContext.strictOGC = true;
        }
        if (string8.indexOf(string3 = "ALL_USE_RDF_STATS") >= 0) {
            sQLGenContext.allStatsHints = true;
            n3 = string8.indexOf(string3) + string3.length();
            n2 = string8.indexOf("(", n3);
            int n5 = string8.indexOf(")", n2);
            sQLGenContext.allStatsHintsArg = n2 >= 0 && n5 >= 0 && string8.substring(n3, n2).trim().length() == 0 ? string8.substring(n2 + 1, n5) : null;
        }
        if (string8.indexOf("GET_EXACT_VALUES") >= 0) {
            sQLGenContext.useExactValue = true;
        }
        if (string8.indexOf("USE_OLD_HINTS") >= 0) {
            sQLGenContext.useOldHintGenerator = true;
        }
        if (string8.indexOf("OPT_COALESCE=F") >= 0) {
            sQLGenContext.optJoinFlags |= 1;
        }
        if (string8.indexOf("NG_COALESCE=T") < 0) {
            sQLGenContext.ngJoinFlags |= 1;
        }
        if (string8.indexOf("NG_JOIN_OPT=F") >= 0) {
            sQLGenContext.ngJoinFlags |= 2;
        }
        if (string8.indexOf("NG_JOIN_TRANS_OPT=F") >= 0) {
            sQLGenContext.ngJoinFlags |= 4;
        }
        if (string8.indexOf("ALL_LEX_JOIN") >= 0) {
            sQLGenContext.lexJoinFlags |= 1;
        }
        if (string8.indexOf("ALL_REJECT_FILTER") >= 0) {
            sQLGenContext.allRejectFilter = true;
        }
        if (string8.indexOf("USE_RAW_VM=T") >= 0) {
            sQLGenContext.vmExpression = QueryUtils.extractBracketedOption(string8, "VM_EXPR");
        }
        if (string8.indexOf("USE_LOCAL_VALUES=[") >= 0) {
            sQLGenContext.localValues = QueryUtils.extractBracketedOption(string8, "USE_LOCAL_VALUES");
        }
        if (string7 != null && string7.indexOf("__dmpbupsql__") >= 0) {
            sQLGenContext.dmpSQL = true;
        }
        if (string7 != null && string7.indexOf("__dmpsparqlast__") >= 0) {
            sQLGenContext.dmpAST = true;
        }
        if (string7 != null && string7.indexOf("__dmpsparqltree__") >= 0) {
            sQLGenContext.dmpSTree = true;
        }
        if (bl2 || string8.indexOf("STRICT_DEFAULT=T") >= 0) {
            sQLGenContext.allGraphsDefault = false;
        }
        if (string8.indexOf("GRAPH_MATCH_UNNAMED=T") >= 0) {
            sQLGenContext.graphMatchUnnamed = true;
            sQLGenContext.contextFlags |= 4;
        }
        if (string8.indexOf("USE_BIND_VAR=T") >= 0 || string8.indexOf("USE_BIND_VAR=JDBC") >= 0 || string8.indexOf("USE_BIND_VAR=PLSQL") >= 0) {
            sQLGenContext.useBindVars = true;
        }
        if (string8.indexOf("__BIND_VALUES__=[") >= 0 || string8.indexOf("USE_BIND_VAR=PLSQL") >= 0) {
            sQLGenContext.useBindValues = true;
        }
        if (string8.indexOf("DISTANCE_REWRITE=F") >= 0) {
            sQLGenContext.disableDistanceOpt = true;
        }
        if (string8.indexOf("CLOB_STR=T") >= 0) {
            sQLGenContext.useOldOptimizationForSTR = false;
        }
        if (bl || string8.indexOf("PROJ_CANON_VALUES=T") >= 0) {
            sQLGenContext.useExactForExpr = false;
        }
        if (string8.indexOf("ALLOW_PP_DUP=T") >= 0) {
            sQLGenContext.allowPPDup = true;
        }
        if ((n3 = string8.indexOf("ALL_MAX_PP_DEPTH")) >= 0 && (string2 = QueryUtils.extractParenValue(string8, n3, "ALL_MAX_PP_DEPTH")) != null) {
            try {
                sQLGenContext.ppMaxDepth = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                QueryUtils.log("Error setting ppMaxDepth: " + exception.getMessage());
            }
        }
        if (string8.indexOf("ALL_USE_PP_HASH") >= 0) {
            sQLGenContext.ppUseHash = true;
        } else if (string8.indexOf("ALL_USE_PP_NL") >= 0) {
            sQLGenContext.ppUseNL = true;
        }
        if (string8.indexOf("ALL_DISABLE_PP_SJ") >= 0) {
            sQLGenContext.disablePPsj = true;
        }
        if (string8.indexOf("ALL_DISABLE_PP_DIST_SJ") >= 0) {
            sQLGenContext.disablePPsjDist = true;
        }
        if (string8.indexOf("ALL_USE_PP_RW") >= 0) {
            sQLGenContext.ppUseRW = true;
        }
        if (string8.indexOf("ALL_RW_PP_DISTINCT") >= 0) {
            sQLGenContext.ppDistinctRW = true;
        }
        if (string8.indexOf("ALL_USE_PP_BFS") >= 0) {
            sQLGenContext.ppUseBFS = true;
        } else if (string8.indexOf("ALL_USE_PP_DFS") >= 0) {
            sQLGenContext.ppUseDFS = true;
        }
        if (string8.indexOf("DISABLE_SEL_EXPR_NO_MERGE") >= 0) {
            sQLGenContext.disableSelExprNoMerge = true;
        }
        if (string8.indexOf("DISABLE_ALIAS_LEN_OPT") >= 0) {
            sQLGenContext.disableAliasOpt = true;
        }
        if (bl4 || string8.indexOf("CONSTRUCT_UNIQUE=T") >= 0) {
            sQLGenContext.constructUnique = true;
        }
        if (bl3 || string8.indexOf("CONSTRUCT_STRICT=T") >= 0) {
            sQLGenContext.constructStrict = true;
        }
        if (bl5 || string8.indexOf("DISABLE_CONSTRUCT_CONST_PROJ") >= 0) {
            sQLGenContext.constructNoConstProj = true;
        }
        if (string8.indexOf("CONSTRUCT_WIDE_COL=F") >= 0) {
            sQLGenContext.constructNarrowCols = true;
        }
        if (string8.indexOf("DO_UNESCAPE=T") >= 0) {
            sQLGenContext.unescapeResults = true;
        }
        if (string8.indexOf("PG_MATCH=T") >= 0) {
            sQLGenContext.isPGQuery = true;
        }
        if (string8.indexOf("ESCAPE_STR_FUNC=F") >= 0) {
            sQLGenContext.unescapeStrFunc = false;
        }
        if (string8.indexOf("DISABLE_REGEX_UNESC") >= 0) {
            sQLGenContext.unescapeUniRegex = false;
        }
        if (string8.indexOf("DISABLE_VID_LEX_OPT") >= 0) {
            sQLGenContext.disableVidLexOpt = true;
        }
        if (string8.indexOf("DISABLE_ROWNUM_OPT") >= 0) {
            sQLGenContext.disableRowNumOpt = true;
        }
        if (string8.indexOf("DISABLE_RDFT_OPT") >= 0) {
            sQLGenContext.disableClobRDFTOpt = true;
        }
        if (string8.indexOf("DISABLE_INLINE_RDFT") >= 0) {
            sQLGenContext.disableInLineRDFT = true;
        }
        if (string8.indexOf("DISABLE_ORDER_COL") >= 0) {
            sQLGenContext.useOrderCol = false;
        }
        if (string8.indexOf("CLOB_AGG_SUPPORT=T") >= 0) {
            sQLGenContext.clobAggSupport = true;
        }
        if (string8.indexOf("CLOB_EXP_SUPPORT=T") >= 0) {
            sQLGenContext.clobExpSupport = true;
        }
        if (string8.indexOf("FORCE_RDFT_STR_EXPR=T") >= 0) {
            sQLGenContext.rdftStrExp = true;
        }
        if (string8.indexOf("DISABLE_RDFT_STR_EXPR") >= 0) {
            sQLGenContext.noRdftStrExp = true;
        }
        if (string8.indexOf("STRICT_AGG_CARD=T") >= 0) {
            sQLGenContext.strictAggCard = true;
        }
        if (string8.indexOf("VJOIN_AGG_PDWN=T") >= 0) {
            sQLGenContext.aggValPushDown = true;
        }
        if (string8.indexOf("DISABLE_NULL_JOIN") >= 0) {
            sQLGenContext.disableNullJoin = true;
        }
        if (string8.indexOf("DISABLE_NULL_EXPR_JOIN") >= 0) {
            sQLGenContext.disableNullExprJoin = true;
        }
        if (string8.indexOf("DESCRIBE_INCL_NG=T") >= 0) {
            sQLGenContext.describeIncludeNG = true;
            sQLGenContext.allGraphsDefault = false;
        }
        if (string8.indexOf("DISABLE_INLINE_ORDER_BY") >= 0) {
            sQLGenContext.inlineOrderBy = false;
        }
        if (string8.indexOf("DISABLE_INLINE_AGG") >= 0) {
            sQLGenContext.inlineAggregates = false;
        }
        if (string8.indexOf("DISABLE_INLINE_SAMPLE") >= 0) {
            sQLGenContext.inlineSample = false;
        }
        if (string8.indexOf("LEX_VID_HASH=T") >= 0) {
            sQLGenContext.hashVids = true;
        }
        if (string8.indexOf("DISABLE_DISTINCT_PDWN") >= 0) {
            sQLGenContext.distinctPdwn = false;
        }
        if (string8.indexOf("DISABLE_NE_NEGATION") >= 0) {
            sQLGenContext.disableNotExists = true;
        }
        if (string8.indexOf("FORCE_MASK_FOR_NEGATION=T") >= 0) {
            sQLGenContext.forceMaskForNE = true;
        }
        if (string8.indexOf("DISABLE_MASK_FOR_NEGATION") >= 0) {
            sQLGenContext.disableMaskForNE = true;
        }
        if ((n2 = string8.indexOf("NEGATION_MASK_THRESHOLD")) >= 0 && (string = QueryUtils.extractParenValue(string8, n2, "NEGATION_MASK_THRESHOLD")) != null) {
            try {
                sQLGenContext.neMaskThreshold = Integer.parseInt(string);
            }
            catch (Exception exception) {
                QueryUtils.log("Error setting neMaskThreshold: " + exception.getMessage());
            }
        }
        if (string8.indexOf("ALL_AJ_UNNEST") >= 0) {
            sQLGenContext.allUnnest = true;
        }
        if (string8.indexOf("ALL_AJ_NO_UNNEST") >= 0) {
            sQLGenContext.allNest = true;
        }
        if (string8.indexOf("ALL_AJ_HASH") >= 0) {
            sQLGenContext.allHashAj = true;
        }
        if (string8.indexOf("ALL_AJ_NL") >= 0) {
            sQLGenContext.allNlAj = true;
        }
        if (string8.indexOf("ALL_AJ_MERGE") >= 0) {
            sQLGenContext.allMergeAj = true;
        }
        if (string8.indexOf("RDFV_LEX_FOPT=T") >= 0) {
            sQLGenContext.forceRDFVFilterOpt = true;
        }
        if (string8.indexOf("DISABLE_RDFV_LEX_FOPT") >= 0) {
            sQLGenContext.disableRDFVFilterOpt = true;
        }
        if (string8.indexOf("DISABLE_LOCAL_LEX_FOPT") >= 0) {
            sQLGenContext.disableLocalLexFilterOpt = true;
        }
        if (string8.indexOf("EXTENDED_VC=T") >= 0) {
            sQLGenContext.extendedVc = true;
        }
        if (string8.indexOf("EXPR_UNDEF_VAR_CHECK=T") >= 0) {
            sQLGenContext.allowUnDefVarsInExpr = false;
        }
        if (string8.indexOf("INF_ONLY=T") >= 0) {
            sQLGenContext.infOnly = true;
        }
        if (string8.indexOf("AS_OF=[") >= 0) {
            String string9 = QueryUtils.extractBracketedOption(string8, "AS_OF");
            if (string9.substring(0, string9.indexOf(",")).equals("TIMESTAMP")) {
                String string10 = string9.substring(string9.indexOf(",") + 1);
                if (!QueryUtils.isSafeTimestamp(string10)) throw new RDFException("Error setting timestamp:" + string10);
                sQLGenContext.asOfClause = "\nAS OF TIMESTAMP TO_TIMESTAMP('" + string10 + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
            } else if (string9.substring(0, string9.indexOf(",")).equals("SCN")) {
                String string11 = string9.substring(string9.indexOf(",") + 1);
                try {
                    int n6 = Integer.parseInt(string11);
                    sQLGenContext.asOfClause = "\nAS OF SCN " + n6;
                }
                catch (Exception exception) {
                    throw new RDFException("Error setting SCN:" + string11);
                }
            }
        }
        if (string7 != null) {
            if (string7.indexOf("RDB2RDF_SUBJECTMAP_MATCHABILITY=MIN") >= 0) {
                sQLGenContext.r2r_smap_matchability_level = 0;
            } else if (string7.indexOf("RDB2RDF_SUBJECTMAP_MATCHABILITY=CONGRUENT") >= 0) {
                sQLGenContext.r2r_smap_matchability_level = 1;
            } else if (string7.indexOf("RDB2RDF_SUBJECTMAP_MATCHABILITY=SIMILAR") >= 0) {
                sQLGenContext.r2r_smap_matchability_level = 2;
            } else if (string7.indexOf("RDB2RDF_SUBJECTMAP_MATCHABILITY=MAX") >= 0) {
                sQLGenContext.r2r_smap_matchability_level = 99;
            }
        }
        if (string7 != null && string7.indexOf("__r2rlog__") >= 0) {
            sQLGenContext.R2RFlags |= 1L;
        }
        if (string7 != null && string7.indexOf("__r2rlog2__") >= 0) {
            sQLGenContext.R2RFlags |= 2L;
        }
        if (string7 != null && string7.indexOf("__r2rlog4__") >= 0) {
            sQLGenContext.R2RFlags |= 4L;
        }
        if (string7 != null && string7.indexOf("CONFORMANCE=T") >= 0) {
            sQLGenContext.R2RFlags |= 0x10L;
        }
        if (string7 != null && string7.indexOf("BFLOAT_AS_DOUBLE=T") >= 0) {
            sQLGenContext.R2RFlags |= 0x20L;
        }
        if (string7 != null && string7.indexOf("SKIP_BNODE_AUGM=T") >= 0) {
            sQLGenContext.R2RFlags |= 0x40L;
        }
        if (string7 != null && string7.indexOf("SKIP_BNODE_GRAPH_AUGM=T") >= 0) {
            sQLGenContext.R2RFlags |= 0x80L;
        }
        if (string7 != null && string7.indexOf("RDB2RDF_ESCAPE=F") >= 0) {
            sQLGenContext.R2RFlags = sQLGenContext.R2RFlags | 0x100L | 0x200L;
        } else {
            if (string7 != null && string7.indexOf("RDB2RDF_IRI_ESCAPE=F") >= 0) {
                sQLGenContext.R2RFlags |= 0x100L;
            }
            if (string7 != null && string7.indexOf("RDB2RDF_TTL_ESCAPE=F") >= 0) {
                sQLGenContext.R2RFlags |= 0x200L;
            }
        }
        if (string7 != null && string7.indexOf("RDB2RDF_VALUE_COMPONENT=INLINE") >= 0) {
            sQLGenContext.R2RFlags |= 0x400L;
        } else if (string7 != null && string7.indexOf("RDB2RDF_VALUE_COMPONENT=EMBEDDED") >= 0) {
            sQLGenContext.R2RFlags |= 0x800L;
        }
        if (string7 != null && string7.indexOf("RDB2RDF_NATIVE_FILTER=F") >= 0) {
            sQLGenContext.R2RFlags |= 0x1000L;
        }
        if (string7 != null && string7.indexOf("RDB2RDF_NO_MERGE_HINT=F") >= 0) {
            sQLGenContext.R2RFlags |= 0x2000L;
        }
        if (string7 != null && string7.indexOf("RDB2RDF_UNION_ALL_OPT=F") >= 0) {
            sQLGenContext.R2RFlags |= 0x4000L;
        }
        if (string7 != null && string7.indexOf("RDB2RDF_SKIP_SPARQL_2V_FILTER=T") >= 0) {
            sQLGenContext.R2RFlags |= 0x8000L;
        }
        if (string7 != null && string7.indexOf("RDB2RDF_USE_UTL_URL=T") >= 0) {
            sQLGenContext.R2RFlags |= 0x10000L;
        }
        if (string7 == null || string7.indexOf("ESC_SBYTE_OPT=F") < 0) return;
        sQLGenContext.R2RFlags |= 0x20000L;
    }

    protected static void setTripleRowSources(SQLGenContext sQLGenContext, String[] stringArray, String string, long l, String string2, String string3, long[] lArray, long[] lArray2, long[] lArray3, String[] stringArray2, int n) {
        boolean bl;
        boolean bl2;
        String string4 = "G_ID IS NULL ";
        String string5 = "G_ID IS NOT NULL ";
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        String string6 = "";
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        boolean bl6 = false;
        String string7 = QueryUtils.buildInList("G_ID", lArray);
        String string8 = QueryUtils.buildInList("G_ID", lArray2);
        String string9 = " WHERE ";
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray2 != null) {
            arrayList.addAll(Arrays.asList(stringArray2));
        }
        String string10 = QueryUtils.buildInList("MODEL_ID", lArray3);
        boolean bl7 = bl2 = string7.length() > 0 || string10.length() > 0 || sQLGenContext.allUnnamedTrips || sQLGenContext.entUnnamedTrips;
        if (sQLGenContext.infOnly) {
            stringArray = null;
        }
        if (stringArray != null) {
            n2 = stringArray.length;
        }
        if (string != null) {
            ++n2;
        }
        boolean bl8 = bl3 = n2 > 1;
        if (stringArray != null && stringArray.length > 1) {
            bl4 = true;
        }
        if (string != null && !string2.equals("VALID")) {
            bl5 = true;
        }
        boolean bl9 = bl = !bl5 && !bl4;
        if (sQLGenContext.forceDup) {
            bl = true;
            bl4 = false;
            bl5 = false;
        }
        if (bl3 && bl) {
            stringBuffer.append("\nSELECT /*+ INLINE */ * FROM (");
            stringBuffer2.append("\nSELECT * FROM (");
            stringBuffer3.append("\nSELECT * FROM (");
            stringBuffer4.append("\nSELECT * FROM (");
        }
        if (bl4 || bl5) {
            stringBuffer.append("\nSELECT /*+ INLINE */ START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID,").append(" MIN(END_NODE_ID) END_NODE_ID FROM (");
            stringBuffer2.append("\nSELECT START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID,").append(" MIN(END_NODE_ID) END_NODE_ID FROM (");
            stringBuffer3.append("\nSELECT START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID,").append(" MIN(END_NODE_ID) END_NODE_ID, G_ID FROM (");
            stringBuffer4.append("\nSELECT START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID,").append(" MIN(END_NODE_ID) END_NODE_ID, G_ID FROM (");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string9 = " WHERE ";
                if (i > 0) {
                    stringBuffer.append("\nUNION ALL");
                    stringBuffer2.append("\nUNION ALL");
                    stringBuffer3.append("\nUNION ALL");
                    stringBuffer4.append("\nUNION ALL");
                }
                stringBuffer.append("\nSELECT /*+ INLINE */ START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, END_NODE_ID").append(" FROM \"MDSYS\".\"RDFM_" + stringArray[i].toUpperCase() + "\"");
                stringBuffer2.append("\nSELECT * FROM \"MDSYS\".\"RDFM_" + stringArray[i].toUpperCase() + "\"");
                stringBuffer3.append("\nSELECT * FROM \"MDSYS\".\"RDFM_" + stringArray[i].toUpperCase() + "\"");
                stringBuffer4.append("\nSELECT * FROM \"MDSYS\".\"RDFM_" + stringArray[i].toUpperCase() + "\"");
                if (sQLGenContext.asOfClause != null) {
                    stringBuffer3.append(sQLGenContext.asOfClause);
                    stringBuffer4.append(sQLGenContext.asOfClause);
                }
                if (sQLGenContext.policyName.length() > 0 && sQLGenContext.minLabel.length() > 0) {
                    bl6 = true;
                    string9 = " AND ";
                    stringBuffer2.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
                    stringBuffer.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
                    stringBuffer3.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
                    stringBuffer4.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
                }
                if (string7.length() > 0 || arrayList.contains(stringArray[i].toUpperCase()) || sQLGenContext.allUnnamedTrips) {
                    stringBuffer3.append(string9).append(" (");
                    String string11 = "";
                    if (string7.length() > 0) {
                        stringBuffer3.append(string7);
                        string11 = " OR ";
                    }
                    if (sQLGenContext.allUnnamedTrips) {
                        stringBuffer3.append(string11).append(" " + string4);
                    } else if (arrayList.contains(stringArray[i].toUpperCase())) {
                        stringBuffer3.append(string11).append(" " + string4);
                    }
                    stringBuffer3.append(") ");
                } else if (bl2 || string8.length() > 0) {
                    stringBuffer3.append(string9).append("(1=0) ");
                } else if (!sQLGenContext.allGraphsDefault) {
                    stringBuffer3.append(string9).append(" " + string4);
                }
                if (string8.length() > 0) {
                    stringBuffer4.append(string9).append("(").append(string8);
                    if (sQLGenContext.graphMatchUnnamed) {
                        stringBuffer4.append(" OR " + string4);
                    }
                    stringBuffer4.append(")");
                    continue;
                }
                if (!sQLGenContext.nonEmptyNamed && string7.length() > 0) {
                    stringBuffer4.append(string9).append("(1=0) ");
                    continue;
                }
                if (sQLGenContext.graphMatchUnnamed) continue;
                stringBuffer4.append(string9).append(" " + string5);
            }
        }
        if (bl4 && !bl5) {
            stringBuffer.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID");
            stringBuffer2.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID");
            stringBuffer3.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, G_ID");
            stringBuffer4.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, G_ID");
        }
        if (string != null) {
            string9 = " WHERE ";
            if (stringArray != null && stringArray.length > 0) {
                stringBuffer.append("\nUNION ALL");
                stringBuffer2.append("\nUNION ALL");
                stringBuffer3.append("\nUNION ALL");
                stringBuffer4.append("\nUNION ALL");
            }
            stringBuffer.append("\nSELECT /*+ INLINE */ START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, END_NODE_ID").append(" FROM \"MDSYS\".\"RDFI_" + string.toUpperCase() + "\"");
            if (bl4 && !bl5) {
                stringBuffer2.append("\nSELECT /*+ INLINE */ START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, END_NODE_ID").append(" FROM \"MDSYS\".\"RDFI_" + string.toUpperCase() + "\"");
                stringBuffer3.append("\nSELECT /*+ INLINE */ START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, END_NODE_ID, G_ID").append(" FROM \"MDSYS\".\"RDFI_" + string.toUpperCase() + "\"");
                stringBuffer4.append("\nSELECT /*+ INLINE */ START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, END_NODE_ID, G_ID").append(" FROM \"MDSYS\".\"RDFI_" + string.toUpperCase() + "\"");
            } else {
                stringBuffer2.append("\nSELECT * FROM \"MDSYS\".\"RDFI_" + string.toUpperCase() + "\"");
                stringBuffer3.append("\nSELECT * FROM \"MDSYS\".\"RDFI_" + string.toUpperCase() + "\"");
                stringBuffer4.append("\nSELECT * FROM \"MDSYS\".\"RDFI_" + string.toUpperCase() + "\"");
            }
            if (sQLGenContext.policyName.length() > 0 && sQLGenContext.minLabel.length() > 0) {
                string9 = " AND ";
                stringBuffer2.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
                stringBuffer.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
                stringBuffer3.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
                stringBuffer4.append(" WHERE strictly_dominates(char_to_label('").append(sQLGenContext.policyName).append("','").append(sQLGenContext.minLabel).append("'), ctxt1)=0 ");
            }
            if (string7.length() > 0 || sQLGenContext.entUnnamedTrips || sQLGenContext.allUnnamedTrips) {
                stringBuffer3.append(string9).append(" (");
                String string12 = "";
                if (string7.length() > 0) {
                    stringBuffer3.append(string7);
                    string12 = " OR ";
                }
                if (sQLGenContext.allUnnamedTrips) {
                    stringBuffer3.append(string12).append(" " + string4);
                } else if (sQLGenContext.entUnnamedTrips) {
                    stringBuffer3.append(string12).append(" " + string4);
                }
                stringBuffer3.append(") ");
            } else if (bl2 || string8.length() > 0) {
                stringBuffer3.append(string9).append("(1=0) ");
            } else if (!sQLGenContext.allGraphsDefault) {
                stringBuffer3.append(string9).append(" " + string4);
            }
            if (string8.length() > 0) {
                stringBuffer4.append(string9).append("(").append(string8);
                if (sQLGenContext.graphMatchUnnamed) {
                    stringBuffer4.append(" OR " + string4);
                }
                stringBuffer4.append(")");
            } else if (!sQLGenContext.nonEmptyNamed && string7.length() > 0) {
                stringBuffer4.append(string9).append("(1=0) ");
            } else if (!sQLGenContext.graphMatchUnnamed) {
                stringBuffer4.append(string9).append(" " + string5);
            }
        }
        if (bl5) {
            stringBuffer.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID");
            stringBuffer2.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID");
            stringBuffer3.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, G_ID");
            stringBuffer4.append("\n) GROUP BY START_NODE_ID, P_VALUE_ID, CANON_END_NODE_ID, G_ID");
        }
        if (bl3 && bl) {
            stringBuffer.append("\n)");
            stringBuffer2.append("\n)");
            stringBuffer3.append("\n)");
            stringBuffer4.append("\n)");
        }
        if (string3 != null) {
            sQLGenContext.vmViewName = string3;
            sQLGenContext.vmDefault = string3;
            sQLGenContext.vmNamed = string3;
            sQLGenContext.useVM = true;
            string6 = "";
            if (sQLGenContext.vmExpression != null && sQLGenContext.vmExpression.length() > 0) {
                sQLGenContext.vmDefault = sQLGenContext.vmExpression;
                sQLGenContext.vmNamed = sQLGenContext.vmExpression;
            }
            if (sQLGenContext.entUnnamedTrips) {
                long[] lArray4 = new long[lArray3.length + 1];
                System.arraycopy(lArray3, 0, lArray4, 0, lArray3.length);
                lArray4[lArray3.length] = l;
                string10 = QueryUtils.buildInList("MODEL_ID", lArray4);
            }
            if (sQLGenContext.asOfClause != null) {
                sQLGenContext.vmDefault = sQLGenContext.vmDefault + sQLGenContext.asOfClause;
                sQLGenContext.vmNamed = sQLGenContext.vmNamed + sQLGenContext.asOfClause;
            }
            if (string7.length() > 0 || string10.length() > 0 || sQLGenContext.allUnnamedTrips) {
                sQLGenContext.vmDefault = " SELECT * FROM " + sQLGenContext.vmDefault + " WHERE ";
                String string13 = "";
                if (string7.length() > 0) {
                    sQLGenContext.vmDefault = sQLGenContext.vmDefault + string7;
                    string13 = " OR ";
                }
                if (sQLGenContext.allUnnamedTrips) {
                    sQLGenContext.vmDefault = sQLGenContext.vmDefault + string13 + string4;
                } else if (string10.length() > 0) {
                    sQLGenContext.vmDefault = sQLGenContext.vmDefault + string13 + "(" + string10 + " AND " + string4 + ")";
                }
            } else if (bl2 || string8.length() > 0) {
                sQLGenContext.vmDefault = " SELECT * FROM " + sQLGenContext.vmDefault + " WHERE (1=0) ";
            } else if (!sQLGenContext.allGraphsDefault) {
                sQLGenContext.vmDefault = " SELECT * FROM " + sQLGenContext.vmDefault + " WHERE " + string4;
            }
            if (string8.length() > 0) {
                sQLGenContext.vmNamed = " SELECT * FROM " + sQLGenContext.vmNamed + " WHERE (" + string8;
                string6 = " SELECT G_ID FROM ( SELECT DISTINCT G_ID FROM " + sQLGenContext.vmViewName + ")" + " WHERE (" + string8;
                if (sQLGenContext.graphMatchUnnamed) {
                    sQLGenContext.vmNamed = sQLGenContext.vmNamed + " OR " + string4;
                    string6 = string6 + " OR " + string4;
                }
                sQLGenContext.vmNamed = sQLGenContext.vmNamed + ")";
                string6 = string6 + ")";
            } else if (!sQLGenContext.nonEmptyNamed && string7.length() > 0) {
                sQLGenContext.vmNamed = " SELECT * FROM " + sQLGenContext.vmNamed + " WHERE (1=0) ";
                string6 = " SELECT G_ID FROM ( SELECT DISTINCT G_ID FROM " + sQLGenContext.vmViewName + ")" + " WHERE (1=0)";
            } else {
                sQLGenContext.vmNamed = " SELECT * FROM " + sQLGenContext.vmNamed;
                string6 = " SELECT G_ID FROM ( SELECT DISTINCT G_ID FROM " + sQLGenContext.vmViewName + ")";
                if (!sQLGenContext.graphMatchUnnamed && (n & 0x80) == 0) {
                    sQLGenContext.vmNamed = sQLGenContext.vmNamed + " WHERE " + string5;
                    string6 = string6 + " WHERE " + string5;
                }
            }
        }
        if (string6 != null && string6.length() > 0) {
            sQLGenContext.optDistinctGQuery = string6;
        }
        sQLGenContext.basicTriples = "(" + stringBuffer2.toString() + ")";
        sQLGenContext.basicTriplesWith = stringBuffer.toString();
        sQLGenContext.defaultGraph = stringBuffer3.toString();
        sQLGenContext.namedGraphs = stringBuffer4.toString();
    }

    protected static void buildDefaultBGPHint(SQLGenContext sQLGenContext) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (sQLGenContext.allBgpNL) {
            stringBuffer.append(" " + Hint.JoinHint.USE_NL.getName());
        } else if (sQLGenContext.allSwap) {
            stringBuffer.append(" " + Hint.JoinHint.SWAP_JOIN_INPUTS.getName());
        } else if (sQLGenContext.allBgpHash) {
            stringBuffer.append(" " + Hint.JoinHint.USE_HASH.getName());
        }
        if (sQLGenContext.allNoMerge) {
            stringBuffer.append(" " + Hint.JoinHint.NO_MERGE.getName());
        }
        if (sQLGenContext.allPullBgp) {
            stringBuffer.append(" " + Hint.QueryOption.BGP_PUSH_DOWN.getName());
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "BGP_JOIN( ");
            stringBuffer.append(" )");
        }
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (sQLGenContext.allUnnest) {
            stringBuffer2.append(" " + Hint.AntiJoinHint.UNNEST.getName());
        } else if (sQLGenContext.allNest) {
            stringBuffer2.append(" " + Hint.AntiJoinHint.NO_UNNEST.getName());
        } else if (sQLGenContext.allHashAj) {
            stringBuffer2.append(" " + Hint.AntiJoinHint.HASH_AJ.getName());
        } else if (sQLGenContext.allNlAj) {
            stringBuffer2.append(" " + Hint.AntiJoinHint.NL_AJ.getName());
        } else if (sQLGenContext.allMergeAj) {
            stringBuffer2.append(" " + Hint.AntiJoinHint.MERGE_AJ.getName());
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer2.insert(0, "ANTI_JOIN( ");
            stringBuffer2.append(" )");
            stringBuffer.append(" " + stringBuffer2.toString());
        }
        if (sQLGenContext.allLinkNL) {
            stringBuffer.append(" " + Hint.QueryOption.ALL_LINK_NL.getName());
        } else if (sQLGenContext.allLinkHash) {
            stringBuffer.append(" " + Hint.QueryOption.ALL_LINK_HASH.getName());
        }
        if (sQLGenContext.allLinkNoIndex) {
            stringBuffer.append(" " + Hint.QueryOption.NO_LINK_INDEX.getName());
        }
        if (sQLGenContext.allNLValueHash) {
            stringBuffer.append(" " + Hint.QueryOption.ALL_NONLOCAL_VALUE_HASH.getName());
        } else if (sQLGenContext.allNLValueNL) {
            stringBuffer.append(" " + Hint.QueryOption.ALL_NONLOCAL_VALUE_NL.getName());
        }
        if (sQLGenContext.allValueNoMerge) {
            stringBuffer.append(" " + Hint.QueryOption.ALL_NONLOCAL_VALUE_NO_MERGE.getName());
        }
        if (sQLGenContext.allNLValueNoIndex) {
            stringBuffer.append(" " + Hint.QueryOption.NO_NL_VALUE_INDEX.getName());
        }
        if (sQLGenContext.allLValueHash) {
            stringBuffer.append(" " + Hint.QueryOption.ALL_LOCAL_VALUE_HASH.getName());
        } else if (sQLGenContext.allLValueNL) {
            stringBuffer.append(" " + Hint.QueryOption.ALL_LOCAL_VALUE_NL.getName());
        }
        if (sQLGenContext.allLValueNoIndex) {
            stringBuffer.append(" " + Hint.QueryOption.NO_VALUE_INDEX.getName());
        }
        stringBuffer.append(" " + Hint.QueryOption.MAX_PP_DEPTH.getName() + "(" + sQLGenContext.ppMaxDepth + ")");
        if (sQLGenContext.ppUseHash) {
            stringBuffer.append(" " + Hint.QueryOption.USE_PP_HASH.getName());
        } else if (sQLGenContext.ppUseNL) {
            stringBuffer.append(" " + Hint.QueryOption.USE_PP_NL.getName());
        }
        if (sQLGenContext.disablePPsj) {
            stringBuffer.append(" " + Hint.QueryOption.DISABLE_PP_SJ.getName());
        }
        if (sQLGenContext.disablePPsjDist) {
            stringBuffer.append(" " + Hint.QueryOption.DISABLE_PP_SJ_DIST.getName());
        }
        if (sQLGenContext.ppUseRW) {
            stringBuffer.append(" " + Hint.QueryOption.USE_PP_RW.getName());
        }
        if (sQLGenContext.ppDistinctRW) {
            stringBuffer.append(" " + Hint.QueryOption.RW_PP_DISTINCT.getName());
        }
        if (sQLGenContext.ppUseBFS) {
            stringBuffer.append(" " + Hint.QueryOption.USE_PP_BFS.getName());
        }
        if (sQLGenContext.ppUseDFS) {
            stringBuffer.append(" " + Hint.QueryOption.USE_PP_DFS.getName());
        }
        if (sQLGenContext.allMaterialize) {
            stringBuffer.append(" MATERIALIZE");
        }
        if (sQLGenContext.allOrdered) {
            stringBuffer.append(" ORDERED");
        }
        if (sQLGenContext.allStatsHints) {
            if (sQLGenContext.allStatsHintsArg != null && sQLGenContext.allStatsHintsArg.length() > 0) {
                stringBuffer.append(" " + String.format("%s(%s)", "USE_RDF_STATS", sQLGenContext.allStatsHintsArg));
            } else {
                stringBuffer.append(" USE_RDF_STATS");
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "HINT0={ ");
            stringBuffer.append(" }");
        }
        sQLGenContext.defaultBGPHint = stringBuffer.toString();
    }

    protected static Connection getConnection() throws SQLException {
        if (sConn == null) {
            sConn = DriverManager.getConnection("jdbc:oracle:kprb:");
        }
        return sConn;
    }

    protected static boolean getIsMigrated() throws SQLException {
        if (isMigrated == null) {
            isMigrated = "YES";
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            try {
                Connection connection = SPARQLEngine.getConnection();
                preparedStatement = connection.prepareStatement("SELECT count(*) FROM MDSYS.RDF_PARAMETER WHERE namespace = 'MDSYS'   AND attribute = 'RDF_VALUE$'   AND value     = 'INVALID_ORDER_COLUMNS' ");
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next() && resultSet.getInt(1) > 0) {
                    isMigrated = "NO";
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        return isMigrated == "YES";
    }

    private static void setNetworkSpatialInfo(SQLGenContext sQLGenContext, Node node) throws RDFException, SQLException {
        if (SPARQLEngine.isSpatialQuery(node)) {
            long[] lArray = new long[2];
            String[] stringArray = new String[3];
            SPARQLEngine.getNetworkSpatialInfo(lArray, stringArray);
            sQLGenContext.matSpaIdx = lArray[0] == 1L;
            sQLGenContext.srid = lArray[1];
            sQLGenContext.geoColumn = stringArray[0];
            sQLGenContext.geoTolerance = stringArray[1];
            sQLGenContext.geoDimension = stringArray[2];
        }
    }

    private static boolean isSpatialQuery(Node node) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("http://www.opengis.net/def/function/geosparql/");
        hashSet.add("http://www.opengis.net/def/function/geosparql/relate");
        hashSet.add("http://www.opengis.net/def/function/geosparql/distance");
        hashSet.add("http://www.opengis.net/def/function/geosparql/buffer");
        hashSet.add("http://www.opengis.net/def/function/geosparql/envelope");
        hashSet.add("http://www.opengis.net/def/function/geosparql/convexHull");
        hashSet.add("http://www.opengis.net/def/function/geosparql/intersection");
        hashSet.add("http://www.opengis.net/def/function/geosparql/union");
        hashSet.add("http://www.opengis.net/def/function/geosparql/difference");
        hashSet.add("http://www.opengis.net/def/function/geosparql/symDifference");
        hashSet.add("http://www.opengis.net/def/function/geosparql/getSRID");
        hashSet.add("http://www.opengis.net/def/function/geosparql/boundary");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfEquals");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfDisjoint");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfIntersects");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfTouches");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfCrosses");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfWithin");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfContains");
        hashSet.add("http://www.opengis.net/def/function/geosparql/sfOverlaps");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/withinDistance");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/idxWithinDistance");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/funcWithinDistance");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/relate");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/idxRelate");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/funcRelate");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/nearestNeighbor");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/area");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/centroid");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/length");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/maxMbrOrdinate");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/minMbrOrdinate");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/distance");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/buffer");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/convexHull");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/intersection");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/union");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/difference");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/xor");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/mbr");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/sdoJoin");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/sdoDistJoin");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/getSRID");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/aggrCentroid");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/aggrConcatLines");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/aggrConvexhull");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/aggrMBR");
        hashSet.add("http://xmlns.oracle.com/rdf/geo/aggrUnion");
        Stack<Node> stack = new Stack<Node>();
        stack.push(node);
        while (!stack.isEmpty()) {
            SimpleNode simpleNode = (SimpleNode)stack.pop();
            if ((simpleNode.id == 58 || simpleNode.id == 90) && simpleNode.jjtGetNumChildren() > 0 && ((SimpleNode)simpleNode.jjtGetChild((int)0)).id == 73) {
                ASTTripleAtom aSTTripleAtom = (ASTTripleAtom)simpleNode.jjtGetChild(0);
                if (hashSet.contains(aSTTripleAtom.name)) {
                    return true;
                }
            }
            for (int i = 0; i < simpleNode.jjtGetNumChildren(); ++i) {
                stack.push(simpleNode.jjtGetChild(i));
            }
        }
        return false;
    }

    private static void getNetworkSpatialInfo(long[] lArray, String[] stringArray) throws RDFException, SQLException {
        String string;
        PreparedStatement preparedStatement;
        ResultSet resultSet;
        Connection connection;
        block19: {
            connection = SPARQLEngine.getConnection();
            resultSet = null;
            preparedStatement = null;
            long l = -1L;
            string = "SELECT /*+ dynamic_sampling(0) result_cache */  md.srid as srid, md.column_name as col FROM   all_sdo_geom_metadata md WHERE  md.owner ='MDSYS' AND        md.table_name='RDF_VALUE$' AND        (md.column_name = ? OR         md.column_name like ?)";
            try {
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setString(1, "GEOM");
                preparedStatement.setString(2, "MDSYS.SDO_RDF.GETV$GEOMETRYVAL(VALUE_TYPE,VNAME_PREFIX,VNAME_SUFFIX,LITERAL_TYPE,LANGUAGE_TYPE,LONG_VALUE,%");
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    lArray[1] = resultSet.getLong(1);
                    stringArray[0] = resultSet.getString(2);
                    lArray[0] = stringArray[0].equals("GEOM") ? 1L : 0L;
                    break block19;
                }
                throw new RDFException(NO_SRID_MSG);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RDFException(NO_SRID_MSG);
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        resultSet = null;
        preparedStatement = null;
        string = "select /*+ dynamic_sampling(0) result_cache */  'sdo_dim_element('''||  d.sdo_dimname ||''',''' ||  d.sdo_lb || ''',''' ||  d.sdo_ub || ''',''' ||  d.sdo_tolerance ||''')' as dim,  d.sdo_tolerance as tol from table  (SELECT md.diminfo   FROM all_sdo_geom_metadata md   WHERE md.owner ='MDSYS'   AND   md.table_name='RDF_VALUE$'   AND   md.column_name = ?) d";
        try {
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, stringArray[0]);
            resultSet = preparedStatement.executeQuery();
            StringBuffer stringBuffer = new StringBuffer("sdo_dim_array(");
            boolean bl = true;
            while (resultSet.next()) {
                if (!bl) {
                    stringBuffer.append(",");
                } else {
                    stringArray[1] = resultSet.getString(2);
                }
                stringBuffer.append(resultSet.getString(1));
                bl = false;
            }
            if (bl) {
                throw new RDFException(NO_DIM_MSG);
            }
            stringBuffer.append(")");
            stringArray[2] = stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RDFException(NO_DIM_MSG);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }
}

