/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class VariableSet
implements Cloneable {
    public static final int NUMCOLS = 5;
    public static final int NUMLITCOLS = 8;
    protected HashMap set = new HashMap();
    protected HashSet maybeLiteral = new HashSet();
    protected HashMap exactSet = new HashMap();
    protected Vector indexedNames = new Vector();
    protected HashMap projNamesAliases = new HashMap();
    protected HashSet alwaysCanonNames = new HashSet();
    protected HashSet funcExactNames = new HashSet();
    protected HashMap equalColGroups = new HashMap();
    protected Map<String, Integer> colIdxMap = new HashMap<String, Integer>();
    protected int totalNumCols;
    private static final boolean DEBUG = false;

    private static void log(String string) {
        System.out.print("\n");
        System.out.print(string);
    }

    public void clear() {
        this.set.clear();
        this.maybeLiteral.clear();
        this.exactSet.clear();
        this.indexedNames.clear();
        this.projNamesAliases.clear();
        this.alwaysCanonNames.clear();
        this.funcExactNames.clear();
        this.equalColGroups.clear();
        this.colIdxMap.clear();
    }

    public void putVariable(String string, boolean bl) {
        if (!this.set.containsKey(string)) {
            this.set.put(string, null);
            this.indexedNames.add(string);
            if (!bl) {
                this.maybeLiteral.add(string);
            }
        } else if (bl) {
            this.maybeLiteral.remove(string);
        }
    }

    public void addMapping(String string, String string2) {
        this.set.put(string, string2);
    }

    public void addExactMapping(String string, String string2) {
        this.exactSet.put(string, string2);
    }

    public void addProjection(String string, String string2) {
        this.projNamesAliases.put(string, string2);
    }

    public void buildColIdxMap() {
        Iterator iterator = this.indexedNames.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.colIdxMap.put(string, new Integer(n));
            n += 8;
        }
        this.totalNumCols = n - 1;
    }

    public int getStartColPos(String string) {
        return this.colIdxMap.get(string);
    }

    public int getTotalNumCols() {
        return this.totalNumCols;
    }

    public List<Integer> getValueIdPositions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n : this.colIdxMap.values()) {
            arrayList.add(new Integer(n + 1));
        }
        return arrayList;
    }

    public int size() {
        return this.set.size();
    }

    public String getMappingByName(String string) {
        return (String)this.set.get(string);
    }

    public String getExactMappingByName(String string) {
        return (String)this.exactSet.get(string);
    }

    public String getProjectionByName(String string) {
        return (String)this.projNamesAliases.get(string);
    }

    public String getMappingByIndex(int n) {
        return (String)this.set.get(this.indexedNames.elementAt(n));
    }

    public String getExactMappingByIndex(int n) {
        return (String)this.exactSet.get(this.indexedNames.elementAt(n));
    }

    public String getProjectionByIndex(int n) {
        return (String)this.projNamesAliases.get(this.indexedNames.elementAt(n));
    }

    public String getNameByIndex(int n) {
        return (String)this.indexedNames.elementAt(n);
    }

    public boolean getMaybeLiteralByIndex(int n) {
        return this.maybeLiteral.contains(this.indexedNames.elementAt(n));
    }

    public boolean getMaybeLiteralByName(String string) {
        return this.maybeLiteral.contains(string);
    }

    public boolean getAlwaysCanonNamesByIndex(int n) {
        return this.alwaysCanonNames.contains(this.indexedNames.elementAt(n));
    }

    public boolean getAlwaysCanonNamesByName(String string) {
        return this.alwaysCanonNames.contains(string);
    }

    public boolean getFuncExactNamesByIndex(int n) {
        return this.funcExactNames.contains(this.indexedNames.elementAt(n));
    }

    public boolean getFuncExactNamesByName(String string) {
        return this.funcExactNames.contains(string);
    }

    public void addtoColGroup(String string, String string2) {
        if (this.equalColGroups.get(string) == null) {
            this.equalColGroups.put(string, " " + string2 + " ");
        } else {
            this.equalColGroups.put(string, (String)this.equalColGroups.get(string) + string2 + " ");
        }
    }

    public String getColGroupByName(String string) {
        return (String)this.equalColGroups.get(string);
    }

    public void dumpColGroups() {
        int n = 0;
        for (String string : this.equalColGroups.keySet()) {
            VariableSet.log("Var#" + n + ": " + string + "=>" + (String)this.equalColGroups.get(string) + "\n");
            ++n;
        }
    }

    public String[] returnSignature() throws SQLException {
        int n = 16 * this.set.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        for (int i = 0; i < this.set.size(); ++i) {
            stringArray[n2++] = "VC";
            stringArray[n2++] = this.getNameByIndex(i);
            stringArray[n2++] = "NU";
            stringArray[n2++] = this.getNameByIndex(i) + "$RDFVID";
            stringArray[n2++] = "VC";
            stringArray[n2++] = this.getNameByIndex(i) + "$_PREFIX";
            stringArray[n2++] = "VC";
            stringArray[n2++] = this.getNameByIndex(i) + "$_SUFFIX";
            stringArray[n2++] = "VC3";
            stringArray[n2++] = this.getNameByIndex(i) + "$RDFVTYP";
            stringArray[n2++] = "CL";
            stringArray[n2++] = this.getNameByIndex(i) + "$RDFCLOB";
            stringArray[n2++] = "VC";
            stringArray[n2++] = this.getNameByIndex(i) + "$RDFLTYP";
            stringArray[n2++] = "VC";
            stringArray[n2++] = this.getNameByIndex(i) + "$RDFLANG";
        }
        return stringArray;
    }

    public String toString() {
        String string = "";
        for (String string2 : this.set.keySet()) {
            String string3 = (String)this.set.get(string2);
            string = string + string2 + " -> " + string3 + "\n";
        }
        for (int i = 0; i < this.indexedNames.size(); ++i) {
            string = string + "[" + i + "] = " + this.indexedNames.elementAt(i) + "\n";
        }
        return string;
    }

    public Object clone() throws CloneNotSupportedException {
        VariableSet variableSet = new VariableSet();
        variableSet.set.putAll(this.set);
        variableSet.maybeLiteral.addAll(this.maybeLiteral);
        variableSet.exactSet.putAll(this.exactSet);
        variableSet.indexedNames.addAll(this.indexedNames);
        variableSet.projNamesAliases.putAll(this.projNamesAliases);
        variableSet.alwaysCanonNames.addAll(this.alwaysCanonNames);
        variableSet.funcExactNames.addAll(this.funcExactNames);
        variableSet.equalColGroups.putAll(this.equalColGroups);
        variableSet.colIdxMap.putAll(this.colIdxMap);
        variableSet.totalNumCols = this.totalNumCols;
        return variableSet;
    }
}

