/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server.parser.ttl;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import oracle.spatial.rdf.server.SQLEntryPoints;
import oracle.spatial.rdf.server.parser.sparql.SPARQLBasePrefix;
import oracle.spatial.rdf.server.parser.ttl.ParseException;
import oracle.spatial.rdf.server.parser.ttl.QuadHandler;
import oracle.spatial.rdf.server.parser.ttl.SimpleCharStream;
import oracle.spatial.rdf.server.parser.ttl.Token;
import oracle.spatial.rdf.server.parser.ttl.TtlParserConstants;
import oracle.spatial.rdf.server.parser.ttl.TtlParserTokenManager;

public class TtlParser
implements TtlParserConstants {
    QuadHandler qh;
    public boolean baseURISet = false;
    public SPARQLBasePrefix baseURI = new SPARQLBasePrefix();
    HashMap<String, String> nspMap;
    public TtlParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[30];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public void parse(QuadHandler quadHandler) throws ParseException {
        this.qh = quadHandler;
        try {
            this.nspMap = SQLEntryPoints.setupNamespaceMap(null);
        }
        catch (Exception exception) {
            throw new ParseException("Error setting default namespaces:" + exception.getMessage());
        }
        this.Input();
    }

    private void setBaseURI(String string) throws ParseException {
        this.baseURI.setBaseURI(string);
        this.baseURISet = true;
    }

    private String expandURIwBase(String string) {
        if (this.baseURISet) {
            string = this.baseURI.getExtendedURI(string);
        }
        return string;
    }

    private String escapeQtAndTab(String string, boolean bl, boolean bl2) {
        if (!(string.contains("\t") || bl && string.contains("'") || bl2 && string.contains("\""))) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\\') {
                stringBuffer.append(cArray[i]);
                if (i >= cArray.length - 1 || cArray[i + 1] != '\'' && cArray[i + 1] != '\\' && cArray[i + 1] != '\"') continue;
                stringBuffer.append(cArray[i + 1]);
                ++i;
                continue;
            }
            if (cArray[i] == '\t') {
                stringBuffer.append('\\').append('t');
                continue;
            }
            if (bl && cArray[i] == '\'') {
                stringBuffer.append('\\').append('\'');
                continue;
            }
            if (bl2 && cArray[i] == '\"') {
                stringBuffer.append('\\').append('\"');
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    private void updateNspMap(String string, String string2) {
        this.nspMap.put(string, string2);
    }

    public HashMap getNspMap() {
        return this.nspMap;
    }

    private static String escapeUnicode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        char c = ' ';
        String string2 = "";
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            c = string.charAt(i);
            if (c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            if (c < '\u10000') {
                stringBuilder.append("\\u");
                string2 = Integer.toHexString(c).toUpperCase();
                for (n2 = 4 - string2.length(); n2 > 0; --n2) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(string2);
                continue;
            }
            stringBuilder.append("\\U");
            string2 = Integer.toHexString(c).toUpperCase();
            for (n2 = 8 - string2.length(); n2 > 0; --n2) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public final void Input() throws ParseException {
        this.trigDoc();
        this.jj_consume_token(0);
    }

    public final void trigDoc() throws ParseException {
        block8: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 30: 
                    case 41: 
                    case 45: 
                    case 47: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 6: 
                    case 7: 
                    case 11: 
                    case 12: {
                        this.directive();
                        continue block7;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 30: 
                    case 41: 
                    case 45: 
                    case 47: {
                        this.block();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void block() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 30: {
                this.triplesOrGraph();
                break;
            }
            case 41: {
                this.wrappedGraph(null);
                break;
            }
            case 45: 
            case 47: {
                this.triples2();
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                String string = this.labelOrSubject();
                this.wrappedGraph(string);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void triplesOrGraph() throws ParseException {
        String string = this.labelOrSubject();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.wrappedGraph(string);
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                this.predicateObjectList(null, string);
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void triples2() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                String string = this.blankNodePropertyList(null);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.predicateObjectList(null, string);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                    }
                }
                this.jj_consume_token(40);
                break;
            }
            case 47: {
                String string = this.collection(null);
                this.predicateObjectList(null, string);
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void wrappedGraph(String string) throws ParseException {
        this.jj_consume_token(41);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 30: 
            case 45: 
            case 47: {
                this.triplesBlock(string);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(42);
    }

    public final void triplesBlock(String string) throws ParseException {
        this.triples(string);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 30: 
                    case 45: 
                    case 47: {
                        this.triplesBlock(string);
                        break block0;
                    }
                }
                this.jj_la1[7] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
    }

    public final String labelOrSubject() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: {
                string = this.iri();
                break;
            }
            case 17: 
            case 30: {
                string = this.BlankNode();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final void directive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 7: {
                this.prefixID();
                break;
            }
            case 6: {
                this.base();
                break;
            }
            case 12: {
                this.sparqlPrefix();
                break;
            }
            case 11: {
                this.sparqlBase();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void prefixID() throws ParseException {
        String string = "";
        String string2 = "";
        this.jj_consume_token(7);
        Token token = this.jj_consume_token(15);
        string2 = this.QuotedURI(true);
        this.jj_consume_token(40);
        if (token.image.length() > 1) {
            string = token.image.substring(0, token.image.length() - 1);
            string = this.escapeQtAndTab(string, true, false);
        }
        this.updateNspMap(string, string2);
    }

    public final void base() throws ParseException {
        this.jj_consume_token(6);
        String string = this.QuotedURI(false);
        this.jj_consume_token(40);
        this.setBaseURI(string);
    }

    public final void sparqlPrefix() throws ParseException {
        String string = "";
        String string2 = "";
        this.jj_consume_token(12);
        Token token = this.jj_consume_token(15);
        string2 = this.QuotedURI(true);
        if (token.image.length() > 1) {
            string = token.image.substring(0, token.image.length() - 1);
            string = this.escapeQtAndTab(string, true, false);
        }
        this.updateNspMap(string, string2);
    }

    public final void sparqlBase() throws ParseException {
        this.jj_consume_token(11);
        String string = this.QuotedURI(false);
        this.setBaseURI(string);
    }

    public final void triples(String string) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 30: 
            case 47: {
                String string2 = this.subject(string);
                this.predicateObjectList(string, string2);
                break;
            }
            case 45: {
                String string3 = this.blankNodePropertyList(string);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 14: 
                    case 15: 
                    case 16: {
                        this.predicateObjectList(string, string3);
                        break block0;
                    }
                }
                this.jj_la1[11] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void predicateObjectList(String string, String string2) throws ParseException {
        String string3 = this.verb();
        this.objectList(string, string2, string3);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(43);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 10: 
                case 14: 
                case 15: 
                case 16: {
                    string3 = this.verb();
                    this.objectList(string, string2, string3);
                    continue block6;
                }
            }
            this.jj_la1[14] = this.jj_gen;
        }
    }

    public final void objectList(String string, String string2, String string3) throws ParseException {
        String string4 = this.object(string);
        this.qh.processQuad(TtlParser.escapeUnicode(string2), TtlParser.escapeUnicode(string3), TtlParser.escapeUnicode(string4), TtlParser.escapeUnicode(string));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 44: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(44);
            string4 = this.object(string);
            this.qh.processQuad(TtlParser.escapeUnicode(string2), TtlParser.escapeUnicode(string3), TtlParser.escapeUnicode(string4), TtlParser.escapeUnicode(string));
        }
    }

    public final String verb() throws ParseException {
        String string;
        Object var1_1 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: {
                string = this.predicate();
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                string = "<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>";
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final String subject(String string) throws ParseException {
        String string2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: {
                string2 = this.iri();
                break;
            }
            case 17: 
            case 30: 
            case 47: {
                string2 = this.blank(string);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string2;
    }

    public final String predicate() throws ParseException {
        String string = this.iri();
        return string;
    }

    public final String object(String string) throws ParseException {
        String string2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 15: 
            case 16: {
                string2 = this.iri();
                break;
            }
            case 17: 
            case 30: 
            case 47: {
                string2 = this.blank(string);
                break;
            }
            case 45: {
                string2 = this.blankNodePropertyList(string);
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string2 = this.literal();
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string2;
    }

    public final String literal() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = this.RDFLiteral();
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                string = this.NumericLiteral();
                break;
            }
            case 8: 
            case 9: {
                string = this.BooleanLiteral();
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string;
    }

    public final String blank(String string) throws ParseException {
        String string2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: 
            case 30: {
                string2 = this.BlankNode();
                break;
            }
            case 47: {
                string2 = this.collection(string);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return string2;
    }

    public final String blankNodePropertyList(String string) throws ParseException {
        String string2 = "_:bn" + UUID.randomUUID().toString();
        this.jj_consume_token(45);
        this.predicateObjectList(string, string2);
        this.jj_consume_token(46);
        return string2;
    }

    public final String collection(String string) throws ParseException {
        String string2;
        String string3 = string2 = "_:bn" + UUID.randomUUID().toString();
        Boolean bl = true;
        this.jj_consume_token(47);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 30: 
                case 45: 
                case 47: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            String string4 = this.object(string);
            if (!bl.booleanValue()) {
                String string5 = "_:bn" + UUID.randomUUID().toString();
                this.qh.processQuad(TtlParser.escapeUnicode(string3), "<http://www.w3.org/1999/02/22-rdf-syntax-ns#rest>", TtlParser.escapeUnicode(string5), TtlParser.escapeUnicode(string));
                this.qh.processQuad(TtlParser.escapeUnicode(string5), "<http://www.w3.org/1999/02/22-rdf-syntax-ns#first>", TtlParser.escapeUnicode(string4), TtlParser.escapeUnicode(string));
                string3 = string5;
            } else {
                this.qh.processQuad(TtlParser.escapeUnicode(string2), "<http://www.w3.org/1999/02/22-rdf-syntax-ns#first>", TtlParser.escapeUnicode(string4), TtlParser.escapeUnicode(string));
                string3 = string2;
            }
            bl = false;
        }
        this.jj_consume_token(48);
        if (!bl.booleanValue()) {
            this.qh.processQuad(TtlParser.escapeUnicode(string3), "<http://www.w3.org/1999/02/22-rdf-syntax-ns#rest>", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#nil>", TtlParser.escapeUnicode(string));
        }
        return string2;
    }

    public final String NumericLiteral() throws ParseException {
        String string;
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                token = this.jj_consume_token(19);
                string = "<http://www.w3.org/2001/XMLSchema#integer>";
                break;
            }
            case 20: {
                token = this.jj_consume_token(20);
                string = "<http://www.w3.org/2001/XMLSchema#decimal>";
                break;
            }
            case 21: {
                token = this.jj_consume_token(21);
                string = "<http://www.w3.org/2001/XMLSchema#double>";
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String string2 = this.escapeQtAndTab(token.image, true, false);
        if (string2.startsWith("0x") || string2.startsWith("0X")) {
            String string3 = string2.substring(2);
            BigInteger bigInteger = new BigInteger(string3, 16);
            string2 = bigInteger.toString();
        }
        return "\"" + string2 + "\"^^" + string;
    }

    public final String RDFLiteral() throws ParseException {
        Token token = null;
        String string = null;
        String string2 = this.String();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 49: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        token = this.jj_consume_token(18);
                        break block0;
                    }
                    case 49: {
                        this.jj_consume_token(49);
                        string = this.iri();
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (token != null && string != null) {
            throw new ParseException("Literal cannot specify both language and type: \"" + string2 + token.image + "^^" + string + "\"");
        }
        string2 = "\"" + string2 + "\"";
        if (token != null) {
            string2 = string2 + token.image;
        }
        if (string != null) {
            string2 = string2 + "^^" + string;
        }
        return string2;
    }

    public final String BooleanLiteral() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                token = this.jj_consume_token(8);
                break;
            }
            case 9: {
                token = this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return "\"" + token.image.toLowerCase() + "\"^^<http://www.w3.org/2001/XMLSchema#boolean>";
    }

    public final String String() throws ParseException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                n = 1;
                bl = true;
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                n = 1;
                bl2 = true;
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                n = 3;
                bl = true;
                bl2 = true;
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                n = 3;
                bl = true;
                bl2 = true;
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String string = this.token.image.substring(n);
        return this.escapeQtAndTab(string.substring(0, string.length() - n), bl, bl2);
    }

    public final String iri() throws ParseException {
        String string;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                string = this.QuotedURI(true);
                break;
            }
            case 15: 
            case 16: {
                string = this.PrefixedName();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return "<" + string + ">";
    }

    public final String PrefixedName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                token = this.jj_consume_token(16);
                break;
            }
            case 15: {
                token = this.jj_consume_token(15);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        int n = token.image.indexOf(":");
        String string = token.image.substring(0, n);
        String string2 = token.image.substring(n + 1);
        string = this.escapeQtAndTab(string, true, false);
        string2 = this.escapeQtAndTab(string2, true, false);
        if (!this.nspMap.containsKey(string)) {
            throw new ParseException("Unknown namespace prefix '" + string + "'");
        }
        String string3 = this.nspMap.get(string) + string2;
        return string3;
    }

    public final String BlankNode() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                token = this.jj_consume_token(17);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String string = token != null ? token.image.toLowerCase() : "_:bn" + UUID.randomUUID().toString();
        return string;
    }

    public final String QuotedURI(boolean bl) throws ParseException {
        Token token = this.jj_consume_token(14);
        String string = token.image.substring(1, token.image.length() - 1);
        string = this.escapeQtAndTab(string, true, false);
        if (bl) {
            string = this.expandURIwBase(string);
        }
        return string;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1074002112, 1074002112, 1073995776, 115712, 115712, 0, 1073987584, 1073987584, 0, 1073987584, 6336, 115712, 1073987584, 0, 115712, 0, 115712, 1073987584, 1203487488, 129499904, 0x40020000, 1203487488, 0x380000, 262144, 262144, 768, 0x7800000, 114688, 98304, 0x40020000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{41472, 41472, 41472, 512, 0, 40960, 40960, 40960, 256, 0, 0, 0, 40960, 2048, 0, 4096, 0, 32768, 40960, 0, 32768, 40960, 0, 131072, 131072, 0, 0, 0, 0, 0};
    }

    public TtlParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public TtlParser(InputStream inputStream, String string) {
        try {
            this.jj_input_stream = new SimpleCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new TtlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public TtlParser(Reader reader) {
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new TtlParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public TtlParser(TtlParserTokenManager ttlParserTokenManager) {
        this.token_source = ttlParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(TtlParserTokenManager ttlParserTokenManager) {
        this.token_source = ttlParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 30; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[50];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 30; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) == 0) continue;
                blArray[32 + n] = true;
            }
        }
        for (n2 = 0; n2 < 50; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        TtlParser.jj_la1_init_0();
        TtlParser.jj_la1_init_1();
    }
}

