/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.rdf.server;

import java.util.ArrayList;
import java.util.Hashtable;
import oracle.spatial.rdf.server.RDFException;
import oracle.spatial.rdf.server.RDFRuntimeException;
import oracle.spatial.rdf.server.parser.sparql.ASTTripleAtom;
import oracle.spatial.rdf.server.parser.sparql.ASTTriplesBlock;
import oracle.spatial.rdf.server.parser.sparql.SimpleNode;
import oracle.spatial.rdf.server.sparqlIdent;
import oracle.spatial.rdf.server.sparqlVPDConstraint;

class sparqlPredicate {
    String pred;
    ArrayList<ArrayList<sparqlIdent>> soVars;
    Hashtable<String, sparqlVPDConstraint> constrApplied;
    String domainType;
    String rangeType;

    sparqlPredicate(String string) {
        this.pred = string;
        this.soVars = new ArrayList();
        this.constrApplied = new Hashtable();
        this.domainType = null;
        this.rangeType = null;
    }

    String getIdentifier() {
        return this.pred;
    }

    void addSubjectObjects(sparqlIdent sparqlIdent2, sparqlIdent sparqlIdent3, int n) {
        ArrayList<sparqlIdent> arrayList = null;
        if (this.soVars.size() > n) {
            arrayList = this.soVars.get(n);
        } else {
            this.soVars.ensureCapacity(n + 1);
            for (int i = n + 1 - this.soVars.size(); i > 0; --i) {
                this.soVars.add(null);
            }
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(sparqlIdent2);
            arrayList.add(sparqlIdent3);
            this.soVars.set(n, arrayList);
        } else {
            arrayList.add(sparqlIdent2);
            arrayList.add(sparqlIdent3);
        }
    }

    void setVPDConstraint(sparqlVPDConstraint sparqlVPDConstraint2) {
        if (sparqlVPDConstraint2.constraintType.equals("C") || !sparqlVPDConstraint2.resourceId.equals(this.pred)) {
            return;
        }
        if (!this.constrApplied.containsKey(sparqlVPDConstraint2.constraintName)) {
            this.constrApplied.put(sparqlVPDConstraint2.constraintName, sparqlVPDConstraint2);
        }
    }

    void setDomainType(String string) {
        this.domainType = string;
    }

    void setRangeType(String string) {
        this.rangeType = string;
    }

    String getDomainType() {
        return this.domainType;
    }

    String getRangeType() {
        return this.rangeType;
    }

    void setRDFTypeForSubject(ArrayList<String> arrayList) throws RDFException {
        for (int i = 0; i < this.soVars.size(); ++i) {
            int n = 0;
            ArrayList<sparqlIdent> arrayList2 = this.soVars.get(i);
            if (arrayList2 == null) continue;
            assert (arrayList2.size() % 2 == 0) : new RDFRuntimeException("[Internal Error VPD] Number of identifiers is not even");
            while (n + 1 < arrayList2.size()) {
                sparqlIdent sparqlIdent2 = arrayList2.get(n + 1);
                if (!sparqlIdent2.hasFlags(2)) {
                    throw new RDFException("URI expected in the object position of the rdf:type triple pattern");
                }
                arrayList2.get(n).setClass(i, sparqlIdent2.getIdentifier());
                arrayList.add(sparqlIdent2.getIdentifier());
                n += 2;
            }
        }
    }

    void collectVariableTypes() {
        boolean bl = this.domainType != null && !this.domainType.equals("-1");
        boolean bl2 = this.rangeType != null && !this.rangeType.equals("-1");
        for (int i = 0; i < this.soVars.size(); ++i) {
            int n = 0;
            ArrayList<sparqlIdent> arrayList = this.soVars.get(i);
            if (arrayList == null) continue;
            assert (arrayList.size() % 2 == 0) : new RDFRuntimeException("[Internal Error VPD] Number of identifiers is not even");
            while (n + 1 < arrayList.size()) {
                if (bl) {
                    arrayList.get(n).setClass(i, this.domainType);
                }
                if (bl2) {
                    arrayList.get(n + 1).setClass(i, this.rangeType);
                }
                n += 2;
            }
        }
    }

    private ASTTripleAtom getTripleAtom(int n, int n2, String string, Hashtable<String, String> hashtable, sparqlIdent sparqlIdent2, sparqlIdent sparqlIdent3) {
        ASTTripleAtom aSTTripleAtom = new ASTTripleAtom(73);
        int n3 = 0;
        aSTTripleAtom.flags = 1;
        if (n2 == 1 && (n & 0x100) > 0 || n2 == 2 && (n & 0x40) > 0 || n2 == 3 && (n & 0x10) > 0) {
            if (string.equals(":1")) {
                n3 = sparqlIdent2.identFlags;
            } else if (string.equals(":2")) {
                n3 = sparqlIdent3.identFlags;
            }
            aSTTripleAtom.type = (n3 & 2) > 0 ? 1 : ((n3 & 4) > 0 ? 1 : ((n3 & 8) > 0 ? 7 : 0));
            if (hashtable.containsKey(string)) {
                aSTTripleAtom.name = hashtable.get(string);
                aSTTripleAtom.flags += 2;
            } else {
                aSTTripleAtom.name = "RDF$VPDPSDO_" + sparqlIdent.glbVarIdx;
                ++sparqlIdent.glbVarIdx;
                hashtable.put(string, aSTTripleAtom.name);
                aSTTripleAtom.flags += 2;
            }
        } else if (n2 == 1 && (n & 0x200) > 0 || n2 == 2 && (n & 0x80) > 0 || n2 == 3 && (n & 0x20) > 0) {
            aSTTripleAtom.type = 7;
            aSTTripleAtom.name = string;
        } else {
            aSTTripleAtom.type = 1;
            aSTTripleAtom.name = string;
        }
        return aSTTripleAtom;
    }

    SimpleNode getConstraintNode(int n) {
        ASTTriplesBlock aSTTriplesBlock = null;
        ASTTriplesBlock aSTTriplesBlock2 = null;
        ArrayList<sparqlIdent> arrayList = null;
        if (this.constrApplied.size() == 0) {
            return null;
        }
        if (this.soVars.size() <= n) {
            return null;
        }
        arrayList = this.soVars.get(n);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        for (sparqlVPDConstraint sparqlVPDConstraint2 : this.constrApplied.values()) {
            block3: for (int i = 0; i < arrayList.size(); i += 2) {
                int n2 = 3;
                sparqlIdent sparqlIdent2 = null;
                sparqlIdent sparqlIdent3 = null;
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                if (arrayList.get(i) != null) {
                    sparqlIdent2 = arrayList.get(i);
                    hashtable.put(":1", arrayList.get(i).getIdentifier());
                }
                if (arrayList.get(i + 1) != null) {
                    sparqlIdent3 = arrayList.get(i + 1);
                    hashtable.put(":2", arrayList.get(i + 1).getIdentifier());
                }
                if (aSTTriplesBlock2 != null) {
                    ASTTriplesBlock aSTTriplesBlock3 = aSTTriplesBlock2;
                    aSTTriplesBlock2 = new ASTTriplesBlock(47);
                    aSTTriplesBlock2.jjtSetParent(aSTTriplesBlock3);
                    aSTTriplesBlock3.jjtAddChild(aSTTriplesBlock2, aSTTriplesBlock3.jjtGetNumChildren());
                } else {
                    aSTTriplesBlock = aSTTriplesBlock2 = new ASTTriplesBlock(47);
                }
                while (n2 < sparqlVPDConstraint2.instrSet.length) {
                    int n3 = 0;
                    try {
                        n3 = Integer.parseInt(sparqlVPDConstraint2.instrSet[n2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new RDFRuntimeException("Invalid instruction [" + n2 + "] [" + n3 + "]");
                    }
                    assert ((n3 & 1) > 0) : new RDFRuntimeException("Invalid instruction [" + n2 + "] [" + n3 + "]");
                    ASTTripleAtom aSTTripleAtom = this.getTripleAtom(n3, 1, sparqlVPDConstraint2.instrSet[n2 + 1], hashtable, sparqlIdent2, sparqlIdent3);
                    aSTTripleAtom.jjtSetParent(aSTTriplesBlock2);
                    aSTTriplesBlock2.jjtAddChild(aSTTripleAtom, 0);
                    aSTTripleAtom = this.getTripleAtom(n3, 2, sparqlVPDConstraint2.instrSet[n2 + 2], hashtable, sparqlIdent2, sparqlIdent3);
                    aSTTripleAtom.jjtSetParent(aSTTriplesBlock2);
                    aSTTriplesBlock2.jjtAddChild(aSTTripleAtom, 1);
                    aSTTripleAtom = this.getTripleAtom(n3, 3, sparqlVPDConstraint2.instrSet[n2 + 3], hashtable, sparqlIdent2, sparqlIdent3);
                    aSTTripleAtom.jjtSetParent(aSTTriplesBlock2);
                    aSTTriplesBlock2.jjtAddChild(aSTTripleAtom, 2);
                    if ((n2 += 4) >= sparqlVPDConstraint2.instrSet.length) continue block3;
                    ASTTriplesBlock aSTTriplesBlock4 = aSTTriplesBlock2;
                    aSTTriplesBlock2 = new ASTTriplesBlock(47);
                    aSTTriplesBlock2.jjtSetParent(aSTTriplesBlock4);
                    aSTTriplesBlock4.jjtAddChild(aSTTriplesBlock2, 3);
                }
            }
        }
        return aSTTriplesBlock;
    }

    void append2StringBuffer(StringBuffer stringBuffer, String string) {
        for (int i = 0; i < this.soVars.size(); ++i) {
            int n = 0;
            ArrayList<sparqlIdent> arrayList = this.soVars.get(i);
            if (arrayList == null) continue;
            stringBuffer.append(string + "<graphpattern index=\"" + i + "\"> \n");
            assert (arrayList.size() % 2 == 0) : new RDFRuntimeException("[Internal Error VPD] Number of identifiers is not even");
            while (n + 1 < arrayList.size()) {
                stringBuffer.append(string + "  <reference pos=\"subject\" ident=\"" + arrayList.get(n).getIdentifier() + "\" /> \n");
                stringBuffer.append(string + "  <reference pos=\"object\" ident=\"" + arrayList.get(n + 1).getIdentifier() + "\" /> \n");
                n += 2;
            }
            stringBuffer.append(string + "</graphpattern>\n");
        }
    }
}

