/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import oracle.ide.Version;
import oracle.ide.net.AlikeStrings;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLKey;
import oracle.ide.net.URLTempFile;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.util.Log;
import oracle.javatools.util.Maps;
import oracle.javatools.util.NullArgumentException;

public final class JarIndex {
    private static long TIMESTAMP_INTERVAL = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private static final boolean CACHE_ENABLED = !Boolean.getBoolean("ide.jar.nocache");
    private static final Map<URLKey, JarIndex> _cache = CACHE_ENABLED ? new Maps.CacheMap<URLKey, JarIndex>(Maps.CacheMap.SOFT){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void purgeEntry(Maps.LinkedEntry<URLKey, JarIndex> entry) {
            super.purgeEntry(entry);
            if (URL_ALIASES_ENABLED) {
                Map map = _cache;
                synchronized (map) {
                    URLKey key = (URLKey)entry.getKey();
                    String fileName = URLFileSystem.getFileName(key.toURL());
                    Set keys = (Set)_nameToUrlKeys.get(fileName);
                    if (keys != null) {
                        keys.remove(key);
                        if (keys.isEmpty()) {
                            _nameToUrlKeys.remove(fileName);
                        }
                    }
                }
            }
        }
    } : null;
    private static final Log LOG = new Log("jarindex");
    private static final Set<JarIndex> _openJars = Collections.synchronizedSet(new HashSet());
    private static final long IO_WARNING_THRESHOLD;
    private static final int IO_MOVING_AVERAGE_SIZE = 5;
    private static final EnumSet<TaskOptions> ENTRY_INDEX;
    private static final EnumSet<TaskOptions> JARFILE;
    private final URL _jarFileURL;
    private volatile long _timestamp = -1L;
    private boolean _pathlessFiles;
    private AlikeStrings _entryNamesPool;
    private long _lastTimestampCheck = -1L;
    private int _lockCount = 0;
    private long[] _durations = new long[5];
    private int _nDuration;
    private AtomicBoolean _alreadyWarned = new AtomicBoolean();
    private URLTempFile _tempFile;
    private JarFile _jarFile;
    private String[] _manifestAttributes;
    private final ReadWriteLock _lock;
    private Set<InputStream> _streams = Collections.synchronizedSet(new HashSet());
    private static final boolean URL_ALIASES_ENABLED;
    private static Map<String, Set<URLKey>> _nameToUrlKeys;
    private String lastEntryName;
    private int lastIndex;

    private JarIndex(URL jarFileURL) {
        this._jarFileURL = jarFileURL;
        this._lock = JarUtil.getLock(this._jarFileURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarIndex getInstance(URL jarFileURL) {
        if (!CACHE_ENABLED || !JarUtil.isArchive(jarFileURL.getPath())) {
            return new JarIndex(jarFileURL);
        }
        Map<URLKey, JarIndex> map = _cache;
        synchronized (map) {
            URLKey key = URLKey.getInstance(jarFileURL);
            JarIndex instance = _cache.get(key);
            if (instance != null && instance.checkTimestamp(true)) {
                JarIndex.uncache(jarFileURL);
                instance = null;
            }
            if (instance == null) {
                key = key.intern();
                instance = new JarIndex(key.toURL());
                _cache.put(key, instance);
                if (URL_ALIASES_ENABLED) {
                    String fileName = URLFileSystem.getFileName(jarFileURL);
                    Set<URLKey> keys = _nameToUrlKeys.get(fileName);
                    if (keys == null) {
                        keys = new HashSet<URLKey>(1);
                        _nameToUrlKeys.put(fileName, keys);
                    }
                    keys.add(key);
                }
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uncache(URL jarFileURL) {
        if (!CACHE_ENABLED || jarFileURL == null) {
            return;
        }
        if (!JarUtil.isArchive(jarFileURL.getPath())) {
            return;
        }
        Map<URLKey, JarIndex> map = _cache;
        synchronized (map) {
            JarIndex jarIndex = null;
            if (URL_ALIASES_ENABLED) {
                String fileName = URLFileSystem.getFileName(jarFileURL);
                Set<URLKey> keys = _nameToUrlKeys.remove(fileName);
                if (keys != null) {
                    for (URLKey key : keys) {
                        jarIndex = _cache.remove(key);
                    }
                }
            } else {
                JarIndex jarIndex2 = _cache.remove(URLKey.getInstance(jarFileURL));
            }
        }
    }

    public synchronized boolean lockJarFile() {
        return this._lockCount++ == 0;
    }

    public synchronized void unlockJarFile() {
        assert (this._lockCount > 0);
        --this._lockCount;
    }

    public void visit(final Visitor visitor) throws IOException {
        this.run(JARFILE, new JarIndexJarFileTask<Void>(){

            @Override
            public Void run(JarFile jar) {
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements() && visitor.visit(JarIndex.getJarIndexEntry(entries.nextElement()))) {
                }
                return null;
            }
        });
    }

    public boolean isEmpty() {
        try {
            return this.isEmptyImpl();
        }
        catch (IOException e) {
            return true;
        }
    }

    private boolean isEmptyImpl() throws IOException {
        return this.run(JARFILE, new JarIndexJarFileTask<Boolean>(){

            @Override
            public Boolean run(JarFile jar) throws IOException {
                try {
                    Enumeration<JarEntry> entries = jar.entries();
                    if (entries.hasMoreElements()) {
                        return false;
                    }
                    return true;
                }
                catch (ZipError e) {
                    throw new IOException("ZipError thrown while determining the number of JAR file entries.", e);
                }
            }
        });
    }

    public boolean isEmptyEx() throws IOException {
        return this.isEmptyImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int dirEntryIndex(final String entryName) {
        JarIndex jarIndex = this;
        synchronized (jarIndex) {
            if (entryName.equals(this.lastEntryName)) {
                return this.lastIndex;
            }
        }
        try {
            return this.run(ENTRY_INDEX, new JarIndexJarFileTask<Integer>(){

                @Override
                public Integer run(JarFile jar) throws IOException {
                    JarIndex.this.lastEntryName = entryName;
                    JarIndex.this.lastIndex = JarIndex.this.dirEntryIndexImpl(entryName.endsWith("/") ? entryName : entryName + "/");
                    return JarIndex.this.lastIndex;
                }
            });
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Deprecated
    public int entryIndex(final String entryName) {
        try {
            return this.run(ENTRY_INDEX, new JarIndexJarFileTask<Integer>(){

                @Override
                public Integer run(JarFile jar) throws IOException {
                    if (entryName.endsWith("/")) {
                        return JarIndex.this.dirEntryIndexImpl(entryName);
                    }
                    return JarIndex.this._entryNamesPool.binarySearch(entryName);
                }
            });
        }
        catch (IOException e) {
            return -1;
        }
    }

    @Deprecated
    public static void closeUserJars() {
    }

    @Deprecated
    public static void leaveJarsOpen() {
    }

    @Deprecated
    public int getNumEntries() {
        try {
            return this.run(ENTRY_INDEX, new JarIndexJarFileTask<Integer>(){

                @Override
                public Integer run(JarFile jar) throws IOException {
                    return JarIndex.this._entryNamesPool.size();
                }
            });
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Deprecated
    public JarIndexEntry getEntryAt(final int i) {
        try {
            return this.run(EnumSet.of(TaskOptions.JARFILE, TaskOptions.ENTRY_INDEX), new JarIndexJarFileTask<JarIndexEntry>(){

                @Override
                public JarIndexEntry run(JarFile jar) throws IOException {
                    String name = JarIndex.this._entryNamesPool.getStringFromIndex(i);
                    return JarIndex.getJarIndexEntry(jar.getJarEntry(name));
                }
            });
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Deprecated
    public String getEntryNameAt(final int i) {
        try {
            return this.run(ENTRY_INDEX, new JarIndexJarFileTask<String>(){

                @Override
                public String run(JarFile jar) throws IOException {
                    return JarIndex.this._entryNamesPool.getStringFromIndex(i);
                }
            });
        }
        catch (IOException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public String[] getEntries() {
        try {
            return this.getEntriesImpl();
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    private String[] getEntriesImpl() throws IOException {
        return this.run(ENTRY_INDEX, new JarIndexJarFileTask<String[]>(){

            @Override
            public String[] run(JarFile jar) {
                int numEntries = JarIndex.this._entryNamesPool.size();
                String[] entryArray = new String[numEntries];
                for (int i = 0; i < numEntries; ++i) {
                    entryArray[i] = JarIndex.this._entryNamesPool.getStringFromIndex(i);
                }
                return entryArray;
            }
        });
    }

    public String[] getEntriesEx() throws IOException {
        return this.getEntriesImpl();
    }

    public long getSize(String entryName) {
        try {
            return this.getSizeImpl(entryName);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long getSizeImpl(final String entryName) throws IOException {
        return this.run(JARFILE, new JarIndexJarFileTask<Long>(){

            @Override
            public Long run(JarFile jar) {
                ZipEntry entry;
                if (entryName != null && (entry = jar.getEntry(entryName)) != null) {
                    return entry.getSize();
                }
                return -1L;
            }
        });
    }

    public long getSizeEx(String entryName) throws IOException {
        return this.getSizeImpl(entryName);
    }

    public String[] list(String dirEntryName) {
        try {
            return this.listImpl(dirEntryName);
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    private String[] listImpl(final String dirEntryName) throws IOException {
        return this.run(ENTRY_INDEX, new JarIndexJarFileTask<String[]>(){

            @Override
            public String[] run(JarFile jar) {
                String[] res;
                if (!(dirEntryName.length() <= 0 || (res = JarIndex.this.listImplImpl(dirEntryName.endsWith("/") ? dirEntryName : dirEntryName + "/")).length <= 0 && JarIndex.this._pathlessFiles && dirEntryName.equals("./"))) {
                    return res;
                }
                return JarIndex.this.listImplImpl("");
            }
        });
    }

    public String[] listEx(String dirEntryName) throws IOException {
        return this.listImpl(dirEntryName);
    }

    public InputStream openInputStream(final String entryName) throws IOException {
        if (entryName != null) {
            return this.run(JARFILE, new JarIndexJarFileTask<InputStream>(){

                @Override
                public InputStream run(JarFile jar) throws IOException {
                    if (jar == null) {
                        throw new FileNotFoundException(JarIndex.this.getJarEntryString(entryName));
                    }
                    ZipEntry entry = jar.getEntry(entryName);
                    if (entry == null) {
                        throw new FileNotFoundException(JarIndex.this.getJarEntryString(entryName));
                    }
                    InputStream in = jar.getInputStream(entry);
                    if (in == null) {
                        throw new FileNotFoundException(JarIndex.this.getJarEntryString(entryName));
                    }
                    in = new StreamWrapper(in);
                    JarIndex.this._streams.add(in);
                    return Version.DEBUG_BUILD == 0 ? new JarIndexStream(in) : new DebugJarIndexStream(in, entryName);
                }
            });
        }
        throw new FileNotFoundException(this.getJarEntryString(entryName));
    }

    public boolean exists(String entryName) {
        try {
            return this.existsImpl(entryName);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean existsImpl(final String entryName) throws IOException {
        boolean[] checkedEntryIndex;
        boolean exists;
        block3: {
            exists = false;
            checkedEntryIndex = new boolean[]{false};
            try {
                exists = this.run(EnumSet.noneOf(TaskOptions.class), new JarIndexJarFileTask<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Boolean run(JarFile jar) throws IOException {
                        boolean openedJar;
                        if (JarIndex.this._entryNamesPool != null) {
                            checkedEntryIndex[0] = true;
                            return entryName.endsWith("/") ? JarIndex.this.dirEntryIndexImpl(entryName) >= 0 : JarIndex.this._entryNamesPool.binarySearch(entryName) >= 0;
                        }
                        boolean bl = openedJar = jar == null;
                        if (openedJar) {
                            jar = JarIndex.this.openJarFile();
                        }
                        try {
                            Boolean bl2 = jar.getEntry(entryName) != null;
                            return bl2;
                        }
                        finally {
                            if (openedJar) {
                                JarIndex.this.closeJarFile();
                            }
                        }
                    }
                });
            }
            catch (IOException e) {
                if (!checkedEntryIndex[0] && !exists && entryName.endsWith("/")) break block3;
                throw e;
            }
        }
        if (!checkedEntryIndex[0] && !exists && entryName.endsWith("/")) {
            exists = this.run(ENTRY_INDEX, new JarIndexJarFileTask<Boolean>(){

                @Override
                public Boolean run(JarFile jar) throws IOException {
                    return JarIndex.this.dirEntryIndexImpl(entryName) >= 0;
                }
            });
        }
        return exists;
    }

    public boolean existsEx(String entryName) throws IOException {
        return this.existsImpl(entryName);
    }

    public boolean isDirectory(String entryName) {
        try {
            return this.isDirectoryImpl(entryName);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isDirectoryImpl(final String entryName) throws IOException {
        return this.run(ENTRY_INDEX, new JarIndexJarFileTask<Boolean>(){

            @Override
            public Boolean run(JarFile jar) throws IOException {
                return JarIndex.this.dirEntryIndexImpl(entryName.endsWith("/") ? entryName : entryName + "/") >= 0;
            }
        });
    }

    public boolean isDirectoryEx(String entryName) throws IOException {
        return this.isDirectoryImpl(entryName);
    }

    @Deprecated
    public static void flushCache() {
    }

    public byte[] getBytes(final String entryName) throws IOException {
        if (entryName != null) {
            return this.run(JARFILE, new JarIndexJarFileTask<byte[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public byte[] run(JarFile jar) throws IOException {
                    assert (jar != null);
                    ZipEntry entry = jar.getEntry(entryName);
                    if (entry == null) {
                        return new byte[0];
                    }
                    int entrySize = (int)entry.getSize();
                    if (entrySize == -1) {
                        return new byte[0];
                    }
                    byte[] contentsArray = new byte[entrySize];
                    try (InputStream inputStream = jar.getInputStream(entry);){
                        int length;
                        int totalBytesRead;
                        int bytesRead;
                        for (totalBytesRead = 0; totalBytesRead < entrySize && (bytesRead = inputStream.read(contentsArray, totalBytesRead, length = entrySize - totalBytesRead)) != -1; totalBytesRead += bytesRead) {
                        }
                        LOG.trace("getBytes() read {0} from entry {1}.", totalBytesRead, (Object)entryName);
                        byte[] byArray = contentsArray;
                        return byArray;
                    }
                }
            });
        }
        return new byte[0];
    }

    public long getCompressedSize(String entryName) {
        try {
            return this.getCompressedSizeImpl(entryName);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private long getCompressedSizeImpl(final String entryName) throws IOException {
        return this.run(JARFILE, new JarIndexJarFileTask<Long>(){

            @Override
            public Long run(JarFile jar) {
                if (entryName != null) {
                    assert (jar != null);
                    ZipEntry entry = jar.getEntry(entryName);
                    if (entry == null) {
                        return -1L;
                    }
                    return entry.getCompressedSize();
                }
                return -1L;
            }
        });
    }

    public long getCompressedSizeEx(String entryName) throws IOException {
        return this.getCompressedSizeImpl(entryName);
    }

    public long getTimestamp(String entryName) {
        try {
            return this.getTimestampImpl(entryName);
        }
        catch (IOException e) {
            return this.getTimestamp();
        }
    }

    private long getTimestampImpl(final String entryName) throws IOException {
        return this.run(JARFILE, new JarIndexJarFileTask<Long>(){

            @Override
            public Long run(JarFile jar) {
                if (entryName != null) {
                    assert (jar != null);
                    ZipEntry entry = jar.getEntry(entryName);
                    if (entry == null) {
                        return JarIndex.this.getTimestamp();
                    }
                    return entry.getTime();
                }
                return JarIndex.this.getTimestamp();
            }
        });
    }

    public long getTimestampEx(String entryName) throws IOException {
        return this.getTimestampImpl(entryName);
    }

    public long getTimestamp() {
        long timestamp = this._timestamp;
        return timestamp == -1L ? URLFileSystem.lastModified(this._jarFileURL) : timestamp;
    }

    String getManifestMainAttribute(final boolean getMainClass) throws IOException {
        return this.run(EnumSet.of(TaskOptions.MANIFEST), new JarIndexJarFileTask<String>(){

            @Override
            public String run(JarFile jar) {
                if (JarIndex.this._manifestAttributes != null) {
                    return getMainClass ? JarIndex.this._manifestAttributes[0] : JarIndex.this._manifestAttributes[1];
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        if (CACHE_ENABLED) {
            Map<URLKey, JarIndex> map = _cache;
            synchronized (map) {
                _cache.clear();
                if (URL_ALIASES_ENABLED) {
                    _nameToUrlKeys.clear();
                }
            }
        }
    }

    String canonicalize(String entryName) {
        return entryName;
    }

    private void buildEntryIndex(JarFile jar) throws IOException {
        long startTime = System.nanoTime();
        try {
            Enumeration<JarEntry> entries = jar.entries();
            ArrayList<String> entryNames = new ArrayList<String>(256);
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!this._pathlessFiles && entryName.lastIndexOf("/") < 0) {
                    this._pathlessFiles = true;
                }
                if (entryName.isEmpty()) {
                    Logger.getLogger(JarIndex.class.getName()).warning(String.format("Empty JAR entry name - possible corrupt JAR file at %s", this._jarFileURL));
                }
                entryNames.add(entryName);
            }
            Collections.sort(entryNames);
            this._entryNamesPool = new AlikeStrings(entryNames);
        }
        catch (ZipError e) {
            throw new IOException("ZipError thrown while building the JAR entry index.", e);
        }
        finally {
            PerformanceLogger.get().log("indexjarfile", this._jarFileURL.toString(), System.nanoTime() - startTime);
        }
    }

    private String getJarEntryString(String entryName) {
        return this._jarFileURL.toString() + "!/" + entryName;
    }

    private int dirEntryIndexImpl(String entryName) {
        String nextEntry;
        int index = this._entryNamesPool.binarySearch(entryName);
        if (index >= 0) {
            return index;
        }
        if (this._pathlessFiles && entryName.equals("./")) {
            return 0;
        }
        int insertPoint = -index - 1;
        if (insertPoint < this._entryNamesPool.size() && (nextEntry = this._entryNamesPool.getStringFromIndex(insertPoint)).startsWith(entryName)) {
            return insertPoint;
        }
        return -1;
    }

    private String[] listImplImpl(String dirEntryName) {
        String entryName;
        ArrayList<String> list = new ArrayList<String>();
        int dirLen = dirEntryName.length();
        int n = this._entryNamesPool.size();
        int i = this._entryNamesPool.binarySearch(dirEntryName);
        if (i >= 0) {
            ++i;
        } else if (dirLen > 0) {
            if ((i = -i - 1) >= n) {
                return new String[0];
            }
        } else {
            i = 0;
        }
        while (i < n && (entryName = this._entryNamesPool.getStringFromIndex(i)).startsWith(dirEntryName)) {
            if (entryName.length() != dirLen) {
                String listEntry;
                int endEntry = entryName.indexOf(47, dirLen);
                if (endEntry == 1 && entryName.charAt(0) == '.') {
                    entryName = entryName.substring(2);
                    endEntry = entryName.indexOf(47, dirLen);
                }
                String string = listEntry = endEntry >= dirLen ? entryName.substring(dirLen, endEntry + 1) : entryName.substring(dirLen);
                if (!list.contains(listEntry)) {
                    list.add(listEntry);
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V run(Set<TaskOptions> options, JarIndexJarFileTask<V> task) throws IOException {
        this._lock.readLock();
        try {
            V v = this.runLocked(options, task);
            return v;
        }
        finally {
            this._lock.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <V> V runLocked(Set<TaskOptions> options, JarIndexJarFileTask<V> task) throws IOException {
        JarFile jarFile = null;
        try {
            block10: {
                try {
                    if (this.checkTimestamp(false)) {
                        this._entryNamesPool = null;
                        this._manifestAttributes = null;
                    }
                    if (options.contains((Object)TaskOptions.JARFILE) || options.contains((Object)TaskOptions.ENTRY_INDEX) && this._entryNamesPool == null || options.contains((Object)TaskOptions.MANIFEST) && this._manifestAttributes == null) {
                        jarFile = this.openJarFile();
                        if (options.contains((Object)TaskOptions.ENTRY_INDEX) && this._entryNamesPool == null) {
                            this.buildEntryIndex(jarFile);
                        }
                        if (options.contains((Object)TaskOptions.MANIFEST) && this._manifestAttributes == null) {
                            this.buildManifestCache();
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    this._entryNamesPool = new AlikeStrings(new String[0]);
                    if (jarFile != null) break block10;
                    throw e;
                }
            }
            V v = task.run(jarFile);
            return v;
        }
        finally {
            if (jarFile != null) {
                this.closeJarFile();
            }
        }
    }

    private boolean checkTimestamp(boolean force) {
        if (force || this._timestamp == -1L || System.nanoTime() - this._lastTimestampCheck > TIMESTAMP_INTERVAL) {
            long start = System.nanoTime();
            long timestamp = URLFileSystem.lastModified(this._jarFileURL);
            this._lastTimestampCheck = System.nanoTime();
            this.warnIfSlowIO(this._lastTimestampCheck - start);
            if (timestamp != this._timestamp) {
                this._timestamp = timestamp;
                return true;
            }
        }
        return false;
    }

    private void warnIfSlowIO(long duration) {
        if (!this._alreadyWarned.get()) {
            int localNDuration;
            if ((localNDuration = this._nDuration++) >= 5) {
                this._nDuration = 1;
                localNDuration = 0;
            }
            this._durations[localNDuration] = duration;
            long total = 0L;
            for (int i = 0; i < 5; ++i) {
                total += this._durations[i];
            }
            long average = total / 5L;
            if (average > IO_WARNING_THRESHOLD && this._alreadyWarned.compareAndSet(false, true)) {
                Logger.getLogger(JarIndex.class.getName()).log(Level.WARNING, "SLOW I/O: {0}ms wait at URLFileSystem.lastModified for {1}", new Object[]{TimeUnit.MILLISECONDS.convert(average, TimeUnit.NANOSECONDS), URLFileSystem.getPlatformPathName(this._jarFileURL)});
            }
        }
    }

    private synchronized boolean isLockedOpen() {
        return this._lockCount > 0;
    }

    public static void runWhileClosed(Runnable r) {
        if (r == null) {
            throw new NullArgumentException("null Runnable");
        }
        LOG.trace("runWhileClosed() called.");
        r.run();
    }

    private synchronized JarFile openJarFile() throws FileNotFoundException {
        try {
            if (this._jarFile == null) {
                this._jarFile = this.openJarFileImpl();
            }
            _openJars.add(this);
            ++this._lockCount;
            return this._jarFile;
        }
        catch (Exception e) {
            throw new FileNotFoundException(URLFileSystem.getPlatformPathName(this._jarFileURL));
        }
    }

    private JarFile openJarFileImpl() throws FileNotFoundException, IOException {
        if (this._tempFile == null) {
            this._tempFile = new URLTempFile(JarUtil.getJarFileURL(this._jarFileURL));
        }
        LOG.trace("Opening JAR file at {0}.", (Object)this._jarFileURL);
        File file = this._tempFile.getFile();
        if (file == null) {
            throw new IOException("Unable to download JAR to temp file");
        }
        return new JarFile(file, false);
    }

    private synchronized boolean closeJarFile() {
        assert (this._lockCount > 0);
        if (--this._lockCount == 0 && this._jarFile != null) {
            return this.closeJarFileImpl();
        }
        return false;
    }

    private synchronized boolean closeJarFileImpl() {
        if (!this.isLockedOpen()) {
            try {
                if (this._jarFile != null) {
                    LOG.trace("Closing JAR file: {0}.", (Object)this._jarFile.getName());
                    this._jarFile.close();
                    _openJars.remove(this);
                    this._jarFile = null;
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void buildManifestCache() {
        InputStream manifestIn = null;
        try {
            manifestIn = this.openInputStream("META-INF/MANIFEST.MF");
            Manifest manifest = new Manifest(manifestIn);
            this._manifestAttributes = new String[2];
            this._manifestAttributes[0] = manifest.getMainAttributes().getValue("Main-Class");
            this._manifestAttributes[1] = manifest.getMainAttributes().getValue("Class-Path");
        }
        catch (IOException iOException) {
        }
        finally {
            if (manifestIn != null) {
                try {
                    manifestIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static JarIndexEntry getJarIndexEntry(JarEntry je) {
        return new JarIndexEntry(je.getName(), je.getCompressedSize(), je.getSize(), je.getTime());
    }

    static {
        int threshold = Version.DEBUG_BUILD == 0 ? Integer.MAX_VALUE : 200;
        String text = System.getProperty("ide.jar.threshold");
        if (text != null) {
            try {
                threshold = Integer.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        IO_WARNING_THRESHOLD = TimeUnit.NANOSECONDS.convert(threshold, TimeUnit.MILLISECONDS);
        ENTRY_INDEX = EnumSet.of(TaskOptions.ENTRY_INDEX);
        JARFILE = EnumSet.of(TaskOptions.JARFILE);
        URL_ALIASES_ENABLED = !Boolean.getBoolean("ide.jar.no.url.aliases");
        Map<Object, Object> map = _nameToUrlKeys = URL_ALIASES_ENABLED && CACHE_ENABLED ? new HashMap() : null;
        if (CACHE_ENABLED) {
            URLFileSystem.addURLFileSystemListener(null, new URLFileSystemListener(){

                @Override
                public void notifyEvent(URLFileSystemEvent event) {
                    switch (event.getEventType()) {
                        case 2: 
                        case 3: {
                            JarIndex.uncache(event.getNewURL());
                            break;
                        }
                        case 4: {
                            JarIndex.uncache(event.getOldURL());
                            break;
                        }
                        case 11: 
                        case 12: {
                            JarIndex.clearCache();
                        }
                    }
                }
            });
        }
    }

    private class StreamWrapper
    extends FilterInputStream {
        StreamWrapper(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                JarIndex.this._streams.remove(this);
            }
        }
    }

    private class DebugJarIndexStream
    extends JarIndexStream {
        private Throwable created;

        DebugJarIndexStream(InputStream stream, String entryName) {
            super(stream);
            this.created = new IllegalStateException("InputStream for " + entryName + " not closed for JAR " + URLFileSystem.getPlatformPathName(JarIndex.this._jarFileURL));
        }

        @Override
        protected void finalize() throws IOException {
            if (!this.closed) {
                Logger.getLogger(JarIndex.class.getName()).log(Level.WARNING, "InputStream not closed on JAR file, potential for deadlock", this.created);
            }
            super.close();
        }
    }

    private class JarIndexStream
    extends FilterInputStream {
        protected volatile boolean closed;

        JarIndexStream(InputStream stream) {
            super(stream);
            JarIndex.this._lock.readLock();
            JarIndex.this.lockJarFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                JarIndexStream jarIndexStream = this;
                synchronized (jarIndexStream) {
                    if (!this.closed) {
                        JarIndex.this.closeJarFile();
                        JarIndex.this._lock.readUnlock();
                        this.closed = true;
                    }
                }
            }
        }

        protected void finalize() throws IOException {
            if (!this.closed) {
                this.close();
            }
        }
    }

    private static interface JarIndexJarFileTask<V> {
        public V run(JarFile var1) throws IOException;
    }

    private static enum TaskOptions {
        ENTRY_INDEX,
        JARFILE,
        MANIFEST;

    }

    public static interface Visitor {
        public boolean visit(JarIndexEntry var1);
    }
}

