/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.util.Assert;
import oracle.ide.util.EncodingsData;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.UtilArb;

public final class Encodings {
    public static final String UTF8_ENCODING = "UTF-8";
    private static final String LOADED_KEY = "encodings-loaded";
    private static File _encodingsFile;
    private static String[] _encodings;
    private static String[] _encodingsWithoutAliases;
    private static String _defaultEncoding;
    private static EncodingsData _data;

    private Encodings() {
    }

    public static void setEncodingsFile(File encodingsFile) {
        _encodingsFile = encodingsFile;
    }

    public static boolean isSupported(String encoding) {
        boolean supported = false;
        try {
            supported = Charset.isSupported(encoding);
            if (!supported) {
                String s = new String(new byte[0], encoding);
                supported = true;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return supported;
    }

    public static String getDefaultEncoding() {
        if (_defaultEncoding == null) {
            InputStreamReader isr = new InputStreamReader(System.in);
            _defaultEncoding = isr.getEncoding().intern();
        }
        return _defaultEncoding;
    }

    public static String getDefaultIanaEncoding() {
        if (Encodings.isDefaultCp1252()) {
            return "windows-1252";
        }
        return Encodings.convertJdk2IanaEncoding(Encodings.getDefaultEncoding());
    }

    public static String convertJdk2IanaEncoding(String jdkEncoding) {
        if (jdkEncoding == null) {
            return null;
        }
        EncodingsData data = Encodings.getEncodingsData();
        String ianaName = (String)data.getJdk2IanaMap().get(jdkEncoding.toUpperCase());
        if (ianaName == null) {
            ianaName = jdkEncoding;
            try {
                Charset cs = Charset.forName(jdkEncoding);
                if (cs != null) {
                    ianaName = cs.name();
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return ianaName;
    }

    public static synchronized String[] getEncodings() {
        Encodings.ensureInit();
        return (String[])_encodings.clone();
    }

    public static boolean isDefaultCp1252() {
        return "Cp1252".equalsIgnoreCase(Encodings.getDefaultEncoding());
    }

    public static boolean isComboBoxLoadedWithEncodings(JComboBox comboBox) {
        return Boolean.TRUE.equals(comboBox.getClientProperty(LOADED_KEY));
    }

    public static void initComboBox(final JComboBox comboBox, final String defaultItem, String selectedEncoding) {
        String curEncoding;
        String string = curEncoding = selectedEncoding == null ? Encodings.getDefaultEncoding() : selectedEncoding;
        if (_encodings == null) {
            comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{curEncoding}));
            comboBox.setSelectedItem(curEncoding);
            comboBox.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (!Encodings.isComboBoxLoadedWithEncodings(comboBox)) {
                        comboBox.removeAllItems();
                        comboBox.addItem(UtilArb.getString(0));
                        comboBox.setSelectedIndex(0);
                        comboBox.removePopupMenuListener(this);
                        Encodings.loadEncodingsImpl(comboBox, defaultItem, curEncoding, true);
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        } else {
            Encodings.populateComboBox(comboBox, defaultItem, curEncoding);
        }
    }

    @Deprecated
    public static void initComboBox(JComboBox comboBox, boolean addDefaultItem, String selectedEncoding) {
        String defaultItem = addDefaultItem ? "Default" : null;
        Encodings.initComboBox(comboBox, defaultItem, selectedEncoding);
    }

    @Deprecated
    public static void loadEncodings(JComboBox comboBox, boolean addDefaultItem, String selectedEncoding) {
        String defaultItem = addDefaultItem ? "Default" : null;
        Encodings.loadEncodingsImpl(comboBox, defaultItem, selectedEncoding, false);
    }

    public static void loadEncodings(JComboBox comboBox, String defaultItem, String selectedEncoding) {
        Encodings.loadEncodingsImpl(comboBox, defaultItem, selectedEncoding, false);
    }

    private static void loadEncodingsImpl(final JComboBox comboBox, final String defaultItem, final String selectedEncoding, final boolean showComboPopup) {
        if (comboBox == null) {
            return;
        }
        if (Encodings.isComboBoxLoadedWithEncodings(comboBox)) {
            comboBox.setSelectedItem(selectedEncoding);
            return;
        }
        SwingWorker worker = new SwingWorker(){
            private String[] _encodings;

            @Override
            public Object construct() {
                this._encodings = Encodings.getEncodings();
                return this._encodings;
            }

            @Override
            public void finished() {
                if (this._encodings != null) {
                    Encodings.populateComboBox(comboBox, defaultItem, selectedEncoding);
                    if (showComboPopup) {
                        comboBox.showPopup();
                    }
                }
            }
        };
        worker.start();
    }

    private static void populateComboBox(JComboBox comboBox, String defaultItem, String selectedEncoding) {
        EncodingsComboBoxModel model = new EncodingsComboBoxModel(_encodingsWithoutAliases, defaultItem);
        comboBox.setModel(model);
        comboBox.putClientProperty(LOADED_KEY, Boolean.TRUE);
        int idx = 0;
        idx = selectedEncoding != null ? model.indexOf(selectedEncoding) : (defaultItem != null ? 0 : model.indexOf(Encodings.getDefaultEncoding()));
        comboBox.setSelectedIndex(idx);
    }

    private static synchronized void ensureInit() {
        if (_encodings == null) {
            Assert.startTiming("oracle.ide.util.Encodings.java.ensureInit", null, false);
            SortedMap<String, Charset> encMap = Charset.availableCharsets();
            TreeSet<String> encodings = new TreeSet<String>(new CharsetComparator());
            TreeSet<String> encodingsWithOutAliases = new TreeSet<String>(new CharsetComparator());
            for (Charset ch : encMap.values()) {
                String chName = ch.name();
                if (chName.length() >= "X-ORACLE-".length() && "X-ORACLE-".equalsIgnoreCase(chName.substring(0, "X-ORACLE-".length()))) continue;
                encodings.add(ch.name());
                encodingsWithOutAliases.add(ch.name());
                Set<String> aliases = ch.aliases();
                encodings.addAll(aliases);
            }
            Encodings.normalizeDefaultEncoding(encodings);
            Encodings.normalizeDefaultEncoding(encodingsWithOutAliases);
            Encodings.addXMLEncodings(encodings);
            Encodings.addXMLEncodings(encodingsWithOutAliases);
            _encodings = encodings.toArray(new String[encodings.size()]);
            _encodingsWithoutAliases = encodingsWithOutAliases.toArray(new String[encodingsWithOutAliases.size()]);
            Assert.endTiming("oracle.ide.util.Encodings.java.ensureInit", "Loaded " + Integer.toString(_encodings.length) + " encodings", "   ", false);
        }
    }

    private static void addXMLEncodings(Set encodings) {
        EncodingsData data = Encodings.getEncodingsData();
        for (String key : data.getEncodingsList()) {
            if (encodings.contains(key) || !Encodings.isSupported(key)) continue;
            encodings.add(key);
        }
    }

    private static void normalizeDefaultEncoding(Set encodings) {
        String defaultEncoding = Encodings.getDefaultEncoding();
        if (encodings.contains(defaultEncoding)) {
            encodings.remove(defaultEncoding);
        }
        encodings.add(defaultEncoding);
    }

    private static synchronized EncodingsData getEncodingsData() {
        if (_data == null) {
            if (_encodingsFile != null) {
                try {
                    _data = new EncodingsData(_encodingsFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (_data == null) {
                _data = new EncodingsData();
            }
        }
        return _data;
    }

    private static class EncodingsComboBoxModel
    extends AbstractListModel
    implements MutableComboBoxModel {
        private int _selection;
        private ArrayList _names;
        private Map _nameMap;

        private EncodingsComboBoxModel(String[] _encodings, String defaultItem) {
            this._names = new ArrayList(defaultItem != null ? _encodings.length + 1 : _encodings.length);
            this._nameMap = new HashMap();
            int startPos = 0;
            if (defaultItem != null) {
                this._addElement(defaultItem, startPos++);
            }
            for (int i = 0; i < _encodings.length; ++i) {
                String val = _encodings[i];
                this._addElement(val, startPos++);
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            String val;
            String key;
            int newSel;
            if (anItem != null && (newSel = this._names.indexOf(key = (val = anItem.toString()).toUpperCase())) != this._selection) {
                this._selection = newSel;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.getElementAt(this._selection);
        }

        @Override
        public int getSize() {
            return this._names.size();
        }

        @Override
        public Object getElementAt(int index) {
            if (index == -1) {
                return null;
            }
            String key = this._names.get(index).toString();
            return this._nameMap.get(key);
        }

        private int indexOf(Object enc) {
            if (enc == null) {
                return -1;
            }
            return this._names.indexOf(enc.toString().toUpperCase());
        }

        private void _addElement(String element, int idx) {
            String key = element.toUpperCase();
            this._names.add(idx, key);
            this._nameMap.put(key, element);
        }

        public void addElement(Object obj) {
            this.insertElementAt(obj, this.getSize());
        }

        private void _remove(int idx) {
            if (idx == this._selection) {
                this._selection = idx == 0 ? (this.getSize() == 1 ? -1 : 0) : idx - 1;
                this.fireContentsChanged(this, -1, -1);
            }
            this._names.remove(idx);
            this.fireIntervalRemoved(this, idx, idx);
        }

        @Override
        public void removeElement(Object obj) {
            String val = obj.toString();
            String key = val.toUpperCase();
            if ((val = (String)this._nameMap.get(key)) != null) {
                this._nameMap.remove(key);
                int idx = this._names.indexOf(val);
                this._remove(idx);
            }
        }

        public void insertElementAt(Object obj, int idx) {
            String val = obj.toString();
            if (!this._nameMap.containsKey(val.toUpperCase())) {
                this._addElement(val, idx);
                this.fireIntervalAdded(this, idx, idx);
            }
        }

        @Override
        public void removeElementAt(int index) {
            String val = (String)this._names.get(index);
            String key = val.toUpperCase();
            this._nameMap.remove(key);
            this._remove(index);
        }
    }

    private static class CharsetComparator
    implements Comparator {
        private CharsetComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareToIgnoreCase(s2);
        }
    }
}

