/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerContext;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerLayer5;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.model.FlowAnalysisListener;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceCatchParameter;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceLambdaParameter;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLambdaExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceNewClassExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceWrapperExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatementLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;

public final class CompilerDriver
extends CompilerLayer5 {
    private List<FlowAnalysisListener> flowAnalysisListeners = Collections.emptyList();

    public CompilerDriver(JavaProvider provider, JdkVersion jdkVersion, boolean forgiving, Sym scope) {
        if (provider == null) {
            new RuntimeException().printStackTrace();
        }
        this.setProvider(provider);
        this.jdkVersion = jdkVersion;
        this.flag_forgiving = forgiving;
        if (scope != null) {
            this.compilerContext = new CompilerContext(this, scope);
        }
    }

    public void startFlowAnalysis(List<FlowAnalysisListener> flowAnalysisListeners) {
        if (flowAnalysisListeners != null) {
            this.flowAnalysisListeners = new ArrayList<FlowAnalysisListener>(flowAnalysisListeners);
        }
    }

    public void endFlowAnalysis() {
        for (FlowAnalysisListener listener : this.flowAnalysisListeners) {
            listener.clear();
        }
        this.flowAnalysisListeners = new ArrayList<FlowAnalysisListener>();
    }

    public void startClassFlowAnalysis(SourceClass sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startClass(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endClassFlowAnalysis(SourceClass sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endClass(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startStaticInitializersFlowAnalysis(SourceClass sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startStaticInitializers(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endStaticInitializersFlowAnalysis(SourceClass sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endStaticInitializers(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startInitializerFlowAnalysis(SourceClassInitializer initializer) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startInitializer(initializer)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endInitializerFlowAnalysis(SourceClassInitializer initializer) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endInitializer(initializer)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startConstructorsFlowAnalysis(SourceClass sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startConstructors(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endConstructorsFlowAnalysis(SourceClass sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endConstructors(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startFieldDeclarationFlowAnalysis(SourceFieldDeclaration sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startFieldDeclaration(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endFieldDeclarationFlowAnalysis(SourceFieldDeclaration sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endFieldDeclaration(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startMethodFlowAnalysis(SourceMethod sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startMethod(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endMethodFlowAnalysis(SourceMethod sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endMethod(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startLambdaExpressionFlowAnalysis(SourceLambdaExpression sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startLambdaExpression(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endLambdaExpressionFlowAnalysis(SourceLambdaExpression sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endLambdaExpression(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startBlockFlowAnalysis(SourceBlock sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startBlock(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endBlockFlowAnalysis(SourceBlock sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endBlock(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void declareFieldFlowAnalysis(SourceFieldVariable sym, SourceExpression initializer) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.declareField(sym, initializer)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void declareLocalVariableFlowAnalysis(SourceLocalVariable sym, SourceExpression initializer) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.declareLocalVariable(sym, initializer)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void switchLabelFlowAnalysis(SourceSwitchLabel sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.switchLabel(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void statementLabelFlowAnalysis(SourceStatementLabel sym) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.statementLabel(sym)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void localVariableUsedFlowAnalysis(SourceLocalVariable local, SourceSimpleNameExpression context) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.localVariableUsed(local, context)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void fieldUsedFlowAnalysis(SourceFieldVariable field, SourceExpression context) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.fieldUsed(field, context)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void parameterUsedFlowAnalysis(SourceFormalParameter parameter, SourceSimpleNameExpression context) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.parameterUsed(parameter, context)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void catchParameterUsedFlowAnalysis(SourceCatchParameter parameter, SourceSimpleNameExpression context) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.catchParameterUsed(parameter, context)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void lambdaParameterUsedFlowAnalysis(SourceLambdaParameter parameter, SourceSimpleNameExpression context) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.lambdaParameterUsed(parameter, context)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startStatementFlowAnalysis(SourceStatement statement) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startStatement(statement)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endStatementFlowAnalysis(SourceStatement statement) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endStatement(statement)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void methodCalledFlowAnalysis(SourceMethodCallExpression methodCall) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.methodCalled(methodCall)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void newClassCreationFlowAnalysis(SourceNewClassExpression newClassExpr) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.newClassCreation(newClassExpr)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startIfConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startIfCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endIfConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endIfCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startWhileConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startWhileCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endWhileConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endWhileCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startDoConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startDoCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endDoConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endDoCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startSwitchConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startSwitchCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endSwitchConditionFlowAnalysis(SourceWrapperExpression condition) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endSwitchCondition(condition)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void startSynchronizedExpressionFlowAnalysis(SourceWrapperExpression expression) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.startSynchronizedExpression(expression)) continue;
            iterator.remove();
            listener.clear();
        }
    }

    public void endSynchronizedExpressionFlowAnalysis(SourceWrapperExpression expression) {
        Iterator<FlowAnalysisListener> iterator = this.flowAnalysisListeners.iterator();
        while (iterator.hasNext()) {
            FlowAnalysisListener listener = iterator.next();
            if (listener.endSynchronizedExpression(expression)) continue;
            iterator.remove();
            listener.clear();
        }
    }
}

