/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.internal.compiler.CompilerDriver;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.internal.symbol.FieldDeclSym;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.VariableSym;
import oracle.javatools.parser.java.v2.internal.symbol.doc.DocCommentSym;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;

public class FieldSym
extends VariableSym
implements SourceFieldVariable {
    @Override
    public int getElementKind() {
        return 5;
    }

    @Override
    public boolean isEnumConstant() {
        return false;
    }

    @Override
    public String getDescriptor() {
        return CommonUtilities.getDescriptor(this);
    }

    @Override
    public String getSignature() {
        return CommonUtilities.getSignature(this);
    }

    @Override
    public String getUniqueIdentifier() {
        return CommonUtilities.getUniqueIdentifier(this);
    }

    @Override
    public JavaField getFieldErasure() {
        return this;
    }

    @Override
    public final SourceFieldVariable getSourceElement() {
        if (this.symFile.isLightSourceFile) {
            SourceClass sourceClass;
            JavaClass owningClass = this.getOwningClass();
            if (owningClass != null && (sourceClass = owningClass.getSourceElement()) != null) {
                return (SourceFieldVariable)CommonUtilities.getSourceElement(this, sourceClass);
            }
            return null;
        }
        return this;
    }

    @Override
    public final JavaClass getOwningClass() {
        return this.getOwningClassSym();
    }

    @Override
    public final DocCommentSym getJavadocSym() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            return parent.getJavadocSym();
        }
        return null;
    }

    @Override
    public final void setJavadocSym(DocCommentSym javadoc) {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            if (parent.getVariables().size() > 1) {
                this.separateSelf();
            }
            parent.setJavadocSym(javadoc);
        } else {
            FieldSym.unsupported("Can't set doc comment on an unattached field variable");
        }
    }

    @Override
    public int getModifiers() {
        int superModifiers = super.getModifiers();
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            return parent.getModifiers() | superModifiers;
        }
        return superModifiers;
    }

    @Override
    public final Collection<JavaAnnotation> getDeclaredAnnotations() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            return parent.getDeclaredAnnotations();
        }
        return Collections.emptyList();
    }

    @Override
    public List<SourceAnnotation> getSourceAnnotations() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null) {
            return parent.getSourceAnnotations();
        }
        return new ArrayList<SourceAnnotation>();
    }

    @Override
    public boolean isDeprecated() {
        FieldDeclSym parent = this.getFieldDeclParent();
        if (parent != null && parent.isDeprecated()) {
            return true;
        }
        return super.isDeprecated();
    }

    @Override
    public SourceExpression getInitializer() {
        return this.getExpression();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaField) {
            return CommonUtilities.equals(this, (JavaField)o);
        }
        return false;
    }

    public int hashCode() {
        return CommonUtilities.hashCode(this);
    }

    @Override
    protected boolean isValidAccess(char access) {
        char allowed = FieldSym.getValidFieldAccess(this, this.isFinal());
        return super.isValidAccess((char)(access & ~allowed));
    }

    protected static char getValidFieldAccess(Sym sym, boolean isFinal) {
        char access;
        ClassSym classSym = sym.getOwningClassSym();
        char c = access = classSym != null && classSym.getOwningClassSym() != null && !classSym.isStatic() && !isFinal ? (char)'\u0000' : '\b';
        if (classSym != null && classSym.isInterface()) {
            access = (char)(access | 0x11);
            return access;
        }
        access = (char)(access | 0x10D7);
        return access;
    }

    @Override
    protected JavaElement compileImpl(CompilerDriver compiler) {
        try {
            JavaElement javaElement = super.compileImpl(compiler);
            return javaElement;
        }
        finally {
            if (!compiler.skipCompilations()) {
                compiler.declareFieldFlowAnalysis(this, this.getInitializer());
            }
        }
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    private FieldDeclSym getFieldDeclParent() {
        Sym parent = this.getParentSym();
        if (parent != null && parent.symKind == 9) {
            return (FieldDeclSym)parent;
        }
        return null;
    }
}

