/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.internal.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.javatools.parser.java.v2.internal.format.FormatDriver;
import oracle.javatools.parser.java.v2.internal.symbol.Sym;
import oracle.javatools.parser.java.v2.internal.symbol.TreeSym;
import oracle.javatools.parser.java.v2.model.SourceModuleExports;
import oracle.javatools.parser.java.v2.model.SourceModuleExportsTo;
import oracle.javatools.parser.java.v2.model.SourceName;

public class ModuleExportsSym
extends TreeSym
implements SourceModuleExports {
    public boolean equals(Object o) {
        if (o instanceof ModuleExportsSym) {
            ModuleExportsSym other = (ModuleExportsSym)o;
            if (this.getName().equals(other.getName()) && this.hasSourceModuleExportsTo() == other.hasSourceModuleExportsTo()) {
                if (!this.hasSourceModuleExportsTo()) {
                    return true;
                }
                return this.getSourceModuleExportsTo().equals(other.getSourceModuleExportsTo());
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.getName().hashCode();
        hashCode = 31 * this.getModifiers() + hashCode;
        if (this.hasSourceModuleExportsTo()) {
            hashCode = 31 * hashCode + this.getSourceModuleExportsTo().hashCode();
        }
        return hashCode;
    }

    @Override
    public int getElementKind() {
        return 15;
    }

    @Override
    public String getPackageName() {
        return this.getName();
    }

    @Override
    public void setPackageName(String packageName) {
        this.setName(packageName);
    }

    @Override
    public boolean hasSourceModuleExportsTo() {
        return this.getChild((byte)36) != null;
    }

    @Override
    public SourceModuleExportsTo getSourceModuleExportsTo() {
        return (SourceModuleExportsTo)((Object)this.getChildOrCreateSkeleton((byte)36));
    }

    @Override
    public Collection<String> getModuleNames() {
        if (this.hasSourceModuleExportsTo()) {
            List<SourceName> moduleNames = this.getSourceModuleExportsTo().getSourceModuleNames();
            ArrayList<String> names = new ArrayList<String>(moduleNames.size());
            for (SourceName moduleName : moduleNames) {
                names.add(moduleName.getName());
            }
            return names;
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean isValidChildSymKind(int symKind) {
        if (symKind == 20 || symKind == 36) {
            return true;
        }
        return super.isValidChildSymKind(symKind);
    }

    @Override
    protected int getTargetIndex(Sym sym, byte filter) {
        switch (sym.symKind) {
            case 20: {
                return 0;
            }
            case 36: {
                return this.getChild((byte)20) != null ? 1 : 0;
            }
        }
        return super.getTargetIndex(sym, filter);
    }

    @Override
    protected void printSelf(FormatDriver out) {
        out.print(this);
    }

    @Override
    protected void verboseSelf(StringBuilder buffer) {
        buffer.append(' ');
        buffer.append(this.getPackageName());
        Collection<String> moduleNames = this.getModuleNames();
        if (!moduleNames.isEmpty()) {
            buffer.append(" to ");
            boolean printComma = false;
            for (String moduleName : moduleNames) {
                if (printComma) {
                    buffer.append(",");
                } else {
                    printComma = true;
                }
                buffer.append(moduleName);
            }
        }
    }
}

