/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Image;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JPanel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.navigator.BaseNavigator;
import oracle.help.library.Library;
import oracle.help.library.LibraryEvent;
import oracle.help.library.LibraryListener;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorException;
import oracle.help.navigator.NavigatorHelper;
import oracle.help.navigator.NavigatorListener;

public abstract class Navigator
extends JPanel
implements LibraryListener,
BaseNavigator {
    protected Library library = null;
    protected String label = null;
    protected Image labelImage;
    protected String type;
    protected boolean filterByLabel = false;
    protected ArrayList views = null;
    protected ListenerManager listeners = null;

    public static Navigator createNavigator(String type, String label, Image labelImage) throws NavigatorException {
        return Navigator.createNavigator(type, null, label, labelImage, false);
    }

    public static Navigator createNavigator(String type, Library library, String label, Image labelImage, boolean filterByLabel) throws NavigatorException {
        if (type == null) {
            throw new IllegalArgumentException("Navigator.createNavigator: type parameter cannot be null");
        }
        Navigator theNavigator = null;
        try {
            Class<?> navClass = Class.forName(type);
            if (navClass != null) {
                theNavigator = (Navigator)navClass.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw new NavigatorException("Navigator.createNavigator: Could not find specified navigator class.  Make sure " + type + "is on your class path.");
        }
        catch (ClassCastException e2) {
            throw new NavigatorException("Specified navigator " + type + " not a subclass of oracle.help.navigator.Navigator");
        }
        catch (Exception e3) {
            throw new NavigatorException("Unable to create specified engine " + type);
        }
        if (theNavigator != null) {
            View[] initialViews = null;
            initialViews = theNavigator.initBaseClass(library, type, label, labelImage, filterByLabel);
            theNavigator.initNavigator(initialViews);
        }
        return theNavigator;
    }

    public void addNavigatorListener(NavigatorListener listener) {
        if (listener != null) {
            this.listeners.addListener((EventListener)listener);
        }
    }

    public void removeNavigatorListener(NavigatorListener listener) {
        if (listener != null) {
            this.listeners.removeListener((EventListener)listener);
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public Image getLabelImage() {
        return this.labelImage;
    }

    public void setLabelImage(Image labelImage) {
        this.labelImage = labelImage;
    }

    protected final View[] initBaseClass(Library library, String type, String label, Image labelImage, boolean filterByLabel) throws NavigatorException {
        View[] initialViews = null;
        int iter = 0;
        this.label = label;
        this.labelImage = labelImage;
        this.library = library;
        this.filterByLabel = filterByLabel;
        this.type = type;
        this.listeners = new ListenerManager();
        this.views = new ArrayList();
        if (library != null) {
            this.library.addLibraryListener((LibraryListener)this);
            initialViews = library.getViewsByType(this.type);
            if (filterByLabel) {
                initialViews = this.filterViewsByLabel(initialViews, label);
            }
            if (initialViews != null) {
                for (iter = 0; iter < initialViews.length; ++iter) {
                    this.views.add(initialViews[iter]);
                }
            }
        }
        return initialViews;
    }

    public void libraryChanged(LibraryEvent e) {
        NavigatorHelper.libraryChanged(e, this, this.filterByLabel, this.label, this.views);
    }

    protected void fireNavigatorEvent(NavigatorEvent event) {
        NavigatorHelper.fireNavigatorEvent(event, this.listeners);
    }

    protected View[] filterViewsByLabel(View[] views, String label) {
        return NavigatorHelper.filterViewsByLabel(views, label);
    }

    protected void fireTopicActivated(Topic topic) {
        this.fireTopicActivated(topic, 1);
    }

    protected void fireTopicActivated(Topic topic, int mode) {
        if (this.listeners != null) {
            NavigatorEvent e = new NavigatorEvent(this, 2001, topic, mode);
            this.fireNavigatorEvent(e);
        }
    }

    protected void fireTopicSelected(Topic topic) {
        if (this.listeners != null) {
            NavigatorEvent e = new NavigatorEvent(this, 2000, topic);
            this.fireNavigatorEvent(e);
        }
    }
}

