/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.command_line;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.headless.HeadlessCommandProcessor;
import oracle.dbtools.raptor.headless.HeadlessCore;
import oracle.dbtools.raptor.headless.HeadlessTask;
import oracle.dbtools.raptor.headless.InvalidCommandArgumentException;
import oracle.dbtools.raptor.navigator.db.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.INLSSupplier;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.standalone.connection.ConnectionUtils;
import oracle.dbtools.raptor.utils.ConnectionCanceledException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.UtRepositoryManager;
import oracle.dbtools.unit_test.impexp.ExportManager;
import oracle.dbtools.unit_test.impexp.ImportListener;
import oracle.dbtools.unit_test.impexp.ImportManager;
import oracle.dbtools.unit_test.repository.RepositoryManager;
import oracle.dbtools.unit_test.runner.Runner;
import oracle.dbtools.unit_test.runner.StatusObject;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class UnitTestCommandLineProcessor
implements HeadlessCommandProcessor {
    public static String USAGE = "\nunittest ?\nunittest -run ?\nunittest -exp ?\nunittest -imp ?\n";

    public HeadlessTask<Void> parseCommandArguments(HeadlessCore headlessCore, String ... stringArray) throws InvalidCommandArgumentException {
        if (stringArray.length > 0) {
            UnitTestTask unitTestTask = new UnitTestTask("unit task", stringArray);
            return unitTestTask;
        }
        System.out.println(this.getUsageString());
        return null;
    }

    public String getUsageString() {
        return USAGE;
    }

    public static class UnitTestTask
    extends HeadlessTask<Void> {
        private String[] args = null;
        protected static final Logger LOGGER = Logger.getLogger(UnitTestCommandLineProcessor.class.getName());
        String _command = null;
        String _id = null;
        String _name = null;
        String _repo = null;
        String _db = null;
        String _log = null;
        String _file = null;
        String _type = null;
        String _return = null;
        ImportManager.ConflictOption _conflictOption = ImportManager.ConflictOption.OVERWRITE;
        public static final String USERNAME = "<USERNAME>";
        public static final String PASSWORD = "<PASSWORD>";
        public static final String USERCHECK = "SELECT COUNT(*) FROM ALL_USERS WHERE USERNAME = UPPER('<USERNAME>')";
        public static final String UTREPOSDROP = "DROP USER <USERNAME> CASCADE; DROP ROLE UT_REPO_ADMINISTRATOR; DROP ROLE UT_REPO_USER";
        public static final String UTREPOSUSER = "CREATE USER <USERNAME> IDENTIFIED BY <PASSWORD>;GRANT CREATE SESSION,RESOURCE,CONNECT,CREATE VIEW TO <USERNAME>;";
        public static final String ROLECHECK = "SELECT COUNT(*) FROM DBA_ROLES WHERE ROLE = UPPER('<USERNAME>')";
        public static final String UTREPOSROLE = "CREATE ROLE UT_REPO_ADMINISTRATOR;GRANT CREATE PUBLIC SYNONYM,DROP PUBLIC SYNONYM TO UT_REPO_ADMINISTRATOR;CREATE ROLE UT_REPO_USER;";
        public static final String UTREPOSPERMS = "GRANT SELECT ON DBA_ROLES TO <USERNAME>;GRANT SELECT ON DBA_ROLE_PRIVS TO <USERNAME>;GRANT SELECT ON DBA_TAB_PRIVS TO <USERNAME>;GRANT EXECUTE ON DBMS_LOCK TO <USERNAME>;GRANT SELECT ON DBA_ROLE_PRIVS TO UT_REPO_USER;GRANT SELECT ON DBA_ROLE_PRIVS TO UT_REPO_ADMINISTRATOR;GRANT SELECT ON DBA_ROLES TO UT_REPO_ADMINISTRATOR;GRANT SELECT ON DBA_ROLES TO UT_REPO_USER;GRANT SELECT ON DBA_TAB_PRIVS TO UT_REPO_ADMINISTRATOR;GRANT SELECT ON DBA_TAB_PRIVS TO UT_REPO_USER;GRANT EXECUTE ON DBMS_LOCK TO UT_REPO_ADMINISTRATOR;GRANT EXECUTE ON DBMS_LOCK TO UT_REPO_USER;GRANT UT_REPO_USER TO UT_REPO_ADMINISTRATOR WITH ADMIN OPTION;GRANT UT_REPO_ADMINISTRATOR TO <USERNAME> WITH ADMIN OPTION;";
        public static final String ERROR = "Error";

        protected UnitTestTask(String string, String[] stringArray) {
            super(string);
            this.args = stringArray;
        }

        protected static void warn(Throwable throwable) {
            String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
            LOGGER.log(Level.WARNING, string, throwable);
        }

        protected Void doWork() throws TaskException {
            if (this.args == null || this.args.length <= 1) {
                this.usage();
            } else {
                try {
                    NLSProvider.setNLSSupplier((INLSSupplier)new INLSSupplier(){

                        public DefaultNLSProvider getNLSProvider(Connection connection) {
                            return ConnectionTypeDetails.getTypeDetails((String)"", (Connection)connection).getNLSProvider(connection);
                        }

                        public DefaultNLSProvider getNLSProvider(String string) {
                            Connection connection = null;
                            try {
                                connection = Connections.getInstance().getConnection(string);
                            }
                            catch (DBException dBException) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                            }
                            return ConnectionTypeDetails.getTypeDetails((String)"", (Connection)connection).getNLSProvider(connection);
                        }
                    });
                    boolean bl = false;
                    Logger logger = Logger.getLogger("");
                    for (Handler handler : logger.getHandlers()) {
                        if (!(handler instanceof ConsoleHandler)) continue;
                        bl = true;
                    }
                    if (!bl) {
                        logger = Logger.getLogger("oracle.dbtools.unit_test");
                        ConsoleHandler consoleHandler = new ConsoleHandler();
                        consoleHandler.setFormatter(new Formatter(){

                            @Override
                            public String format(LogRecord logRecord) {
                                return logRecord.getLevel().getLocalizedName() + " " + logRecord.getMessage() + "\n";
                            }
                        });
                        logger.setLevel(Level.SEVERE);
                        logger.addHandler(consoleHandler);
                    }
                    this.execute(this.args);
                }
                catch (Exception exception) {
                    UnitTestTask.severe(exception);
                    System.exit(1);
                }
            }
            return null;
        }

        protected static void severe(Throwable throwable) {
            String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
            LOGGER.log(Level.SEVERE, string, throwable);
        }

        private void execute(String[] stringArray) throws Exception {
            int n = 0;
            String string = null;
            if ((string = stringArray[n++].replace("-", "").toUpperCase()).equals("RUN") || string.equals("IMP") || string.equals("EXP") || string.equals("INSTALL")) {
                this._command = string;
            } else {
                this.usage();
            }
            string = stringArray[n++];
            if (string.equals("?")) {
                this.detailUsage();
            } else {
                if (this._command.equals("IMP")) {
                    this._type = null;
                } else {
                    if (this._command.equals("INSTALL")) {
                        this.executeInstall(stringArray);
                        return;
                    }
                    if ((string = string.replace("-", "").toUpperCase()).equals("TEST") || string.equals("SUITE") || string.equals("VALIDATION") || string.equals("STARTUP") || string.equals("TEARDOWN") || string.equals("QUERY")) {
                        this._type = string;
                    } else {
                        this.detailUsage();
                    }
                }
                this.loadArgs(stringArray);
            }
            this.openRepo();
            this.branchExecute();
        }

        private void loadArgs(String[] stringArray) {
            int n = 1;
            while (n < stringArray.length && stringArray[n].startsWith("-")) {
                String string;
                if ((string = stringArray[n++].toUpperCase()).equals("-ID")) {
                    if (n >= stringArray.length) continue;
                    this._id = stringArray[n++];
                    continue;
                }
                if (string.equals("-NAME")) {
                    if (n >= stringArray.length) continue;
                    this._name = stringArray[n++];
                    continue;
                }
                if (string.equals("-REPO")) {
                    if (n >= stringArray.length) continue;
                    this._repo = stringArray[n++];
                    continue;
                }
                if (string.equals("-DB")) {
                    if (n >= stringArray.length) continue;
                    this._db = stringArray[n++];
                    continue;
                }
                if (string.equals("-FILE")) {
                    if (n >= stringArray.length) continue;
                    this._file = stringArray[n++];
                    continue;
                }
                if (string.equals("-LOG")) {
                    if (n >= stringArray.length) continue;
                    this._log = stringArray[n++];
                    continue;
                }
                if (string.equals("-RETURN")) {
                    if (n >= stringArray.length) continue;
                    this._return = stringArray[n++];
                    continue;
                }
                if (string.equals("-OVERWRITE")) {
                    this._conflictOption = ImportManager.ConflictOption.OVERWRITE;
                    continue;
                }
                if (!string.equals("-SKIP")) continue;
                this._conflictOption = ImportManager.ConflictOption.SKIP;
            }
            if (n < stringArray.length) {
                System.err.println("Unexpected argument: " + stringArray[n]);
                this.detailUsage();
                System.exit(1);
            }
        }

        private void openRepo() {
            boolean bl;
            UtRepositoryManager utRepositoryManager = UtAddin.getRepositoryManager();
            String string = this.connectionName(this._repo);
            if (Connections.getInstance().getConnectionInfo(string) == null) {
                System.err.println("Connection not found: " + this._repo);
                System.exit(1);
            }
            if (!(bl = utRepositoryManager.openConnectionWithChecks(string))) {
                System.err.println("Unable to open repository");
                System.exit(1);
            }
        }

        private String connectionName(String string) {
            String string2 = null;
            for (String string3 : Connections.getInstance().getConnNames()) {
                String string4 = Connections.getDisplayName((String)string3);
                if (!string4.equals(string)) continue;
                string2 = string3;
                break;
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeInstall(String[] stringArray) {
            Connection connection = null;
            try {
                boolean bl;
                int n = 2;
                String string = stringArray[n++];
                String string2 = stringArray[n];
                stringArray[n++] = null;
                String string3 = "jdbc:oracle:thin:" + stringArray[n++];
                String string4 = "UT_REPOS";
                boolean bl2 = true;
                if (stringArray.length > 5) {
                    string4 = stringArray[n++].toUpperCase();
                    bl2 = false;
                }
                String string5 = "oracle.jdbc.OracleDriver";
                Class.forName(string5);
                Properties properties = new Properties();
                properties.setProperty("oraDriverType", "thin");
                properties.setProperty("subtype", "oraJDBC");
                properties.setProperty("driver", string5);
                properties.setProperty("customUrl", string3);
                String string6 = "SYSDBA";
                String string7 = Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)string6).getQualifiedName();
                boolean bl3 = bl = Connections.getInstance().getConnectionInfo(string7) != null;
                if (!bl) {
                    properties.setProperty("user", string);
                    properties.setProperty("password", string2);
                    properties.setProperty("SavePassword", Boolean.TRUE.toString());
                    properties.setProperty("role", "SYSDBA");
                    DatabaseConnections.getInstance().testConnection(properties);
                    ConnectionUtils.addConnToStore((String)string6, (Properties)properties, null);
                    DatabaseConnectionStores.getInstance().getStore("IdeConnections").saveConnections();
                    bl = true;
                }
                DBUtil dBUtil = DBUtil.getInstance((String)string7);
                dBUtil.setRaiseError(false);
                connection = Connections.getInstance().getConnection(string7);
                String string8 = USERCHECK.replace(USERNAME, string4);
                String string9 = dBUtil.executeReturnOneCol(string8);
                this.checkResult(dBUtil);
                boolean bl4 = "1".equals(string9);
                if (bl2 && bl4) {
                    string8 = UTREPOSDROP.replace(USERNAME, string4);
                    string9 = ScriptUtils.runSqlReturnResult((String)string8, (Connection)connection);
                    bl4 = false;
                }
                if (!bl4) {
                    string8 = UTREPOSUSER.replace(USERNAME, string4);
                    string8 = string8.replace(PASSWORD, string4);
                    string9 = this.checkResult(ScriptUtils.runSqlReturnResult((String)string8, (Connection)connection));
                    properties.setProperty("user", string4);
                    properties.setProperty("password", string4);
                    properties.setProperty("SavePassword", Boolean.TRUE.toString());
                    properties.remove("role");
                    DatabaseConnections.getInstance().testConnection(properties);
                    ConnectionUtils.addConnToStore((String)string4, (Properties)properties, null);
                    DatabaseConnectionStores.getInstance().getStore("IdeConnections").saveConnections();
                    bl4 = true;
                }
                string8 = ROLECHECK.replace(USERNAME, "UT_REPO_USER");
                string9 = dBUtil.executeReturnOneCol(string8);
                this.checkResult(dBUtil);
                boolean bl5 = "1".equals(string9);
                if (bl5) {
                    string8 = ROLECHECK.replace(USERNAME, "UT_REPO_ADMINISTRATOR");
                    string9 = dBUtil.executeReturnOneCol(string8);
                    this.checkResult(dBUtil);
                    bl5 = "1".equals(string9);
                }
                if (!bl5) {
                    string8 = UTREPOSROLE;
                    string9 = this.checkResult(ScriptUtils.runSqlReturnResult((String)string8, (Connection)connection));
                }
                string8 = UTREPOSPERMS.replace(USERNAME, string4);
                string9 = this.checkResult(ScriptUtils.runSqlReturnResult((String)string8, (Connection)connection));
                connection.close();
                String string10 = Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)string4).getQualifiedName();
                connection = Connections.getInstance().getConnection(string10);
                if (!RepositoryManager.doesRepositoryExist(connection)) {
                    RepositoryManager repositoryManager = new RepositoryManager();
                    repositoryManager.installRepository(connection);
                    boolean bl6 = UtAddin.getRepositoryManager().openConnectionWithChecks(string10);
                    if (!bl6) {
                        throw new RuntimeException(UtAddinArb.get("BAD_REPO"));
                    }
                }
            }
            catch (Throwable throwable) {
                UnitTestTask.severe(throwable);
                System.err.println("Unable to perform install");
                System.exit(1);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        UnitTestTask.warn(sQLException);
                    }
                }
            }
            System.out.println("install completed");
        }

        private void checkResult(DBUtil dBUtil) {
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw new RuntimeException(sQLException);
            }
        }

        private String checkResult(String string) {
            if (string.contains(ERROR)) {
                throw new RuntimeException(string);
            }
            return string;
        }

        private void branchExecute() {
            if (this._command.equals("RUN")) {
                this.executeRun();
            } else if (this._command.equals("EXP")) {
                this.executeExp();
            } else if (this._command.equals("IMP")) {
                this.executeImp();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeRun() {
            StatusObject statusObject = null;
            try {
                String string = this.connectionName(this._db);
                if (string == null) {
                    System.err.println("Connection name not found");
                    System.exit(1);
                }
                UtAddin.getDataTypeConnectionProvider().setDataTypeConnectionQualName(string);
                Runner runner = new Runner(string);
                if (this._type.equals("SUITE")) {
                    if (this._return != null && UtUtils.isReturnUsed(this._return, "suite")) {
                        System.out.println("Invalid return id specified, unable to execute");
                        System.exit(1);
                    } else {
                        UtSuite utSuite = null;
                        utSuite = this._id == null ? new UtSuite(UtUtils.getSuiteId(this._name)) : new UtSuite(this._id);
                        if (utSuite.getSuiteName() == null) {
                            System.err.println("Suite does not exist");
                            System.exit(1);
                        }
                        statusObject = runner.executeSuiteCMD(utSuite, this._return, true, true);
                    }
                } else if (this._type.equals("TEST")) {
                    if (this._return != null && UtUtils.isReturnUsed(this._return, "test")) {
                        System.out.println("Invalid return id specified, unable to execute");
                        System.exit(1);
                    } else {
                        UtTest utTest = null;
                        utTest = this._id == null ? new UtTest(UtUtils.getTestId(this._name)) : new UtTest(this._id);
                        if (utTest.getTestName() == null) {
                            System.err.println("Test does not exist");
                            System.exit(1);
                        }
                        statusObject = runner.executeTestCMD(utTest, this._return, true, true);
                    }
                }
            }
            catch (ConnectionCanceledException connectionCanceledException) {
                System.err.println("Cancelled");
                System.exit(1);
            }
            catch (Exception exception) {
                UnitTestTask.severe(exception);
                System.err.println("Unable to run test");
                System.exit(1);
            }
            finally {
                if (this._log == null && statusObject.getStatus() != "UT_SUCCESS") {
                    this._log = "3";
                }
                if (this._log != null) {
                    if (this._log.equals("3")) {
                        System.out.println(statusObject.getReturn());
                        System.out.println(statusObject.getStatus());
                        System.out.println(statusObject.getMessage());
                    } else if (this._log.equals("2")) {
                        System.out.println(statusObject.getStatus());
                        System.out.println(statusObject.getMessage());
                    } else if (this._log.equals("1")) {
                        System.out.println(statusObject.getStatus());
                    }
                }
            }
        }

        private void getId() {
            if (this._type.equals("SUITE")) {
                this._id = UtUtils.getSuiteId(this._name);
            } else if (this._type.equals("TEST")) {
                this._id = UtUtils.getTestId(this._name);
            } else if (this._type.equals("VALIDATION")) {
                this._id = UtUtils.getLibValidationId(this._name);
            } else if (this._type.equals("STARTUP")) {
                this._id = UtUtils.getLibStartupId(this._name);
            } else if (this._type.equals("TEARDOWN")) {
                this._id = UtUtils.getLibTeardownId(this._name);
            } else if (this._type.equals("QUERY")) {
                this._id = UtUtils.getLibDynamicValueQueryId(this._name);
            }
            if (this._id == null) {
                System.err.println("Could not determine ID for object");
                System.exit(1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeImp() {
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(this._file), IdeUtil.getIdeEncoding());
            }
            catch (Exception exception) {
                UnitTestTask.warn(exception);
                System.err.println("Unable to access file: " + this._file);
                System.exit(1);
            }
            try (ImportManager importManager = new ImportManager(inputStreamReader, this._conflictOption);){
                importManager.importObjects(new ImportListener(){

                    @Override
                    public void onImportTest(UtTest utTest) {
                        System.out.println("imported test '" + utTest.getTestName() + "'");
                    }

                    @Override
                    public void onImportSuite(UtSuite utSuite) {
                        System.out.println("imported suite '" + utSuite.getSuiteName() + "'");
                    }

                    @Override
                    public void onImportLibraryItem(UtLibraryItem utLibraryItem) {
                        System.out.println("imported library item '" + utLibraryItem.getRef().getName() + "'");
                    }

                    @Override
                    public void onSkipTest(UtTest utTest) {
                        System.out.println("skipped test '" + utTest.getTestName() + "'");
                    }

                    @Override
                    public void onSkipSuite(UtSuite utSuite) {
                        System.out.println("skipped suite '" + utSuite.getSuiteName() + "'");
                    }

                    @Override
                    public void onSkipLibraryItem(UtLibraryItem utLibraryItem) {
                        System.out.println("skipped library item '" + utLibraryItem.getRef().getName() + "'");
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeExp() {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this._file), IdeUtil.getIdeEncoding());
            }
            catch (Exception exception) {
                UnitTestTask.warn(exception);
                System.err.println("Unable to access file: " + this._file);
                System.exit(1);
            }
            try (ExportManager exportManager = new ExportManager(outputStreamWriter, IdeUtil.getIdeEncoding());){
                if (this._type.equals("SUITE")) {
                    if (this._id == null) {
                        this.getId();
                    }
                    exportManager.exportSuiteById(this._id);
                } else if (this._type.equals("TEST")) {
                    if (this._id == null) {
                        this.getId();
                    }
                    exportManager.exportTestById(this._id);
                } else if (this._type.equals("VALIDATION")) {
                    if (this._id == null) {
                        this.getId();
                    }
                    exportManager.exportLibValidationById(this._id);
                } else if (this._type.equals("STARTUP")) {
                    if (this._id == null) {
                        this.getId();
                    }
                    exportManager.exportLibStartupById(this._id);
                } else if (this._type.equals("TEARDOWN")) {
                    if (this._id == null) {
                        this.getId();
                    }
                    exportManager.exportLibTeardown(this._name);
                } else if (this._type.equals("QUERY")) {
                    if (this._id == null) {
                        this.getId();
                    }
                    exportManager.exportLibDynamicValueQueryById(this._id);
                }
            }
        }

        private void detailUsage() {
            if (this._command.equals("RUN")) {
                this.runUsage();
            } else if (this._command.equals("EXP")) {
                this.expUsage();
            } else if (this._command.equals("IMP")) {
                this.impUsage();
            }
        }

        private void runUsage() {
            System.err.println("");
            System.err.println("unittest -run -test (-id <id>|-name <name>} -repo <connection name>\n\t -db <connection name> {-return <return id>} {-log <0,1,2,3>}");
            System.err.println("unittest -run -suite (-id <id>|-name <name>} -repo <connection name>\n\t -db <connection name> {-return <return id>} {-log <0,1,2,3>}");
            System.exit(0);
        }

        private void expUsage() {
            System.err.println("");
            System.err.println("unittest -exp -test (-id <id>|-name <name>} -repo <connection name> -file <file name>");
            System.err.println("unittest -exp -suite (-id <id>|-name <name>} -repo <connection name> -file <file name>");
            System.err.println("unittest -exp -validation (-id <id>|-name <name>} -repo <connection name> -file <file name>");
            System.err.println("unittest -exp -startup (-id <id>|-name <name>} -repo <connection name> -file <file name>");
            System.err.println("unittest -exp -teardown (-id <id>|-name <name>} -repo <connection name> -file <file name>");
            System.err.println("unittest -exp -query (-id <id>|-name <name>} -repo <connection name> -file <file name>");
            System.exit(0);
        }

        private void impUsage() {
            System.err.println("");
            System.err.println("unittest -imp -repo <connection name> -file <file name> [-overwrite | -skip]");
            System.exit(0);
        }

        private void usage() {
            System.err.println(USAGE);
        }
    }
}

