/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.create_wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import oracle.dbtools.unit_test.create_wizard.CreateWizArb;
import oracle.dbtools.unit_test.create_wizard.CreateWizContext;
import oracle.dbtools.unit_test.create_wizard.CreateWizPanel;
import oracle.dbtools.unit_test.editor.ListTablePanel;
import oracle.dbtools.unit_test.editor.TeardownListTableModel;
import oracle.dbtools.unit_test.teardown.ITeardown;
import oracle.dbtools.unit_test.teardown.TearDownRegistry;
import oracle.dbtools.unit_test.teardown.TeardownArb;
import oracle.dbtools.unit_test.testObjects.UtTest;

public class CreateWizTeardown
extends CreateWizPanel {
    private static final long serialVersionUID = 1L;
    private ListTablePanel<ITeardown> _teardownPanel;

    public CreateWizTeardown() {
        this.setLayout(new GridBagLayout());
    }

    private void init() {
        this.removeAll();
        Insets insets = new Insets(10, 10, 10, 10);
        JTextArea jTextArea = new JTextArea(CreateWizArb.getString("TEARDOWN_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        jTextArea.setBorder(null);
        this.add(jTextArea, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, insets, 0, 0));
        ArrayList arrayList = new ArrayList();
        final TeardownListTableModel teardownListTableModel = new TeardownListTableModel(this.getCreateWizContext().getCodeHookLookup()){

            @Override
            protected List<ITeardown> add() {
                String string = TeardownArb.getString("NONE");
                ITeardown iTeardown = TearDownRegistry.getInstanceFor(string);
                iTeardown.loadFromXml(null);
                ArrayList<ITeardown> arrayList = new ArrayList<ITeardown>();
                arrayList.add(iTeardown);
                return arrayList;
            }
        };
        teardownListTableModel.setRowList(arrayList);
        this._teardownPanel = new ListTablePanel<ITeardown>(teardownListTableModel);
        this.add(this._teardownPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, insets, 0, 0));
        if (this.getCreateWizContext().getUseSeeding()) {
            this._teardownPanel.setEditable(false);
        } else {
            UtTest utTest = this.getCreateWizContext().getTest();
            if (utTest != null) {
                utTest.setTeardownCodeHooks(null);
                this.getCreateWizContext().setTeardownHooks(null);
                teardownListTableModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        List<ITeardown> list = teardownListTableModel.getRowList();
                        CreateWizContext createWizContext = CreateWizTeardown.this.getCreateWizContext();
                        createWizContext.setTeardownHooks(list);
                        UtTest utTest = createWizContext.getTest();
                        utTest.setTeardownCodeHooks(list);
                    }
                });
            }
            this._teardownPanel.setEditable(utTest != null);
        }
    }

    @Override
    protected void onEntryTestChanged() {
        this.init();
    }

    @Override
    protected void onEntrySeedingChanged() {
        this.init();
    }

    public Object getExitTransition() {
        return "SUMMARY_TRANS";
    }
}

