/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.editor.LibraryDetails;
import oracle.dbtools.unit_test.editor.LibraryUsages;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.navigator.nodes.UtDefaultElement;
import oracle.dbtools.unit_test.navigator.nodes.UtStartupElement;
import oracle.dbtools.unit_test.navigator.nodes.UtTeardownElement;
import oracle.dbtools.unit_test.navigator.nodes.UtValidationElement;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtLibraryItem;

public class UtLibraryEditor
extends UtEditor {
    private CustomTabbedPane _tabbed = new CustomTabbedPane();
    private LibraryDetails _details;
    private LibraryUsages _usages;
    private PropertyChangeListener providerQualNameListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = (String)propertyChangeEvent.getNewValue();
            UtLibraryEditor.this.setDataConnectionQualName(string);
        }
    };

    @Override
    protected void init() {
        JPanel jPanel = this.getEditorPanel();
        this._details = new LibraryDetails(this);
        this._usages = new LibraryUsages(this);
        jPanel.setLayout(new BorderLayout());
        this._tabbed.addTab(null, UtAddinArb.getString("DETAILS"), (Component)this._details);
        this._tabbed.addTab(null, UtAddinArb.getString("USAGES"), (Component)this._usages);
        jPanel.add((Component)this._tabbed, "Center");
        UtAddin.getDataTypeConnectionProvider().addPropertyChangeListener("dbQualName", this.providerQualNameListener);
    }

    @Override
    public void close() {
        UtAddin.getDataTypeConnectionProvider().removePropertyChangeListener("dbQualName", this.providerQualNameListener);
        super.close();
    }

    @Override
    public void setDataConnectionQualName(String string) {
        super.setDataConnectionQualName(string);
        UtAddin.getDataTypeConnectionProvider().setDataTypeConnectionQualName(string);
    }

    @Override
    protected void commit() throws ObjectUpdateException {
        if (null != this._details) {
            this._details.commit();
        }
    }

    @Override
    protected void rollback() {
        if (null != this._details) {
            this._details.rollback();
        }
    }

    @Override
    public void updateContent(boolean bl) {
        this.updateContent(true, true);
    }

    void updateContent(boolean bl, boolean bl2) {
        UtDefaultElement utDefaultElement = this.getElementNode();
        String string = utDefaultElement.getId();
        UtLibraryItem.Kind kind = null;
        kind = utDefaultElement instanceof UtStartupElement ? UtLibraryItem.Kind.STARTUP : (utDefaultElement instanceof UtTeardownElement ? UtLibraryItem.Kind.TEARDOWN : (utDefaultElement instanceof UtValidationElement ? UtLibraryItem.Kind.VALIDATION : UtLibraryItem.Kind.DYNAMIC_VALUE_QUERY));
        UtLibraryItem utLibraryItem = new UtLibraryItem(kind, string);
        if (bl) {
            this._details.updateUI(utLibraryItem);
        }
        if (bl2) {
            this._usages.updateUI(utLibraryItem);
        }
    }

    @Override
    protected void setHaveEditLock(boolean bl) {
        super.setHaveEditLock(bl);
        if (null != this._details) {
            this._details.toggleButtons();
        }
    }
}

