/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtDataTypeFactory;
import oracle.dbtools.unit_test.codehook.CodeHook;
import oracle.dbtools.unit_test.editor.DynamicValueQuery;
import oracle.dbtools.unit_test.impexp.ExportContext;
import oracle.dbtools.unit_test.impexp.ImportContext;
import oracle.dbtools.unit_test.impexp.LoggerLevel;
import oracle.dbtools.unit_test.process_validation.IValidation;
import oracle.dbtools.unit_test.runner.UtRunnerImplIterator;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.testObjects.UtArguments;
import oracle.dbtools.unit_test.testObjects.UtLibraryRef;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.testObjects.UtTestImplArgs;
import oracle.dbtools.unit_test.testObjects.UtValidation;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.jdbc.OracleCallableStatement;
import oracle.xml.parser.v2.XMLElement;

public class UtTestImpl {
    private String _utId;
    private String _utiId;
    private String _name;
    private String _expected_status;
    private String _expected_error_code;
    private List<UtValidation> _validations = new ArrayList<UtValidation>();
    private HashSet<String> _savedValidationIdSet = new HashSet();
    private HashMap<String, UtTestImplArgs> _parms = new HashMap();
    private boolean dirty = false;
    private UtTest _test;
    private String _dynamicQuery;
    private UtLibraryRef _dynamicQueryLibRef;
    private Map<Integer, Map<String, Object>> _dynamicData;

    public UtTestImpl(String string, String string2, String string3, boolean bl, UtTest utTest, String string4, String string5, String string6, UtLibraryRef utLibraryRef) {
        this._utiId = string == null ? UUID.randomUUID().toString() : string;
        this._utId = string2;
        if (utTest == null) {
            throw new IllegalArgumentException("Internal: test cannot be null");
        }
        this._test = utTest;
        this._name = string3;
        this._expected_status = string4;
        this._expected_error_code = string5;
        this._dynamicQuery = string6;
        this._dynamicQueryLibRef = utLibraryRef;
        this.dirty = bl;
    }

    UtTestImpl(XMLElement xMLElement, UtTest utTest, Map<String, UtArguments> map, ImportContext importContext) {
        Object object;
        List<XMLElement> list;
        this._test = utTest;
        this._utId = xMLElement.getAttribute("test_id");
        if (this._utId == null || this._utId.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        this._utiId = xMLElement.getAttribute("id");
        if (this._utiId == null || this._utiId.equals("")) {
            importContext.log(LoggerLevel.SEVERE, "unexpected null value");
        }
        this._name = xMLElement.getAttribute("name");
        this._expected_status = xMLElement.getAttribute("expected_ret");
        this._expected_error_code = xMLElement.getAttribute("expected_err");
        String string = xMLElement.getAttribute("dq_lib_id");
        if (string != null && !string.equals("")) {
            if (string == null || string.equals("")) {
                importContext.log(LoggerLevel.SEVERE, "unexpected null value");
            }
            list = xMLElement.getAttribute("dq_lib_name");
            this._dynamicQueryLibRef = new UtLibraryRef(string, (String)((Object)list));
        } else {
            list = importContext.getNestedElements(xMLElement, "dvq");
            for (XMLElement object22 : list) {
                object = new DynamicValueQuery();
                ((CodeHook)object).loadFromXmlElement(object22);
                this._dynamicQuery = ((DynamicValueQuery)object).getXml();
            }
        }
        list = importContext.getNestedElements(xMLElement, "parm");
        for (XMLElement xMLElement2 : list) {
            object = new UtTestImplArgs(xMLElement2, map, importContext);
            this._parms.put(((UtTestImplArgs)object).getArgId(), (UtTestImplArgs)object);
        }
        List<XMLElement> list2 = importContext.getNestedElements(xMLElement, "validation");
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (XMLElement)iterator.next();
            UtValidation utValidation = new UtValidation((XMLElement)object, this, importContext);
            this._validations.add(utValidation);
        }
    }

    void exportRelated(ExportContext exportContext) {
        if (this._dynamicQueryLibRef != null) {
            exportContext.exportRelatedLibDynamicValueQuery(this._dynamicQueryLibRef.getLibId());
        }
        for (UtValidation utValidation : this._validations) {
            utValidation.exportRelated(exportContext);
        }
    }

    void exportFields(XMLElement xMLElement, ExportContext exportContext) {
        XMLElement xMLElement2 = exportContext.createExportedElement(xMLElement, "test_impl");
        xMLElement2.setAttribute("id", this._utiId);
        xMLElement2.setAttribute("test_id", this._utId);
        xMLElement2.setAttribute("name", this._name);
        xMLElement2.setAttribute("expected_ret", this._expected_status);
        xMLElement2.setAttribute("expected_err", this._expected_error_code);
        if (this._dynamicQueryLibRef != null) {
            xMLElement2.setAttribute("dq_lib_id", this._dynamicQueryLibRef.getLibId());
            xMLElement2.setAttribute("dq_lib_name", this._dynamicQueryLibRef.getName());
        } else if (this._dynamicQuery != null) {
            Iterator<UtValidation> iterator = new DynamicValueQuery();
            iterator.loadFromXml(this._dynamicQuery);
            XMLElement object = iterator.getXmlElement();
            if (object != null) {
                exportContext.reparentExportedElement(xMLElement2, object);
            }
        }
        for (UtTestImplArgs utTestImplArgs : this._parms.values()) {
            utTestImplArgs.exportFields(xMLElement2, exportContext);
        }
        for (UtValidation utValidation : this._validations) {
            utValidation.exportFields(xMLElement2, exportContext);
        }
    }

    public UtTest getTest() {
        return this._test;
    }

    public UtTestImpl(String string) {
        if (string == null) {
            throw new IllegalArgumentException("UtiId can not be null!");
        }
        this._utiId = string;
        this.loadImpl();
        this.loadValidations();
        this.loadParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadImpl() {
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            block7: {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string = UtUtils.getQuery("loadSingleImpl");
                    hashMap.put("ID", this._utiId);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet == null) break block7;
                    while (resultSet.next()) {
                        this._test = new UtTest(resultSet.getString("UT_ID"));
                        this._name = resultSet.getString("NAME");
                        this._expected_status = resultSet.getString("EXPECTED_RETURN");
                        this._expected_error_code = resultSet.getString("EXPECTED_RETURN_ERROR");
                        String string2 = resultSet.getString("LIB_DYN_QUERY_ID");
                        if (string2 != null) {
                            this._dynamicQueryLibRef = new UtLibraryRef(string2, resultSet.getString("LIB_DYN_QUERY_NAME"));
                            this._dynamicQuery = resultSet.getString("LIB_DYN_QUERY");
                            continue;
                        }
                        this._dynamicQueryLibRef = null;
                        this._dynamicQuery = resultSet.getString("DYNAMIC_VALUE_QUERY");
                    }
                }
                catch (SQLException sQLException) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                    catch (Throwable throwable) {
                        DBUtil.closeResultSet(resultSet);
                        Connections.getInstance().unlock(connection);
                        throw throwable;
                    }
                }
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void createParameters(ArrayList<UtArguments> arrayList) {
        for (UtArguments utArguments : this._test.getCallableArgumentsSorted(arrayList)) {
            UtTestImplArgs utTestImplArgs = new UtTestImplArgs(this._utiId, utArguments, true, null, null, true);
            this._parms.put(utArguments.getArgId(), utTestImplArgs);
        }
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadValidations() {
        block10: {
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string = UtUtils.getQuery("loadValidations");
                    hashMap.put("UTI_ID", this._utiId);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string2 = resultSet.getString("VALIDATION_ID");
                            int n = resultSet.getInt("INDEX_NO");
                            String string3 = null;
                            UtLibraryRef utLibraryRef = null;
                            String string4 = resultSet.getString("LIB_VALIDATION_ID");
                            if (string4 != null) {
                                utLibraryRef = new UtLibraryRef(string4, resultSet.getString("LIB_VALIDATION_NAME"));
                                string3 = resultSet.getString("LIB_VALIDATION");
                            } else {
                                utLibraryRef = null;
                                string3 = resultSet.getString("VALIDATION");
                            }
                            if (string3 == null || string3.trim().equals("")) continue;
                            int n2 = resultSet.getInt("APPLY_VALIDATION");
                            UtValidation utValidation = new UtValidation(this, string2, n, utLibraryRef, string3, n2 != 0, false);
                            this._validations.add(utValidation);
                            this._savedValidationIdSet.add(utValidation.getValidationId());
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block10;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadParameters() {
        block8: {
            this._parms.clear();
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = UtAddin.getRepositoryManager().getConnection();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(true);
                    String string = UtUtils.getQuery("loadImplArgs");
                    hashMap.put("ID", this._utiId);
                    resultSet = dBUtil.executeOracleQuery(string, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string2 = resultSet.getString("ARG_ID");
                            String string3 = resultSet.getString("UTI_ID");
                            Clob clob = resultSet.getClob("INPUT_VALUE");
                            Clob clob2 = resultSet.getClob("OUTPUT_VALUE");
                            int n = resultSet.getInt("TEST_OUTVAL");
                            UtArguments utArguments = this._test.getArgument(string2);
                            UtTestImplArgs utTestImplArgs = new UtTestImplArgs(string3, utArguments, n != 0, clob == null ? null : clob.getAsciiStream(), clob2 == null ? null : clob2.getAsciiStream(), false);
                            this._parms.put(utTestImplArgs.getArgId(), utTestImplArgs);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(UtUtils.class.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public HashMap<String, UtTestImplArgs> getParameters() {
        return this._parms;
    }

    public String getUtId() {
        return this._utId;
    }

    public String getUtiId() {
        return this._utiId;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
        this.dirty = true;
    }

    public String getExpectedStatus() {
        return this._expected_status;
    }

    public void setExpectedStatus(String string) {
        this._expected_status = string;
        this.dirty = true;
    }

    public String getExpectedErrorCode() {
        return this._expected_error_code;
    }

    public void setExpectedErrorCode(String string) {
        this._expected_error_code = string;
        this.dirty = true;
    }

    public int getValidationCount() {
        return this._validations.size();
    }

    public UtValidation getValidation(int n) {
        return this._validations.get(n);
    }

    public void setValidation(int n, UtValidation utValidation) {
        this._validations.set(n, utValidation);
    }

    public void addValidation(UtValidation utValidation) {
        this._validations.add(utValidation);
    }

    public void removeValidation(int n) {
        this._validations.remove(n);
    }

    public List<IValidation> getValidationCodeHooks() {
        ArrayList<IValidation> arrayList = new ArrayList<IValidation>(this._validations.size());
        for (UtValidation utValidation : this._validations) {
            arrayList.add(utValidation.getValidationCodeHook());
        }
        return arrayList;
    }

    public void setValidationCodeHooks(List<IValidation> list) {
        ArrayList<UtValidation> arrayList = new ArrayList<UtValidation>();
        HashMap<String, UtValidation> hashMap = new HashMap<String, UtValidation>();
        for (UtValidation object : this._validations) {
            hashMap.put(object.getValidationId(), object);
        }
        if (list != null) {
            for (IValidation iValidation : list) {
                if (null == iValidation.getXml()) continue;
                UtValidation utValidation = (UtValidation)hashMap.get(iValidation.getOwnerId());
                if (utValidation == null) {
                    utValidation = new UtValidation(this, null, -1, null, null, true, true);
                }
                utValidation.setValidationCodeHook(iValidation);
                arrayList.add(utValidation);
            }
        }
        this._validations = arrayList;
    }

    void save(boolean bl) throws ObjectUpdateException {
        if (!bl && !this.dirty) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("mergeTestImpl");
                if (bl || this.dirty) {
                    hashMap.put("UTI_ID", this._utiId);
                    hashMap.put("UT_ID", this._utId);
                    hashMap.put("NAME", this._name);
                    hashMap.put("EXPECTED_RETURN", this._expected_status);
                    hashMap.put("EXPECTED_RETURN_ERROR", this._expected_error_code);
                    hashMap.put("DYNAMIC_VALUE_QUERY", this._dynamicQueryLibRef == null ? UtUtils.asClob(connection, this._dynamicQuery) : DBUtil.NULL_VALUE);
                    hashMap.put("LIB_DYN_QUERY_ID", this._dynamicQueryLibRef != null ? this._dynamicQueryLibRef.getLibId() : DBUtil.NULL_VALUE);
                    dBUtil.setRaiseError(true);
                    int n = dBUtil.executeUpdate(string, hashMap);
                    if (0 == n) {
                        throw new ObjectUpdateException();
                    }
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (String object2 : this.getParameters().keySet()) {
                    UtTestImplArgs utTestImplArgs = this.getParameters().get(object2);
                    utTestImplArgs.save(bl);
                }
                for (int i = 0; i < this._validations.size(); ++i) {
                    UtValidation utValidation = this._validations.get(i);
                    hashSet.add(utValidation.getValidationId());
                    utValidation.save(i, bl);
                }
                for (String string2 : this._savedValidationIdSet) {
                    if (hashSet.contains(string2)) continue;
                    dBUtil = DBUtil.getInstance((Connection)connection);
                    string = UtUtils.getQuery("deleteValidation");
                    hashMap.put("ID", string2);
                    dBUtil.setRaiseError(true);
                    int n = dBUtil.executeUpdate(string, hashMap);
                    if (0 != n) continue;
                    throw new ObjectUpdateException();
                }
                this._savedValidationIdSet = new HashSet(this._validations.size());
                for (int i = 0; i < this._validations.size(); ++i) {
                    UtValidation utValidation = this._validations.get(i);
                    this._savedValidationIdSet.add(utValidation.getValidationId());
                }
                this.dirty = false;
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                throw new ObjectUpdateException(sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    public int getRunCount(Connection connection) throws SQLException {
        if (null == this._dynamicQuery) {
            return 1;
        }
        return this.getDynamicData(connection).size();
    }

    private boolean isDynamic() {
        return null != this._dynamicQuery;
    }

    public String getDynamicQuery() {
        return this._dynamicQuery;
    }

    public void setDynamicQuery(String string) {
        this._dynamicQuery = string;
    }

    public UtLibraryRef getDynamicQueryLibRef() {
        return this._dynamicQueryLibRef;
    }

    public void setDynamicQueryLibRef(UtLibraryRef utLibraryRef) {
        this._dynamicQueryLibRef = utLibraryRef;
        this.dirty = true;
    }

    public String getTemplateDynamicQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select");
        boolean bl = true;
        for (UtArguments utArguments : this._test.getCallableArgumentsSorted()) {
            UtTestImplArgs utTestImplArgs = this._parms.get(utArguments.getArgId());
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            BindingMode bindingMode = utTestImplArgs.getMode();
            if (BindingMode.RETURN == bindingMode) {
                stringBuilder.append(" ? as RETURNS$");
                continue;
            }
            if (BindingMode.IN == bindingMode) {
                stringBuilder.append(" ? as ");
                stringBuilder.append(utTestImplArgs.getName());
                continue;
            }
            if (BindingMode.OUT == bindingMode) {
                stringBuilder.append(" ? as ");
                stringBuilder.append(utTestImplArgs.getName() + "$");
                continue;
            }
            if (BindingMode.IN_OUT != bindingMode) continue;
            stringBuilder.append(" ? as ");
            stringBuilder.append(utTestImplArgs.getName());
            stringBuilder.append(", ? as ");
            stringBuilder.append(utTestImplArgs.getName() + "$");
        }
        stringBuilder.append(" from ? where ?");
        return stringBuilder.toString();
    }

    public Map<Integer, Map<String, Object>> getDynamicData(Connection connection) throws SQLException {
        if (null == this._dynamicData) {
            this._dynamicData = new HashMap<Integer, Map<String, Object>>();
            this.loadDynamicData(connection);
        }
        return this._dynamicData;
    }

    public PreparedStatement openDynamicQueryStatement(Connection connection) throws SQLException {
        if (this.isDynamic()) {
            String string = DynamicValueQuery.getQueryFromXml(this._dynamicQuery);
            return connection.prepareStatement(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDynamicData(Connection connection) throws SQLException {
        block9: {
            this._dynamicData.clear();
            int n = 0;
            if (Connections.getInstance().lock(connection)) {
                try {
                    PreparedStatement preparedStatement = this.openDynamicQueryStatement(connection);
                    if (preparedStatement == null) break block9;
                    try {
                        ResultSet resultSet = preparedStatement.executeQuery();
                        int n2 = resultSet.getMetaData().getColumnCount();
                        while (resultSet.next()) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            for (int i = n2; i > 0; --i) {
                                hashMap.put(resultSet.getMetaData().getColumnLabel(i), resultSet.getObject(i));
                            }
                            this._dynamicData.put(n, hashMap);
                            ++n;
                        }
                    }
                    finally {
                        preparedStatement.close();
                    }
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
    }

    public UtRunnerImplIterator getRunnerIterator(DataTypeConnectionProvider dataTypeConnectionProvider) {
        String string = "\"" + this._test.getObjectOwner() + "\"." + this.getQualifiedName();
        UtRunnerImplIterator utRunnerImplIterator = new UtRunnerImplIterator(dataTypeConnectionProvider, string, this.getDynamicQuery());
        BindContext bindContext = UtDataTypeFactory.getInstance().getBindContext(OracleCallableStatement.class, dataTypeConnectionProvider);
        for (UtArguments utArguments : this._test.getCallableArgumentsSorted()) {
            UtTestImplArgs utTestImplArgs = this._parms.get(utArguments.getArgId());
            DataType dataType = utTestImplArgs.getDataType();
            this.datatypeCheck(dataType);
            BindingStrategy bindingStrategy = utTestImplArgs.getBind(bindContext);
            utRunnerImplIterator.addBind(bindingStrategy);
        }
        utRunnerImplIterator.getSql();
        bindContext.setBindTokens(utRunnerImplIterator.getBindTokenList());
        return utRunnerImplIterator;
    }

    private void datatypeCheck(DataType dataType) {
        if (!dataType.isSupported()) {
            // empty if block
        }
    }

    public String getQualifiedName() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"" + this._test.getObjectName() + "\"");
        String string = this._test.getObjectCall();
        if (string != null) {
            stringBuffer.append(".");
            stringBuffer.append("\"" + string + "\"");
        }
        return stringBuffer.toString();
    }

    void upgradeArgs(Collection<String> collection, Collection<UtArguments> collection2) {
        for (String object : collection) {
            this._parms.remove(object);
        }
        for (UtArguments utArguments : collection2) {
            if (utArguments.get_data_level() != 0) continue;
            this._parms.put(utArguments.getArgId(), new UtTestImplArgs(this._utiId, utArguments, true, null, null, true));
        }
    }
}

