/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAggregationOperator;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;

final class LegacyXMLBaseOperator
extends LegacyXMLAggregationOperator {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.OPCODE};

    protected LegacyXMLBaseOperator(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    String getOpcode() {
        return this.getPropertyStringValue(LegacyXMLTags.OPCODE);
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.BASE_OPERATOR_TAG;
    }

    @Override
    FunctionDescriptor getFunctionDescriptor() {
        if ("AVERAGE" == this.getOpcode() || "HAVERAGE" == this.getOpcode() || "HWAVERAGE" == this.getOpcode() || "WAVERAGE" == this.getOpcode()) {
            return FunctionDescriptorCatalog.AGGREGATION_AVG;
        }
        if ("FIRST" == this.getOpcode() || "HFIRST" == this.getOpcode() || "HWFIRST" == this.getOpcode() || "WFIRST" == this.getOpcode()) {
            return FunctionDescriptorCatalog.AGGREGATION_FIRST;
        }
        if ("LAST" == this.getOpcode() || "HLAST" == this.getOpcode() || "HWLAST" == this.getOpcode() || "WLAST" == this.getOpcode()) {
            return FunctionDescriptorCatalog.AGGREGATION_LAST;
        }
        if ("SUM" == this.getOpcode() || "SSUM" == this.getOpcode() || "WSUM" == this.getOpcode()) {
            return FunctionDescriptorCatalog.AGGREGATION_SUM;
        }
        if ("MIN" == this.getOpcode()) {
            return FunctionDescriptorCatalog.AGGREGATION_MIN;
        }
        if ("MAX" == this.getOpcode()) {
            return FunctionDescriptorCatalog.AGGREGATION_MAX;
        }
        if ("NOAGG" == this.getOpcode()) {
            return null;
        }
        return FunctionDescriptorCatalog.AGGREGATION_SUM;
    }
}

