/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.conversion;

import java.util.List;
import oracle.olapi.metadata.BaseMetadataProvider;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.conversion.LegacyXMLAW;
import oracle.olapi.metadata.conversion.LegacyXMLBaseObject;
import oracle.olapi.metadata.conversion.LegacyXMLConverter;
import oracle.olapi.metadata.conversion.LegacyXMLMeasure;
import oracle.olapi.metadata.conversion.LegacyXMLTags;
import oracle.olapi.metadata.mdm.MdmOrganizationalSchema;

final class LegacyXMLMeasureFolder
extends LegacyXMLBaseObject {
    private static final XMLTag[] LOCAL_TAGS = new XMLTag[]{LegacyXMLTags.MEASURES_REF, LegacyXMLTags.MEASURE_FOLDERS};

    protected LegacyXMLMeasureFolder(BaseMetadataProvider baseMetadataProvider) {
        super(baseMetadataProvider);
    }

    List<LegacyXMLMeasure> getMeasures() {
        return this.getPropertyListValues(LegacyXMLTags.MEASURES_REF);
    }

    List<LegacyXMLMeasureFolder> getMeasureFolders() {
        return this.getPropertyListValues(LegacyXMLTags.MEASURES_REF);
    }

    LegacyXMLAW getAW() {
        return (LegacyXMLAW)this.getContainedByObject();
    }

    LegacyXMLMeasureFolder getMeasureFolder() {
        return (LegacyXMLMeasureFolder)this.getContainedByObject();
    }

    MdmOrganizationalSchema getMdmOrganizationalSchema() {
        return (MdmOrganizationalSchema)this.getConvertToObject();
    }

    @Override
    protected XMLTag getPropertyXMLTag(String string, String string2) {
        XMLTag xMLTag = this.findXMLTag(string, string2, LOCAL_TAGS);
        if (null == xMLTag) {
            return super.getPropertyXMLTag(string, string2);
        }
        return xMLTag;
    }

    @Override
    protected XMLTag getXMLTag() {
        return LegacyXMLTags.MEASURE_FOLDER_TAG;
    }

    @Override
    protected boolean validateState(LegacyXMLConverter legacyXMLConverter) {
        if (!super.validateState(legacyXMLConverter)) {
            return false;
        }
        for (LegacyXMLMeasure legacyXMLMeasure : this.getMeasures()) {
            if (legacyXMLMeasure.isValid()) continue;
            legacyXMLConverter.reportIgnoredProperty(LegacyXMLTags.MEASURES_REF, legacyXMLMeasure, this);
        }
        return true;
    }

    @Override
    protected void convertToMdm(LegacyXMLConverter legacyXMLConverter) {
        MdmOrganizationalSchema mdmOrganizationalSchema = this.getMdmDatabaseSchema(legacyXMLConverter).findOrCreateOrganizationalSchema(this.getLocalName());
        if (mdmOrganizationalSchema.isPersistent()) {
            legacyXMLConverter.reportError("DuplicateMetadataID", mdmOrganizationalSchema.getID());
        }
        if (this.getContainedByObject() instanceof LegacyXMLMeasureFolder) {
            MdmOrganizationalSchema mdmOrganizationalSchema2 = this.getMeasureFolder().getMdmOrganizationalSchema();
            mdmOrganizationalSchema2.addOrganizationalSchema(mdmOrganizationalSchema);
        }
        for (LegacyXMLMeasure legacyXMLMeasure : this.getMeasures()) {
            if (!legacyXMLMeasure.isValid()) continue;
            mdmOrganizationalSchema.addMeasure(legacyXMLMeasure.getMdmMeasure());
        }
        this.setMdmOrganizationalSchema(mdmOrganizationalSchema);
        super.convertToMdm(legacyXMLConverter);
    }

    @Override
    protected int getBaseConvertOrderNumber(LegacyXMLConverter legacyXMLConverter) {
        int n = -1;
        for (LegacyXMLMeasure legacyXMLMeasure : this.getMeasures()) {
            int n2 = legacyXMLMeasure.getConvertOrderNumber(legacyXMLConverter);
            if (n2 <= n) continue;
            n = n2;
        }
        if (-1 == n) {
            return super.getBaseConvertOrderNumber(legacyXMLConverter);
        }
        return n + 1;
    }

    private void setMdmOrganizationalSchema(MdmOrganizationalSchema mdmOrganizationalSchema) {
        this.setConvertToObject(mdmOrganizationalSchema);
    }
}

