/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata.mtm;

import java.util.ArrayList;
import java.util.List;
import oracle.olapi.internal.CopyPolicy;
import oracle.olapi.metadata.XMLTag;
import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmDimension;
import oracle.olapi.metadata.mdm.MdmMetadataProvider;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;
import oracle.olapi.metadata.mtm.MtmAWColumnExpression;
import oracle.olapi.metadata.mtm.MtmAWView;
import oracle.olapi.metadata.mtm.MtmAggregationSpecification;
import oracle.olapi.metadata.mtm.MtmAggregationStep;
import oracle.olapi.metadata.mtm.MtmBaseCube;
import oracle.olapi.metadata.mtm.MtmCompoundExpression;
import oracle.olapi.metadata.mtm.MtmCompoundTable;
import oracle.olapi.metadata.mtm.MtmCube;
import oracle.olapi.metadata.mtm.MtmCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmCustomExpression;
import oracle.olapi.metadata.mtm.MtmDerivedAttributeMap;
import oracle.olapi.metadata.mtm.MtmDimensionMap;
import oracle.olapi.metadata.mtm.MtmDimensionOrderSpecification;
import oracle.olapi.metadata.mtm.MtmFirstLastAggregationStep;
import oracle.olapi.metadata.mtm.MtmLevelMap;
import oracle.olapi.metadata.mtm.MtmLiteralExpression;
import oracle.olapi.metadata.mtm.MtmMeasureMap;
import oracle.olapi.metadata.mtm.MtmNoAggregationStep;
import oracle.olapi.metadata.mtm.MtmObject;
import oracle.olapi.metadata.mtm.MtmObjectFactory;
import oracle.olapi.metadata.mtm.MtmObjectVisitor;
import oracle.olapi.metadata.mtm.MtmPartitionedCube;
import oracle.olapi.metadata.mtm.MtmPrimaryDimensionMap;
import oracle.olapi.metadata.mtm.MtmRDBMSColumnExpression;
import oracle.olapi.metadata.mtm.MtmRdbmsTableOrView;
import oracle.olapi.metadata.mtm.MtmSelectStatement;
import oracle.olapi.metadata.mtm.MtmSimpleAggregationStep;
import oracle.olapi.metadata.mtm.MtmSolvedCube;
import oracle.olapi.metadata.mtm.MtmSolvedETCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmSolvedGroupingSetCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmSolvedLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmSolvedRollupCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmStoredAttributeMap;
import oracle.olapi.metadata.mtm.MtmUnsolvedCube;
import oracle.olapi.metadata.mtm.MtmUnsolvedCubeDimensionality;
import oracle.olapi.metadata.mtm.MtmUnsolvedLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmValueExpression;
import oracle.olapi.metadata.mtm.MtmValueLevelHierarchyMap;
import oracle.olapi.metadata.mtm.MtmWeightedAverageAggregationStep;
import oracle.olapi.metadata.mtm.MtmXMLTags;

class MtmCopyVisitor
implements MtmObjectVisitor {
    private static MtmCopyVisitor sInstance = new MtmCopyVisitor();

    private MtmCopyVisitor() {
    }

    private static MtmCopyVisitor getInstance() {
        return sInstance;
    }

    public static MtmObject createCopy(MtmObject mtmObject, CopyPolicy copyPolicy) {
        return (MtmObject)mtmObject.acceptVisitor(MtmCopyVisitor.getInstance(), copyPolicy);
    }

    private MtmObject copyMtmObject(MtmObject mtmObject, MtmObject mtmObject2, Object object) {
        this.copyExternalProperty(mtmObject, mtmObject2, object, MtmXMLTags.MDM_SOURCE);
        this.copyRemainingProperties(mtmObject, mtmObject2, object);
        return mtmObject;
    }

    @Override
    public Object visitMtmStoredAttributeMap(MtmStoredAttributeMap mtmStoredAttributeMap, Object object) {
        MtmStoredAttributeMap mtmStoredAttributeMap2 = this.getMtmObjectFactory(mtmStoredAttributeMap).createStoredAttributeMap();
        return this.copyMtmObject(mtmStoredAttributeMap2, mtmStoredAttributeMap, object);
    }

    @Override
    public Object visitMtmDerivedAttributeMap(MtmDerivedAttributeMap mtmDerivedAttributeMap, Object object) {
        MtmDerivedAttributeMap mtmDerivedAttributeMap2 = this.getMtmObjectFactory(mtmDerivedAttributeMap).createDerivedAttributeMap();
        return this.copyMtmObject(mtmDerivedAttributeMap2, mtmDerivedAttributeMap, object);
    }

    @Override
    public Object visitMtmMeasureMap(MtmMeasureMap mtmMeasureMap, Object object) {
        MtmMeasureMap mtmMeasureMap2 = this.getMtmObjectFactory(mtmMeasureMap).createMeasureMap();
        this.copyExternalProperty(mtmMeasureMap2, mtmMeasureMap, object, MtmXMLTags.CUBE);
        return this.copyMtmObject(mtmMeasureMap2, mtmMeasureMap, object);
    }

    private MtmDimensionMap copyDimensionMap(MtmDimensionMap mtmDimensionMap, MtmDimensionMap mtmDimensionMap2, Object object) {
        MtmDimensionMap mtmDimensionMap3 = (MtmDimensionMap)this.copyMtmObject(mtmDimensionMap, mtmDimensionMap2, object);
        this.copyAttributeMappings(mtmDimensionMap, mtmDimensionMap2, object);
        return mtmDimensionMap3;
    }

    @Override
    public Object visitMtmSolvedLevelHierarchyMap(MtmSolvedLevelHierarchyMap mtmSolvedLevelHierarchyMap, Object object) {
        MtmSolvedLevelHierarchyMap mtmSolvedLevelHierarchyMap2 = this.getMtmObjectFactory(mtmSolvedLevelHierarchyMap).createSolvedLevelHierarchyMap();
        return this.copyDimensionMap(mtmSolvedLevelHierarchyMap2, mtmSolvedLevelHierarchyMap, object);
    }

    @Override
    public Object visitMtmUnsolvedLevelHierarchyMap(MtmUnsolvedLevelHierarchyMap mtmUnsolvedLevelHierarchyMap, Object object) {
        MtmUnsolvedLevelHierarchyMap mtmUnsolvedLevelHierarchyMap2 = this.getMtmObjectFactory(mtmUnsolvedLevelHierarchyMap).createUnsolvedLevelHierarchyMap();
        return this.copyDimensionMap(mtmUnsolvedLevelHierarchyMap2, mtmUnsolvedLevelHierarchyMap, object);
    }

    @Override
    public Object visitMtmLevelMap(MtmLevelMap mtmLevelMap, Object object) {
        MtmLevelMap mtmLevelMap2 = this.getMtmObjectFactory(mtmLevelMap).createLevelMap();
        return this.copyDimensionMap(mtmLevelMap2, mtmLevelMap, object);
    }

    @Override
    public Object visitMtmValueLevelHierarchyMap(MtmValueLevelHierarchyMap mtmValueLevelHierarchyMap, Object object) {
        MtmValueLevelHierarchyMap mtmValueLevelHierarchyMap2 = this.getMtmObjectFactory(mtmValueLevelHierarchyMap).createValueLevelHierarchyMap();
        return this.copyDimensionMap(mtmValueLevelHierarchyMap2, mtmValueLevelHierarchyMap, object);
    }

    @Override
    public Object visitMtmPrimaryDimensionMap(MtmPrimaryDimensionMap mtmPrimaryDimensionMap, Object object) {
        MtmPrimaryDimensionMap mtmPrimaryDimensionMap2 = this.getMtmObjectFactory(mtmPrimaryDimensionMap).createPrimaryDimensionMap();
        return this.copyDimensionMap(mtmPrimaryDimensionMap2, mtmPrimaryDimensionMap, object);
    }

    private MtmCube copyCube(MtmCube mtmCube, MtmCube mtmCube2, Object object) {
        this.copyExternalProperty(mtmCube, mtmCube2, object, MtmXMLTags.DIM_MAP_REF);
        this.copyExternalProperty(mtmCube, mtmCube2, object, MtmXMLTags.MEAS_MAP_REF);
        return (MtmCube)this.copyMtmObject(mtmCube, mtmCube2, object);
    }

    private MtmBaseCube copyBaseCube(MtmBaseCube mtmBaseCube, MtmBaseCube mtmBaseCube2, Object object) {
        this.copyUpProperty(mtmBaseCube, mtmBaseCube2, object, MtmXMLTags.PARTITIONED_CUBE);
        MtmBaseCube mtmBaseCube3 = (MtmBaseCube)this.copyCube(mtmBaseCube, mtmBaseCube2, object);
        this.copyMeasureMappings(mtmBaseCube, mtmBaseCube2, object);
        return mtmBaseCube3;
    }

    @Override
    public Object visitMtmSolvedCube(MtmSolvedCube mtmSolvedCube, Object object) {
        MtmSolvedCube mtmSolvedCube2 = this.getMtmObjectFactory(mtmSolvedCube).createSolvedCube();
        return this.copyBaseCube(mtmSolvedCube2, mtmSolvedCube, object);
    }

    @Override
    public Object visitMtmUnsolvedCube(MtmUnsolvedCube mtmUnsolvedCube, Object object) {
        MtmUnsolvedCube mtmUnsolvedCube2 = this.getMtmObjectFactory(mtmUnsolvedCube).createUnsolvedCube();
        return this.copyBaseCube(mtmUnsolvedCube2, mtmUnsolvedCube, object);
    }

    @Override
    public Object visitMtmPartitionedCube(MtmPartitionedCube mtmPartitionedCube, Object object) {
        MtmPartitionedCube mtmPartitionedCube2 = this.getMtmObjectFactory(mtmPartitionedCube).createPartitionedCube();
        return this.copyCube(mtmPartitionedCube2, mtmPartitionedCube, object);
    }

    private MtmCubeDimensionality copyCubeDimensionality(MtmCubeDimensionality mtmCubeDimensionality, MtmCubeDimensionality mtmCubeDimensionality2, Object object) {
        this.copyExternalProperty(mtmCubeDimensionality, mtmCubeDimensionality2, object, MtmXMLTags.DIM_MAP);
        return (MtmCubeDimensionality)this.copyMtmObject(mtmCubeDimensionality, mtmCubeDimensionality2, object);
    }

    @Override
    public Object visitMtmUnsolvedCubeDimensionality(MtmUnsolvedCubeDimensionality mtmUnsolvedCubeDimensionality, Object object) {
        MtmUnsolvedCubeDimensionality mtmUnsolvedCubeDimensionality2 = this.getMtmObjectFactory(mtmUnsolvedCubeDimensionality).createUnsolvedCubeDimensionality();
        return this.copyCubeDimensionality(mtmUnsolvedCubeDimensionality2, mtmUnsolvedCubeDimensionality, object);
    }

    @Override
    public Object visitMtmSolvedETCubeDimensionality(MtmSolvedETCubeDimensionality mtmSolvedETCubeDimensionality, Object object) {
        MtmSolvedETCubeDimensionality mtmSolvedETCubeDimensionality2 = this.getMtmObjectFactory(mtmSolvedETCubeDimensionality).createSolvedETCubeDimensionality();
        return this.copyCubeDimensionality(mtmSolvedETCubeDimensionality2, mtmSolvedETCubeDimensionality, object);
    }

    @Override
    public Object visitMtmSolvedGroupingSetCubeDimensionality(MtmSolvedGroupingSetCubeDimensionality mtmSolvedGroupingSetCubeDimensionality, Object object) {
        MtmSolvedGroupingSetCubeDimensionality mtmSolvedGroupingSetCubeDimensionality2 = this.getMtmObjectFactory(mtmSolvedGroupingSetCubeDimensionality).createSolvedGroupingSetCubeDimensionality();
        return this.copyCubeDimensionality(mtmSolvedGroupingSetCubeDimensionality2, mtmSolvedGroupingSetCubeDimensionality, object);
    }

    @Override
    public Object visitMtmSolvedRollupCubeDimensionality(MtmSolvedRollupCubeDimensionality mtmSolvedRollupCubeDimensionality, Object object) {
        MtmSolvedRollupCubeDimensionality mtmSolvedRollupCubeDimensionality2 = this.getMtmObjectFactory(mtmSolvedRollupCubeDimensionality).createSolvedRollupCubeDimensionality();
        return this.copyCubeDimensionality(mtmSolvedRollupCubeDimensionality2, mtmSolvedRollupCubeDimensionality, object);
    }

    private MtmAggregationStep copyAggregationStep(MtmAggregationStep mtmAggregationStep, MtmAggregationStep mtmAggregationStep2, Object object) {
        this.copyExternalProperty(mtmAggregationStep, mtmAggregationStep2, object, MtmXMLTags.DIM_MAP_REF);
        return (MtmAggregationStep)this.copyMtmObject(mtmAggregationStep, mtmAggregationStep2, object);
    }

    @Override
    public Object visitMtmNoAggregationStep(MtmNoAggregationStep mtmNoAggregationStep, Object object) {
        MtmNoAggregationStep mtmNoAggregationStep2 = this.getMtmObjectFactory(mtmNoAggregationStep).createNoAggregationStep();
        return this.copyAggregationStep(mtmNoAggregationStep2, mtmNoAggregationStep, object);
    }

    @Override
    public Object visitMtmSimpleAggregationStep(MtmSimpleAggregationStep mtmSimpleAggregationStep, Object object) {
        MtmSimpleAggregationStep mtmSimpleAggregationStep2 = this.getMtmObjectFactory(mtmSimpleAggregationStep).createSimpleAggregationStep();
        return this.copyAggregationStep(mtmSimpleAggregationStep2, mtmSimpleAggregationStep, object);
    }

    @Override
    public Object visitMtmWeightedAverageAggregationStep(MtmWeightedAverageAggregationStep mtmWeightedAverageAggregationStep, Object object) {
        MtmWeightedAverageAggregationStep mtmWeightedAverageAggregationStep2 = this.getMtmObjectFactory(mtmWeightedAverageAggregationStep).createWeightedAverageAggregationStep();
        return this.copyAggregationStep(mtmWeightedAverageAggregationStep2, mtmWeightedAverageAggregationStep, object);
    }

    @Override
    public Object visitMtmFirstLastAggregationStep(MtmFirstLastAggregationStep mtmFirstLastAggregationStep, Object object) {
        MtmFirstLastAggregationStep mtmFirstLastAggregationStep2 = this.getMtmObjectFactory(mtmFirstLastAggregationStep).createFirstLastAggregationStep();
        return this.copyAggregationStep(mtmFirstLastAggregationStep2, mtmFirstLastAggregationStep, object);
    }

    @Override
    public Object visitMtmAggregationSpecification(MtmAggregationSpecification mtmAggregationSpecification, Object object) {
        MtmAggregationSpecification mtmAggregationSpecification2 = this.getMtmObjectFactory(mtmAggregationSpecification).createAggregationSpecification();
        return this.copyMtmObject(mtmAggregationSpecification2, mtmAggregationSpecification, object);
    }

    @Override
    public Object visitMtmRDBMSColumnExpression(MtmRDBMSColumnExpression mtmRDBMSColumnExpression, Object object) {
        MtmRDBMSColumnExpression mtmRDBMSColumnExpression2 = this.getMtmObjectFactory(mtmRDBMSColumnExpression).createRDBMSColumnExpression();
        return this.copyMtmObject(mtmRDBMSColumnExpression2, mtmRDBMSColumnExpression, object);
    }

    @Override
    public Object visitMtmAWColumnExpression(MtmAWColumnExpression mtmAWColumnExpression, Object object) {
        MtmAWColumnExpression mtmAWColumnExpression2 = this.getMtmObjectFactory(mtmAWColumnExpression).createAWColumnExpression();
        return this.copyMtmObject(mtmAWColumnExpression2, mtmAWColumnExpression, object);
    }

    @Override
    public Object visitMtmCompoundExpression(MtmCompoundExpression mtmCompoundExpression, Object object) {
        MtmCompoundExpression mtmCompoundExpression2 = this.getMtmObjectFactory(mtmCompoundExpression).createCompoundExpression();
        return this.copyMtmObject(mtmCompoundExpression2, mtmCompoundExpression, object);
    }

    @Override
    public Object visitMtmLiteralExpression(MtmLiteralExpression mtmLiteralExpression, Object object) {
        MtmLiteralExpression mtmLiteralExpression2 = this.getMtmObjectFactory(mtmLiteralExpression).createLiteralExpression();
        return this.copyMtmObject(mtmLiteralExpression2, mtmLiteralExpression, object);
    }

    @Override
    public Object visitMtmCompoundTable(MtmCompoundTable mtmCompoundTable, Object object) {
        MtmCompoundTable mtmCompoundTable2 = this.getMtmObjectFactory(mtmCompoundTable).createCompoundTable();
        return this.copyMtmObject(mtmCompoundTable2, mtmCompoundTable, object);
    }

    @Override
    public Object visitMtmSelectStatement(MtmSelectStatement mtmSelectStatement, Object object) {
        MtmSelectStatement mtmSelectStatement2 = this.getMtmObjectFactory(mtmSelectStatement).createSelectStatement();
        return this.copyMtmObject(mtmSelectStatement2, mtmSelectStatement, object);
    }

    @Override
    public Object visitMtmAWView(MtmAWView mtmAWView, Object object) {
        MtmAWView mtmAWView2 = this.getMtmObjectFactory(mtmAWView).createAWView();
        return this.copyMtmObject(mtmAWView2, mtmAWView, object);
    }

    @Override
    public Object visitMtmRdbmsTableOrView(MtmRdbmsTableOrView mtmRdbmsTableOrView, Object object) {
        MtmRdbmsTableOrView mtmRdbmsTableOrView2 = this.getMtmObjectFactory(mtmRdbmsTableOrView).createRdbmsTableOrView();
        return this.copyMtmObject(mtmRdbmsTableOrView2, mtmRdbmsTableOrView, object);
    }

    @Override
    public Object visitMtmCustomExpression(MtmCustomExpression mtmCustomExpression, Object object) {
        MtmCustomExpression mtmCustomExpression2 = this.getMtmObjectFactory(mtmCustomExpression).createCustomExpression();
        return this.copyMtmObject(mtmCustomExpression2, mtmCustomExpression, object);
    }

    @Override
    public Object visitMtmDimensionOrderSpecification(MtmDimensionOrderSpecification mtmDimensionOrderSpecification, Object object) {
        MtmDimensionOrderSpecification mtmDimensionOrderSpecification2 = this.getMtmObjectFactory(mtmDimensionOrderSpecification).createDimensionOrderSpecification();
        return this.copyMtmObject(mtmDimensionOrderSpecification2, mtmDimensionOrderSpecification, object);
    }

    private void copyExternalProperty(MtmObject mtmObject, MtmObject mtmObject2, Object object, XMLTag xMLTag) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        mtmObject2.copyPropertyTo(mtmObject, xMLTag, copyPolicy, CopyPolicy.EXTERNAL_REFERENCE_TYPE);
    }

    private void copyUpProperty(MtmObject mtmObject, MtmObject mtmObject2, Object object, XMLTag xMLTag) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        mtmObject2.copyPropertyTo(mtmObject, xMLTag, copyPolicy, CopyPolicy.UP_REFERENCE_TYPE);
    }

    private void copyRemainingProperties(MtmObject mtmObject, MtmObject mtmObject2, Object object) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        copyPolicy.registerCopy(mtmObject2, mtmObject);
        mtmObject2.copyAllPropertiesTo(mtmObject, copyPolicy, CopyPolicy.DOWN_REFERENCE_TYPE);
    }

    private void copyMeasureMappings(MtmBaseCube mtmBaseCube, MtmBaseCube mtmBaseCube2, Object object) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        List list = mtmBaseCube2.getMeasureMaps();
        if (list.isEmpty()) {
            list = mtmBaseCube2.getPartitionedCube().getMeasureMaps();
        }
        for (MtmMeasureMap mtmMeasureMap : list) {
            MtmMeasureMap mtmMeasureMap2 = (MtmMeasureMap)copyPolicy.getCopy(mtmMeasureMap);
            MtmValueExpression mtmValueExpression = mtmMeasureMap.getMappedExpression(mtmBaseCube2);
            if (mtmValueExpression == null) continue;
            mtmMeasureMap2.setMappedExpression(mtmBaseCube, (MtmValueExpression)copyPolicy.copyDownReference(mtmValueExpression));
        }
    }

    private void copyAttributeMappings(MtmDimensionMap mtmDimensionMap, MtmDimensionMap mtmDimensionMap2, Object object) {
        CopyPolicy copyPolicy = (CopyPolicy)object;
        MdmDimension mdmDimension = (MdmDimension)mtmDimensionMap2.getMdmSource();
        MdmPrimaryDimension mdmPrimaryDimension = mdmDimension.getPrimaryDimension();
        ArrayList arrayList = new ArrayList();
        MdmDimension mdmDimension2 = mdmDimension;
        do {
            arrayList.addAll(mdmDimension2.getAttributes());
        } while ((mdmDimension2 = mdmDimension2.getEnclosingDimension()) != null);
        for (MdmAttribute mdmAttribute : arrayList) {
            if (mdmAttribute.getAttributeMap() instanceof MtmDerivedAttributeMap) continue;
            MtmStoredAttributeMap mtmStoredAttributeMap = (MtmStoredAttributeMap)mdmAttribute.getAttributeMap();
            MtmStoredAttributeMap mtmStoredAttributeMap2 = (MtmStoredAttributeMap)copyPolicy.getCopy(mtmStoredAttributeMap);
            MtmValueExpression mtmValueExpression = mtmStoredAttributeMap.getMappedExpression(mtmDimensionMap2);
            if (mtmValueExpression == null) continue;
            mtmStoredAttributeMap2.setMappedExpression(mtmDimensionMap, (MtmValueExpression)copyPolicy.copyDownReference(mtmValueExpression));
        }
    }

    private MtmObjectFactory getMtmObjectFactory(MtmObject mtmObject) {
        return ((MdmMetadataProvider)mtmObject.getBaseMetadataProvider()).getMtmObjectFactory();
    }
}

