/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.AggregateOverClause;
import oracle.olapi.syntax.Expression;
import oracle.olapi.syntax.FunctionArgument;
import oracle.olapi.syntax.FunctionDescriptor;
import oracle.olapi.syntax.FunctionDescriptorCatalog;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.TypedExpression;
import oracle.olapi.syntax.ValidationContext;

public final class AggregationFunctionExpression
extends TypedExpression {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;
    private AggregateOverClause m_OverClause;
    private String m_OperatorName = null;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("AGGREGATE");
        Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
        syntaxPrintingContext.append(" OVER (");
        syntaxPrintingContext.print(this.getOverClause());
        syntaxPrintingContext.append(")");
        if (this.getOperatorName() != null && this.getOperatorName().length() > 0 && syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("1.2")) {
            syntaxPrintingContext.append(" OPERATOR " + this.getOperatorName());
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        FunctionArgument[] functionArgumentArray = new FunctionArgument[this.getArgumentsInternal().length];
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), functionArgumentArray, null, null, 512, "UnknownAggregationFunction", validationContext);
        this.m_Arguments = functionArgumentArray;
        this.m_OverClause = (AggregateOverClause)validationContext.validate(this.m_OverClause);
        validationContext.pop();
        this.setDataType(validationContext.getCurrentDataType());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getArgumentsInternal());
    }

    private AggregationFunctionExpression(String string, FunctionArgument[] functionArgumentArray, AggregateOverClause aggregateOverClause, boolean bl) {
        AggregationFunctionExpression.validateValue(string);
        this.m_FunctionName = "AGGREGATE";
        if (!string.equalsIgnoreCase("AGGREGATE")) {
            AggregationFunctionExpression.validateEnum(string, new String[]{"SUM", "AVG", "MAX", "MIN"});
            this.m_OperatorName = string.toUpperCase();
        }
        AggregationFunctionExpression.validateValue(aggregateOverClause);
        this.m_OverClause = aggregateOverClause;
        this.m_Arguments = bl ? (FunctionArgument[])functionArgumentArray.clone() : functionArgumentArray;
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitAggregationFunctionExpression(this, object);
    }

    public AggregationFunctionExpression(String string, FunctionArgument functionArgument, AggregateOverClause aggregateOverClause) {
        this(string, new FunctionArgument[]{functionArgument}, aggregateOverClause, true);
    }

    public AggregationFunctionExpression(String string, List<FunctionArgument> list, AggregateOverClause aggregateOverClause) {
        this(string, AggregationFunctionExpression.getFunctionArgumentArrayClone(list), aggregateOverClause, false);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }

    public String getOperatorName() {
        return this.m_OperatorName;
    }

    public AggregateOverClause getOverClause() {
        return this.m_OverClause;
    }
}

