/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.syntax;

import java.util.List;
import oracle.olapi.syntax.BuildCommand;
import oracle.olapi.syntax.MaintainDimensionCommand;
import oracle.olapi.syntax.OrderByClause;
import oracle.olapi.syntax.SyntaxObject;
import oracle.olapi.syntax.SyntaxObjectVisitor;
import oracle.olapi.syntax.SyntaxPrintingContext;
import oracle.olapi.syntax.ValidationContext;

public class BuildSpecification
extends SyntaxObject {
    public static final int AS_OF_CURRENT_SCN = 1;
    public static final int AS_OF_BUILD_SCN = 2;
    private BuildCommand[] m_Commands;
    private String m_Name;
    private OrderByClause m_OrderByClause;
    private int m_Flags = 0;

    private BuildCommand[] getCommandsInternal() {
        return this.m_Commands;
    }

    private BuildSpecification(String string, BuildCommand[] buildCommandArray, boolean bl, OrderByClause orderByClause, int n) {
        this.m_Name = string;
        this.m_OrderByClause = orderByClause;
        this.m_Flags = n;
        if (!this.isShellOnly()) {
            BuildSpecification.validateValues(buildCommandArray, 1);
        }
        this.m_Commands = bl && null != buildCommandArray ? (BuildCommand[])buildCommandArray.clone() : buildCommandArray;
        this.initialize();
    }

    private static BuildCommand[] createBuildCommandArray(List<BuildCommand> list) {
        if (null == list) {
            return null;
        }
        BuildCommand[] buildCommandArray = new BuildCommand[list.size()];
        list.toArray(buildCommandArray);
        return buildCommandArray;
    }

    private boolean isShellOnly() {
        return null == this.getCommandsInternal() && (null != this.getOrderByClause() || this.getFlags() > 0);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        if (null != this.getCommandsInternal()) {
            validationContext.validateComponents(this, this.getCommandsInternal());
        }
        if (null != this.getOrderByClause()) {
            validationContext.validate(this.getOrderByClause());
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (null != this.getOrderByClause() && !this.getOrderByClause().isDefinitionComplete()) {
            return false;
        }
        if (this.isShellOnly()) {
            return true;
        }
        return this.areComponentsComplete(this.getCommandsInternal());
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("BUILD SPEC ");
        syntaxPrintingContext.append(this.getName());
        this.printCommands(syntaxPrintingContext);
        if (syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.1")) {
            if (null != this.getOrderByClause()) {
                syntaxPrintingContext.print(this.getOrderByClause());
            }
            if ((this.getFlags() & 1) > 0) {
                syntaxPrintingContext.append(" AS OF CURRENT SCN");
            } else if ((this.getFlags() & 2) > 0) {
                syntaxPrintingContext.append(" AS OF BUILD SCN");
            }
        }
    }

    void addToBuildItem(SyntaxPrintingContext syntaxPrintingContext) {
        if (null != this.getCommandsInternal()) {
            syntaxPrintingContext.append(" USING ");
            this.printCommands(syntaxPrintingContext);
        }
        if (syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.1")) {
            if (null != this.getOrderByClause()) {
                syntaxPrintingContext.append(" ");
                syntaxPrintingContext.print(this.getOrderByClause());
            }
            if ((this.getFlags() & 1) > 0) {
                syntaxPrintingContext.append(" AS OF CURRENT SCN");
            } else if ((this.getFlags() & 2) > 0) {
                syntaxPrintingContext.append(" AS OF BUILD SCN");
            }
        }
    }

    void printCommands(SyntaxPrintingContext syntaxPrintingContext) {
        if (null == this.getCommandsInternal()) {
            return;
        }
        syntaxPrintingContext.decrementIndent();
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.incrementIndent();
        syntaxPrintingContext.append("(");
        int n = 0;
        for (int i = 0; i < this.getCommandsInternal().length; ++i) {
            if (!syntaxPrintingContext.isMetadataXMLVersionSameOrLaterThan("2.0") && this.getCommandsInternal()[i] instanceof MaintainDimensionCommand) continue;
            if (0 != n) {
                syntaxPrintingContext.append(", ");
            }
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.print(this.getCommandsInternal()[i]);
            ++n;
        }
        if (n == 0) {
            syntaxPrintingContext.newLineAndIndent();
            syntaxPrintingContext.append("COMPILE");
        }
        syntaxPrintingContext.decrementIndent();
        syntaxPrintingContext.newLineAndIndent();
        syntaxPrintingContext.append(")");
        syntaxPrintingContext.incrementIndent();
    }

    public BuildSpecification(String string, BuildCommand[] buildCommandArray) {
        this(string, buildCommandArray, true, null, 0);
    }

    public BuildSpecification(String string, List<BuildCommand> list) {
        this(string, list, null, 0);
    }

    public BuildSpecification(String string, List<BuildCommand> list, OrderByClause orderByClause) {
        this(string, list, orderByClause, 0);
    }

    public BuildSpecification(String string, List<BuildCommand> list, OrderByClause orderByClause, int n) {
        this(string, BuildSpecification.createBuildCommandArray(list), false, orderByClause, n);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitBuildSpecification(this, object);
    }

    public BuildCommand[] getCommands() {
        return (BuildCommand[])this.getCommandsInternal().clone();
    }

    public String getName() {
        return this.m_Name;
    }

    public OrderByClause getOrderByClause() {
        return this.m_OrderByClause;
    }

    public boolean isOrderByOnly() {
        return null != this.getOrderByClause() && null == this.getCommandsInternal();
    }

    public int getFlags() {
        return this.m_Flags;
    }
}

