/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataArrayInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataInfo;
import oracle.jdevimpl.debugger.support.DebugArrayElementInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;

final class DebugJDIArrayElementInfo
implements DebugArrayElementInfo {
    DebugJDI dj;
    int stoppedCount;
    DebugJDIClassInfo clazz;
    int index;
    DebugJDIDataInfo data;
    DebugJDIDataArrayInfo array;
    private int hashCode;

    DebugJDIArrayElementInfo(DebugJDI dj, DebugJDIClassInfo clazz, int index, DebugJDIDataInfo data, DebugJDIDataArrayInfo array) {
        this.dj = dj;
        this.stoppedCount = dj.stoppedCount;
        this.clazz = clazz;
        this.index = index;
        this.data = data;
        this.array = array;
        data.owner = this;
    }

    public boolean hasExpired() {
        return this.dj.stoppedCount != this.stoppedCount;
    }

    public DebugClassInfo getClassInfo() {
        return this.clazz;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return "[" + this.index + "]";
    }

    public DebugDataInfo getDataInfo() {
        return this.data;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.clazz.hashCode() + this.index;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof DebugJDIArrayElementInfo) {
            DebugJDIArrayElementInfo other = (DebugJDIArrayElementInfo)o;
            return this.clazz.equals((Object)other.clazz) && this.index == other.index && (this.data == null ? other.data == null : this.data.equals((Object)other.data));
        }
        return false;
    }
}

