/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.jdi.request.WatchpointRequest;
import java.util.List;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpoint;
import oracle.jdevimpl.debugger.support.DebugBreakpointWatchpoint;

final class DebugJDIBreakpointWatchpoint
extends DebugJDIBreakpoint
implements DebugBreakpointWatchpoint {
    private String classname;
    private String fieldname;
    private boolean access;
    private boolean modify;

    DebugJDIBreakpointWatchpoint(DebugJDI dj, String classname, String fieldname, boolean access, boolean modify) {
        super(dj);
        this.classname = classname;
        this.fieldname = fieldname;
        this.access = access;
        this.modify = modify;
    }

    public String getWatchpointClassname() {
        return this.classname;
    }

    public String getWatchpointFieldname() {
        return this.fieldname;
    }

    public boolean getAccess() {
        return this.access;
    }

    public boolean getModify() {
        return this.modify;
    }

    public void setWatchpoint(String classname, String fieldname, boolean access, boolean modify) {
        if (ModelUtil.areDifferent((Object)this.classname, (Object)classname) || ModelUtil.areDifferent((Object)this.fieldname, (Object)fieldname) || this.access != access || this.modify != modify) {
            this.prepareForChange();
            this.classname = classname;
            this.fieldname = fieldname;
            this.access = access;
            this.modify = modify;
            this.afterChange();
        }
    }

    @Override
    String getClassPrepareFilter() {
        return this.classname;
    }

    @Override
    boolean verify(ReferenceType rt, String rtName) {
        if (this.classname.equals(rtName)) {
            this.classIdentified(rt);
            return true;
        }
        return false;
    }

    private void classIdentified(ReferenceType rt) {
        List<Field> fields = rt.fields();
        if (fields != null) {
            for (Field field : fields) {
                WatchpointRequest er2;
                if (!this.fieldname.equals(field.name())) continue;
                if (this.access) {
                    try {
                        er2 = this.dj.erm.createAccessWatchpointRequest(field);
                        this.setOptions(er2);
                        this.addRequest(er2);
                    }
                    catch (UnsupportedOperationException er2) {
                        // empty catch block
                    }
                }
                if (!this.modify) continue;
                try {
                    er2 = this.dj.erm.createModificationWatchpointRequest(field);
                    this.setOptions(er2);
                    this.addRequest(er2);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
    }

    @Override
    protected ObjectReference getInstanceForEvent(Event e, ThreadReference tr) {
        if (e instanceof WatchpointEvent) {
            WatchpointEvent we = (WatchpointEvent)e;
            return we.object();
        }
        return null;
    }
}

