/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.helper;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Stack;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.helper.TranslationMetaData;
import oracle.dbtools.migration.translation.api.components.Block;
import oracle.dbtools.migration.translation.api.components.Cursor;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.components.Var;

public class QueryCursorHelper {
    private static final String CURSOR_VAR_NAME_PREFIX = "cv_";
    private static final String CURSOR_VAR_DATATYPE = "SYS_REFCURSOR";
    private ArrayList<Cursor> m_queryCursorList;
    private TranslationMetaData m_metadata;
    private Stack<CVBlock> m_cursorVarBlocks;
    private int m_idRunningNo;
    private int m_currentIdNo;

    public QueryCursorHelper(TranslationMetaData translationMetaData) {
        this.m_metadata = translationMetaData;
        this.m_idRunningNo = 0;
        this.m_currentIdNo = 0;
        this.m_cursorVarBlocks = new Stack();
        this.m_queryCursorList = new ArrayList();
    }

    public TranslationParameter addCursorVariable(AST aST, Block block) {
        String string = this.getCursorVariableName(aST);
        this.m_queryCursorList.add(new Cursor(aST, block, string, true));
        TranslationParameter translationParameter = new TranslationParameter();
        translationParameter.setName(string);
        translationParameter.setParamType("TYPE_OUTPUT");
        translationParameter.setDataType(new TranslationDataType(CURSOR_VAR_DATATYPE));
        translationParameter.setExtra(true);
        Block block2 = block;
        if (!block2.getBlockType().equals("CREATEOBJBLOCK")) {
            block2 = block2.getEnclosingBlockByType("CREATEOBJBLOCK");
        }
        translationParameter.setObjectBlock(block2);
        if (this.m_metadata.getTranslationHelper().getTranslationContext().getTranslationPreferences(null) != null && !this.m_metadata.getTranslationHelper().getTranslationContext().getTranslationPreferences(null).getImplicitResultSets()) {
            this.m_metadata.addTranslationParameter(translationParameter);
        } else {
            Block block3 = block.getTopAncestor();
            String string2 = "v_cursor";
            if (!this.m_metadata.hasVariable(string2, block3 = block3.getDescendentBlock("BEGINBLOCK", "BEGIN"))) {
                this.m_metadata.addVariable(new Var(string2, new TranslationDataType(CURSOR_VAR_DATATYPE), block3, aST));
            }
        }
        return translationParameter;
    }

    public String getCursorName(AST aST) {
        AST aST2 = null;
        String string = null;
        for (Cursor cursor : this.m_queryCursorList) {
            aST2 = cursor.getTree();
            if (aST.getLine() != aST2.getLine() || aST.getColumn() != aST2.getColumn()) continue;
            string = cursor.getName();
            break;
        }
        return string;
    }

    private String getCursorVariableName(AST aST) {
        Block block = ((ExtAST)aST).getBlock();
        boolean bl = false;
        if (this.m_cursorVarBlocks.isEmpty()) {
            this.m_currentIdNo = ++this.m_idRunningNo;
            Block block2 = this.getEnclosingControlBlock(block);
            if (block2 != null) {
                this.m_cursorVarBlocks.push(new CVBlock(block2, this.m_currentIdNo));
            }
        } else {
            Block block3;
            CVBlock cVBlock = null;
            while (!this.m_cursorVarBlocks.isEmpty()) {
                cVBlock = this.m_cursorVarBlocks.peek();
                block3 = cVBlock.getBlock();
                if (block3.hasAltBlock()) {
                    for (Block block4 : block3.getAltBlocks()) {
                        if (block4 != block.getParent() && !this.isDescendentBlock(block4, block)) continue;
                        this.m_cursorVarBlocks.pop();
                        this.m_currentIdNo = cVBlock.getCursorNo();
                        bl = true;
                        break;
                    }
                }
                if (!bl) {
                    if (this.isDescendentBlock(block3, block)) {
                        int n;
                        if (this.m_currentIdNo < this.m_idRunningNo) {
                            n = this.m_currentIdNo + 1;
                            this.m_currentIdNo = this.m_currentIdNo;
                        } else {
                            n = this.m_idRunningNo + 1;
                            this.m_idRunningNo = this.m_idRunningNo;
                        }
                        this.m_currentIdNo = n;
                        bl = true;
                    } else if (this.isInSameHierarchyTree(block3, block)) {
                        this.m_cursorVarBlocks.pop();
                        continue;
                    }
                }
                if (bl) break;
                this.m_cursorVarBlocks.pop();
                this.m_currentIdNo = cVBlock.getCursorNo() - 1;
            }
            if (!bl) {
                this.m_currentIdNo = ++this.m_idRunningNo;
            }
            if ((block3 = this.getEnclosingControlBlock(block)) != null && cVBlock.getBlock() != block3) {
                this.m_cursorVarBlocks.push(new CVBlock(block3, this.m_currentIdNo));
            }
        }
        return CURSOR_VAR_NAME_PREFIX + this.m_currentIdNo;
    }

    public boolean isRefCursorRequired(AST aST) {
        if (aST == null) {
            return false;
        }
        boolean bl = false;
        ExtAST extAST = (ExtAST)aST;
        Block block = extAST.getBlock();
        if (block != null && this.isInSubProgramDefinition(block) && !this.isWithinDeclaration(block) && !this.isWithinExpression(block) && !this.hasIntoClause(block)) {
            bl = true;
        }
        return bl;
    }

    private Block getEnclosingControlBlock(Block block) {
        Block block2 = null;
        for (Block block3 = block.getParent(); block3 != null; block3 = block3.getParent()) {
            if (!block3.getBlockType().equals("CONTROLBLOCK")) continue;
            block2 = block3;
            break;
        }
        return block2;
    }

    private boolean isInSameHierarchyTree(Block block, Block block2) {
        boolean bl = false;
        Block block3 = this.getEnclosingControlBlock(block2);
        for (Block block4 = block.getParent(); block4 != null; block4 = block4.getParent()) {
            if (block4 != block3) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isDescendentBlock(Block block, Block block2) {
        boolean bl = false;
        ArrayList<Block> arrayList = block.getChildren();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Block block3 = arrayList.get(i);
            if (block3 == block2) {
                bl = true;
                break;
            }
            if (!block3.hasChildren() || !this.isDescendentBlock(block3, block2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isInSubProgramDefinition(Block block) {
        Block block2 = block.getTopAncestor();
        return block2.getBlockType().equals("CREATEOBJBLOCK") && !block2.getBlockName().equalsIgnoreCase("VIEW");
    }

    private boolean isWithinDeclaration(Block block) {
        boolean bl = false;
        for (Block block2 = block.getParent(); block2 != null && !block2.getBlockType().equals("CREATEOBJBLOCK") && !block2.getBlockType().equals("GRAMMARROOTBLOCK"); block2 = block2.getParent()) {
            if (!block2.getBlockType().equals("STMTBLOCK") || !"DECLARE".equalsIgnoreCase(block2.getBlockName()) && !"SET".equalsIgnoreCase(block2.getBlockName())) continue;
            bl = true;
        }
        return bl;
    }

    private boolean isNested(Block block) {
        boolean bl = false;
        for (Block block2 = block.getParent(); block2 != null && !block2.getBlockType().equals("CREATEOBJBLOCK") && !block2.getBlockType().equals("GRAMMARROOTBLOCK"); block2 = block2.getParent()) {
            if (!block2.getBlockType().equals("STMTBLOCK") || !"SELECT".equalsIgnoreCase(block2.getBlockName())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isWithinExpression(Block block) {
        Block block2 = block.getParent();
        return block2 != null && block2.getBlockType().equals("OPERATIONBLOCK") || block.getBlockType().equals("OPERATIONBLOCK");
    }

    private boolean hasSubqueryFactorClause(Block block) {
        for (Block block2 = block.getParent(); block2 != null && block2.getBlockType().equals("STMTBLOCK"); block2 = block2.getParent()) {
            if (!block2.getAST().getText().equalsIgnoreCase("WITH")) continue;
            return true;
        }
        return false;
    }

    private boolean hasIntoClause(Block block) {
        boolean bl = false;
        for (Block block2 : block.getChildren()) {
            if ("CLAUSEBLOCK".equals(block2.getBlockType()) && "INTO".equalsIgnoreCase(block2.getBlockName())) {
                return true;
            }
            if (block2.getChildren() == null || block2.getChildren().size() <= 0 || !(bl = this.hasIntoClause(block2))) continue;
            return true;
        }
        return false;
    }

    class CVBlock {
        private Block m_ctrlBlock;
        private int m_cursorNo;

        public CVBlock(Block block, int n) {
            this.m_ctrlBlock = block;
            this.m_cursorNo = n;
        }

        public int getCursorNo() {
            return this.m_cursorNo;
        }

        public Block getBlock() {
            return this.m_ctrlBlock;
        }
    }
}

