/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph;

import java.awt.Point;
import oracle.bali.dbUI.graph.NodeComponent;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.share.thread.Timer;

class NodeAutoScroller
implements Runnable {
    private static final int _INITIAL_SCROLLING_DELAY = 400;
    private static final int _REPEAT_SCROLLING_DELAY = 200;
    private static NodeAutoScroller _sAutoScroller;
    private Timer _timer = new Timer((Runnable)this, "NodeAutoScroller");
    private Grid _scrollee;
    private NodeComponent _node;
    private boolean _vDecrease;
    private boolean _cancel;
    private boolean _scheduled;

    public static NodeAutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new NodeAutoScroller();
        }
        return _sAutoScroller;
    }

    public void schedule(NodeComponent scrollee, boolean verticalDecrease) {
        this._node = scrollee;
        this._scrollee = scrollee.getSpreadTable().getGrid();
        this._vDecrease = verticalDecrease;
        this._cancel = false;
        if (this._scheduled) {
            return;
        }
        this._scheduled = true;
        this._timer.schedule(400L);
    }

    public void cancel() {
        this._timer.cancel();
        this._scheduled = false;
        this._cancel = true;
    }

    public void cancel(NodeComponent possibleTarget) {
        if (this._node == possibleTarget) {
            this.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._cancel) {
            return;
        }
        Point origin = this._scrollee.getCanvasOrigin();
        boolean scrolledVertical = false;
        this._scrollee.freezeRepaints();
        try {
            int rowIndex = -1;
            if (this._vDecrease) {
                rowIndex = this._scrollee.getRowAt(-origin.y);
                if (rowIndex != -1) {
                    rowIndex = this._scrollee.getPreviousVisibleRow(rowIndex);
                }
            } else {
                int pos = -origin.y + this._scrollee.getInnerSize().height;
                rowIndex = this._scrollee.getRowAt(pos);
                if (rowIndex != -1) {
                    rowIndex = this._scrollee.getNextVisibleRow(rowIndex);
                }
            }
            if (rowIndex != -1) {
                this._scrollee.scrollRowIntoView(rowIndex);
                this._node.locationChanged();
                scrolledVertical = true;
            }
        }
        finally {
            this._scrollee.unfreezeRepaints();
        }
        if (scrolledVertical) {
            this._timer.schedule(200L);
        } else {
            this._scheduled = false;
        }
    }

    private NodeAutoScroller() {
    }
}

