/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

class JLECaptionTile
extends AbstractPainter {
    private static Painter _sPainter;
    private static final int _NORMAL_HEIGHT = 12;

    private JLECaptionTile() {
    }

    public static Painter getPainter() {
        if (_sPainter == null) {
            _sPainter = new JLECaptionTile();
        }
        return _sPainter;
    }

    public int getRepaintFlags(PaintContext context) {
        return 2;
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        return new Dimension(availableWidth, 12);
    }

    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(0, 12);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        UIDefaults defaults = context.getPaintUIDefaults();
        Color dark = Color.black;
        Color light = defaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        boolean armed = (context.getPaintState() & 2) != 0;
        int right = x + width - 1;
        if (x % 4 != 0) {
            x -= x % 4;
        }
        while (x < right) {
            if (x % 8 == 0) {
                if (right - x >= 4) {
                    this._drawDot(g, x, y, dark, light, armed);
                    this._drawDot(g, x, y + 8, dark, light, armed);
                }
            } else if (right - x >= 8) {
                this._drawDot(g, x, y + 4, dark, light, armed);
            }
            x += 4;
        }
    }

    private void _drawDot(Graphics g, int x, int y, Color dark, Color light, boolean armed) {
        if (armed) {
            g.setColor(dark);
            g.drawLine(x + 1, y, x + 1, y);
            g.drawLine(x, y + 1, x, y + 1);
            g.setColor(light);
            g.drawLine(x + 2, y + 1, x + 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 2, y + 2);
        } else {
            g.setColor(dark);
            g.drawLine(x + 2, y + 3, x + 2, y + 3);
            g.drawLine(x + 3, y + 2, x + 3, y + 2);
            g.setColor(light);
            g.drawLine(x + 1, y + 1, x + 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
        }
    }
}

