/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.graph.jle;

import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.bali.dbUI.graph.jle.GraphCanvas;
import oracle.bali.dbUI.graph.jle.NodeFocusManager;
import oracle.bali.jle.GlassPane;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.ComponentItem;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;

class NodeGlassPane
extends GlassPane {
    public static final Object TOOLTIP_KEY = new StringKey("TOOLTIP_KEY");

    public NodeGlassPane(GraphCanvas canvas) {
        super((JLECanvas)canvas);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        FocusManager.setCurrentManager(new NodeFocusManager(canvas));
    }

    public String getToolTipText(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        JLECanvas canvas = this.getCanvas();
        Point origin = new Point(0, 0);
        Point2D content = canvas.deviceToContent((double)(x - origin.x), (double)(y - origin.y));
        for (LayoutItem found = canvas.getHitItem(content.getX(), content.getY()); found != null; found = found.getItemParent()) {
            Point2D p;
            String tooltipValue;
            Object result = found.getProperty(TOOLTIP_KEY);
            if (result != PropertyManager.NOT_FOUND_OBJECT && result != null && !"".equals(result)) {
                return (String)result;
            }
            if (!(found instanceof ComponentItem) || (tooltipValue = ((ComponentItem)found).getToolTipText((p = ItemUtils.deviceToItem((LayoutItem)found, (double)(x - origin.x), (double)(y - origin.y))).getX(), p.getY())) == null || "".equals(tooltipValue)) continue;
            return tooltipValue;
        }
        return null;
    }
}

