/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.laf;

import java.awt.Graphics;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

class FocusPainter
extends AbstractBorderPainter {
    private ImmInsets _insets = null;
    private boolean _drawVertical;
    private static final ImmInsets _sInsets = new ImmInsets(2, 0, 2, 0);
    private static FocusPainter _sPainter;

    public static BorderPainter getPainter() {
        if (_sPainter == null) {
            _sPainter = new FocusPainter();
        }
        return _sPainter;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        return this._insets == null ? _sInsets : this._insets;
    }

    protected ImmInsets getOwnFillInsets(PaintContext context) {
        return ImmInsets.getEmptyInsets();
    }

    public Painter getContentPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Object contentPainter = super.getContentPainterAt(context, availableWidth, availableHeight, x, y, proxyPainter);
        if (proxyPainter == this && contentPainter != null || contentPainter == null && x >= 0 && y >= 0 && x < availableWidth && y < availableHeight) {
            contentPainter = this;
        }
        return contentPainter;
    }

    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        if ((context.getPaintState() & 0x40) != 0) {
            if (this._drawVertical) {
                this._drawVFocusLine(g, x, y, height);
                this._drawVFocusLine(g, x + width - 1, y, height);
            } else {
                this._drawFocusLine(g, x, y, width);
                this._drawFocusLine(g, x, y + height - 1, width);
            }
        }
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x20;
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    private void _drawFocusLine(Graphics g, int x, int y, int width) {
        int numDashes = width / 3;
        int intWidth = numDashes * 3;
        int endX = x + intWidth;
        while (x < endX) {
            g.drawLine(x, y, x + 1, y);
            x += 3;
        }
        if ((width -= intWidth) > 0) {
            if (width > 2) {
                width = 2;
            }
            g.drawLine(x, y, x + width - 1, y);
        }
    }

    private void _drawVFocusLine(Graphics g, int x, int y, int height) {
        int numDashes = height / 3;
        int intHeight = numDashes * 3;
        int endY = y + intHeight;
        while (y < endY) {
            g.drawLine(x, y, x, y + 1);
            y += 3;
        }
        if ((height -= intHeight) > 0) {
            if (height > 2) {
                height = 2;
            }
            g.drawLine(x, y, x, y + height - 1);
        }
    }

    private FocusPainter() {
    }
}

