/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractOLAPDDLAction;
import oracle.olap.actions.OLAPActionDDLPanel;

public class ConfirmDialog
extends JDialog
implements ActionListener {
    private ConfirmDialog currentInstance = null;
    private String owner;
    private String currentName;
    private boolean m_clickedOK = false;
    private final String OK_COMMAND = "OK_ID";
    private final String CANCEL_COMMAND = "CANCEL_ID";
    private final String HELP_COMMAND = "HELP_ID";
    private JPanel promptPanel;
    private JButton m_btnOK;
    private JButton m_btnCancel;
    private JButton m_btnHelp;
    private JLabel lblObjName;
    private JTextField objectName;
    private JTextField ownerName;
    private OLAPActionDDLPanel sqlPanel;
    private AbstractOLAPDDLAction olapDDLAction;
    private String helpID;
    private JTabbedPane tabs;
    private static final int SQL_TAB = 1;

    public ConfirmDialog(Frame frame, String string, String string2, String string3, String string4, AbstractOLAPDDLAction abstractOLAPDDLAction) {
        super(frame, string, true);
        this.setName("ConfirmDialog");
        this.currentInstance = this;
        this.owner = string3;
        this.helpID = string2;
        this.currentName = string4;
        this.olapDDLAction = abstractOLAPDDLAction;
        this.initDialog();
        this.initializeFields();
    }

    private void initDialog() {
        this.initComponents();
        this.layoutComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.promptPanel, this.helpID);
        this.registerKeyboardActions();
    }

    private void initComponents() {
        this.m_btnOK = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_APPLY_BUTTON_TEXT")));
        this.m_btnOK.setName("m_btnOK");
        this.m_btnOK.setActionCommand("OK_ID");
        this.m_btnOK.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_APPLY_BUTTON_TEXT")));
        this.m_btnOK.addActionListener(this);
        this.m_btnCancel = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.setName("m_btnCancel");
        this.m_btnCancel.setActionCommand("CANCEL_ID");
        this.m_btnCancel.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_CANCEL_BUTTON_TEXT")));
        this.m_btnCancel.addActionListener(this);
        this.m_btnHelp = new JButton(StringUtils.stripMnemonic((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.setName("m_btnHelp");
        this.m_btnHelp.setActionCommand("HELP_ID");
        this.m_btnHelp.setMnemonic(StringUtils.getMnemonicKeyCode((String)OLAPArb.get("DIALOG_HELP_BUTTON_TEXT")));
        this.m_btnHelp.addActionListener(this);
        this.getRootPane().setDefaultButton(this.m_btnOK);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.tabs = new JTabbedPane();
        this.promptPanel = new JPanel(new GridBagLayout());
        this.promptPanel.setName("mainPanel");
        this.promptPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        JLabel jLabel = new JLabel(OLAPArb.getString("RENAME_DIALOG_OWNER_LABEL"));
        jLabel.setName("lblOwner");
        this.promptPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.ownerName = new JTextField(1024);
        this.ownerName.setName("ownerName");
        this.ownerName.setMinimumSize(new Dimension(250, 20));
        this.promptPanel.add((Component)this.ownerName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        this.lblObjName = new JLabel(OLAPArb.getString("DESCRIPTION_PANEL_NAME_LABEL"));
        this.lblObjName.setName("lblObjName");
        this.promptPanel.add((Component)this.lblObjName, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.objectName = new JTextField(1024);
        this.objectName.setName("objectName");
        this.objectName.setMinimumSize(new Dimension(250, 20));
        this.promptPanel.add((Component)this.objectName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        JLabel jLabel2 = new JLabel(this.olapDDLAction.getConfirmMessage(this.currentName));
        jLabel2.setName("lblConfirmMsg");
        this.promptPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.promptPanel.add((Component)new JPanel(), gridBagConstraints);
        DialogButtonBar dialogButtonBar = new DialogButtonBar();
        dialogButtonBar.add((Component)this.m_btnHelp, DialogButtonBar.CONSTRAINT_HELP);
        dialogButtonBar.add((Component)this.m_btnOK, DialogButtonBar.CONSTRAINT_APPLY);
        dialogButtonBar.add((Component)this.m_btnCancel, DialogButtonBar.CONSTRAINT_CANCEL);
        this.tabs.add(OLAPArb.getString("RENAME_DIALOG_PROMPTS_TAB"), this.promptPanel);
        this.sqlPanel = new OLAPActionDDLPanel();
        this.tabs.add(OLAPArb.getString("MAP_PANEL_QUERY_TAB"), this.sqlPanel);
        this.add((Component)this.tabs, new GridBagConstraints(0, 0, 1, 4, 1.0, 0.9, 10, 1, new Insets(5, 5, 0, 5), 5, 0));
        this.add((Component)dialogButtonBar, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.1, 10, 2, new Insets(0, 5, 0, 5), 5, 0));
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ConfirmDialog.this.tabs.getSelectedIndex() == 1) {
                    try {
                        ConfirmDialog.this.sqlPanel.setDDLText(ConfirmDialog.this.olapDDLAction.getOLAPDDLStatements());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this, "CANCEL_ID", KeyStroke.getKeyStroke(27, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this, "HELP_ID", KeyStroke.getKeyStroke(156, 0), 1);
    }

    private void initializeFields() {
        this.ownerName.setText(this.owner);
        this.ownerName.setEnabled(false);
        if (this.currentName == null) {
            this.lblObjName.setVisible(false);
            this.objectName.setVisible(false);
        } else {
            this.objectName.setVisible(true);
            this.objectName.setText(this.currentName);
        }
        this.objectName.setEnabled(false);
    }

    public boolean isOKSelected() {
        return this.m_clickedOK;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equalsIgnoreCase("OK_ID")) {
            if (this.validateFields()) {
                this.m_clickedOK = true;
                this.currentInstance.setVisible(false);
            }
        } else if (string.equalsIgnoreCase("CANCEL_ID")) {
            this.m_clickedOK = false;
            this.currentInstance.setVisible(false);
        } else if (string.equalsIgnoreCase("HELP_ID")) {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.promptPanel);
        }
    }

    private boolean validateFields() {
        return true;
    }
}

