/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.olap.actions.AbstractLangDescXMLGenerator;
import oracle.olap.app.olapmetadata.Cube;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.cube.model.CubeCalculatedMeasure;
import oracle.olap.cube.model.CubeMeasure;
import oracle.olap.db.model.AbstractChildObjectWithDesc;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;

public class CubeLangDescXMLGenerator
extends AbstractLangDescXMLGenerator {
    private Cube cube;

    public CubeLangDescXMLGenerator(Cube cube) {
        this.cube = cube;
    }

    @Override
    public String generateXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Cube>\n");
        stringBuffer.append("     " + this.getDescXML("CubeObject", this.cube));
        List<Measure> list = this.getMeasuresList("BASE");
        List<Measure> list2 = this.getMeasuresList("DERIVED");
        if (list.size() > 0) {
            stringBuffer.append("  <Measures type=\"\">\n");
            for (Measure measure : list) {
                stringBuffer.append("     " + this.getDescXML("Measure", measure));
            }
            stringBuffer.append("  </Measures>\n");
        }
        if (list2.size() > 0) {
            stringBuffer.append("  <DerivedMeasures type=\"\">\n");
            for (Measure measure : list2) {
                stringBuffer.append("     " + this.getDescXML("DerivedMeasure", measure));
            }
            stringBuffer.append("  </DerivedMeasures>\n");
        }
        stringBuffer.append("</Cube>\n");
        return stringBuffer.toString();
    }

    private List<Measure> getMeasuresList(String string) {
        List<Measure> list = Collections.emptyList();
        if (this.cube.getMeasures().size() > 0) {
            list = new ArrayList<Measure>();
            for (Measure measure : this.cube.getMeasures()) {
                if (!measure.getType().equalsIgnoreCase(string)) continue;
                list.add(measure);
            }
        }
        return list;
    }

    @Override
    public AbstractSchemaObjectWithDesc createModelOriginalObject() {
        oracle.olap.cube.model.Cube cube = new oracle.olap.cube.model.Cube();
        cube.setName(this.cube.getName());
        this.addLanguageDescriptions(cube, this.cube);
        for (Measure measure : this.cube.getMeasures()) {
            AbstractChildObjectWithDesc abstractChildObjectWithDesc;
            if (measure.isDerived()) {
                abstractChildObjectWithDesc = new CubeCalculatedMeasure(measure.getName());
                cube.addCalculatedMeasure((CubeCalculatedMeasure)abstractChildObjectWithDesc);
                this.addLanguageDescriptions(abstractChildObjectWithDesc, measure);
                continue;
            }
            abstractChildObjectWithDesc = new CubeMeasure(measure.getName());
            cube.addMeasure((CubeMeasure)abstractChildObjectWithDesc);
            this.addLanguageDescriptions(abstractChildObjectWithDesc, measure);
        }
        return cube;
    }
}

