/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.util.Map;
import javax.swing.DefaultListModel;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.olap.actions.AWNodeType;
import oracle.olap.actions.AbstractUpdatedObjectGenerator;
import oracle.olap.cubedimension.model.CubeDimension;
import oracle.olap.cubedimension.model.CubeDimensionAttribute;
import oracle.olap.cubedimension.model.CubeDimensionHierarchy;
import oracle.olap.cubedimension.model.CubeDimensionLevel;
import oracle.olap.db.model.AbstractSchemaObjectWithDesc;
import oracle.olap.db.model.Descriptions;
import oracle.olap.db.model.LanguageDescriptionsHelper;
import oracle.olap.db.model.StatefulDescriptions;
import org.w3c.dom.Node;

public class DimensionUpdatedObjectGenerator
extends AbstractUpdatedObjectGenerator {
    private String dimensionName;

    public DimensionUpdatedObjectGenerator(DefaultListModel defaultListModel, String[] stringArray) {
        super(defaultListModel, stringArray);
    }

    @Override
    protected void traverse(Node node, XPath xPath, Map<String, AbstractSchemaObjectWithDesc> map, Map<String, AbstractSchemaObjectWithDesc> map2) throws Exception {
        if (node != null) {
            Object object;
            AWNodeType aWNodeType = AWNodeType.valueFrom(node.getNodeName());
            if (aWNodeType != null) {
                object = null;
                StatefulDescriptions statefulDescriptions = null;
                switch (aWNodeType) {
                    case CUBE_DIMENSION_OBJECT: {
                        XPathExpression xPathExpression = xPath.compile("@name");
                        this.dimensionName = xPathExpression.evaluate(node);
                        CubeDimension cubeDimension = (CubeDimension)map.get(this.dimensionName);
                        CubeDimension cubeDimension2 = (CubeDimension)DBUtil.makeTemporaryCopy((DBObject)cubeDimension);
                        map2.put(this.dimensionName, cubeDimension2);
                        object = cubeDimension2;
                        statefulDescriptions = cubeDimension2;
                        break;
                    }
                    case LEVEL: {
                        XPathExpression xPathExpression = xPath.compile("@name");
                        String string = xPathExpression.evaluate(node);
                        CubeDimension cubeDimension2 = (CubeDimension)map2.get(this.dimensionName);
                        CubeDimensionLevel cubeDimensionLevel = null;
                        if (cubeDimension2 == null) break;
                        cubeDimensionLevel = cubeDimension2.findLevel(string);
                        object = cubeDimensionLevel;
                        statefulDescriptions = cubeDimensionLevel;
                        break;
                    }
                    case HIERARCHY: {
                        XPathExpression xPathExpression = xPath.compile("@name");
                        String string = xPathExpression.evaluate(node);
                        CubeDimension cubeDimension2 = (CubeDimension)map2.get(this.dimensionName);
                        CubeDimensionHierarchy cubeDimensionHierarchy = null;
                        if (cubeDimension2 == null) break;
                        cubeDimensionHierarchy = cubeDimension2.findHierarchy(string);
                        object = cubeDimensionHierarchy;
                        statefulDescriptions = cubeDimensionHierarchy;
                        break;
                    }
                    case ATTRIBUTE: {
                        XPathExpression xPathExpression = xPath.compile("@name");
                        String string = xPathExpression.evaluate(node);
                        CubeDimension cubeDimension2 = (CubeDimension)map2.get(this.dimensionName);
                        CubeDimensionAttribute cubeDimensionAttribute = null;
                        if (cubeDimension2 == null) break;
                        cubeDimensionAttribute = cubeDimension2.findAttribute(string);
                        object = cubeDimensionAttribute;
                        statefulDescriptions = cubeDimensionAttribute;
                    }
                }
                this.setDescriptions(node, xPath, (Descriptions)object, (LanguageDescriptionsHelper)((Object)statefulDescriptions));
            }
            if (node.hasChildNodes()) {
                object = node.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    this.traverse(object.item(i), xPath, map, map2);
                }
            }
        }
    }
}

