/*
 * Decompiled with CFR 0.152.
 */
package oracle.olap.actions;

import java.awt.Component;
import java.awt.Window;
import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.olap.OLAPArb;
import oracle.olap.actions.AbstractDropMeasureAction;
import oracle.olap.actions.DropOLAPChildObjectHelper;
import oracle.olap.app.db.DatabaseImpl;
import oracle.olap.app.olapmetadata.AnalyticWorkspace;
import oracle.olap.app.olapmetadata.CalcReferences;
import oracle.olap.app.olapmetadata.Measure;
import oracle.olap.app.olapmetadata.Schema;
import oracle.olap.db.CubeCalcPersist;
import oracle.olap.db.OLAPExceptionHandler;
import oracle.olap.syntaxbuilder.olapihelpers.OLAPISyntaxParser;
import oracle.olap.syntaxbuilder.olapihelpers.SyntaxBuilderLauncher;

public class DropMeasureHelper
implements DropOLAPChildObjectHelper {
    private String title;
    private List<Measure> dependencies;
    private boolean readOnly;
    private CubeCalcPersist calcCreator;
    private AbstractDropMeasureAction dropMeasureAction;
    private String measureName;
    private String cubeName;
    private int baseMeasures;
    private int calcMeasures;
    private boolean dropDependencies = true;

    public DropMeasureHelper() {
    }

    public DropMeasureHelper(String string, String string2, String string3, String string4, AbstractDropMeasureAction abstractDropMeasureAction, boolean bl, List<Measure> list) {
        this(string, null, string2, string3, string4, null, null, abstractDropMeasureAction, bl, list);
    }

    public DropMeasureHelper(String string, AnalyticWorkspace analyticWorkspace, String string2, String string3, String string4, Connection connection, CubeCalcPersist cubeCalcPersist, AbstractDropMeasureAction abstractDropMeasureAction, boolean bl, List<Measure> list) {
        this.title = string;
        this.readOnly = bl;
        this.dependencies = list;
        this.calcCreator = cubeCalcPersist;
        this.dropMeasureAction = abstractDropMeasureAction;
        this.measureName = string2;
        this.cubeName = string3;
        if (!bl) {
            DatabaseImpl databaseImpl = new DatabaseImpl();
            databaseImpl.setConnection(connection);
            Properties properties = new Properties();
            properties.setProperty("SCHEMA", string4);
            Schema schema = SyntaxBuilderLauncher.populateSchema(null, properties, null, databaseImpl);
            OLAPISyntaxParser oLAPISyntaxParser = new OLAPISyntaxParser(schema, properties);
            if (this.dependencies == null) {
                this.dependencies = CalcReferences.getDependencies(analyticWorkspace, string3, string2, oLAPISyntaxParser);
            }
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getSQL() {
        this.calcCreator.clear();
        this.calcCreator.addRemoveMeasure(this.measureName, this.cubeName);
        if (!this.dependencies.isEmpty()) {
            for (Measure measure : this.dependencies) {
                this.calcCreator.addRemoveMeasure(measure.getName(), measure.getCube().getName());
            }
        }
        Object object = "";
        try {
            object = this.getSQLXML();
        }
        catch (Exception exception) {
            OLAPExceptionHandler.handleException((Window)Ide.getMainWindow(), exception);
        }
        return object;
    }

    @Override
    public boolean commitChanges() {
        int n;
        if (!this.readOnly) {
            this.calcCreator.clear();
            this.calcCreator.addRemoveMeasure(this.measureName, this.cubeName);
            if (this.dropDependencies && !this.dependencies.isEmpty()) {
                int n2 = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), OLAPArb.format("DROP_MEASURE_DEPENDENCIES_WARNING", this.measureName), this.title, 0, 2);
                if (n2 != 0) {
                    return false;
                }
                for (Measure measure : this.dependencies) {
                    this.calcCreator.addRemoveMeasure(measure.getName(), measure.getCube().getName());
                }
            }
            this.commit();
        } else if (this.dropDependencies && !this.dependencies.isEmpty() && (n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), OLAPArb.format("DROP_MEASURE_DEPENDENCIES_WARNING", this.measureName), this.title, 0, 2)) != 0) {
            return false;
        }
        return true;
    }

    private void commit() {
        this.countMeasuresToDrop();
        String string = OLAPArb.format("DROP_MEASURE_DIALOG_DROPPING_MEASURES_PROGRESS", this.baseMeasures, this.calcMeasures);
        RaptorTask raptorTask = new RaptorTask(string, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    DropMeasureHelper.this.calcCreator.commit();
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                    throw new TaskException((Throwable)exception);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string);
        ObjectAction objectAction = this.dropMeasureAction.getObjectAction();
        DBObject dBObject = this.dropMeasureAction.getDBObject();
        if (null == objectAction) {
            objectAction = new ObjectAction();
            objectAction.setReloadParent(true);
        }
        objectAction.setRemoveFromParent(true);
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
        IRaptorTaskListener iRaptorTaskListener = ObjectActionController.getRaptorTaskListener((ObjectActionController.ObjectActionPostProcess)objectActionPostProcess);
        raptorTask.getDescriptor().addListener(iRaptorTaskListener);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        if (throwable.getCause() != null) {
                            OLAPExceptionHandler.handleException((Window)Ide.getMainWindow(), (Exception)throwable.getCause());
                        } else {
                            OLAPExceptionHandler.handleException((Window)Ide.getMainWindow(), throwable.getMessage());
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!DropMeasureHelper.this.dropDependencies) {
                            DropMeasureHelper.this.showConfirmation();
                        } else if (!DropMeasureHelper.this.dependencies.isEmpty()) {
                            DropMeasureHelper.this.showConfirmationWithDependencies();
                        } else {
                            DropMeasureHelper.this.showConfirmation();
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    private String getSQLXML() throws Exception {
        return this.calcCreator.generateSQLXML();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Object getDependencies() {
        return this.dependencies;
    }

    private String getMeasureDependenciesText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Measure measure : this.dependencies) {
            stringBuffer.append(measure.getName() + ",");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private void countMeasuresToDrop() {
        if (this.dropDependencies) {
            for (Measure measure : this.dependencies) {
                if (measure.getType().equals("BASE")) {
                    ++this.baseMeasures;
                    continue;
                }
                ++this.calcMeasures;
            }
        }
        if (this.dropMeasureAction.getType().equals("BASE")) {
            ++this.baseMeasures;
        } else {
            ++this.calcMeasures;
        }
    }

    private void showConfirmation() {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), this.dropMeasureAction.getDropMeasureConfirmation(this.measureName), this.title, 1);
    }

    private void showConfirmationWithDependencies() {
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), OLAPArb.format("DROP_CALCULATED_MEASURE_DEPENDENCIES_CONFIRMATION", this.measureName + ", " + this.getMeasureDependenciesText()), this.title, 1);
    }
}

